/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.util;

import com.hundsun.t2sdk.common.share.event.CommonEvent_1;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;

public class EventUtils {
    private static EventUtils instance = null;
    private byte[] lock = new byte[0];
    private long iMessageId = 0L;

    public static EventUtils getInstance() {
        return instance;
    }

    private EventUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateEventNo() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.iMessageId = this.iMessageId == Long.MAX_VALUE ? 1L : ++this.iMessageId;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.iMessageId;
        }
    }

    public static String getEventName(IEvent event) {
        if (event == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append(event.getIntegerAttributeValue("11"));
        sb.append("|");
        sb.append(event.getEventType());
        sb.append("|");
        sb.append(event.getServiceId());
        sb.append("|");
        sb.append(event.getServiceAlias());
        return sb.toString();
    }

    public static byte[] packEvent(IEvent event, String charset) throws Exception {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        if (charset == null) {
            charset = "utf-8";
        }
        if (event instanceof CommonEvent_1) {
            CommonEvent_1 commonEvent = (CommonEvent_1)event;
            return commonEvent.packAllAttributes(charset);
        }
        throw new UnsupportedOperationException("wrong event version");
    }

    public static IEvent unpackEvent(byte[] data, String charset) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("byte[] is null");
        }
        if (charset == null) {
            charset = "utf-8";
        }
        CommonEvent_1 event = new CommonEvent_1(data, charset);
        return event;
    }

    public static IEvent getRequestEvent(String serviceId, IDataset request) {
        if (serviceId == null) {
            throw new IllegalArgumentException("serviceId is null");
        }
        CommonEvent_1 event = new CommonEvent_1();
        event.prepare(serviceId, 0);
        if (request != null) {
            event.putEventData(request);
        }
        return event;
    }

    public static IEvent getRequestEventByFunctionId(String functionId, IDataset request) {
        if (functionId == null) {
            throw new IllegalArgumentException("functionId is null");
        }
        CommonEvent_1 event = new CommonEvent_1();
        event.prepareByAlias(functionId, 0);
        if (request != null) {
            event.putEventData(request);
        }
        return event;
    }

    static {
        instance = new EventUtils();
    }
}

