/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util;

import com.hundsun.t2sdk.common.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class CollectionUtils {
    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static List arrayToList(Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray(source));
    }

    public static void mergeArrayIntoCollection(Object array, Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        Object[] arr = ObjectUtils.toObjectArray(array);
        for (int i = 0; i < arr.length; ++i) {
            collection.add(arr[i]);
        }
    }

    public static void mergePropertiesIntoMap(Properties props, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                map.put(key, props.getProperty(key));
            }
        }
    }

    public static boolean contains(Iterator iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            if (!source.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstMatch(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static Object findValueOfType(Collection collection, Class type) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Object value = null;
        for (Object obj : collection) {
            if (type != null && !type.isInstance(obj)) continue;
            if (value != null) {
                return null;
            }
            value = obj;
        }
        return value;
    }

    public static Object findValueOfType(Collection collection, Class[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            Object value = CollectionUtils.findValueOfType(collection, types[i]);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }
}

