/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util;

import com.hundsun.t2sdk.common.util.Location;
import com.hundsun.t2sdk.common.util.Resource;

public final class LocationImpl
implements Location {
    private Resource _resource;
    private int _lineNumber = -1;
    private int _columnNumber = -1;

    public LocationImpl(Resource resource) {
        this._resource = resource;
    }

    public LocationImpl(Resource resource, int lineNumber) {
        this(resource);
        this._lineNumber = lineNumber;
    }

    public LocationImpl(Resource resource, int lineNumber, int columnNumber) {
        this(resource);
        this._lineNumber = lineNumber;
        this._columnNumber = columnNumber;
    }

    public Resource getResource() {
        return this._resource;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public int getColumnNumber() {
        return this._columnNumber;
    }

    public int hashCode() {
        return 237 + this._resource.hashCode() << 3 + this._lineNumber << 3 + this._columnNumber;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LocationImpl)) {
            return false;
        }
        LocationImpl l = (LocationImpl)other;
        if (this._lineNumber != l.getLineNumber()) {
            return false;
        }
        if (this._columnNumber != l.getColumnNumber()) {
            return false;
        }
        return this._resource.equals(l.getResource());
    }

    public String getPosition() {
        String result = "";
        if (this._lineNumber > 0) {
            result = result + "line " + this._lineNumber;
        }
        if (this._columnNumber > 0) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + "column " + this._columnNumber;
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this._resource.toString());
        String position = this.getPosition();
        if (position.length() > 0) {
            buffer.append(", ");
            buffer.append(position);
        }
        return buffer.toString();
    }
}

