/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util;

import java.math.BigInteger;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class PKStr {
    public static final long serialVersionUID = 1L;
    private static final char[] digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '-', '_'};
    public static final long LOCAL_IP = PKStr.getLocalIP();
    public static final int BIN = 1;
    public static final int QUA = 2;
    public static final int OCT = 3;
    public static final int HEX = 4;
    public static final int THIRTY_TWO = 5;
    public static final int SIXTY_FOUR = 6;
    public static int CODE = 0;
    public static int CODE9999 = (int)(Math.random() * 1000.0);

    private static char getDigit(int i) {
        return digit[i % 64];
    }

    private static String toHex(long decimal) {
        return PKStr.convert(decimal, 4);
    }

    private static String toHex(BigInteger decimal) {
        return PKStr.convert(decimal, 4);
    }

    private static String toSixtyFour(long decimal) {
        return PKStr.convert(decimal, 6);
    }

    private static String toSixtyFour(BigInteger decimal) {
        return PKStr.convert(decimal, 6);
    }

    private static String convert(long decimal, int type) {
        StringBuffer binary = new StringBuffer();
        long oldValue = decimal;
        long newValue = decimal;
        if (type > 0) {
            for (int i = 0; i < 64 && newValue > 0L; i += type) {
                oldValue = newValue >>> type;
                binary.append(PKStr.getDigit((int)(newValue - (oldValue << type))));
                newValue = oldValue;
            }
        }
        return binary.reverse().toString();
    }

    private static String convert(BigInteger decimal, int type) {
        StringBuffer binary = new StringBuffer();
        BigInteger oldValue = decimal;
        BigInteger newValue = decimal;
        if (type > 0) {
            for (int i = 0; i < decimal.bitLength(); i += type) {
                oldValue = newValue.shiftRight(type);
                binary.append(PKStr.getDigit(newValue.subtract(oldValue.shiftLeft(type)).intValue()));
                newValue = oldValue;
            }
        }
        return binary.reverse().toString();
    }

    private static long getLocalIP() {
        long IP = 0L;
        try {
            byte[] ch = InetAddress.getLocalHost().getAddress();
            int[] ip = new int[4];
            for (int i = 0; i < 4; ++i) {
                ip[i] = Integer.parseInt(String.valueOf(ch[i]));
                if (ip[i] >= 0) continue;
                int n = i;
                ip[n] = ip[n] + 256;
            }
            IP = (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
            if (IP < 0L) {
                IP += Integer.MAX_VALUE;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return IP;
    }

    public static String getUuid(int type) {
        String uuid = null;
        StringBuffer uuidString = new StringBuffer();
        uuidString.append(PKStr.formatDigit(LOCAL_IP, 10));
        uuidString.append(System.currentTimeMillis());
        uuidString.append(PKStr.formatDigit(CODE, 4));
        CODE = (CODE + 1) % 4096;
        uuid = PKStr.convert(new BigInteger(uuidString.toString()), type);
        return uuid;
    }

    public static String getUuidHex() {
        return PKStr.getUuid(4);
    }

    public static String getUuid64() {
        return PKStr.getUuid(6);
    }

    public static String generateApplyId() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
        return formatter.format(cal.getTime()) + PKStr.formatDigit(++CODE9999 % 10000, 4);
    }

    public static String formatDigit(long num, int dit) {
        String res = String.valueOf(num);
        String str = "0000000000000000";
        int count = dit - res.length();
        res = count < 0 ? res.substring(-1 * count) : str.substring(str.length() - count) + res;
        return res;
    }
}

