/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Vector;

public class StringFormat {
    public static final long serialVersionUID = 1L;

    public StringFormat(String str, String oldCodeSet, String newCodeSet) {
        this.convert(str, oldCodeSet, newCodeSet);
    }

    public StringFormat(String str) {
        this.convert(str, "GBK", "ISO-8859-1");
    }

    public String convert(String str, String oldCodeSet, String newCodeSet) {
        try {
            str = new String(str.trim().getBytes(oldCodeSet), newCodeSet);
            return str;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.toString());
            return "null";
        }
    }

    public static String Convert(String str) {
        if (str == null || str.trim().equals("")) {
            return str;
        }
        try {
            str = new String(str.trim().getBytes("GBK"), "ISO-8859-1");
            str = str.replace('\n', ' ');
            str = str.replace('\r', ' ');
            return str;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.toString());
            return "null";
        }
    }

    public static String fromFilter(String str) {
        if (str == null || str.trim().equals("")) {
            return str;
        }
        try {
            str = StringFormat.replace(str, ",", "\ufffd\ufffd");
            str = StringFormat.replace(str, "'", "\ufffd\ufffd");
            return str;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return str;
        }
    }

    public static String unConvert(String str) {
        try {
            str = new String(str.trim().getBytes("ISO-8859-1"), "GBK");
            return str;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.toString());
            return "null";
        }
    }

    public static String replace(String source, String oldString, String newString) {
        try {
            int pos;
            StringBuffer output = new StringBuffer();
            int lengthOfSource = source.length();
            int lengthOfOld = oldString.length();
            int posStart = 0;
            while ((pos = source.indexOf(oldString, posStart)) >= 0) {
                output.append(source.substring(posStart, pos));
                output.append(newString);
                posStart = pos + lengthOfOld;
            }
            if (posStart < lengthOfSource) {
                output.append(source.substring(posStart));
            }
            return output.toString();
        }
        catch (Exception e) {
            return source;
        }
    }

    public static String toHtml(String str) {
        String html = str;
        if (str == null || str.length() == 0) {
            return str;
        }
        html = StringFormat.replace(html, "&", "&amp;");
        html = StringFormat.replace(html, "<", "&lt;");
        html = StringFormat.replace(html, ">", "&gt;");
        html = StringFormat.replace(html, "\r\n", "\n");
        html = StringFormat.replace(html, "\n", "<br>\n");
        html = StringFormat.replace(html, "\"", "&quot;");
        html = StringFormat.replace(html, " ", "&nbsp;");
        return html;
    }

    public static String toText(String str) {
        String text = str;
        if (str == null || str.length() == 0) {
            return str;
        }
        text = StringFormat.replace(text, "&amp;", "&");
        text = StringFormat.replace(text, "&lt;", "<");
        text = StringFormat.replace(text, "&gt;", ">");
        text = StringFormat.replace(text, "\n", "\r\n");
        text = StringFormat.replace(text, "<br>\n", "\n");
        text = StringFormat.replace(text, "<br>", "\n");
        text = StringFormat.replace(text, "&quot;", "\"");
        text = StringFormat.replace(text, "&nbsp;", " ");
        return text;
    }

    public static String formatNumber(String number) {
        String retNumber = "";
        int numLen = number.length();
        int hasNag = number.indexOf("-");
        String absnumber = "";
        if (hasNag > 0) {
            return number;
        }
        absnumber = hasNag == 0 ? number.substring(1, numLen) : number;
        int pointPos = absnumber.indexOf(".");
        if (pointPos <= 0) {
            pointPos = absnumber.length();
        }
        String tailStr = absnumber.substring(pointPos);
        String newNumber = "";
        if (pointPos > 3) {
            if (pointPos % 3 != 0) {
                newNumber = absnumber.substring(0, pointPos % 3) + ",";
                for (int i = 0; i < pointPos / 3 - 1; ++i) {
                    newNumber = newNumber + absnumber.substring(pointPos % 3 + i * 3, pointPos % 3 + (i + 1) * 3) + ",";
                }
                newNumber = newNumber + absnumber.substring(pointPos - 3, pointPos) + tailStr;
            } else {
                for (int i = 0; i < pointPos / 3 - 1; ++i) {
                    newNumber = newNumber + absnumber.substring(i * 3, (i + 1) * 3) + ",";
                }
                newNumber = newNumber + absnumber.substring(pointPos - 3, pointPos) + tailStr;
            }
        } else {
            newNumber = absnumber;
        }
        retNumber = hasNag == 0 ? "-" + newNumber : newNumber;
        return retNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeDH(String numValue) {
        if (numValue == null || numValue.length() <= 0) {
            return numValue;
        }
        try {
            int indexOfDH = numValue.indexOf(",");
            while (indexOfDH >= 0) {
                numValue = numValue.substring(0, indexOfDH) + numValue.substring(indexOfDH + 1);
                indexOfDH = numValue.indexOf(",");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            return numValue;
        }
    }

    public static String Decode(String str) {
        if (str == null || str.trim().equals("")) {
            return str;
        }
        try {
            str = URLDecoder.decode(str);
            return str;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return "null";
        }
    }

    public static String trim(String strStr) {
        strStr = strStr == null || strStr.length() <= 0 ? " " : strStr.trim();
        return strStr;
    }

    public static Vector splitString(String strStr, char chr) {
        Vector<String> vStr = new Vector<String>();
        if (strStr == null || strStr.length() <= 0) {
            return vStr;
        }
        strStr = strStr.trim();
        try {
            int indexOf = strStr.indexOf(chr);
            while (indexOf >= 0) {
                vStr.add(strStr.substring(0, indexOf));
                strStr = strStr.substring(indexOf + 1);
                indexOf = strStr.indexOf(chr);
            }
            vStr.add(strStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return vStr;
    }

    public static Vector splitString(String strStr) {
        char chr = '\r';
        return StringFormat.splitString(strStr, chr);
    }

    public static String doubleToChinese(double je) {
        String[] chinese = new String[]{"\ufffd\ufffd", "\u04bc", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\u00bd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd"};
        String str = Double.toString(je);
        String tmpstr = str.substring(0, str.indexOf("."));
        String result = "";
        if (tmpstr.length() > 4) {
            result = result + StringFormat.fourdigit(tmpstr.substring(0, tmpstr.length() - 4)) + "\ufffd\ufffd";
            if (tmpstr.charAt(tmpstr.length() - 4) - 48 == 0 && Integer.parseInt(tmpstr.substring(tmpstr.length() - 4, tmpstr.length())) != 0) {
                result = result + "\ufffd\ufffd";
            }
            result = result + StringFormat.fourdigit(tmpstr.substring(tmpstr.length() - 4, tmpstr.length()));
        } else {
            result = result + StringFormat.fourdigit(tmpstr.substring(0, tmpstr.length()));
        }
        tmpstr = str.substring(str.indexOf(".") + 1);
        if (Integer.parseInt(tmpstr) != 0) {
            result = result + "\ufffd\ufffd";
            for (int i = 0; i < tmpstr.length(); ++i) {
                result = result + chinese[Integer.parseInt(tmpstr.substring(i, i + 1))];
            }
        }
        return result;
    }

    public static String fourdigit(String tmpstr) {
        String[] chinese = new String[]{"\ufffd\ufffd", "\u04bc", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\u00bd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd"};
        tmpstr = Integer.toString(Integer.parseInt(tmpstr));
        String str = "";
        if (tmpstr.length() == 4) {
            str = str + chinese[tmpstr.charAt(0) - 48] + "\u01e7";
            if (tmpstr.charAt(1) - 48 != 0) {
                str = str + chinese[tmpstr.charAt(1) - 48] + "\ufffd\ufffd";
            }
            if (tmpstr.charAt(2) - 48 != 0) {
                if (tmpstr.charAt(1) - 48 == 0) {
                    str = str + "\ufffd\ufffd";
                }
                str = str + chinese[tmpstr.charAt(2) - 48] + "\u02b0";
            }
            if (tmpstr.charAt(3) - 48 != 0) {
                if (tmpstr.charAt(2) - 48 == 0) {
                    str = str + "\ufffd\ufffd";
                }
                str = str + chinese[tmpstr.charAt(3) - 48];
            }
        }
        if (tmpstr.length() == 3) {
            str = str + chinese[tmpstr.charAt(0) - 48] + "\ufffd\ufffd";
            if (tmpstr.charAt(1) - 48 != 0) {
                str = str + chinese[tmpstr.charAt(1) - 48] + "\u02b0";
            }
            if (tmpstr.charAt(2) - 48 != 0) {
                if (tmpstr.charAt(1) - 48 == 0) {
                    str = str + "\ufffd\ufffd";
                }
                str = str + chinese[tmpstr.charAt(2) - 48];
            }
        }
        if (tmpstr.length() == 2) {
            str = str + chinese[tmpstr.charAt(0) - 48] + "\u02b0";
            if (tmpstr.charAt(1) - 48 != 0) {
                str = str + chinese[tmpstr.charAt(1) - 48];
            }
        }
        if (tmpstr.length() == 1 && tmpstr.charAt(0) - 48 != 0) {
            str = str + chinese[tmpstr.charAt(0) - 48];
        }
        return str;
    }

    public static String tidyDateString(String strDate) {
        int posBlank = strDate.indexOf(" ");
        String str1 = strDate.substring(0, posBlank);
        StringBuffer str2 = new StringBuffer();
        for (int i = 0; i < str1.length(); ++i) {
            if (str1.charAt(i) == '-') continue;
            str2.append(str1.charAt(i));
        }
        return str2.toString();
    }

    public static String twodigit(String tmpstr) {
        String[] chinese = new String[]{"\ufffd\ufffd", "\u04bc", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd", "\u00bd", "\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd"};
        tmpstr = Integer.toString(Integer.parseInt(tmpstr));
        String str = "";
        if (tmpstr.length() == 2) {
            str = str + chinese[tmpstr.charAt(0) - 48] + "\ufffd\ufffd";
            if (tmpstr.charAt(1) - 48 != 0) {
                str = str + chinese[tmpstr.charAt(1) - 48] + "\ufffd\ufffd";
            }
        }
        if (tmpstr.length() == 1 && tmpstr.charAt(0) - 48 != 0) {
            str = str + "\ufffd\ufffd" + chinese[tmpstr.charAt(0) - 48] + "\ufffd\ufffd";
        }
        return str;
    }

    public static String S_NULL(String tmpstr) {
        String str = " ";
        if (tmpstr != null || tmpstr.equalsIgnoreCase("")) {
            return str;
        }
        return tmpstr;
    }

    public static String numtochinese(String input) {
        String s1 = "\ufffd\ufffd\u04bc\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u00bd\ufffd\ufffd\u01be\ufffd";
        String s4 = "\ufffd\u05bd\ufffd\ufffd\ufffd\u052a\u02b0\ufffd\ufffd\u01ea\ufffd\ufffd\u02b0\ufffd\ufffd\u01ea\ufffd\ufffd\u02b0\ufffd\ufffd\u01ea";
        String temp = "";
        String result = "";
        if (input == null) {
            return "\ufffd\ufffd\ufffd\ufffd\ufffd\u05b4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b4\ufffd\u05bb\ufffd\u0730\ufffd(\ufffd\ufffd\ufffd\ufffd\ufffd\u05b7\ufffd'0'\ufffd\ufffd'9'\ufffd\ufffd'.')\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b4\ufffd\ufffd\ufffd\ufffd\u05bb\ufffd\u073e\ufffd\u0237\ufffd\ufffd\u01ea\ufffd\u06a3\ufffd\u0421\ufffd\ufffd\ufffd\u05bb\ufffd\ufffd}\u03bb\ufffd\ufffd";
        }
        temp = input.trim();
        try {
            float f = Float.parseFloat(temp);
        }
        catch (Exception e) {
            return "\ufffd\ufffd\ufffd\ufffd\ufffd\u05b4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b4\ufffd\u05bb\ufffd\u0730\ufffd(\ufffd\ufffd\ufffd\ufffd\ufffd\u05b7\ufffd'0'\ufffd\ufffd'9'\ufffd\ufffd'.')\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b4\ufffd\ufffd\ufffd\ufffd\u05bb\ufffd\u073e\ufffd\u0237\ufffd\ufffd\u01ea\ufffd\u06a3\ufffd\u0421\ufffd\ufffd\ufffd\u05bb\ufffd\ufffd}\u03bb\ufffd\ufffd";
        }
        int len = 0;
        len = temp.indexOf(".") == -1 ? temp.length() : temp.indexOf(".");
        if (len > s4.length() - 3) {
            return "\ufffd\ufffd\ufffd\ufffd\ufffd\u05b4\ufffd\ufffd\ufffd\ufffd\u05bb\ufffd\u073e\ufffd\u0237\ufffd\ufffd\u01ea\ufffd\u06a3\ufffd\u0421\ufffd\ufffd\ufffd\u05bb\ufffd\ufffd}\u03bb\ufffd\ufffd";
        }
        boolean n2 = false;
        String num = "";
        String unit = "";
        for (int i = 0; i < temp.length() && i <= len + 2; ++i) {
            if (i == len) continue;
            int n1 = Integer.parseInt(String.valueOf(temp.charAt(i)));
            num = s1.substring(n1, n1 + 1);
            n1 = len - i + 2;
            unit = s4.substring(n1, n1 + 1);
            result = result.concat(num).concat(unit);
        }
        if (len == temp.length() || len == temp.length() - 1) {
            result = result.concat("\ufffd\ufffd");
        }
        if (len == temp.length() - 2) {
            result = result.concat("\ufffd\ufffd\ufffd");
        }
        return result;
    }

    public static final String formatDatetime(String datetime) {
        if (datetime != null) {
            if (datetime.indexOf("1900-01-01") >= 0 || datetime.indexOf("1900-1-1") >= 0) {
                return "";
            }
            if (datetime.indexOf(" 00:00:00") >= 0) {
                return datetime.substring(0, datetime.indexOf(" 00:00:00"));
            }
            return datetime;
        }
        return "";
    }

    public static String getMapValue(Map map, String id) {
        return map.get(id) == null ? "" : map.get(id).toString();
    }

    public static void main(String[] args) {
    }
}

