/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;

public class StringUtils {
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static MessageDigest digest = null;
    private static final int fillchar = 61;
    private static final String cvt = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static Random randGen = new Random();
    private static char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] zeroArray = "0000000000000000".toCharArray();

    private void StringUtil() {
    }

    public static String[] split(String source, String delim) {
        if (source == null) {
            String[] wordLists = new String[]{source};
            return wordLists;
        }
        if (delim == null) {
            delim = ",";
        }
        StringTokenizer st = new StringTokenizer(source, delim);
        int total = st.countTokens();
        String[] wordLists = new String[total];
        for (int i = 0; i < total; ++i) {
            wordLists[i] = st.nextToken();
        }
        return wordLists;
    }

    public static String[] split(String source, char delim) {
        return StringUtils.split(source, String.valueOf(delim));
    }

    public static String[] split(String source) {
        return StringUtils.split(source, ",");
    }

    public static void printStrings(String[] strings, String delim, OutputStream out) {
        try {
            if (strings != null) {
                int length = strings.length - 1;
                for (int i = 0; i < length; ++i) {
                    if (strings[i] != null) {
                        if (strings[i].indexOf(delim) > -1) {
                            out.write(("\"" + strings[i] + "\"" + delim).getBytes());
                            continue;
                        }
                        out.write((strings[i] + delim).getBytes());
                        continue;
                    }
                    out.write("null".getBytes());
                }
                if (strings[length] != null) {
                    if (strings[length].indexOf(delim) > -1) {
                        out.write(("\"" + strings[length] + "\"").getBytes());
                    } else {
                        out.write(strings[length].getBytes());
                    }
                } else {
                    out.write("null".getBytes());
                }
            } else {
                out.write("null".getBytes());
            }
            out.write(LINE_SEPARATOR.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void printStrings(String[] strings, String delim) {
        StringUtils.printStrings(strings, delim, System.out);
    }

    public static void printStrings(String[] strings, OutputStream out) {
        StringUtils.printStrings(strings, ",", out);
    }

    public static void printStrings(String[] strings) {
        StringUtils.printStrings(strings, ",", System.out);
    }

    public static String getReplaceString(String prefix, String source, String[] values) {
        String result = source;
        if (source == null || values == null || values.length < 1) {
            return source;
        }
        if (prefix == null) {
            prefix = "%";
        }
        for (int i = 0; i < values.length; ++i) {
            String argument = prefix + Integer.toString(i + 1);
            int index = result.indexOf(argument);
            if (index == -1) continue;
            String temp = result.substring(0, index);
            temp = i < values.length ? temp + values[i] : temp + values[values.length - 1];
            result = temp = temp + result.substring(index + 2);
        }
        return result;
    }

    public static String getReplaceString(String source, String[] values) {
        return StringUtils.getReplaceString("%", source, values);
    }

    public static boolean contains(String[] strings, String string, boolean caseSensitive) {
        for (int i = 0; i < strings.length; ++i) {
            if (!(caseSensitive ? strings[i].equals(string) : strings[i].equalsIgnoreCase(string))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String[] strings, String string) {
        return StringUtils.contains(strings, string, true);
    }

    public static boolean containsIgnoreCase(String[] strings, String string) {
        return StringUtils.contains(strings, string, false);
    }

    public static String combineStringArray(String[] array, String delim) {
        int length = array.length - 1;
        if (delim == null) {
            delim = "";
        }
        StringBuffer result = new StringBuffer(length * 8);
        for (int i = 0; i < length; ++i) {
            result.append(array[i]);
            result.append(delim);
        }
        result.append(array[length]);
        return result.toString();
    }

    public static final String replace(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static String GetItemfromStr(String sSource, int iIndex, char chSplit) {
        try {
            String Result = "";
            int iI = 1;
            for (int iJ = 0; iJ <= sSource.length() - 1; ++iJ) {
                if (sSource.charAt(iJ) == chSplit) {
                    ++iI;
                }
                if (iI > iIndex) break;
                if (iI != iIndex || sSource.charAt(iJ) == chSplit) continue;
                Result = Result + sSource.charAt(iJ);
            }
            return Result;
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static String FillStrByChar(String sSource, int intMaxLength, char cFill, boolean blRL) {
        if (blRL) {
            while (sSource.length() < intMaxLength) {
                sSource = sSource + cFill;
            }
            return sSource;
        }
        while (sSource.length() < intMaxLength) {
            sSource = cFill + sSource;
        }
        return sSource;
    }

    public static int GetItemCountsInStr(String sSource, String sItem) {
        try {
            String s = sSource;
            int i = 0;
            int index = 0;
            while (index >= 0) {
                index = s.indexOf(sItem);
                if (index < 0) continue;
                ++i;
                s = StringUtils.StringRemove(s, index, sItem.length());
            }
            return i;
        }
        catch (Exception E) {
            return -1;
        }
    }

    public static String StringRemove(String sSource, int index, int RemoveLen) {
        try {
            String sTmp = sSource;
            String s = sTmp.substring(0, index) + sTmp.substring(index + RemoveLen, sTmp.length());
            return s;
        }
        catch (Exception E) {
            E.getStackTrace();
            return null;
        }
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString, int[] count) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            int counter = 0;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            count[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String replace(String line, String oldString, String newString, int[] count) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            int counter = 0;
            ++counter;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            count[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String escapeHTMLTags(String in) {
        int i;
        if (in == null) {
            return null;
        }
        int last = 0;
        char[] input = in.toCharArray();
        int len = input.length;
        StringBuffer out = new StringBuffer((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch != '>') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(GT_ENCODE);
        }
        if (last == 0) {
            return in;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static final synchronized String hash(String data) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                System.err.println("\u8f6c\u6362 MD5 \u5931\u8d25. ");
                nsae.printStackTrace();
            }
        }
        digest.update(data.getBytes());
        return StringUtils.encodeHex(digest.digest());
    }

    public static final String encodeHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static final byte[] decodeHex(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int byteCount = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | StringUtils.hexCharToByte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[byteCount] = newByte = (byte)(newByte | StringUtils.hexCharToByte(chars[i + 1]));
            ++byteCount;
        }
        return bytes;
    }

    private static final byte hexCharToByte(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public static String encodeBase64(String data) {
        return StringUtils.encodeBase64(data.getBytes());
    }

    public static String encodeBase64(byte[] data) {
        int len = data.length;
        StringBuffer ret = new StringBuffer((len / 3 + 1) * 4);
        for (int i = 0; i < len; ++i) {
            int c = data[i] >> 2 & 0x3F;
            ret.append(cvt.charAt(c));
            c = data[i] << 4 & 0x3F;
            if (++i < len) {
                c |= data[i] >> 4 & 0xF;
            }
            ret.append(cvt.charAt(c));
            if (i < len) {
                c = data[i] << 2 & 0x3F;
                if (++i < len) {
                    c |= data[i] >> 6 & 3;
                }
                ret.append(cvt.charAt(c));
            } else {
                ++i;
                ret.append('=');
            }
            if (i < len) {
                c = data[i] & 0x3F;
                ret.append(cvt.charAt(c));
                continue;
            }
            ret.append('=');
        }
        return ret.toString();
    }

    public static String decodeBase64(String data) {
        return StringUtils.decodeBase64(data.getBytes());
    }

    public static String decodeBase64(byte[] data) {
        int len = data.length;
        StringBuffer ret = new StringBuffer(len * 3 / 4);
        for (int i = 0; i < len; ++i) {
            int c = cvt.indexOf(data[i]);
            int c1 = cvt.indexOf(data[++i]);
            c = c << 2 | c1 >> 4 & 3;
            ret.append((char)c);
            if (++i < len) {
                c = data[i];
                if (61 == c) break;
                c = cvt.indexOf((char)c);
                c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                ret.append((char)c1);
            }
            if (++i >= len) continue;
            c1 = data[i];
            if (61 == c1) break;
            c1 = cvt.indexOf((char)c1);
            c = c << 6 & 0xC0 | c1;
            ret.append((char)c);
        }
        return ret.toString();
    }

    public static final String[] toLowerCaseWordArray(String text) {
        if (text == null || text.length() == 0) {
            return new String[0];
        }
        ArrayList<String> wordList = new ArrayList<String>();
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int start = 0;
        int end = boundary.next();
        while (end != -1) {
            String tmp = text.substring(start, end).trim();
            tmp = StringUtils.replace(tmp, "+", "");
            tmp = StringUtils.replace(tmp, "/", "");
            tmp = StringUtils.replace(tmp, "\\", "");
            tmp = StringUtils.replace(tmp, "#", "");
            tmp = StringUtils.replace(tmp, "*", "");
            tmp = StringUtils.replace(tmp, ")", "");
            tmp = StringUtils.replace(tmp, "(", "");
            if ((tmp = StringUtils.replace(tmp, "&", "")).length() > 0) {
                wordList.add(tmp);
            }
            start = end;
            end = boundary.next();
        }
        return wordList.toArray(new String[wordList.size()]);
    }

    public static final String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    public static final String chopAtWord(String string, int length) {
        int i;
        if (string == null) {
            return string;
        }
        char[] charArray = string.toCharArray();
        int sLength = string.length();
        if (length < sLength) {
            sLength = length;
        }
        for (i = 0; i < sLength - 1; ++i) {
            if (charArray[i] == '\r' && charArray[i + 1] == '\n') {
                return string.substring(0, i + 1);
            }
            if (charArray[i] != '\n') continue;
            return string.substring(0, i);
        }
        if (charArray[sLength - 1] == '\n') {
            return string.substring(0, sLength - 1);
        }
        if (string.length() < length) {
            return string;
        }
        for (i = length - 1; i > 0; --i) {
            if (charArray[i] != ' ') continue;
            return string.substring(0, i).trim();
        }
        return string.substring(0, length);
    }

    public static final String escapeForXML(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuffer out = new StringBuffer((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '&') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(AMP_ENCODE);
                continue;
            }
            if (ch != '\"') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(QUOTE_ENCODE);
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static final String unescapeFromXML(String string) {
        string = StringUtils.replace(string, "&lt;", "<");
        string = StringUtils.replace(string, "&gt;", ">");
        string = StringUtils.replace(string, "&quot;", "\"");
        return StringUtils.replace(string, "&amp;", "&");
    }

    public static final String zeroPadString(String string, int length) {
        if (string == null || string.length() > length) {
            return string;
        }
        StringBuffer buf = new StringBuffer(length);
        buf.append(zeroArray, 0, length - string.length()).append(string);
        return buf.toString();
    }

    public static String nbspPadString(String string, int length) {
        if (string == null || string.toCharArray().length > length) {
            return string;
        }
        int len = string.length();
        StringBuffer buf = new StringBuffer(string);
        for (int i = 0; i < length - len; ++i) {
            buf.append("&nbsp;");
        }
        return buf.toString();
    }

    public static String nbspPadStringmid(String string, int length) {
        int i;
        StringBuffer buf = new StringBuffer();
        if (string == null || string.equals("")) {
            for (int i2 = 0; i2 < length; ++i2) {
                buf.append("&nbsp;");
            }
            return buf.toString();
        }
        int len = string.getBytes().length;
        if (len >= length) {
            return string;
        }
        int leftlen = (length - len) / 2;
        int rightlen = length - len - leftlen;
        for (i = 0; i < leftlen; ++i) {
            buf.append("&nbsp;");
        }
        buf.append(string);
        for (i = 0; i < rightlen; ++i) {
            buf.append("&nbsp;");
        }
        return buf.toString();
    }

    public static final String dateToMillis(Date date) {
        return StringUtils.zeroPadString(Long.toString(date.getTime()), 15);
    }

    public static String removeEnterChar(String sour) {
        for (int i = 0; sour != null && i < sour.length(); ++i) {
            char c = sour.charAt(i);
            if (c != '\r' && c != '\n') continue;
            sour = sour.replace(c, ' ');
        }
        return sour.trim();
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String trimWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        int index = 0;
        while (buf.length() > index) {
            if (Character.isWhitespace(buf.charAt(index))) {
                buf.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return buf.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && buf.charAt(0) == leadingCharacter) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && buf.charAt(buf.length() - 1) == trailingCharacter) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

