/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util.objectutil;

import com.hundsun.t2sdk.common.util.objectutil.PropertyAdaptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

class ClassAdaptor {
    private final Map _propertyAdaptorMap = new HashMap();

    ClassAdaptor(PropertyDescriptor[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor d = properties[i];
            String name = d.getName();
            this._propertyAdaptorMap.put(name, new PropertyAdaptor(name, d.getPropertyType(), d.getReadMethod(), d.getWriteMethod()));
        }
    }

    public void write(Object target, String propertyName, Object value) {
        PropertyAdaptor a = this.getPropertyAdaptor(target, propertyName);
        a.write(target, value);
    }

    public void smartWrite(Object target, String propertyName, String value) {
        PropertyAdaptor a = this.getPropertyAdaptor(target, propertyName);
        a.smartWrite(target, value);
    }

    public Object read(Object target, String propertyName) {
        PropertyAdaptor a = this.getPropertyAdaptor(target, propertyName);
        return a.read(target);
    }

    public Class getPropertyType(Object target, String propertyName) {
        PropertyAdaptor a = this.getPropertyAdaptor(target, propertyName);
        return a.getPropertyType();
    }

    public boolean isReadable(String propertyName) {
        PropertyAdaptor result = (PropertyAdaptor)this._propertyAdaptorMap.get(propertyName);
        return result != null && result.isReadable();
    }

    public boolean isWritable(String propertyName) {
        PropertyAdaptor result = (PropertyAdaptor)this._propertyAdaptorMap.get(propertyName);
        return result != null && result.isWritable();
    }

    PropertyAdaptor getPropertyAdaptor(Object target, String propertyName) {
        PropertyAdaptor result = (PropertyAdaptor)this._propertyAdaptorMap.get(propertyName);
        if (result == null) {
            throw new RuntimeException(target + " \u5c5e\u6027 \u4e0d\u5b58\u5728\uff1a" + propertyName);
        }
        return result;
    }

    public List getReadableProperties() {
        ArrayList<String> result = new ArrayList<String>(this._propertyAdaptorMap.size());
        for (PropertyAdaptor a : this._propertyAdaptorMap.values()) {
            if (!a.isReadable()) continue;
            result.add(a.getPropertyName());
        }
        return result;
    }

    public List getWriteableProperties() {
        ArrayList<String> result = new ArrayList<String>(this._propertyAdaptorMap.size());
        for (PropertyAdaptor a : this._propertyAdaptorMap.values()) {
            if (!a.isWritable()) continue;
            result.add(a.getPropertyName());
        }
        return result;
    }

    public void configureProperties(Object target, String initializer) {
        StringTokenizer tokenizer = new StringTokenizer(initializer, ",");
        while (tokenizer.hasMoreTokens()) {
            this.configurePropertyFromToken(target, tokenizer.nextToken());
        }
    }

    private void configurePropertyFromToken(Object target, String token) {
        int equalsx = token.indexOf(61);
        if (equalsx > 0) {
            String propertyName = token.substring(0, equalsx).trim();
            String value = token.substring(equalsx + 1);
            this.smartWrite(target, propertyName, value);
            return;
        }
        boolean negate = token.startsWith("!");
        String propertyName = negate ? token.substring(1) : token;
        Boolean value = negate ? Boolean.FALSE : Boolean.TRUE;
        this.write(target, propertyName, value);
    }
}

