/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util.objectutil;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class PropertyAdaptor {
    private String _propertyName;
    private Class _propertyType;
    private Method _readMethod;
    private Method _writeMethod;

    PropertyAdaptor(String propertyName, Class propertyType, Method readMethod, Method writeMethod) {
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._readMethod = readMethod;
        this._writeMethod = writeMethod;
    }

    public String getReadMethodName() {
        return this._readMethod == null ? null : this._readMethod.getName();
    }

    public String getWriteMethodName() {
        return this._writeMethod == null ? null : this._writeMethod.getName();
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Class getPropertyType() {
        return this._propertyType;
    }

    public void write(Object target, Object value) {
        if (this._writeMethod == null) {
            throw new RuntimeException(target + " Property " + this._propertyName + " of object " + target + " is read-only.");
        }
        try {
            this._writeMethod.invoke(target, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(target + " Unable to update property " + this._propertyName + " of object " + target + ": " + ex, ex);
        }
    }

    public void smartWrite(Object target, String value) {
        Object convertedValue = this.convertValueForAssignment(target, value);
        this.write(target, convertedValue);
    }

    private Object convertValueForAssignment(Object target, String value) {
        if (value == null || this._propertyType.isInstance(value)) {
            return value;
        }
        PropertyEditor e = PropertyEditorManager.findEditor(this._propertyType);
        if (e == null) {
            Object convertedValue = this.instantiateViaStringConstructor(target, value);
            if (convertedValue != null) {
                return convertedValue;
            }
            throw new RuntimeException("There has no Editor for property " + this._propertyName + " of class " + target.getClass());
        }
        try {
            e.setAsText(value);
            return e.getValue();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to convert value [" + value + "] to type [" + this._propertyType + "] for property [" + this._propertyName + "] of " + target, ex);
        }
    }

    private Object instantiateViaStringConstructor(Object target, String value) {
        try {
            Constructor c = this._propertyType.getConstructor(String.class);
            return c.newInstance(value);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isWritable() {
        return this._writeMethod != null;
    }

    public Object read(Object target) {
        if (this._readMethod == null) {
            throw new RuntimeException(target + " roperty " + this._propertyName + " of object " + target + " is write-only.");
        }
        try {
            return this._readMethod.invoke(target, (Object[])null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Fail to read property " + this._propertyName + " of " + target, ex);
        }
    }

    public boolean isReadable() {
        return this._readMethod != null;
    }
}

