/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util.objectutil;

import com.hundsun.t2sdk.common.util.objectutil.propertyeditors.SqlDateEditor;
import com.hundsun.t2sdk.common.util.objectutil.propertyeditors.SqlTimestampEditor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverterUtil {
    public static void registerPropertyEditor(Class type, Class editorClass) {
        PropertyEditorManager.registerEditor(type, editorClass);
    }

    public static <T> T convertString(Object value, Class<T> type) {
        return TypeConverterUtil.convertString(value, type, true);
    }

    public static <T> T convertString(Object value, Class<T> type, boolean returnDefault) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (value.toString().length() == 0) {
            if (type.equals(String.class)) {
                return (T)"";
            }
            if (returnDefault && type.equals(Integer.class)) {
                return (T)new Integer(0);
            }
            return null;
        }
        PropertyEditor e = PropertyEditorManager.findEditor(type);
        T convertedValue = null;
        if (e == null) {
            try {
                Constructor<T> c = type.getConstructor(String.class);
                convertedValue = c.newInstance(value);
            }
            catch (Exception ex) {
                return null;
            }
            if (convertedValue != null) {
                return convertedValue;
            }
            throw new RuntimeException("\u65e0\u6cd5\u8f6c\u6362[" + value + "]\u5230\u7c7b\u578b" + type);
        }
        try {
            e.setAsText(value.toString());
            return (T)e.getValue();
        }
        catch (Exception ex) {
            throw new RuntimeException("\u65e0\u6cd5\u8f6c\u6362[" + value + "]\u5230\u7c7b\u578b" + type, ex);
        }
    }

    public static void initilize() {
        TypeConverterUtil.registerPropertyEditor(Date.class, SqlDateEditor.class);
        TypeConverterUtil.registerPropertyEditor(Timestamp.class, SqlTimestampEditor.class);
    }

    static {
        TypeConverterUtil.initilize();
    }
}

