/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.util.resource;

import com.hundsun.t2sdk.common.util.PathMatcher;
import com.hundsun.t2sdk.common.util.ResourceUtils;
import com.hundsun.t2sdk.common.util.StringUtils;
import com.hundsun.t2sdk.common.util.resource.AntPathMatcher;
import com.hundsun.t2sdk.common.util.resource.IAdapterURLBean;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AresResourceResolver {
    private PathMatcher pathMatcher = new AntPathMatcher();
    private ClassLoader _classLoader;
    String CLASSPATH_ALL_URL_PREFIX = "classpath*:";

    public AresResourceResolver(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public Enumeration<IAdapterURLBean> getResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith(this.CLASSPATH_ALL_URL_PREFIX)) {
            if (this.getPathMatcher().isPattern(locationPattern.substring(this.CLASSPATH_ALL_URL_PREFIX.length()))) {
                return this.findPathMatchingResources(locationPattern);
            }
            return this.findAllClassPathResources(locationPattern.substring(this.CLASSPATH_ALL_URL_PREFIX.length()));
        }
        int prefixEnd = locationPattern.indexOf(":") + 1;
        if (this.getPathMatcher().isPattern(locationPattern.substring(prefixEnd))) {
            return this.findPathMatchingResources(locationPattern);
        }
        return this.findAllClassPathResources(locationPattern);
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public Enumeration<IAdapterURLBean> findAllClassPathResources(String location) throws IOException {
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Enumeration<URL> resourceUrls = this._classLoader.getResources(path);
        return this.createURLBeanEnumeration(resourceUrls);
    }

    private Enumeration<IAdapterURLBean> createURLBeanEnumeration(Enumeration<URL> urlEnum) {
        Vector<IAdapterURLBean> vector = new Vector<IAdapterURLBean>();
        while (urlEnum.hasMoreElements()) {
            IAdapterURLBean urlBean = new IAdapterURLBean(urlEnum.nextElement(), 0L, "", "unknown");
            vector.add(urlBean);
        }
        return vector.elements();
    }

    protected Enumeration<IAdapterURLBean> findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Enumeration<IAdapterURLBean> rootDirResources = this.getResources(rootDirPath);
        Vector result = new Vector(16);
        while (rootDirResources.hasMoreElements()) {
            IAdapterURLBean rootDirResourceURLBean = rootDirResources.nextElement();
            URL rootDirResource = rootDirResourceURLBean.getUrl();
            if (ResourceUtils.isJarURL(rootDirResource)) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, subPattern));
                continue;
            }
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        return result.elements();
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(":") + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.getPathMatcher().isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set doFindPathMatchingJarResources(URL rootDirResource, String subPattern) throws IOException {
        URLConnection con = rootDirResource.openConnection();
        JarFile jarFile = null;
        String jarFileUrl = null;
        String rootEntryPath = null;
        boolean newJarFile = false;
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarCon.setUseCaches(false);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = rootDirResource.getFile();
            int separatorIndex = urlFile.indexOf("!/");
            if (separatorIndex != -1) {
                jarFileUrl = urlFile.substring(0, separatorIndex);
                rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
                jarFile = this.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                rootEntryPath = "";
            }
            newJarFile = true;
        }
        try {
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath + "/";
            }
            LinkedHashSet<IAdapterURLBean> result = new LinkedHashSet<IAdapterURLBean>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath)) continue;
                String relativePath = entryPath.substring(rootEntryPath.length());
                if (!this.getPathMatcher().match(subPattern, relativePath)) continue;
                String rootDirResourceString = rootDirResource.toString();
                if (!"".equals(rootDirResourceString) && !rootDirResourceString.endsWith("/")) {
                    rootDirResourceString = rootDirResourceString + "/";
                }
                URL url = new URL(rootDirResourceString + entryPath.substring(rootEntryPath.length()));
                IAdapterURLBean urlBean = new IAdapterURLBean(url, entry.getTime(), rootDirResource.toString(), "inJar");
                result.add(urlBean);
            }
            LinkedHashSet<IAdapterURLBean> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(ResourceUtils.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    public Set doFindPathMatchingFileResources(URL rootDirResource, String subPattern) throws IOException {
        File rootDir = null;
        try {
            rootDir = new File(URLDecoder.decode(rootDirResource.getFile(), "utf-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_SET;
        }
        return this.doFindMatchingFileSystemResources(rootDir, subPattern);
    }

    protected Set doFindMatchingFileSystemResources(File rootDir, String subPattern) throws IOException {
        Set matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        LinkedHashSet<IAdapterURLBean> result = new LinkedHashSet<IAdapterURLBean>(matchingFiles.size());
        for (File file : matchingFiles) {
            IAdapterURLBean urlBean = new IAdapterURLBean(file.toURL(), file.lastModified(), rootDir.toURL().toString(), "inFolder");
            result.add(urlBean);
        }
        return result;
    }

    protected Set retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("Resource path [" + rootDir + "] does not denote a directory");
        }
        String fullPattern = StringUtils.replace(rootDir.getAbsolutePath(), File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        fullPattern = fullPattern + StringUtils.replace(pattern, File.separator, "/");
        LinkedHashSet result = new LinkedHashSet(8);
        this.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, Set result) throws IOException {
        File[] dirContents = dir.listFiles();
        if (dirContents == null) {
            throw new IOException("Could not retrieve contents of directory [" + dir.getAbsolutePath() + "]");
        }
        for (int i = 0; i < dirContents.length; ++i) {
            File content = dirContents[i];
            String currPath = StringUtils.replace(content.getAbsolutePath(), File.separator, "/");
            if (content.isDirectory() && this.getPathMatcher().matchStart(fullPattern, currPath + "/")) {
                this.doRetrieveMatchingFiles(fullPattern, content, result);
            }
            if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
            result.add(content);
        }
    }
}

