/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.executor;

import com.hundsun.t2sdk.common.core.context.ContextUtil;
import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.common.share.dataset.DatesetCoalition;
import com.hundsun.t2sdk.executor.IServiceExecutor;
import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.interfaces.IClient;
import com.hundsun.t2sdk.interfaces.T2SDKException;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class T2ServiceExecutor
implements IServiceExecutor {
    static T2ServiceExecutor defaultServiceExecutor = new T2ServiceExecutor();
    static T2Services sdkServices = null;
    static IClient client = null;

    private void T2ServiceExecutor() {
    }

    @Override
    public void stop() {
        sdkServices.stop();
    }

    @Override
    public void init() {
        sdkServices = T2Services.getInstance();
        try {
            sdkServices.init();
            sdkServices.start();
        }
        catch (T2SDKException e) {
            T2Services.getLogAdapter().log("T2ServiceExecutor  init error:" + e.getErrorMessage());
        }
    }

    @Override
    public void getClient(String clientName) {
        try {
            client = sdkServices.getClient(clientName);
        }
        catch (T2SDKException e) {
            T2Services.getLogAdapter().log("T2ServiceExecutor  getClient error:" + e.getErrorMessage());
        }
    }

    public static T2ServiceExecutor getInstance() {
        return defaultServiceExecutor;
    }

    @Override
    public Map<String, Object> execute(String serviceId, List<Object> inDataList, List<Class> outClassList) {
        IEvent event = ContextUtil.getServiceContext().getEventFactory().getEvent(serviceId, 0);
        return this.execute(event, inDataList, outClassList);
    }

    @Override
    public Map<String, Object> executeByAlias(int functionId, List<Object> inDataList, List<Class> outClassList) {
        IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias(Integer.toString(functionId), 0);
        return this.execute(event, inDataList, outClassList);
    }

    @Override
    public Map<String, Object> executeMultiLine(String serviceId, List<List<Object>> inDataList, List<Class> outClassList) {
        IEvent event = ContextUtil.getServiceContext().getEventFactory().getEvent(serviceId, 0);
        return this.executeMultiLine(event, inDataList, outClassList);
    }

    @Override
    public Map<String, Object> executeMultiLineByAlias(int functionId, List<List<Object>> inDataList, List<Class> outClassList) {
        IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias(Integer.toString(functionId), 0);
        return this.executeMultiLine(event, inDataList, outClassList);
    }

    private Map<String, Object> execute(IEvent event, List<Object> inDataList, List<Class> outClassList) {
        DatesetCoalition datasetCoalition = new DatesetCoalition();
        int i = 0;
        IDataset dataset = null;
        for (Object inData : inDataList) {
            if (i++ == 0) {
                dataset = DatasetService.getInstace().getDataset(inData, inData.getClass());
                continue;
            }
            dataset = datasetCoalition.join(dataset, DatasetService.getInstace().getDataset(inData, inData.getClass()));
        }
        event.putEventData(dataset);
        IEvent resultEvent = null;
        try {
            resultEvent = client.sendReceive(event);
        }
        catch (T2SDKException e) {
            T2Services.getLogAdapter().log("T2ServiceExecutor  execute error:" + e.getErrorMessage());
        }
        IDataset retDataset = resultEvent.getEventDatas().getDataset(0);
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("error_no", resultEvent.getErrorNo());
        retMap.put("error_info", resultEvent.getErrorInfo());
        retMap.put("return_code", resultEvent.getReturnCode());
        for (Class outClass : outClassList) {
            retMap.put(outClass.getName(), DatasetService.getInstace().transformToList(retDataset, outClass));
        }
        return retMap;
    }

    private Map<String, Object> executeMultiLine(IEvent event, List<List<Object>> inDataList, List<Class> outClassList) {
        DatesetCoalition datasetCoalition = new DatesetCoalition();
        int i = 0;
        IDataset dataset = null;
        for (List<Object> inData : inDataList) {
            Class<?> listValueClass = null;
            if (inData.size() <= 0) continue;
            listValueClass = inData.get(0).getClass();
            if (i++ == 0) {
                dataset = DatasetService.getInstace().getDataset(inData, listValueClass);
                continue;
            }
            dataset = datasetCoalition.join(dataset, DatasetService.getInstace().getDataset(inData, listValueClass));
        }
        event.putEventData(dataset);
        IEvent resultEvent = null;
        try {
            resultEvent = client.sendReceive(event);
        }
        catch (T2SDKException e) {
            T2Services.getLogAdapter().log("T2ServiceExecutor  executeMultiLine error:" + e.getErrorMessage());
        }
        IDataset retDataset = resultEvent.getEventDatas().getDataset(0);
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("error_info", resultEvent.getErrorInfo());
        retMap.put("error_no", resultEvent.getErrorNo());
        retMap.put("return_code", resultEvent.getReturnCode());
        for (Class outClass : outClassList) {
            retMap.put(outClass.getName(), DatasetService.getInstace().transformToList(retDataset, outClass));
        }
        return retMap;
    }
}

