/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.client;

import com.hundsun.t2sdk.common.share.event.CommonEvent_1;
import com.hundsun.t2sdk.common.share.util.ByteArrayStream;
import com.hundsun.t2sdk.common.share.util.ByteArrayUtil;
import com.hundsun.t2sdk.common.share.util.EventUtils;
import com.hundsun.t2sdk.impl.client.EventReceive;
import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.impl.client.TransportControl;
import com.hundsun.t2sdk.impl.environment.ClientConnectionInfo;
import com.hundsun.t2sdk.impl.environment.ClientEnvironment;
import com.hundsun.t2sdk.impl.environment.Environment;
import com.hundsun.t2sdk.impl.pwd.PwdParameter;
import com.hundsun.t2sdk.impl.safe.SafeLevel;
import com.hundsun.t2sdk.impl.util.AbstractLogAdapter;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import com.hundsun.t2sdk.interfaces.share.exception.EventException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicLong;

public class ClientConnection {
    private long closeThreadPoolTimeout = 1000L;
    private static AbstractLogAdapter logAdapter = T2Services.getLogAdapter();
    private ClientConnectionInfo clientConnectionInfo;
    private ClientEnvironment clientEnvironment;
    private Environment environment;
    private EventReceive eventReceive;
    private int poolNumber;
    public static final int DEFAULT_REPAIR_TIME = 12000;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_CLIENT = 0;
    public static final int TYPE_SERVER_NAMED = 1;
    public static final int TYPE_SERVER_NONAME = 2;
    public static final int NODE_TYPE_NONE = 0;
    public static final int NODE_TYPE_JRES = 1;
    public static final int STATUS_CANCLED = -1;
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_CONNECTED = 1;
    public static final int STATUS_T2_REGISTED = 2;
    public static final int STATUS_IDLE = 3;
    public static final int STATUS_BUSY = 4;
    public static final int STATUS_ERROR = 0;
    protected int type = -1;
    protected int remoteNodeType = 0;
    protected volatile int status = 0;
    private volatile boolean hasSafeConnected = false;
    protected String nodeName = null;
    protected int nodeNo = -1;
    protected int connectionNo = -1;
    protected long connectedTime;
    protected String address;
    protected int port;
    protected String remoteCharset = "utf-8";
    public static int SO_TIMEOUT = 2000;
    private Socket clientSocket = null;
    private String connectionName;
    private int checkConnectionNum = 0;
    private int identityNo = 0;
    protected AtomicLong sendPackCount = new AtomicLong(0L);
    protected AtomicLong recvPackCount = new AtomicLong(0L);
    protected AtomicLong sendDataSize = new AtomicLong(0L);
    protected AtomicLong recvDataSize = new AtomicLong(0L);
    protected long lastActiveTime = System.currentTimeMillis();
    protected long lastDisconnTime = -1L;
    protected long lastConnectTime = -1L;
    protected int reconnCount = -1;
    protected TransportControl transportControl;

    public ClientConnection(int identityNo, int poolNumber, ClientConnectionInfo clientConnectionInfo, ClientEnvironment clientEnvironment, Environment environment, TransportControl transportControl) {
        this.transportControl = transportControl;
        this.poolNumber = poolNumber;
        this.clientConnectionInfo = clientConnectionInfo;
        this.environment = environment;
        this.clientEnvironment = clientEnvironment;
        this.nodeNo = clientConnectionInfo.getNodeNo();
        this.identityNo = identityNo;
        this.connectionName = clientEnvironment.getParentName() + "#" + clientConnectionInfo.getNodeNo() + "#" + poolNumber;
        this.address = clientConnectionInfo.getIp();
        this.port = clientConnectionInfo.getPort();
        this.status = 0;
        this.remoteCharset = clientConnectionInfo.getCharset();
        this.nodeName = clientEnvironment.getParentName();
        this.connectionNo = poolNumber;
    }

    public ClientConnectionInfo getClientConnectionInfo() {
        return this.clientConnectionInfo;
    }

    public void setClientConnectionInfo(ClientConnectionInfo clientConnectionInfo) {
        this.clientConnectionInfo = clientConnectionInfo;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public int getStatus() {
        return this.status;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getNodeNo() {
        return this.nodeNo;
    }

    public int getConnectionNo() {
        return this.connectionNo;
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    public long getLastActiveTime() {
        return this.eventReceive.getHeartBeatBegin();
    }

    public boolean isDisconnected() {
        return this.status == 0;
    }

    public boolean isConnected() {
        return this.status == 1;
    }

    public boolean hasConnected() {
        return this.status >= 1;
    }

    public boolean isRegistered() {
        return this.status == 2;
    }

    public boolean hasRegisterd() {
        return this.status >= 2;
    }

    public boolean isIdle() {
        return this.status == 3;
    }

    public boolean isValid() {
        return this.status > 2;
    }

    public boolean markConnectionIdle() {
        if (this.status >= 2) {
            this.status = 3;
            return true;
        }
        return false;
    }

    public boolean markConnectionBusy() {
        if (this.status >= 2) {
            this.status = 4;
            return true;
        }
        return false;
    }

    public boolean markConnectionError() {
        if (this.status >= 2) {
            this.status = 0;
        }
        return true;
    }

    public void start() {
        this.eventReceive = new EventReceive(this.clientConnectionInfo, this.clientEnvironment, this.environment, this);
        this.eventReceive.start();
    }

    public void stop() {
        this.close();
        this.cutThread();
    }

    public void close() {
        PwdParameter pwdParam;
        if (this.isDisconnected()) {
            return;
        }
        this.status = 0;
        Socket clientSocket = this.clientSocket;
        if (clientSocket != null && !clientSocket.isClosed()) {
            try {
                clientSocket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((pwdParam = this.clientEnvironment.getPwdParameter()) != null) {
            this.eventReceive.setBlowfish(null);
            this.hasSafeConnected = false;
        }
        this.lastDisconnTime = System.currentTimeMillis();
        logAdapter.log(93, this.getConnectionName(), "" + this.connectionNo);
    }

    public void close(String message) {
        PwdParameter pwdParam;
        if (this.isDisconnected()) {
            return;
        }
        this.status = 0;
        Socket clientSocket = this.clientSocket;
        if (clientSocket != null && !clientSocket.isClosed()) {
            try {
                clientSocket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((pwdParam = this.clientEnvironment.getPwdParameter()) != null) {
            this.eventReceive.setBlowfish(null);
            this.hasSafeConnected = false;
        }
        logAdapter.log("\u901a\u4fe1\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00[" + this.getConnectionName() + "] \u539f\u56e0[" + message + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IEvent event) throws EventException {
        Socket clientSocket = this.clientSocket;
        if (this.hasConnected() && clientSocket != null) {
            if (event.isTimestampOn()) {
                event.addTimestamp(System.nanoTime(), "packing event");
            }
            byte[] sendBytes = this.packEvent(event);
            Socket socket = clientSocket;
            synchronized (socket) {
                try {
                    OutputStream output = clientSocket.getOutputStream();
                    output.write(sendBytes);
                    output.flush();
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(12000L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (this.checkConnectionNum++ == 0) {
                        try {
                            this.send(event);
                        }
                        catch (EventException e2) {
                            this.checkConnectionNum = 0;
                            this.close();
                            throw new EventException("100", new Object[]{this.getConnectionName()});
                        }
                    }
                    this.checkConnectionNum = 0;
                    throw new EventException(e, "100", this.getConnectionName());
                }
            }
            if (sendBytes != null) {
                this.sendPackCount.incrementAndGet();
                this.sendDataSize.addAndGet(sendBytes.length);
            }
        } else {
            try {
                Thread.sleep(12000L);
            }
            catch (InterruptedException e3) {
                // empty catch block
            }
            if (this.checkConnectionNum++ == 0) {
                try {
                    this.send(event);
                }
                catch (EventException e4) {
                    this.checkConnectionNum = 0;
                    logAdapter.log("connection closed !");
                    throw new EventException("100", new Object[]{this.getConnectionName()});
                }
            } else {
                this.checkConnectionNum = 0;
                logAdapter.log("connection closed !");
                throw new EventException("100", new Object[]{this.getConnectionName()});
            }
        }
        this.checkConnectionNum = 0;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    protected byte[] packEvent(IEvent event) throws EventException {
        try {
            CommonEvent_1 event_1 = (CommonEvent_1)event;
            ByteArrayStream tmpbuf = new ByteArrayStream(200);
            String charset = this.remoteCharset;
            if (charset == null) {
                charset = T2Services.DEFAULT_CHARSET;
            }
            if (this.environment.isEnmCompress()) {
                event_1.setIntegerAttributeValue("43", 1L);
            }
            byte[] data = event_1.packAllAttributes(charset);
            if (this.clientEnvironment.getClientSafeLevel() == SafeLevel.PWD && this.hasSafeConnected) {
                try {
                    data = this.eventReceive.getBlowfish().encode(data);
                }
                catch (Exception e) {
                    throw new EventException(e, "100", this.getConnectionName());
                }
            }
            byte[] check = ByteArrayUtil.intToByteArray_C(data.length);
            check[0] = (byte)(check[1] ^ check[2] ^ check[3]);
            tmpbuf.write(check);
            tmpbuf.write(data);
            byte[] buff = tmpbuf.toByteArray();
            return buff;
        }
        catch (Exception e) {
            throw new EventException(e, "103", EventUtils.getEventName(event));
        }
    }

    private void cutThread() {
        this.status = 0;
        this.eventReceive.forceToStop();
        this.eventReceive.executeThreadPool.stop(this.closeThreadPoolTimeout);
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }

    public void setClientSocket(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getRemoteCharset() {
        return this.remoteCharset;
    }

    public void setRemoteCharset(String remoteCharset) {
        this.remoteCharset = remoteCharset;
    }

    public int getPoolNumber() {
        return this.poolNumber;
    }

    public void setPoolNumber(int poolNumber) {
        this.poolNumber = poolNumber;
    }

    public EventReceive getEventReceive() {
        return this.eventReceive;
    }

    public void setEventReceive(EventReceive eventReceive) {
        this.eventReceive = eventReceive;
    }

    public int getCheckConnectionNum() {
        return this.checkConnectionNum;
    }

    public AtomicLong getSendPackCount() {
        return this.sendPackCount;
    }

    public void setSendPackCount(AtomicLong sendPackCount) {
        this.sendPackCount = sendPackCount;
    }

    public AtomicLong getRecvPackCount() {
        return this.recvPackCount;
    }

    public void setRecvPackCount(AtomicLong recvPackCount) {
        this.recvPackCount = recvPackCount;
    }

    public AtomicLong getSendDataSize() {
        return this.sendDataSize;
    }

    public void setSendDataSize(AtomicLong sendDataSize) {
        this.sendDataSize = sendDataSize;
    }

    public AtomicLong getRecvDataSize() {
        return this.recvDataSize;
    }

    public void setRecvDataSize(AtomicLong recvDataSize) {
        this.recvDataSize = recvDataSize;
    }

    public long getLastDisconnTime() {
        return this.lastDisconnTime;
    }

    public void setLastDisconnTime(long lastDisconnTime) {
        this.lastDisconnTime = lastDisconnTime;
    }

    public long getLastConnectTime() {
        return this.lastConnectTime;
    }

    public void setLastConnectTime(long lastConnectTime) {
        this.lastConnectTime = lastConnectTime;
    }

    public int getReconnCount() {
        return this.eventReceive.getReconnCount();
    }

    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public void recvPackCountIncrement() {
        this.recvPackCount.incrementAndGet();
    }

    public void recvDataSizeAddAndGet(Integer length) {
        this.recvDataSize.addAndGet(length.intValue());
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int getIdentityNo() {
        return this.identityNo;
    }

    public boolean isSafeConnected() {
        return this.hasSafeConnected;
    }

    public void setSafeConnected(boolean hasSafeConnected) {
        this.hasSafeConnected = hasSafeConnected;
    }

    public TransportControl getTransportControl() {
        return this.transportControl;
    }

    public ClientEnvironment getClientEnvironment() {
        return this.clientEnvironment;
    }
}

