/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.client;

import com.hundsun.t2sdk.common.core.context.ContextUtil;
import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.common.share.util.EventUtils;
import com.hundsun.t2sdk.impl.client.ClientConnection;
import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.impl.client.TransportControl;
import com.hundsun.t2sdk.impl.client.TransportEvent;
import com.hundsun.t2sdk.impl.environment.ClientConnectionInfo;
import com.hundsun.t2sdk.impl.environment.ClientEnvironment;
import com.hundsun.t2sdk.impl.environment.Environment;
import com.hundsun.t2sdk.impl.util.AbstractLogAdapter;
import com.hundsun.t2sdk.interfaces.IClient;
import com.hundsun.t2sdk.interfaces.T2SDKException;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import com.hundsun.t2sdk.interfaces.share.exception.EventException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
implements IClient {
    private AbstractLogAdapter logAdapter = T2Services.getLogAdapter();
    private byte[] connWaitEvent = new byte[0];
    private List<ClientConnection> connections = new ArrayList<ClientConnection>();
    private int currentIndex = 0;
    private ClientEnvironment clientEnvironment;
    private Environment environment;
    private TransportControl transportControl;

    public ClientImpl(ClientEnvironment clientEnvironment, Environment environment) {
        this.clientEnvironment = clientEnvironment;
        this.environment = environment;
    }

    public ClientEnvironment getClientEnvironment() {
        return this.clientEnvironment;
    }

    public void setClientEnvironment(ClientEnvironment clientEnvironment) {
        this.clientEnvironment = clientEnvironment;
    }

    @Override
    public void start() {
        this.transportControl = new TransportControl();
        Map<Integer, ClientConnectionInfo> connectionInfoMap = this.clientEnvironment.getConnectionInfoMap();
        Iterator<Map.Entry<Integer, ClientConnectionInfo>> it = connectionInfoMap.entrySet().iterator();
        int identityNo = 0;
        while (it.hasNext()) {
            Map.Entry<Integer, ClientConnectionInfo> entry = it.next();
            ClientConnectionInfo clientConnectionInfo = entry.getValue();
            int poolSize = clientConnectionInfo.getPoolSize();
            for (int i = 0; i < poolSize; ++i) {
                ClientConnection clientConnection = new ClientConnection(identityNo++, i, clientConnectionInfo, this.clientEnvironment, this.environment, this.transportControl);
                this.connections.add(clientConnection);
                clientConnection.start();
            }
        }
    }

    public boolean clientConnectionBeReady() {
        for (ClientConnection clientConnection : this.connections) {
            if (clientConnection.getStatus() >= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
        for (ClientConnection clientConnection : this.connections) {
            clientConnection.stop();
        }
        this.connections.clear();
    }

    @Override
    public void send(IEvent event) throws T2SDKException {
        ClientConnection clientConnection = this.getConnection();
        if (clientConnection == null) {
            throw new T2SDKException("801", new Object[0]);
        }
        try {
            clientConnection.send(event);
        }
        catch (EventException e) {
            throw new T2SDKException("805", new Object[0]);
        }
        finally {
            this.returnConnection(clientConnection);
        }
    }

    @Override
    public void send(Map<String, Object> tagMap, Map<Object, Object> dataMap) throws T2SDKException {
        this.send(this.getEvent(tagMap, dataMap));
    }

    @Override
    public IEvent sendReceive(IEvent event) throws T2SDKException {
        return this.sendReceive(event, this.environment.getCallBackTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEvent sendReceive(IEvent event, long waitTime) throws T2SDKException {
        IEvent response = null;
        ClientConnection clientConnection = this.getConnection();
        if (clientConnection == null) {
            throw new T2SDKException("801", new Object[0]);
        }
        event.setIntegerAttributeValue("11", EventUtils.getInstance().generateEventNo());
        TransportEvent transportEvent = this.transportControl.registerTransportEvent(event);
        if (transportEvent == null) {
            this.transportControl.releaseEvent(transportEvent);
        }
        try {
            clientConnection.send(event);
        }
        catch (EventException e) {
            this.transportControl.releaseEvent(transportEvent);
            throw new T2SDKException("805", new Object[0]);
        }
        finally {
            this.returnConnection(clientConnection);
        }
        try {
            TransportEvent transportEvent2 = transportEvent;
            synchronized (transportEvent2) {
                response = transportEvent.getResponse();
                if (response == null) {
                    try {
                        transportEvent.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    response = transportEvent.getResponse();
                }
            }
        }
        finally {
            this.transportControl.releaseEvent(transportEvent);
        }
        if (response == null) {
            throw new T2SDKException("802", new Object[]{EventUtils.getEventName(event)});
        }
        return response;
    }

    @Override
    public IEvent sendReceive(Map<String, Object> tagMap, Map<Object, Object> dataMap) throws T2SDKException {
        IEvent event = this.sendReceive(this.getEvent(tagMap, dataMap), this.environment.getCallBackTime());
        return event;
    }

    @Override
    public IEvent sendReceive(Map<String, Object> tagMap, Map<Object, Object> dataMap, long time) throws T2SDKException {
        IEvent event = this.sendReceive(this.getEvent(tagMap, dataMap), time);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized ClientConnection getConnection() {
        ClientConnection conn = null;
        boolean bTimeOut = false;
        long start = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        long iTimeout = this.environment.getAcquireConnWaitTime();
        if (iTimeout <= 0L) {
            iTimeout = 5L;
        }
        int index = 0;
        int size = this.connections.size();
        if (size == 0) {
            return null;
        }
        while (true) {
            if (!bTimeOut && conn == null) {
                size = this.connections.size();
            } else {
                this.currentIndex = (this.currentIndex + index + 1) % size;
                return conn;
            }
            for (index = 0; index < size; ++index) {
                conn = this.connections.get((this.currentIndex + index) % size);
                if (conn != null && conn.isIdle()) {
                    conn.markConnectionBusy();
                    break;
                }
                conn = null;
            }
            if (conn != null) continue;
            byte[] byArray = this.connWaitEvent;
            // MONITORENTER : this.connWaitEvent
            try {
                this.connWaitEvent.wait(iTimeout);
                now = System.currentTimeMillis();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (now - start < iTimeout) continue;
            bTimeOut = true;
        }
    }

    private IEvent getEvent(Map<String, Object> tagMap, Map<Object, Object> dataMap) {
        IEvent event = null;
        String serviceId = (String)tagMap.get("75");
        int eventTypeInt = 0;
        if (tagMap.get("3") != null) {
            eventTypeInt = Integer.parseInt((String)tagMap.get("3"));
        }
        if (serviceId != null) {
            event = ContextUtil.getServiceContext().getEventFactory().getEvent(serviceId, eventTypeInt);
        } else {
            String aliasId = (String)tagMap.get("5");
            if (aliasId != null) {
                event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias(aliasId, eventTypeInt);
            } else {
                this.logAdapter.log(1403, new String[0]);
            }
        }
        if (event != null) {
            for (Map.Entry<String, Object> entry : tagMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                if (value instanceof String) {
                    event.setStringAttributeValue(key, (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    event.setIntegerAttributeValue(key, (Long)value);
                    continue;
                }
                if (value instanceof Integer) {
                    event.setIntegerAttributeValue(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof byte[]) {
                    event.setByteArrayAttributeValue(key, (byte[])value);
                    continue;
                }
                if (value instanceof String[]) {
                    event.setStringArrayAttributeValue(key, (String[])value);
                    continue;
                }
                event.setAttributeValue(key, value);
            }
            Map<Object, Object> map = new HashMap();
            if (dataMap != null) {
                map = dataMap;
            }
            IDataset dataset = DatasetService.getDefaultInstance().getDataset(map);
            event.putEventData(dataset);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnConnection(ClientConnection conn) {
        conn.markConnectionIdle();
        byte[] byArray = this.connWaitEvent;
        synchronized (this.connWaitEvent) {
            this.connWaitEvent.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public List<ClientConnection> getConnections() {
        return this.connections;
    }
}

