/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.client;

import com.hundsun.t2sdk.common.core.context.ContextUtil;
import com.hundsun.t2sdk.common.core.pool.RestlessThreadExcutor;
import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.common.share.dataset.MapWriter;
import com.hundsun.t2sdk.common.share.event.CommonEvent_1;
import com.hundsun.t2sdk.common.share.util.ByteArrayUtil;
import com.hundsun.t2sdk.common.share.util.EventUtils;
import com.hundsun.t2sdk.common.share.util.StringUtil;
import com.hundsun.t2sdk.impl.client.ClientConnection;
import com.hundsun.t2sdk.impl.client.ClientSocket;
import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.impl.client.TransportEvent;
import com.hundsun.t2sdk.impl.environment.ClientConnectionInfo;
import com.hundsun.t2sdk.impl.environment.ClientEnvironment;
import com.hundsun.t2sdk.impl.environment.Environment;
import com.hundsun.t2sdk.impl.pwd.PwdParameter;
import com.hundsun.t2sdk.impl.reliable.ReliableBody;
import com.hundsun.t2sdk.impl.safe.SSLUtil;
import com.hundsun.t2sdk.impl.safe.SafeLevel;
import com.hundsun.t2sdk.impl.util.AbstractLogAdapter;
import com.hundsun.t2sdk.impl.util.CallBackSampleTask;
import com.hundsun.t2sdk.impl.util.HSBlowfish;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasets;
import com.hundsun.t2sdk.interfaces.share.event.EventType;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import com.hundsun.t2sdk.interfaces.share.exception.EventException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class EventReceive {
    public static final String EVENT_DATA = "jres#EVENT_DATA";
    private final boolean isMsgCenterMode;
    private final String TAG_MSG_CENTER_HEARTBEAT = "620000";
    protected RestlessThreadExcutor executeThreadPool;
    private T2ClientConnThread connThread = null;
    private static AbstractLogAdapter logAdapter = T2Services.getLogAdapter();
    private long abandonedCount = 0L;
    private byte[] abandonedCountLock = new byte[0];
    private byte[] connLock = new byte[0];
    private ClientConnectionInfo connectionInfo;
    private Environment environment;
    private ClientEnvironment clientEnvironment;
    private ClientConnection clientConnection;
    private HSBlowfish blowfish;

    public EventReceive(ClientConnectionInfo clientConnectionInfo, ClientEnvironment clientEnvironment, Environment environment, ClientConnection clientConnection) {
        this.clientEnvironment = clientEnvironment;
        this.connectionInfo = clientConnectionInfo;
        this.environment = environment;
        this.clientConnection = clientConnection;
        this.isMsgCenterMode = clientConnectionInfo.isMsgCenter();
    }

    public long getHeartBeatBegin() {
        return this.connThread.getHeartBeatBegin();
    }

    public int getReconnCount() {
        return this.connThread.getReconnCount();
    }

    public void forceToStop() {
        this.connThread.forceToStop();
    }

    public void start() {
        this.connThread = new T2ClientConnThread();
        this.executeThreadPool = new RestlessThreadExcutor(this.environment.getSendPoolSize(), this.environment.getSenderQueueLength(), "t2sdk-eventReceiveThreadPool");
        this.executeThreadPool.start();
        this.connThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEventReveived(IEvent event) throws EventException {
        long eventId = event.getIntegerAttributeValue("11");
        long sendId = event.getIntegerAttributeValue("12");
        if (sendId == -1L && this.environment.getCallBackMethods().get(new Long(-1L)) != null && !this.clientConnection.getTransportControl().getEventRepository().containsKey(eventId)) {
            if (!this.executeThreadPool.execute(new CallBackSampleTask(this.environment.getCallBackMethods().get(new Long(-1L)), event, new ClientSocket(this.clientConnection), this.environment.getCallBackMethodInstance()))) {
                throw new EventException("81", new Object[]{EventUtils.getEventName(event)});
            }
        } else if (EventType.isAnswer(event.getEventType()) && sendId <= 0L) {
            TransportEvent te = this.clientConnection.getTransportControl().getEventRepository().remove(eventId);
            if (te != null) {
                TransportEvent transportEvent = te;
                synchronized (transportEvent) {
                    te.setResponse(event);
                    te.notifyAll();
                }
            } else {
                byte[] byArray = this.abandonedCountLock;
                synchronized (this.abandonedCountLock) {
                    ++this.abandonedCount;
                    // ** MonitorExit[var7_6] (shouldn't be in output)
                }
            }
        } else if (EventType.isAnswer(event.getEventType()) && sendId > 0L && this.environment.getCallBackMethods().get(sendId) != null ? !this.executeThreadPool.execute(new CallBackSampleTask(this.environment.getCallBackMethods().get(sendId), event, new ClientSocket(this.clientConnection), this.environment.getCallBackMethodInstance())) : EventType.isRequest(event.getEventType()) && sendId >= 0L && this.environment.getCallBackMethods().get(new Long(0L)) != null && !this.executeThreadPool.execute(new CallBackSampleTask(this.environment.getCallBackMethods().get(new Long(0L)), event, new ClientSocket(this.clientConnection), this.environment.getCallBackMethodInstance()))) {
            throw new EventException("81", new Object[]{EventUtils.getEventName(event)});
        }
    }

    public long getAbandonedCount() {
        return this.abandonedCount;
    }

    public HSBlowfish getBlowfish() {
        return this.blowfish;
    }

    public void setBlowfish(HSBlowfish blowfish) {
        this.blowfish = blowfish;
    }

    private class T2ClientConnThread
    extends Thread {
        private Thread runThread;
        private ClientConnectionInfo connectionInfo;
        private Environment environment;
        private volatile boolean isActive = false;
        private long heartBeatBegin;
        private static final int HB_NORMAL = 0;
        private static final int HB_COUNT = 1;
        private int heartBeatMode = 0;
        private int reconnCount = 0;
        private ParsePackageTask packageTask;

        public T2ClientConnThread() {
            this.connectionInfo = EventReceive.this.connectionInfo;
            this.environment = EventReceive.this.environment;
            this.packageTask = new ParsePackageTask();
            this.setName("client#" + EventReceive.this.clientConnection.getConnectionName());
        }

        public void start() {
            this.isActive = true;
            super.start();
        }

        public void run() {
            this.runThread = Thread.currentThread();
            if (this.environment.getStopMode().equals("interrupt")) {
                try {
                    while (this.isActive && !Thread.interrupted()) {
                        if (EventReceive.this.clientConnection.isDisconnected()) {
                            EventReceive.this.clientConnection.setSafeConnected(false);
                            if (this.reconnCount >= 1) {
                                T2ClientConnThread.sleep(this.environment.getReconnInterval() * 1000);
                            }
                            this.createConnection();
                            continue;
                        }
                        this.commonReadEvent();
                    }
                }
                catch (InterruptedException e) {}
            } else {
                while (this.isActive) {
                    if (EventReceive.this.clientConnection.isDisconnected()) {
                        EventReceive.this.clientConnection.setSafeConnected(false);
                        if (this.reconnCount >= 1) {
                            try {
                                T2ClientConnThread.sleep(this.environment.getReconnInterval() * 1000);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        this.createConnection();
                        continue;
                    }
                    this.commonReadEvent();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createConnection() {
            byte[] byArray = EventReceive.this.connLock;
            synchronized (byArray) {
                ++this.reconnCount;
                this.establishConnection();
                if (EventReceive.this.clientConnection.isConnected()) {
                    boolean goingOn = false;
                    if (EventReceive.this.clientEnvironment.getClientSafeLevel() == SafeLevel.PWD) {
                        if (!this.registerPwdConnection()) {
                            logAdapter.log("pwd register error");
                            EventReceive.this.clientConnection.setSafeConnected(false);
                            goingOn = false;
                        } else {
                            EventReceive.this.clientConnection.setSafeConnected(true);
                            goingOn = true;
                        }
                    } else {
                        goingOn = true;
                    }
                    if (goingOn && this.registerT2Connection()) {
                        this.reconnCount = 0;
                        this.heartBeatBegin = System.currentTimeMillis();
                        EventReceive.this.clientConnection.markConnectionIdle();
                        logAdapter.log(105, EventReceive.this.clientConnection.getConnectionName(), EventReceive.this.clientConnection.getClientSocket().getInetAddress().toString(), "" + EventReceive.this.clientConnection.getClientSocket().getPort());
                        EventReceive.this.clientConnection.setLastConnectTime(System.currentTimeMillis());
                        ++this.reconnCount;
                    }
                    if (EventReceive.this.clientEnvironment.getStateListen() != null) {
                        EventReceive.this.clientEnvironment.getStateListen().onConnected(EventReceive.this.clientEnvironment.getParentName());
                    }
                }
                EventReceive.this.clientConnection.setLastConnectTime(System.currentTimeMillis());
            }
        }

        public void notifyToStop() {
            this.isActive = false;
        }

        public void forceToStop() {
            this.isActive = false;
            if (this.environment.getStopMode().equals("interrupt")) {
                if (this.runThread != null) {
                    this.runThread.interrupt();
                }
            } else {
                try {
                    this.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        protected boolean establishConnection() {
            EventReceive.this.clientConnection.close();
            EventReceive.this.clientConnection.setClientSocket(null);
            try {
                EventReceive.this.clientConnection.setClientSocket(this.getSocket());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (EventReceive.this.clientConnection.getClientSocket() != null) {
                ClientConnection clientConnection = EventReceive.this.clientConnection;
                EventReceive.this.clientConnection;
                clientConnection.setStatus(1);
                return true;
            }
            ClientConnection clientConnection = EventReceive.this.clientConnection;
            EventReceive.this.clientConnection;
            clientConnection.setStatus(0);
            return false;
        }

        private Socket getSocket() throws IOException {
            InetAddress hostAddress = null;
            try {
                hostAddress = InetAddress.getByName(this.connectionInfo.getIp());
            }
            catch (UnknownHostException e) {
                logAdapter.log(100, EventReceive.this.clientConnection.getConnectionName(), this.connectionInfo.getIp());
                return null;
            }
            Socket clientSocket = null;
            try {
                if (EventReceive.this.clientEnvironment.getClientSafeLevel() == SafeLevel.SSL) {
                    clientSocket = this.getSSLSocket(this.connectionInfo.getIp());
                } else {
                    clientSocket = new Socket(hostAddress, this.connectionInfo.getPort());
                    clientSocket.setKeepAlive(true);
                    clientSocket.setSoTimeout(this.environment.getSocketSOTimeout());
                    clientSocket.setReceiveBufferSize(this.environment.getClient_SO_RCVBUF());
                    clientSocket.setSendBufferSize(this.environment.getClient_SO_SNDBUF());
                }
            }
            catch (IOException e) {
                logAdapter.log(101, EventReceive.this.clientConnection.getConnectionName(), hostAddress.toString(), "" + this.connectionInfo.getPort());
                clientSocket = null;
            }
            return clientSocket;
        }

        private boolean registerPwdConnection() {
            PwdParameter pwdParam = EventReceive.this.clientEnvironment.getPwdParameter();
            try {
                IEvent event = this.makeSafeConnectRequest();
                EventReceive.this.clientConnection.send(event);
            }
            catch (Exception e) {
                logAdapter.log("registerPwdConnection has error for[" + e.getMessage() + "]");
                return false;
            }
            String errorInfo = "";
            IEvent response = this.readEvent();
            if (response != null) {
                String errorNo = response.getErrorNo();
                if (errorNo != null && !errorNo.equals("0")) {
                    errorInfo = response.getErrorInfo();
                } else {
                    byte[] dataKey = response.getByteArrayAttributeValue("26");
                    if (dataKey != null) {
                        if (dataKey.length == 16) {
                            try {
                                byte[] commKey = HSBlowfish.decode(dataKey, pwdParam.getCommPwd());
                                HSBlowfish blowfish = new HSBlowfish(commKey);
                                EventReceive.this.blowfish = blowfish;
                                return true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                errorInfo = e.getMessage();
                            }
                        } else {
                            errorInfo = "Key length error: " + dataKey.length;
                        }
                    } else {
                        errorInfo = "Key not specified";
                    }
                }
            } else {
                errorInfo = "registerPwdConnection receive error";
            }
            EventReceive.this.clientConnection.close(errorInfo);
            return false;
        }

        private IEvent makeSafeConnectRequest() throws Exception {
            PwdParameter pwdParam = EventReceive.this.clientEnvironment.getPwdParameter();
            byte[] buffer = new byte[64];
            Arrays.fill(buffer, (byte)75);
            int idLenth = pwdParam.getClientId().length();
            if (idLenth > 0) {
                System.arraycopy(pwdParam.getClientId().getBytes(), 0, buffer, buffer.length - idLenth, idLenth);
            } else {
                System.arraycopy("_defpwd_".getBytes(), 0, buffer, buffer.length - 8, 8);
            }
            buffer = HSBlowfish.encode(buffer, pwdParam.getCommPwd());
            CommonEvent_1 request = new CommonEvent_1();
            request.prepareByAlias("30", 2);
            if (idLenth > 0) {
                request.setStringAttributeValue("24", pwdParam.getClientId());
            }
            request.setByteArrayAttributeValue("25", buffer);
            return request;
        }

        protected boolean registerT2Connection() {
            int eventType;
            boolean result = false;
            try {
                IEvent event = this.makeRegisterEvent();
                EventReceive.this.clientConnection.send(event);
            }
            catch (EventException e) {
                logAdapter.log("send t2-register pack error");
                return result;
            }
            IEvent response = this.readEvent();
            String errorInfo = null;
            if (response != null && (eventType = response.getEventType()) == 3 && "32".equals(response.getServiceAlias())) {
                int returnCode = response.getReturnCode();
                String errorNo = response.getErrorNo();
                errorInfo = response.getErrorInfo();
                if (returnCode == 0 && (errorNo == null || "0".equals(errorNo))) {
                    result = true;
                    String strNodeType = response.getStringAttributeValue("77");
                    if (strNodeType != null && "1".equals(strNodeType)) {
                        ClientConnection clientConnection = EventReceive.this.clientConnection;
                        EventReceive.this.clientConnection;
                        clientConnection.setType(1);
                        if (EventReceive.this.clientConnection.getRemoteCharset() == null) {
                            EventReceive.this.clientConnection.setRemoteCharset("UTF-8");
                        }
                    } else {
                        ClientConnection clientConnection = EventReceive.this.clientConnection;
                        EventReceive.this.clientConnection;
                        clientConnection.setType(0);
                        if (EventReceive.this.clientConnection.getRemoteCharset() == null) {
                            EventReceive.this.clientConnection.setRemoteCharset("GBK");
                        }
                    }
                }
            }
            if (result) {
                EventReceive.this.clientConnection.setStatus(2);
            } else {
                EventReceive.this.clientConnection.close(errorInfo);
            }
            return result;
        }

        protected IEvent readEvent() {
            int length = this.readHead();
            if (length > 0) {
                return this.readBody(length);
            }
            return null;
        }

        protected int commonReadEvent() {
            int length = this.readHead();
            if (length > 0) {
                return this.commonReadBody(length);
            }
            return 0;
        }

        private int readHead() {
            int length = -1;
            byte[] head = new byte[4];
            try {
                this.readData(EventReceive.this.clientConnection.getClientSocket().getInputStream(), head, 0, 4);
            }
            catch (IOException e) {
                logAdapter.log(102, EventReceive.this.clientConnection.getConnectionName(), e.getMessage());
                EventReceive.this.clientConnection.close();
                return length;
            }
            if (head[0] != (byte)(head[1] ^ head[2] ^ head[3])) {
                logAdapter.log(102, EventReceive.this.clientConnection.getConnectionName(), "pack-head varified error");
                EventReceive.this.clientConnection.close();
                return length;
            }
            head[0] = 0;
            length = ByteArrayUtil.byteArrayToInt_C(head, 0);
            if (length <= 0) {
                logAdapter.log(102, EventReceive.this.clientConnection.getConnectionName(), "invalid pack-body size:" + length);
                EventReceive.this.clientConnection.close();
                return -1;
            }
            return length;
        }

        private IEvent readBody(int length) {
            byte[] body = new byte[length];
            try {
                this.readData(EventReceive.this.clientConnection.getClientSocket().getInputStream(), body, 0, length);
            }
            catch (IOException e) {
                logAdapter.log(103, EventReceive.this.clientConnection.getConnectionName(), e.getMessage());
                EventReceive.this.clientConnection.close();
                return null;
            }
            try {
                String charset;
                if (EventReceive.this.clientEnvironment.getClientSafeLevel() == SafeLevel.PWD && EventReceive.this.clientConnection.isSafeConnected()) {
                    try {
                        body = EventReceive.this.blowfish.decode(body);
                    }
                    catch (Exception e) {
                        throw new EventException(e, "100", EventReceive.this.clientConnection.getConnectionName());
                    }
                }
                if ((charset = EventReceive.this.clientConnection.getRemoteCharset()) == null) {
                    charset = T2Services.DEFAULT_CHARSET;
                }
                CommonEvent_1 event = new CommonEvent_1(body, charset);
                EventReceive.this.clientConnection.recvPackCountIncrement();
                EventReceive.this.clientConnection.recvDataSizeAddAndGet(length + 4);
                return event;
            }
            catch (Exception e) {
                logAdapter.log(104, EventReceive.this.clientConnection.getConnectionName());
                return null;
            }
        }

        private int commonReadBody(int length) {
            byte[] body = new byte[length];
            try {
                this.readData(EventReceive.this.clientConnection.getClientSocket().getInputStream(), body, 0, length);
            }
            catch (IOException e) {
                logAdapter.log(103, EventReceive.this.clientConnection.getConnectionName(), e.getMessage());
                EventReceive.this.clientConnection.close();
                return -1;
            }
            EventReceive.this.clientConnection.recvPackCountIncrement();
            EventReceive.this.clientConnection.recvDataSizeAddAndGet(length + 4);
            if (EventReceive.this.clientEnvironment.getClientSafeLevel() == SafeLevel.PWD) {
                try {
                    body = EventReceive.this.blowfish.decode(body);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logAdapter.log("pwd\u89e3\u5305\u5931\u8d25\uff0c\u539f\u56e0[" + e.getMessage() + "]");
                }
            }
            this.packageTask.run(body);
            return length;
        }

        private Socket getSSLSocket(String hostAddress) {
            SSLSocket resultSocket = null;
            try {
                SSLSocketFactory factory = SSLUtil.getSSLContext(EventReceive.this.clientEnvironment.getClientSSLParameter()).getSocketFactory();
                resultSocket = (SSLSocket)factory.createSocket(hostAddress, this.connectionInfo.getPort());
                String[] stringArray = new String[1];
                stringArray[0] = "SSLv3";
                resultSocket.setEnabledProtocols(stringArray);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resultSocket;
        }

        private int readData(InputStream stream, byte[] dest, int offset, int length) throws IOException {
            block8: {
                int i = 0;
                while (true) {
                    long heartBeatTimeout;
                    block7: {
                        heartBeatTimeout = this.environment.getHeartBeatTime() * 1000;
                        i = 0;
                        try {
                            i = stream.read(dest, offset, length);
                        }
                        catch (IOException e1) {
                            if (e1 instanceof SocketTimeoutException) break block7;
                            throw e1;
                        }
                    }
                    if (i == -1) {
                        throw new IOException("1_ InputStream.read() return -1");
                    }
                    if (i == length) break block8;
                    offset += i;
                    length -= i;
                    if (i != 0) {
                        this.heartBeatBegin = System.currentTimeMillis();
                        this.heartBeatMode = 0;
                        continue;
                    }
                    if (System.currentTimeMillis() - this.heartBeatBegin < heartBeatTimeout) continue;
                    if (this.heartBeatMode == 0) {
                        this.heartBeatMode = 1;
                        this.heartBeatBegin = System.currentTimeMillis();
                        if (this.environment.isDebugMode()) {
                            logAdapter.log("connection[" + EventReceive.this.clientConnection.getConnectionName() + "] sent heart beat package to test connection whether is ok");
                        }
                        this.sendHeartBeat();
                        continue;
                    }
                    if (this.heartBeatMode == 1) break;
                }
                this.heartBeatMode = 0;
                this.heartBeatBegin = System.currentTimeMillis();
                throw new IOException("heart beat test failed");
            }
            return 0;
        }

        private void sendHeartBeat() {
            logAdapter.log("sendHeartBeat...");
            IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("33", 2);
            try {
                EventReceive.this.clientConnection.send(event);
            }
            catch (EventException e) {
                logAdapter.log("send heart-beat pack error");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void responseHeartBeat() {
            Socket socket;
            Socket socket2 = socket = EventReceive.this.clientConnection.getClientSocket();
            synchronized (socket2) {
                try {
                    byte[] msg = new byte[]{9, 0, 0, 9, 51, 61, 51, 0, 53, 61, 51, 51, 0};
                    socket.getOutputStream().write(msg);
                    socket.getOutputStream().flush();
                }
                catch (Exception e) {
                    logAdapter.log("response heart-beat pack error");
                    EventReceive.this.clientConnection.close();
                }
            }
        }

        private IEvent makeRegisterEvent() throws EventException {
            IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("32", 2);
            String localServerName = this.environment.getLocalServerName();
            String noNameConnection = EventReceive.this.clientEnvironment.getNoNameConnection();
            if (localServerName != null && localServerName.trim().length() != 0 && noNameConnection.equals("false")) {
                Integer connNo = EventReceive.this.clientConnection.getNodeNo() * 1000 + EventReceive.this.clientConnection.getPoolNumber();
                event.setStringAttributeValue("30", this.environment.getLocalServerName() + "#" + connNo);
            }
            byte[] licenseNo = EventReceive.this.clientEnvironment.getLicenseNo().getBytes();
            byte[] key = new byte[]{49, 0, 83, 53, -120, 96, 5, 112, 25, 115, 7, 35, -105, 3, 24, 69};
            try {
                HSBlowfish blowfish = new HSBlowfish(key);
                licenseNo = blowfish.encodeWithBase64(licenseNo);
            }
            catch (Exception e) {
                throw new EventException(e, "814", new Object[0]);
            }
            event.setByteArrayAttributeValue("31", licenseNo);
            if (!this.environment.isEnmCompress()) {
                event.setStringAttributeValue("57", "1");
            } else {
                event.setStringAttributeValue("57", "0");
            }
            event.setStringAttributeValue("77", "1");
            if (EventReceive.this.clientEnvironment.getUfxPassword() != null) {
                event.setStringAttributeValue("21", EventReceive.this.clientEnvironment.getUfxPassword());
            }
            return event;
        }

        public long getHeartBeatBegin() {
            return this.heartBeatBegin;
        }

        public int getReconnCount() {
            return this.reconnCount;
        }

        private void processMDBEvent(IEvent event) throws EventException {
            int eventType;
            int eventTypeBak = eventType = event.getEventType();
            if (EventType.isRequest(eventType &= 0xBFFFFFFF)) {
                String[] routeInfo = event.getStringArrayAttributeValue("9");
                String[] senderPath = new String[6];
                senderPath[0] = routeInfo[0];
                Integer connNo = EventReceive.this.clientConnection.getNodeNo() * 1000 + EventReceive.this.clientConnection.getPoolNumber();
                senderPath[1] = this.environment.getLocalServerName() + "#" + connNo;
                senderPath[3] = "com.hundsun.fbase.mdb";
                byte[] reliableData = event.getByteArrayAttributeValue("58");
                ReliableBody reliableBody = new ReliableBody(reliableData);
                IDatasets dss = event.getEventDatas();
                IDataset ds = dss.getDataset(0);
                byte[] reBody = reliableBody.change2Response();
                event.changeToresponse();
                event.setByteArrayAttributeValue("58", reBody);
                event.setStringArrayAttributeValue("10", senderPath);
                event.setIntegerAttributeValue("3", eventTypeBak + 1);
                EventReceive.this.clientConnection.send(event);
                DatasetService.printDataset(ds);
                if (ds != null) {
                    ds.beforeFirst();
                    if (ds.hasNext()) {
                        ds.next();
                    }
                }
                if (ds != null) {
                    String tableName = ds.getString("table_name");
                    String where = ds.getString("where");
                    MapWriter mw = new MapWriter();
                    mw.put("tableName", tableName);
                    mw.put("where", where);
                    if (this.environment.getMDBSupport() != null) {
                        this.environment.getMDBSupport().submit(mw.getDataset());
                    }
                }
            }
        }

        private class ParsePackageTask {
            private ParsePackageTask() {
            }

            public void run(byte[] data) {
                try {
                    long startUnpackTime = System.nanoTime();
                    String charset = EventReceive.this.clientConnection.getRemoteCharset() != null ? EventReceive.this.clientConnection.getRemoteCharset() : T2Services.DEFAULT_CHARSET;
                    CommonEvent_1 event = new CommonEvent_1(data, charset);
                    event.getIntegerAttributeValue("3");
                    long endUnpackTime = System.nanoTime();
                    if (event != null) {
                        event.setAttributeValue(EventReceive.EVENT_DATA, data);
                        event.addTimestamp(startUnpackTime, "unpack by " + Thread.currentThread().getName());
                        event.addTimestamp(endUnpackTime, "unpacked by " + Thread.currentThread().getName());
                        int eventType = event.getEventType();
                        String functionId = event.getServiceAlias();
                        if (functionId != null) {
                            if (functionId.equals("33")) {
                                if (eventType == 0 || eventType == 2) {
                                    T2ClientConnThread.this.responseHeartBeat();
                                }
                                T2ClientConnThread.this.heartBeatMode = 0;
                                T2ClientConnThread.this.heartBeatBegin = System.currentTimeMillis();
                                return;
                            }
                            if (functionId.equals("32")) {
                                return;
                            }
                            if (EventReceive.this.isMsgCenterMode && StringUtil.equals("620000", functionId)) {
                                event.changeToresponse();
                                EventReceive.this.clientConnection.send(event);
                                return;
                            }
                        } else if (eventType > 3) {
                            T2ClientConnThread.this.processMDBEvent(event);
                            return;
                        }
                    }
                    EventReceive.this.onEventReveived(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logAdapter.log("Receive pack error for[" + e.getMessage() + "]");
                }
            }
        }
    }
}

