/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.client;

import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.common.share.dataset.MapWriter;
import com.hundsun.t2sdk.common.share.util.DataGetter;
import com.hundsun.t2sdk.common.util.ResourceUtils;
import com.hundsun.t2sdk.impl.client.ClientConnection;
import com.hundsun.t2sdk.impl.client.ClientImpl;
import com.hundsun.t2sdk.impl.client.LicenseHandle;
import com.hundsun.t2sdk.impl.configuration.DefaultConfigurationHelper;
import com.hundsun.t2sdk.impl.environment.ClientConnectionInfo;
import com.hundsun.t2sdk.impl.environment.ClientEnvironment;
import com.hundsun.t2sdk.impl.environment.Environment;
import com.hundsun.t2sdk.impl.mdb.MDBSupport;
import com.hundsun.t2sdk.impl.pwd.PasswordEncode;
import com.hundsun.t2sdk.impl.pwd.PwdParameter;
import com.hundsun.t2sdk.impl.safe.SSLParameter;
import com.hundsun.t2sdk.impl.safe.SafeLevel;
import com.hundsun.t2sdk.impl.util.AbstractLogAdapter;
import com.hundsun.t2sdk.impl.util.CommonLogAdapter;
import com.hundsun.t2sdk.impl.util.ICrypt;
import com.hundsun.t2sdk.impl.util.LicenseReader;
import com.hundsun.t2sdk.impl.util.T2LogManage;
import com.hundsun.t2sdk.interfaces.ICallBackMethod;
import com.hundsun.t2sdk.interfaces.IClient;
import com.hundsun.t2sdk.interfaces.IStateListen;
import com.hundsun.t2sdk.interfaces.IT2Services;
import com.hundsun.t2sdk.interfaces.T2SDKException;
import com.hundsun.t2sdk.interfaces.configuration.IConfiguration;
import com.hundsun.t2sdk.interfaces.configuration.IElement;
import com.hundsun.t2sdk.interfaces.core.channel.IMessageHandler;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class T2Services
implements IT2Services {
    private static AbstractLogAdapter logAdapter = new CommonLogAdapter();
    private static T2Services t2Services = new T2Services();
    private int connectionWaitTimes;
    static final long CREATE_TIME_LONG = 1500L;
    private Environment environment = new Environment();
    private ConcurrentMap<String, IClient> clientMap = new ConcurrentHashMap<String, IClient>();
    private ConcurrentMap<String, ClientEnvironment> clientEnvironmentMap = new ConcurrentHashMap<String, ClientEnvironment>();
    public static int DEFAULT_POOL_SIZE = 2;
    public static int MAX_POOL_SIZE = 64;
    public static int MIN_POOL_SIZE = 1;
    public static String DEFAULT_CHARSET = "UTF-8";
    public static final String T2SDK_NAME = "T2SDK";
    private static final String T2SDK_CONFIGFILE = "/t2sdk-config.xml";
    private String t2sdkConfigString;
    private ICrypt crypt = null;
    private MDBSupport mdbSupport;
    private IConfiguration t2sdkConfig = null;

    public static T2Services getInstance() {
        return t2Services;
    }

    public IConfiguration getT2sdkConfig() {
        return this.t2sdkConfig;
    }

    private IConfiguration loadConfiguration() throws T2SDKException {
        try {
            URL url;
            DefaultConfigurationHelper configurationHelper = new DefaultConfigurationHelper();
            if (this.t2sdkConfigString != null) {
                try {
                    url = ResourceUtils.getURL(this.t2sdkConfigString);
                }
                catch (Exception e) {
                    url = null;
                }
            } else {
                url = T2Services.class.getResource(T2SDK_CONFIGFILE);
            }
            return configurationHelper.URLToConfiguration(url);
        }
        catch (Exception e) {
            throw new T2SDKException("804", new Object[]{e});
        }
    }

    @Override
    public void init() throws T2SDKException {
        this.init(this.loadConfiguration());
    }

    @Override
    public void init(IConfiguration config) throws T2SDKException {
        T2LogManage.logConfigurationInit(null);
        if (config == null) {
            throw new T2SDKException("804", null);
        }
        this.t2sdkConfig = config;
        try {
            IElement parents;
            IElement mdbsupport;
            String classNameString;
            IElement logAdapter;
            IElement callBackMethodElement;
            String cryptClasString;
            IElement extCryptElement;
            IElement element = config.getRoot();
            IElement performance = element.getChild("performance");
            if (performance != null) {
                this.connectionWaitTimes = DataGetter.getInt(performance.getProterty("connectionWaitTimes"), 1);
                boolean isDebug = DataGetter.getBoolean(performance.getProterty("debug"), false);
                int heartBeatTime = DataGetter.getInt(performance.getProterty("heartbeatTime"), 5);
                int acquireConnWaitTime = DataGetter.getInt(performance.getProterty("acquireConnWaitTime"), 100);
                int registerTime = DataGetter.getInt(performance.getProterty("registerTime"), 5);
                int reconnInterval = DataGetter.getInt(performance.getProterty("reconnInterval"), 5);
                String localServerName = performance.getProterty("localServerName");
                int callBackTime = DataGetter.getInt(performance.getProterty("callBackTime"), 1000);
                int sendPoolSize = DataGetter.getInt(performance.getProterty("sendPoolSize"), 2);
                int senderQueueLength = DataGetter.getInt(performance.getProterty("senderQueueLength"), 30);
                String stopMode = performance.getProterty("stopMode");
                boolean enmCompress = DataGetter.getBoolean(performance.getProterty("enmCompress"), false);
                int compressionThreshold = DataGetter.getInt(performance.getProterty("compressionThreshold"), 0);
                this.environment.setDebugMode(isDebug);
                this.environment.setHeartBeatTime(heartBeatTime);
                this.environment.setAcquireConnWaitTime(acquireConnWaitTime);
                this.environment.setRegisterTime(registerTime);
                this.environment.setReconnInterval(reconnInterval);
                this.environment.setLocalServerName(localServerName);
                this.environment.setCallBackTime(callBackTime);
                this.environment.setSendPoolSize(sendPoolSize);
                this.environment.setSenderQueueLength(senderQueueLength);
                this.environment.setStopMode(stopMode);
                this.environment.setEnmCompress(enmCompress);
                this.environment.setCompressionThreshold(compressionThreshold);
            }
            if ((extCryptElement = element.getChild("extCrypt")) != null && (cryptClasString = extCryptElement.getProterty("class")) != null) {
                this.crypt = (ICrypt)Class.forName(cryptClasString).newInstance();
            }
            if ((callBackMethodElement = element.getChild("callBackMethods")) != null) {
                this.environment.setCallBackMethods(this.parseMethodElement(callBackMethodElement));
            }
            if ((logAdapter = element.getChild("logAdapter")) != null && (classNameString = logAdapter.getProterty("className")) != null) {
                AbstractLogAdapter abstractLogAdapter = (AbstractLogAdapter)Class.forName(classNameString).newInstance();
                T2Services.setLogAdapter(abstractLogAdapter);
            }
            if ((mdbsupport = element.getChild("mdbsupport")) != null) {
                int threadCount = DataGetter.getInt(mdbsupport.getProterty("threadCount"), 2);
                int queueSize = DataGetter.getInt(mdbsupport.getProterty("queueSize"), 30);
                this.mdbSupport = new MDBSupport(threadCount, queueSize);
                this.environment.setMDBSupport(this.mdbSupport);
                List<IElement> listeners = mdbsupport.getChildren("listener");
                for (IElement listenerElement : listeners) {
                    String strClass = listenerElement.getProterty("class");
                    Class<?> clazz = null;
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(strClass);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        throw new T2SDKException(e, "813", new Object[0]);
                    }
                    try {
                        IMessageHandler handler = (IMessageHandler)clazz.newInstance();
                        this.mdbSupport.register(handler);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new T2SDKException(e, "813", new Object[0]);
                    }
                }
            }
            if ((parents = element.getChild("parents")) != null) {
                this.parse(parents);
            }
        }
        catch (T2SDKException e) {
            throw e;
        }
        catch (Exception e) {
            throw new T2SDKException(e, "809", new Object[0]);
        }
    }

    @Override
    public void start() {
        if (this.mdbSupport != null) {
            this.mdbSupport.start();
        }
        for (Map.Entry entry : this.clientEnvironmentMap.entrySet()) {
            ClientEnvironment clientEnvironment = (ClientEnvironment)entry.getValue();
            ClientImpl clientImpl = new ClientImpl(clientEnvironment, this.environment);
            clientImpl.start();
            this.clientMap.put(clientEnvironment.getParentName(), clientImpl);
        }
        boolean beReady = true;
        for (int i = 0; i < this.connectionWaitTimes; ++i) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            beReady = true;
            for (Map.Entry entry : this.clientMap.entrySet()) {
                ClientImpl clientImpl = (ClientImpl)entry.getValue();
                if (clientImpl.clientConnectionBeReady()) continue;
                beReady = false;
                break;
            }
            if (beReady) break;
        }
        if (!beReady) {
            logAdapter.log("error!Failed to create connections within the specified time!");
        }
    }

    @Override
    public void stop() {
        if (this.mdbSupport != null) {
            this.mdbSupport.stop();
        }
        for (Map.Entry entry : this.clientMap.entrySet()) {
            ClientImpl clientImpl = (ClientImpl)entry.getValue();
            clientImpl.stop();
            this.clientMap.remove(entry.getKey());
        }
        this.clientEnvironmentMap.clear();
    }

    @Override
    public void stop(String parentName) {
        if (this.clientMap.containsKey(parentName)) {
            ClientImpl clientImpl = (ClientImpl)this.clientMap.get(parentName);
            clientImpl.stop();
            this.clientMap.remove(parentName);
            this.clientEnvironmentMap.remove(parentName);
        }
    }

    @Override
    public IClient getClient(String clientName) throws T2SDKException {
        IClient resultClient = (IClient)this.clientMap.get(clientName);
        if (resultClient == null) {
            throw new T2SDKException("806", new Object[]{clientName});
        }
        return resultClient;
    }

    private void parse(IElement config) throws Exception {
        List<IElement> parents = config.getChildren("parent");
        int size = parents.size();
        for (int i = 0; i < size; ++i) {
            IElement parentElement = parents.get(i);
            if (parentElement == null) continue;
            ClientEnvironment clientEnvironment = this.parseParentElement(parentElement);
            this.clientEnvironmentMap.put(clientEnvironment.getParentName(), clientEnvironment);
        }
    }

    private ClientEnvironment parseParentElement(IElement parentElement) throws Exception {
        ClientEnvironment clientEnvironment = null;
        String parentName = parentElement.getProterty("parentName");
        int poolSize = DEFAULT_POOL_SIZE;
        String licenseNo = null;
        int no = -1;
        String address = null;
        int port = -1;
        String charset = DEFAULT_CHARSET;
        SSLParameter sslParameter = null;
        PwdParameter pwdParameter = null;
        SafeLevel safeLevel = SafeLevel.NONE;
        boolean isMsgCenterMode = false;
        String ufxPassword = null;
        IStateListen stateListen = null;
        String stateListenClass = parentElement.getProterty("stateListenClass");
        if (stateListenClass != null) {
            stateListen = (IStateListen)Class.forName(stateListenClass).newInstance();
        }
        String noNameConnection = parentElement.getProterty("noNameConnection");
        if (parentName == null || parentName.trim().length() == 0) {
            return null;
        }
        parentName = parentName.trim();
        IElement limit = parentElement.getChild("limit");
        String licenceFileName = null;
        if (limit != null) {
            ufxPassword = limit.getProterty("ufxPassword");
            String encrypt = limit.getProterty("encrypt");
            String license = limit.getProterty("license");
            if (license == null || license.trim().length() == 0) {
                license = null;
            }
            String licenseFile = limit.getProterty("licenseFile");
            if (license == null && licenseFile != null && licenseFile.trim().length() != 0) {
                URL url = null;
                licenceFileName = licenseFile;
                try {
                    url = ResourceUtils.getURL(licenseFile);
                    url = new URL(URLDecoder.decode(url.toString(), "UTF-8"));
                }
                catch (Exception e) {
                    logAdapter.log(98, "", parentName, licenseFile);
                    throw new T2SDKException("810", new Object[0]);
                }
                licenceFileName = url.getFile();
                if ("jcc".equalsIgnoreCase(encrypt)) {
                    LicenseReader lr = new LicenseReader();
                    try {
                        licenseNo = lr.decodeLicenseFile(licenceFileName, "888888");
                    }
                    catch (Exception e) {
                        throw new T2SDKException("811", new Object[0]);
                    }
                }
                try {
                    File file = new File(licenceFileName);
                    FileInputStream fis = new FileInputStream(file);
                    int available = fis.available();
                    licenseNo = LicenseHandle.getLicense(licenceFileName);
                    fis.close();
                }
                catch (Exception e) {
                    throw new T2SDKException("811", new Object[0]);
                }
            }
        }
        if (licenseNo == null || licenseNo.trim().length() == 0) {
            logAdapter.log(98, "", parentName, licenceFileName);
            throw new T2SDKException("810", new Object[0]);
        }
        logAdapter.log("\u5ba2\u6237\u7aef\u8bc1\u4e66\u53f7\u4e3a\uff1a" + licenseNo);
        String strSafeLevel = parentElement.getProterty("safeLevel");
        if (strSafeLevel == null) {
            safeLevel = SafeLevel.NONE;
        } else if (strSafeLevel.equalsIgnoreCase(SafeLevel.PWD.toString())) {
            safeLevel = SafeLevel.PWD;
            IElement pwdElement = parentElement.getChild("pwd");
            if (pwdElement != null) {
                pwdParameter = new PwdParameter();
                String clientId = pwdElement.getProterty("clientId");
                String commPwd = pwdElement.getProterty("commPwd");
                pwdParameter.setClientId(clientId);
                if (clientId != null) {
                    pwdParameter.setCommPwd(PasswordEncode.encrypt(commPwd));
                } else {
                    pwdParameter.setCommPwd(commPwd);
                }
            }
        } else if (strSafeLevel.equalsIgnoreCase(SafeLevel.SSL.toString())) {
            safeLevel = SafeLevel.SSL;
            IElement ssl = parentElement.getChild("ssl");
            if (ssl != null) {
                sslParameter = new SSLParameter();
                sslParameter.setProtocol(ssl.getProterty("protocol"));
                sslParameter.setKeyManageAlgorithm(ssl.getProterty("keyManageAlgorithm"));
                sslParameter.setTrustManageAlgorithm(ssl.getProterty("trustManageAlgorithm"));
                sslParameter.setKeyStoreType(ssl.getProterty("keyStoreType"));
                sslParameter.setTrustKeyStoreType(ssl.getProterty("trustKeyStoreType"));
                sslParameter.setKeyCertFile(ssl.getProterty("keyCertFile"));
                sslParameter.setKeyCertPwd(ssl.getProterty("keyCertPwd"));
                sslParameter.setTrustCertFile(ssl.getProterty("trustCertFile"));
                sslParameter.setTrustCertPwd(ssl.getProterty("trustCertPwd"));
            }
        } else {
            safeLevel = SafeLevel.NONE;
        }
        isMsgCenterMode = DataGetter.getBoolean(parentElement.getProterty("msgCenter"), false);
        clientEnvironment = new ClientEnvironment();
        clientEnvironment.setParentName(parentName);
        clientEnvironment.setLicenseNo(licenseNo);
        clientEnvironment.setClientSafeLevel(safeLevel);
        clientEnvironment.setClientSSLParameter(sslParameter);
        clientEnvironment.setPwdParameter(pwdParameter);
        clientEnvironment.setNoNameConnection(noNameConnection);
        clientEnvironment.setUfxPassword(ufxPassword);
        clientEnvironment.setStateListen(stateListen);
        HashMap<Integer, ClientConnectionInfo> connectionInfoMap = new HashMap<Integer, ClientConnectionInfo>();
        IElement members = parentElement.getChild("members");
        if (members != null) {
            List<IElement> membersElement = members.getChildren();
            int membersElementSize = membersElement.size();
            for (int i = 0; i < membersElementSize; ++i) {
                IElement member = membersElement.get(i);
                if (member == null) continue;
                ClientConnectionInfo clientConnectionInfo = new ClientConnectionInfo();
                no = DataGetter.getInt(member.getProterty("no"), -1);
                if (no < 0) {
                    logAdapter.log(99, T2SDK_NAME, parentName, "no", member.getProterty("no"));
                    continue;
                }
                address = member.getProterty("address");
                if (address == null || address.trim().length() == 0) {
                    logAdapter.log(99, T2SDK_NAME, parentName, "address", address);
                    continue;
                }
                port = DataGetter.getInt(member.getProterty("port"), -1);
                if (port < 0) {
                    logAdapter.log(99, T2SDK_NAME, parentName, "port", member.getProterty("port"));
                    continue;
                }
                charset = member.getProterty("charset");
                if (charset != null) {
                    try {
                        new String("\u4e2d\u56fd".getBytes(), charset);
                    }
                    catch (Exception e) {
                        charset = DEFAULT_CHARSET;
                    }
                }
                if ((poolSize = DataGetter.getInt(member.getProterty("poolSize"), DEFAULT_POOL_SIZE)) < MIN_POOL_SIZE) {
                    poolSize = MIN_POOL_SIZE;
                } else if (poolSize > MAX_POOL_SIZE) {
                    poolSize = MAX_POOL_SIZE;
                }
                clientConnectionInfo.setNodeNo(no);
                clientConnectionInfo.setPort(port);
                clientConnectionInfo.setIp(address);
                clientConnectionInfo.setCharset(charset);
                clientConnectionInfo.setPoolSize(poolSize);
                clientConnectionInfo.setMsgCenter(isMsgCenterMode);
                connectionInfoMap.put(no, clientConnectionInfo);
            }
        }
        clientEnvironment.setConnectionInfoMap(connectionInfoMap);
        return clientEnvironment;
    }

    private Map<Long, String> parseMethodElement(IElement methodsElement) throws T2SDKException {
        HashMap<String, ICallBackMethod> callBackMethodInstance = new HashMap<String, ICallBackMethod>();
        HashMap<Long, String> result = new HashMap<Long, String>();
        long id = 0L;
        String className = null;
        List<IElement> methodElement = methodsElement.getChildren();
        int membersElementSize = methodElement.size();
        for (int i = 0; i < membersElementSize; ++i) {
            IElement method = methodElement.get(i);
            if (method != null) {
                id = method.getProterty("id") == null ? 0L : (long)DataGetter.getInt(method.getProterty("id"), -1);
                if (id < -1L) {
                    logAdapter.log(99, T2SDK_NAME, "callBackMethod", "id", method.getProterty("id"));
                    continue;
                }
                className = method.getProterty("className");
                if (className == null || className.trim().length() == 0) {
                    logAdapter.log(99, T2SDK_NAME, "callBackMethod", "className", className);
                    continue;
                }
            }
            result.put(id, className);
            try {
                callBackMethodInstance.put(className, (ICallBackMethod)Class.forName(className).newInstance());
                continue;
            }
            catch (InstantiationException e) {
                throw new T2SDKException(e, "812", new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new T2SDKException(e, "812", new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new T2SDKException(e, "812", new Object[0]);
            }
        }
        this.environment.setCallBackMethodInstance(callBackMethodInstance);
        return result;
    }

    @Override
    public void appendAParent(IElement appendAConfig) throws T2SDKException {
        block6: {
            try {
                if (appendAConfig == null) break block6;
                ClientEnvironment clientEnvironment = this.parseParentElement(appendAConfig);
                ClientImpl clientImpl = new ClientImpl(clientEnvironment, this.environment);
                clientImpl.start();
                IClient oldClientImpl = (IClient)this.clientMap.get(clientEnvironment.getParentName());
                if (oldClientImpl != null) {
                    oldClientImpl.stop();
                }
                this.clientMap.put(clientEnvironment.getParentName(), clientImpl);
                Thread.sleep(1500L);
                this.clientEnvironmentMap.put(clientEnvironment.getParentName(), clientEnvironment);
                return;
            }
            catch (T2SDKException e) {
                throw e;
            }
            catch (Exception e) {
                throw new T2SDKException("808", new Object[0]);
            }
        }
        throw new T2SDKException("808", new Object[0]);
    }

    public static AbstractLogAdapter getLogAdapter() {
        return logAdapter;
    }

    public static void setLogAdapter(AbstractLogAdapter logAdapter) {
        T2Services.logAdapter = logAdapter;
    }

    @Override
    public IDataset getQueryAllConnsCommand() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        IDataset dataset = DatasetService.getDefaultInstance().getDataset();
        dataset.setDatasetName("all connections");
        dataset.addColumn("remoteNodeName");
        dataset.addColumn("remoteNodeNo", 73);
        dataset.addColumn("connectionNo", 73);
        dataset.addColumn("remoteCharset");
        dataset.addColumn("status", 73);
        dataset.addColumn("connectionType", 73);
        dataset.addColumn("address");
        dataset.addColumn("port");
        dataset.addColumn("sendPackCount", 76);
        dataset.addColumn("sendDataSize", 76);
        dataset.addColumn("recvPackCount", 76);
        dataset.addColumn("recvDataSize", 76);
        dataset.addColumn("lastActiveTime");
        dataset.addColumn("lastDisconnTime");
        dataset.addColumn("lastConnectTime");
        dataset.addColumn("reconnCount", 73);
        for (Map.Entry entry : this.clientMap.entrySet()) {
            ClientImpl clientImpl = (ClientImpl)entry.getValue();
            List<ClientConnection> connections = clientImpl.getConnections();
            for (ClientConnection conn : connections) {
                if (conn == null) continue;
                dataset.appendRow();
                dataset.updateString("remoteNodeName", conn.getNodeName());
                dataset.updateInt("remoteNodeNo", conn.getNodeNo());
                dataset.updateInt("connectionNo", conn.getConnectionNo());
                dataset.updateString("remoteCharset", conn.getRemoteCharset());
                dataset.updateInt("status", conn.getStatus());
                dataset.updateInt("connectionType", conn.getType());
                dataset.updateString("remoteCharset", conn.getRemoteCharset());
                dataset.updateString("address", conn.getAddress());
                dataset.updateInt("port", conn.getPort());
                dataset.updateLong("sendPackCount", conn.getSendPackCount().get());
                dataset.updateLong("sendDataSize", conn.getSendDataSize().get());
                dataset.updateLong("recvPackCount", conn.getRecvPackCount().get());
                dataset.updateLong("recvDataSize", conn.getRecvDataSize().get());
                dataset.updateValue("lastActiveTime", (Object)dateFormat.format(new Date(conn.getLastActiveTime())));
                if (conn.getLastDisconnTime() == -1L) {
                    dataset.updateValue("lastDisconnTime", (Object)"");
                } else {
                    dataset.updateValue("lastDisconnTime", (Object)dateFormat.format(new Date(conn.getLastDisconnTime())));
                }
                dataset.updateValue("lastConnectTime", (Object)dateFormat.format(new Date(conn.getLastConnectTime())));
                dataset.updateInt("reconnCount", conn.getReconnCount());
            }
        }
        return dataset;
    }

    @Override
    public IDataset getParametersCommand() {
        MapWriter mw = new MapWriter();
        mw.put("localServiceName", this.environment.getLocalServerName());
        mw.put("heartbeatTime", "" + this.environment.getHeartBeatTime());
        mw.put("callBackTime", this.environment.getCallBackTime());
        mw.put("acquireConnWaitTime", this.environment.getAcquireConnWaitTime());
        mw.put("reconnInterval", this.environment.getReconnInterval());
        mw.put("registerTime", this.environment.getRegisterTime());
        mw.put("isDebugMode", this.environment.isDebugMode());
        return mw.getDataset();
    }

    @Override
    public void setT2sdkConfigString(String configString) {
        this.t2sdkConfigString = configString;
    }

    @Override
    public String getT2sdkConfigString() {
        return this.t2sdkConfigString;
    }

    public ICrypt getCrypt() {
        return this.crypt;
    }
}

