/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.configuration;

import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.impl.configuration.CustomizeConfiguration;
import com.hundsun.t2sdk.impl.configuration.CustomizeConfigurationFromNamespace;
import com.hundsun.t2sdk.impl.configuration.PropretiesConfiguration;
import com.hundsun.t2sdk.impl.configuration.RuntimeUtil;
import com.hundsun.t2sdk.impl.configuration.XMLConfiguration;
import com.hundsun.t2sdk.impl.configuration.XMLElement;
import com.hundsun.t2sdk.impl.util.AbstractLogAdapter;
import com.hundsun.t2sdk.interfaces.configuration.IConfiguration;
import com.hundsun.t2sdk.interfaces.configuration.IConfigurationHelper;
import com.hundsun.t2sdk.interfaces.configuration.ICustomizeConfiguration;
import com.hundsun.t2sdk.interfaces.configuration.IElement;
import com.hundsun.t2sdk.interfaces.exception.T2SDKBaseException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationHelper
implements IConfigurationHelper {
    static final String JARURL_PREFIX = "jar:file:";
    private static AbstractLogAdapter logAdapter;
    private ClassLoader outClassLoader = IConfigurationHelper.class.getClassLoader();

    public static AbstractLogAdapter getLog() {
        if (logAdapter == null) {
            logAdapter = T2Services.getLogAdapter();
        }
        return logAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File loadFile(String path, String encoding) {
        try {
            File file = null;
            if (path.startsWith("jrespath:")) {
                String rootPath = RuntimeUtil.getJresPath();
                file = new File(rootPath + "/" + path.substring("jrespath:".length()));
            }
            File file2 = file;
            return file2;
        }
        catch (RuntimeException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("641", (Throwable)e, path).getMessage());
        }
        return null;
    }

    @Override
    public File loadFile(String path) {
        return this.loadFile(path, "utf-8");
    }

    public IConfiguration loadFileToConfiguration(String path, HashSet<String> traversalSet) {
        return this.loadFileToConfiguration(null, path, "utf-8", traversalSet);
    }

    public IConfiguration URLToConfiguration(URL url) {
        return this.URLToConfiguration(url, "utf-8", null);
    }

    private IConfiguration URLToConfiguration(URL url, String encoding, HashSet<String> traversalSet) {
        XMLConfiguration cfg = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding(encoding);
            Document doc = reader.read(url.openStream());
            cfg = new XMLConfiguration(url, doc, traversalSet);
        }
        catch (RuntimeException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("643", (Throwable)e, url.getPath()).getMessage());
        }
        catch (IOException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("643", (Throwable)e, url.getPath()).getMessage());
        }
        catch (DocumentException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("645", (Throwable)e, new Object[0]).getMessage());
        }
        return cfg;
    }

    private IConfiguration loadFileToConfiguration(String namespace, String path, String encoding, HashSet<String> traversalSet) {
        IConfiguration cfg = null;
        try {
            URL url = path.startsWith(JARURL_PREFIX) ? new URL(path) : this.outClassLoader.getResource(path);
            if (path.trim().endsWith(".properties")) {
                Properties properties = new Properties();
                properties.load(url.openStream());
                cfg = new PropretiesConfiguration(url, properties);
            } else if (path.trim().endsWith(".xml")) {
                SAXReader reader = new SAXReader();
                reader.setEncoding(encoding);
                Document doc = reader.read(url.openStream());
                cfg = namespace == null ? new XMLConfiguration(url, doc, traversalSet) : new XMLConfiguration(namespace, url, doc, traversalSet);
            }
        }
        catch (RuntimeException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("643", (Throwable)e, path).getMessage());
        }
        catch (IOException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("643", (Throwable)e, path).getMessage());
        }
        catch (DocumentException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("645", (Throwable)e, new Object[0]).getMessage());
        }
        return cfg;
    }

    @Override
    public IConfiguration loadFileToConfiguration(String path, String encoding) {
        return this.loadFileToConfiguration(null, path, encoding, null);
    }

    public IConfiguration loadDomToConfiguration(URL url, String domContent) {
        XMLConfiguration cfg = null;
        try {
            Document doc = DocumentHelper.parseText((String)domContent);
            cfg = new XMLConfiguration(url, doc);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("642", (Throwable)e, new Object[0]).getMessage());
        }
        return cfg;
    }

    @Override
    public IConfiguration loadFileToConfiguration(String path) {
        return this.loadFileToConfiguration(null, path, "utf-8", null);
    }

    public IConfiguration loadFileToConfigurationFromNamespace(String namespace, String path) {
        return this.loadFileToConfiguration(namespace, path, "utf-8", null);
    }

    @Override
    public IConfiguration loadAresAppConfig() {
        return this.loadFileToConfiguration(null, "ares-app-config.xml", "utf-8", null);
    }

    public IConfiguration loadAresAppConfigFromNamespace(String namespace) {
        return this.loadFileToConfiguration(namespace, "ares-app-config.xml", "utf-8", null);
    }

    @Override
    public IConfiguration elementToConfiguration(IElement element, URL url) {
        if (element instanceof XMLElement) {
            return new XMLConfiguration(url, (XMLElement)element);
        }
        return null;
    }

    @Override
    public ICustomizeConfiguration getCustomizeConfiguration() {
        return new CustomizeConfiguration();
    }

    @Override
    public ICustomizeConfiguration getCustomizeConfiguration(String namespace) {
        return new CustomizeConfigurationFromNamespace(namespace);
    }

    public String getCurrentJarPath(String jarPath) {
        return "jar:" + Thread.currentThread().getContextClassLoader().getResource("") + jarPath;
    }
}

