/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.configuration;

import com.hundsun.t2sdk.impl.configuration.DefaultConfigurationHelper;
import com.hundsun.t2sdk.impl.configuration.PropertiesElement;
import com.hundsun.t2sdk.interfaces.configuration.IConfiguration;
import com.hundsun.t2sdk.interfaces.configuration.IElement;
import com.hundsun.t2sdk.interfaces.exception.T2SDKBaseException;
import com.hundsun.t2sdk.interfaces.exception.T2SDKBaseRuntimeException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Properties;
import org.dom4j.io.OutputFormat;

public class PropretiesConfiguration
implements IConfiguration {
    private URL url;
    private PropertiesElement root;
    private Properties properties;

    public PropretiesConfiguration(URL url, Properties properties) {
        this.url = url;
        this.properties = properties;
        this.init(properties);
    }

    private void init(Properties properties) {
        this.root = new PropertiesElement(properties);
    }

    public String getFormatType() {
        return "properties";
    }

    public URL getResource() {
        return this.url;
    }

    public IElement getRoot() {
        return this.root;
    }

    public void saveToFile(String path, String encoding) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(encoding);
            FileOutputStream fos = new FileOutputStream(path);
            FileChannel fcout = fos.getChannel();
            FileLock flout = null;
            while ((flout = fcout.tryLock()) == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("646", (Throwable)e, new Object[0]).getMessage());
                }
            }
            this.properties.store(fos, null);
            fos.close();
            fcout.close();
        }
        catch (IOException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("647", (Throwable)e, path).getMessage());
        }
    }

    public String getRootElementAsXml() {
        throw new T2SDKBaseRuntimeException("334", (Throwable)new RuntimeException(), "getRootElementAsXml()");
    }
}

