/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.configuration;

import com.hundsun.t2sdk.impl.configuration.DefaultConfigurationHelper;
import com.hundsun.t2sdk.interfaces.configuration.IConfigurationHelper;
import com.hundsun.t2sdk.interfaces.exception.T2SDKBaseRuntimeException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class RuntimeUtil {
    private static String jresPath;

    public static String getJresPath() {
        if (jresPath == null) {
            File file = null;
            URL url = IConfigurationHelper.class.getClassLoader().getResource("/");
            try {
                file = new File(URLDecoder.decode(url.getFile(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                DefaultConfigurationHelper.getLog().log(new T2SDKBaseRuntimeException("650", (Throwable)e, new Object[0]).getMessage());
            }
            file = RuntimeUtil.findSpecialFolder(file.getParentFile(), "jres-osgi");
            if (file != null) {
                jresPath = file.getParentFile().getPath();
            } else {
                DefaultConfigurationHelper.getLog().log(new T2SDKBaseRuntimeException("648", (Throwable)new RuntimeException(), new Object[0]).getMessage());
            }
        }
        return jresPath;
    }

    private static File findSpecialFolder(File folder, String targetFoldName) {
        File parentFolder;
        File targetFolder = null;
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !file.getName().equals(targetFoldName)) continue;
                targetFolder = file;
                return targetFolder;
            }
        }
        if ((parentFolder = folder.getParentFile()) != null) {
            targetFolder = RuntimeUtil.findSpecialFolder(parentFolder, targetFoldName);
        }
        return targetFolder;
    }
}

