/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.configuration;

import com.hundsun.t2sdk.common.encrypt.EncryptFactoryImpl;
import com.hundsun.t2sdk.common.util.StringUtils;
import com.hundsun.t2sdk.impl.configuration.DefaultConfigurationHelper;
import com.hundsun.t2sdk.impl.configuration.XMLElement;
import com.hundsun.t2sdk.interfaces.configuration.IConfiguration;
import com.hundsun.t2sdk.interfaces.configuration.IElement;
import com.hundsun.t2sdk.interfaces.encrypt.Encrypt;
import com.hundsun.t2sdk.interfaces.encrypt.EncryptFactory;
import com.hundsun.t2sdk.interfaces.exception.T2SDKBaseException;
import com.hundsun.t2sdk.interfaces.exception.T2SDKBaseRuntimeException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
implements IConfiguration {
    private static final String CONFIGURATION_INJECTION_PREFIX = "_CONFIGURATION_INJECTION{";
    private static final String DEFAULT_ENCRYPT_TYPE = "Des";
    private static final String COMPONENT_TAG_END = "}";
    private static final String ENCRYPT_PREFIX = "_ENCRYPT{";
    private URL url;
    private XMLElement root;
    private Document doc;
    private static EncryptFactory encryptFactory = new EncryptFactoryImpl();

    public XMLConfiguration(URL url, Document documnet) {
        documnet = this.buildConfiguration(documnet, url, null);
        this.url = url;
        this.root = new XMLElement(documnet.getRootElement(), null);
        this.doc = documnet;
    }

    public XMLConfiguration(URL url, Document documnet, HashSet<String> traversalSet) {
        documnet = this.buildConfiguration(documnet, url, traversalSet);
        this.url = url;
        this.root = new XMLElement(documnet.getRootElement(), null);
        this.doc = documnet;
    }

    public XMLConfiguration(String namespace, URL url, Document document, HashSet<String> traversalSet) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("space", namespace);
        XPath x = document.createXPath("//space:param");
        x.setNamespaceURIs(map);
        List nodelist = x.selectNodes((Object)document);
        document = this.buildConfiguration(document, url, traversalSet);
        this.url = url;
        this.root = new XMLElement((Element)nodelist.get(0), null);
        this.doc = document;
    }

    public XMLConfiguration(URL url, XMLElement element) {
        this.url = url;
        this.root = element;
    }

    private Document buildConfiguration(Document doc, URL url, HashSet<String> traversalSet) {
        try {
            Encrypt enc = encryptFactory.getEncrypt(DEFAULT_ENCRYPT_TYPE);
            DefaultConfigurationHelper configHelp = new DefaultConfigurationHelper();
            String documentContent = doc.asXML();
            List configPrefixList = this.parsePrefixToList(documentContent, CONFIGURATION_INJECTION_PREFIX);
            if (traversalSet == null) {
                traversalSet = new HashSet();
            }
            if (url != null) {
                if (traversalSet.contains(url.toString())) {
                    DefaultConfigurationHelper.getLog().log(642, new String[0]);
                    throw new T2SDKBaseRuntimeException();
                }
                traversalSet.add(url.toString());
            }
            for (Prefix configPrefix : configPrefixList) {
                IConfiguration cfg = configHelp.loadFileToConfiguration(configPrefix.getValue(), traversalSet);
                if (cfg == null) continue;
                documentContent = StringUtils.replace(documentContent, configPrefix.getPrefix(), cfg.getRootElementAsXml());
            }
            List encryptPrefixList = this.parsePrefixToList(documentContent, ENCRYPT_PREFIX);
            for (Prefix encryptPrefix : encryptPrefixList) {
                documentContent = StringUtils.replace(documentContent, encryptPrefix.getPrefix(), enc.getDecryptStr(encryptPrefix.getValue()));
            }
            return DocumentHelper.parseText((String)documentContent);
        }
        catch (Exception e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("653", (Throwable)e, new Object[0]).getMessage());
            return doc;
        }
    }

    private List parsePrefixToList(String content, String prefix) {
        ArrayList<Prefix> resultList = new ArrayList<Prefix>();
        StringBuffer _content = new StringBuffer(content);
        int prefixLen = prefix.length();
        String tmp = "";
        try {
            while (_content.indexOf(prefix) != -1) {
                if ((_content = new StringBuffer(_content.substring(_content.indexOf(prefix) + prefixLen, _content.length()))).indexOf(COMPONENT_TAG_END) != -1) {
                    tmp = _content.substring(0, _content.indexOf(COMPONENT_TAG_END));
                    try {
                        resultList.add(new Prefix(prefix + tmp + COMPONENT_TAG_END, tmp));
                    }
                    catch (Exception e) {
                        DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("654", (Throwable)e, new Object[0]).getMessage());
                        break;
                    }
                    _content = new StringBuffer(_content.substring(_content.indexOf(COMPONENT_TAG_END) + 1, _content.length()));
                    continue;
                }
                DefaultConfigurationHelper.getLog().log(641, new String[0]);
                break;
            }
        }
        catch (Exception e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("654", (Throwable)e, new Object[0]).getMessage());
        }
        return resultList;
    }

    @Override
    public String getRootElementAsXml() {
        return this.doc.getRootElement().asXML();
    }

    @Override
    public String getFormatType() {
        return "xml";
    }

    @Override
    public URL getResource() {
        return this.url;
    }

    @Override
    public IElement getRoot() {
        return this.root;
    }

    public String getDocumentAsXml() {
        return this.doc.asXML();
    }

    @Override
    public void saveToFile(String path, String encoding) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(encoding);
            FileOutputStream fos = new FileOutputStream(path);
            FileChannel fcout = fos.getChannel();
            FileLock flout = null;
            while ((flout = fcout.tryLock()) == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("646", (Throwable)e, new Object[0]).getMessage());
                }
            }
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(this.doc);
            writer.close();
            fos.close();
            fcout.close();
        }
        catch (IOException e) {
            DefaultConfigurationHelper.getLog().log(new T2SDKBaseException("649", (Throwable)e, path).getMessage());
        }
    }

    class Prefix {
        private String prefix;
        private String value;

        public String getPrefix() {
            return this.prefix;
        }

        public String getValue() {
            return this.value;
        }

        public Prefix(String prefix, String value) {
            this.prefix = prefix;
            this.value = value;
        }
    }
}

