/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.configuration;

import com.hundsun.t2sdk.interfaces.configuration.IElement;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement
implements IElement {
    private Element dom4jElement;
    private IElement parent;
    private List<IElement> children = new ArrayList<IElement>();
    public String name;

    public XMLElement(Element dom4jElement, IElement parent) {
        this.dom4jElement = dom4jElement;
        this.parent = parent;
        this.name = dom4jElement.getName();
        this.init();
    }

    private void init() {
        List list = this.dom4jElement.elements();
        if (list != null) {
            XMLElement child = null;
            for (Element dom4jChild : list) {
                child = new XMLElement(dom4jChild, this);
                this.children.add(child);
            }
        }
    }

    @Override
    public List<IElement> getChildren(String name) {
        List list = this.dom4jElement.elements(name);
        ArrayList<IElement> iElements = new ArrayList<IElement>();
        if (list != null) {
            XMLElement child = null;
            for (Element dom4jChild : list) {
                child = new XMLElement(dom4jChild, this);
                iElements.add(child);
            }
        }
        return iElements;
    }

    @Override
    public List<IElement> getChildren() {
        return this.children;
    }

    @Override
    public String getContent() {
        return this.dom4jElement.getText();
    }

    @Override
    public void setContent(String text) {
        this.dom4jElement.setText(text);
    }

    @Override
    public IElement getParent() {
        return this.parent;
    }

    @Override
    public String getProterty(String key) {
        return this.dom4jElement.attributeValue(key);
    }

    @Override
    public void setProterty(String key, String value) {
        this.dom4jElement.addAttribute(key, value);
    }

    @Override
    public String getProtertyOrElementContent(String key) {
        Element child;
        String result = this.dom4jElement.attributeValue(key);
        if (result == null && (child = this.dom4jElement.element(key)) != null) {
            result = child.getText();
        }
        return result;
    }

    @Override
    public String[] propertyNames() {
        List list = this.dom4jElement.attributes();
        String[] names = null;
        if (list != null && list.size() > 0) {
            names = new String[list.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((Attribute)list.get(i)).getName();
            }
        }
        return names;
    }

    public String toString() {
        return this.dom4jElement.asXML();
    }

    @Override
    public IElement getChild(String name) {
        IElement result = null;
        for (IElement child : this.children) {
            if (!name.trim().equals(((XMLElement)child).name)) continue;
            result = child;
            break;
        }
        return result;
    }
}

