/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.mdb;

import com.hundsun.t2sdk.common.core.pool.RestlessThreadExcutorEx;
import com.hundsun.t2sdk.common.core.pool.Task;
import com.hundsun.t2sdk.common.share.dataset.MapReader;
import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.impl.mdb.MDBListener;
import com.hundsun.t2sdk.impl.util.AbstractLogAdapter;
import com.hundsun.t2sdk.interfaces.core.channel.IMessageHandler;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import java.util.Observable;

public class MDBSupport
extends Observable {
    private int threadCount = 2;
    private int queueSize = 30;
    private RestlessThreadExcutorEx excutor;
    private AbstractLogAdapter logAdapter = T2Services.getLogAdapter();

    public MDBSupport(int threadCount, int queueSize) {
        if (threadCount <= 0) {
            threadCount = 0;
        }
        if (queueSize <= 0) {
            queueSize = 0;
        }
        this.threadCount = threadCount;
        this.queueSize = queueSize;
    }

    public synchronized void start() {
        if (this.threadCount != 0) {
            this.excutor = new RestlessThreadExcutorEx(this.threadCount, this.queueSize, "mdbsupport");
            this.excutor.start();
        } else {
            this.excutor = null;
        }
    }

    public synchronized void stop() {
        if (this.excutor != null) {
            this.excutor.stop(500L);
            this.excutor = null;
        }
    }

    public synchronized MDBListener register(IMessageHandler handler) {
        MDBListener listener = new MDBListener(handler);
        this.addObserver(listener);
        return listener;
    }

    public void submit(IDataset ds) {
        if (this.excutor != null) {
            if (!this.excutor.execute(new Notifier(ds))) {
                MapReader mw = new MapReader(ds);
                String tableName = mw.getString("tableName");
                String where = mw.getString("where");
                this.logAdapter.log("dispose MDB update table[" + tableName + "] where[" + where + "] for queue full");
            }
        } else {
            this.process(ds);
        }
    }

    private void process(IDataset ds) {
        this.setChanged();
        this.notifyObservers(ds);
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    class Notifier
    extends Task {
        private IDataset ds;

        public Notifier(IDataset ds) {
            this.ds = ds;
        }

        public void run() {
            MDBSupport.this.process(this.ds);
        }
    }
}

