/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.safe;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;

public class CertificateConvertor {
    public static final String PKCS12 = "PKCS12";
    public static final String JKS = "JKS";

    public static KeyStore getJKSFromPFX(String pfxFile, String cerPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore inputKeyStore = KeyStore.getInstance(PKCS12);
        FileInputStream fis = new FileInputStream(pfxFile);
        char[] nPassword = null;
        nPassword = cerPassword == null || cerPassword.trim().equals("") ? null : cerPassword.toCharArray();
        inputKeyStore.load(fis, nPassword);
        fis.close();
        KeyStore outputKeyStore = KeyStore.getInstance(JKS);
        outputKeyStore.load(null, cerPassword.toCharArray());
        Enumeration<String> enums = inputKeyStore.aliases();
        while (enums.hasMoreElements()) {
            String keyAlias = enums.nextElement();
            if (!inputKeyStore.isKeyEntry(keyAlias)) continue;
            Key key = inputKeyStore.getKey(keyAlias, nPassword);
            Certificate[] certChain = inputKeyStore.getCertificateChain(keyAlias);
            outputKeyStore.setKeyEntry(keyAlias, key, cerPassword.toCharArray(), certChain);
        }
        return outputKeyStore;
    }

    public static KeyStore getPFXFromJKS(String jksFile, String cerPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore inputKeyStore = KeyStore.getInstance(JKS);
        FileInputStream fis = new FileInputStream(jksFile);
        char[] nPassword = null;
        nPassword = cerPassword == null || cerPassword.trim().equals("") ? null : cerPassword.toCharArray();
        inputKeyStore.load(fis, nPassword);
        fis.close();
        KeyStore outputKeyStore = KeyStore.getInstance(PKCS12);
        outputKeyStore.load(null, cerPassword.toCharArray());
        Enumeration<String> enums = inputKeyStore.aliases();
        while (enums.hasMoreElements()) {
            String keyAlias = enums.nextElement();
            if (!inputKeyStore.isKeyEntry(keyAlias)) continue;
            Key key = inputKeyStore.getKey(keyAlias, nPassword);
            Certificate[] certChain = inputKeyStore.getCertificateChain(keyAlias);
            outputKeyStore.setKeyEntry(keyAlias, key, cerPassword.toCharArray(), certChain);
        }
        return outputKeyStore;
    }

    public static void convertPFX2JKS(String pfxFile, String cerPassword, String jksFile, String pwd) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException {
        char[] nPassword = null;
        nPassword = cerPassword == null || cerPassword.trim().equals("") ? null : cerPassword.toCharArray();
        KeyStore store = CertificateConvertor.getJKSFromPFX(pfxFile, pwd);
        FileOutputStream out = new FileOutputStream(jksFile);
        store.store(out, nPassword);
        out.close();
    }

    public static void convertJKS2PFX(String jksFile, String cerPassword, String pfxFile, String pwd) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException {
        char[] nPassword = null;
        nPassword = cerPassword == null || cerPassword.trim().equals("") ? null : cerPassword.toCharArray();
        KeyStore store = CertificateConvertor.getPFXFromJKS(jksFile, pwd);
        FileOutputStream out = new FileOutputStream(pfxFile);
        store.store(out, nPassword);
        out.close();
    }

    public static void main(String[] args) {
        try {
            CertificateConvertor.convertPFX2JKS("c:\\hs-jcc.pfx", "123456", "c:\\hs-jcc.jks", "123456");
            CertificateConvertor.convertJKS2PFX("c:\\hs-jcc.jks", "123456", "c:\\temp.pfx", "123456");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

