/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.safe;

import com.hundsun.t2sdk.common.util.ResourceUtils;
import com.hundsun.t2sdk.impl.safe.CertificateConvertor;
import com.hundsun.t2sdk.impl.safe.SSLParameter;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLUtil {
    public static SSLContext getSSLContext(SSLParameter param) throws Exception {
        SSLContext ctx = null;
        KeyManagerFactory kmf = null;
        String defaultAlgorithm = "SunX509";
        if (param.getKeyManageAlgorithm() != null) {
            defaultAlgorithm = param.getKeyManageAlgorithm();
        }
        try {
            ctx = param.getProtocol() != null && !param.getProtocol().equals("") ? SSLContext.getInstance(param.getProtocol()) : SSLContext.getInstance("SSL");
            kmf = KeyManagerFactory.getInstance(defaultAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        KeyStore ks = null;
        String keyCertFileName = param.getKeyCertFile();
        URL url = null;
        url = ResourceUtils.getURL(keyCertFileName);
        url = new URL(URLDecoder.decode(url.toString(), "UTF-8"));
        keyCertFileName = url.getFile();
        try {
            ks = CertificateConvertor.getJKSFromPFX(keyCertFileName, param.getKeyCertPwd());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            kmf.init(ks, param.getKeyCertPwd().toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ctx.init(kmf.getKeyManagers(), SSLUtil.getTrustManagers(), null);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        ctx.getServerSocketFactory();
        return ctx;
    }

    public static TrustManager[] getTrustManagers() {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return trustManagers;
    }
}

