/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.util;

import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.impl.util.AbstractLogAdapter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class HSBlowfish {
    private static final byte[] DEFAULT_KEY = new byte[]{90, 65, 81, 33, 120, 115, 119, 50, 67, 68, 69, 35, 118, 102, 114, 52};
    private AbstractLogAdapter logAdapter = null;
    private String KEYLOCATION = "client_license.dat";
    private byte[] KEY = DEFAULT_KEY;
    private byte[] encryption = null;
    private Cipher decryptCipher = null;
    private Cipher encryptCipher = null;

    public HSBlowfish() {
        this.logAdapter = this.getLog();
    }

    public HSBlowfish(byte[] key) {
        this();
        if (key != null) {
            this.KEY = key;
        }
    }

    public HSBlowfish(String key) {
        this();
        if (key != null) {
            this.KEY = key.getBytes();
        }
    }

    protected void initEncrypt() throws Exception {
        if (this.encryptCipher == null) {
            this.encryptCipher = HSBlowfish._initEncrypt(this.KEY);
        }
    }

    private static Cipher _initEncrypt(byte[] key) throws Exception {
        SecretKeySpec sksSpec = new SecretKeySpec(key, "Blowfish");
        Cipher encryptCipher = Cipher.getInstance("Blowfish/ECB/NoPadding");
        encryptCipher.init(1, sksSpec);
        return encryptCipher;
    }

    protected void initDecrypt() throws Exception, InvalidKeyException {
        if (this.decryptCipher == null) {
            this.decryptCipher = HSBlowfish._initDecrypt(this.KEY);
        }
    }

    private static Cipher _initDecrypt(byte[] key) throws Exception {
        SecretKeySpec sksSpec = new SecretKeySpec(key, "Blowfish");
        Cipher decryptCipher = Cipher.getInstance("Blowfish/ECB/NoPadding");
        decryptCipher.init(2, sksSpec);
        return decryptCipher;
    }

    public byte[] encode(byte[] data) throws Exception {
        if (this.encryptCipher == null) {
            this.initEncrypt();
        }
        byte[] encrypted = data;
        int length = encrypted.length;
        int superfluity = length % 8;
        byte[] encrypted_tmp = new byte[length - superfluity];
        System.arraycopy(encrypted, 0, encrypted_tmp, 0, length - superfluity);
        byte[] decrypted_tmp = null;
        byte[] decrypted = this.encryptCipher.doFinal(encrypted_tmp);
        decrypted_tmp = new byte[length];
        System.arraycopy(decrypted, 0, decrypted_tmp, 0, decrypted.length);
        for (int i = superfluity; i > 0; --i) {
            decrypted_tmp[length - i] = (byte)((byte)(76 + superfluity) ^ encrypted[length - i]);
        }
        return decrypted_tmp;
    }

    public byte[] decode(byte[] data) throws Exception {
        if (this.decryptCipher == null) {
            this.initDecrypt();
        }
        byte[] encrypted = data;
        int length = encrypted.length;
        int superfluity = length % 8;
        byte[] encrypted_tmp = new byte[length - superfluity];
        System.arraycopy(encrypted, 0, encrypted_tmp, 0, length - superfluity);
        byte[] decrypted_tmp = null;
        byte[] decrypted = this.decryptCipher.doFinal(encrypted_tmp);
        decrypted_tmp = new byte[length];
        System.arraycopy(decrypted, 0, decrypted_tmp, 0, decrypted.length);
        for (int i = superfluity; i > 0; --i) {
            decrypted_tmp[length - i] = (byte)((byte)(76 + superfluity) ^ encrypted[length - i]);
        }
        return decrypted_tmp;
    }

    public byte[] encodeWithBase64(byte[] data) throws Exception {
        byte[] tmp_buff = this.encode(data);
        tmp_buff = Base64.encodeBase64((byte[])tmp_buff);
        return tmp_buff;
    }

    public byte[] decodeWithBase64(byte[] data) throws Exception {
        byte[] tmp_buff = Base64.decodeBase64((byte[])data);
        tmp_buff = this.decode(tmp_buff);
        return tmp_buff;
    }

    public static byte[] encode(byte[] data, byte[] key) throws Exception {
        HSBlowfish blowfish = new HSBlowfish(key);
        return blowfish.encode(data);
    }

    public static byte[] decode(byte[] data, byte[] key) throws Exception {
        HSBlowfish blowfish = new HSBlowfish(key);
        return blowfish.decode(data);
    }

    public byte[] getStringInputStream(InputStream is) throws IOException {
        int length;
        byte[] byteArrays = new byte[256];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((length = is.read(byteArrays)) > 0) {
            bos.write(byteArrays, 0, length);
        }
        return bos.toByteArray();
    }

    private void setEncryption(String userKeyLocation) {
        block3: {
            if (userKeyLocation != null && !userKeyLocation.equals("")) {
                this.KEYLOCATION = userKeyLocation;
            }
            try {
                this.encryption = this.getStringInputStream(new FileInputStream(this.KEYLOCATION));
            }
            catch (Exception e) {
                this.encryption = null;
                if (this.logAdapter == null) break block3;
                this.logAdapter.log("HSBlowfish::setEncryption");
            }
        }
    }

    private byte[] decodeLicense(byte[] userKey, String userKeyLocation) {
        try {
            this.setEncryption(userKeyLocation);
            return this.decodeLicense(this.encryption);
        }
        catch (Exception e) {
            if (this.logAdapter != null) {
                this.logAdapter.log("HSBlowfish::decode - \u89e3\u5bc6\u51fa\u9519\uff0c\u89e3\u5bc6\u6587\u4ef6\u4e0d\u5bf9 " + e.getClass().toString());
            }
            return null;
        }
    }

    private byte[] decodeLicense(byte[] base64Code) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        byte[] encrypted = Base64.decodeBase64((byte[])base64Code);
        int length = encrypted.length;
        int superfluity = length % 8;
        byte[] encrypted_tmp = new byte[length - superfluity];
        System.arraycopy(encrypted, 0, encrypted_tmp, 0, length - superfluity);
        byte[] decrypted_tmp = null;
        byte[] decrypted = this.decryptCipher.doFinal(encrypted_tmp);
        decrypted_tmp = new byte[length];
        System.arraycopy(decrypted, 0, decrypted_tmp, 0, decrypted.length);
        for (int i = superfluity; i > 0; --i) {
            decrypted_tmp[length - i] = (byte)((byte)(76 + superfluity) ^ encrypted[length - i]);
        }
        return decrypted_tmp;
    }

    public static String getLicenseNo(String userKeyLocation) {
        block3: {
            HSBlowfish blowfish = new HSBlowfish(DEFAULT_KEY);
            try {
                blowfish.initDecrypt();
                byte[] data = blowfish.decodeLicense(null, userKeyLocation);
                if (data != null) {
                    return new String(data);
                }
            }
            catch (Exception e) {
                if (blowfish.logAdapter == null) break block3;
                blowfish.logAdapter.log("HSBlowfish::decode - \u89e3\u5bc6\u51fa\u9519\uff0c\u89e3\u5bc6\u6587\u4ef6\u4e0d\u5bf9 " + e.getClass().toString());
            }
        }
        return null;
    }

    public AbstractLogAdapter getLog() {
        try {
            AbstractLogAdapter logAdapter = T2Services.getLogAdapter();
            return logAdapter;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        HSBlowfish blowfish = new HSBlowfish();
        String licence = "HS-HUNDSUN001-FBASE2-0000-4ePWxzscBVtY9ZKdgDKhSyk2";
        try {
            byte[] encodeBuff = blowfish.encode(licence.getBytes());
            System.out.println("size: " + encodeBuff.length + "  " + new String(encodeBuff));
            byte[] decodeBuff = blowfish.decode(encodeBuff);
            System.out.println("size: " + decodeBuff.length + "  " + new String(decodeBuff));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

