/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.util;

import com.hundsun.t2sdk.common.util.ResourceUtils;
import com.hundsun.t2sdk.impl.pwd.BlowFishAlgorithm;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

public class LicenseReader {
    public String decodeLicenseFile(String licenseFile, String pwd) throws Exception {
        String result = null;
        if (pwd == null) {
            pwd = "";
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(licenseFile));
        }
        catch (FileNotFoundException e) {
            throw new Exception("\u8bb8\u53ef\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + licenseFile);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            byte[] temp = new byte[1024];
            int size = 0;
            while ((size = in.read(temp)) != -1) {
                out.write(temp, 0, size);
            }
        }
        catch (IOException e) {
            throw new Exception("\u8bfb\u53d6\u8bb8\u53ef\u6587\u4ef6\u51fa\u73b0I/O\u5f02\u5e38: " + e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        byte[] content = out.toByteArray();
        BlowFishAlgorithm bfa = new BlowFishAlgorithm();
        bfa.init(true, pwd.getBytes());
        result = bfa.decryptString(content);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encodeLicense2File(String license, String pwd, String licenseFile) {
        BlowFishAlgorithm bf1 = new BlowFishAlgorithm();
        bf1.init(true, pwd.getBytes());
        byte[] content = bf1.encrypt(license);
        if (content == null) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(licenseFile, false);
            fos.write(content);
            fos.flush();
            fos.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException iex) {}
        }
        return false;
    }

    public static void main(String[] args) {
        URL url = null;
        String licenseFile = "./license/jcc-license.dat";
        try {
            url = ResourceUtils.getURL(licenseFile);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        LicenseReader lr = new LicenseReader();
        lr.encodeLicense2File("HS-HUNDSUN001-FBASE2-0000-4ePWxzscBVtY9ZKdgDKhSyk2", "888888", url.getFile());
        try {
            String content = lr.decodeLicenseFile(url.getFile(), "888888");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

