/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.impl.util;

import com.hundsun.t2sdk.interfaces.exception.T2SDKBaseRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class T2LogManage {
    public static String encryptType = "";
    private static final String LOG_FORMAT_PREFIX = "logFormat.";
    private static final String PROPERTIES_PATH = "t2sdkLogFormat.properties";
    private static Map<Integer, String> logFormatConfigurationMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void logConfigurationInit(Properties pros) {
        logFormatConfigurationMap = new ConcurrentHashMap<Integer, String>();
        InputStream in = null;
        try {
            if (pros == null) {
                InputStream is = T2LogManage.class.getClassLoader().getResourceAsStream(PROPERTIES_PATH);
                pros = new Properties();
                pros.load(is);
            }
            Enumeration<?> en = pros.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (key.indexOf(LOG_FORMAT_PREFIX) == -1) continue;
                String tmpstr = key.substring(key.indexOf(LOG_FORMAT_PREFIX) + LOG_FORMAT_PREFIX.length());
                int tmpint = 0;
                if (tmpstr.startsWith("0x")) {
                    tmpstr = tmpstr.substring(tmpstr.indexOf("0x") + 2);
                    tmpint = Integer.parseInt(tmpstr, 16);
                } else if (tmpstr.startsWith("0X")) {
                    tmpstr = tmpstr.substring(tmpstr.indexOf("0X") + 2);
                    tmpint = Integer.parseInt(tmpstr, 16);
                } else {
                    tmpint = Integer.parseInt(tmpstr);
                }
                logFormatConfigurationMap.put(tmpint, pros.getProperty(key));
            }
        }
        catch (RuntimeException e) {
            new T2SDKBaseRuntimeException("585", (Throwable)e, new Object[0]).printStackTrace();
        }
        catch (IOException e) {
            new T2SDKBaseRuntimeException("586", (Throwable)e, new Object[0]).printStackTrace();
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                new T2SDKBaseRuntimeException("587", (Throwable)e, new Object[0]).printStackTrace();
            }
        }
    }

    public static String logFormatConversion(int logType, String[] logField) {
        StringBuilder conversionFormat = new StringBuilder("");
        if (logFormatConfigurationMap.get(logType) != null) {
            conversionFormat = new StringBuilder(MessageFormat.format(logFormatConfigurationMap.get(logType), logField));
        }
        return conversionFormat.toString();
    }
}

