/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.interfaces.exception;

import com.hundsun.t2sdk.interfaces.exception.ErrorFormatter;
import com.hundsun.t2sdk.interfaces.exception.IT2SDKBaseErrorMessage;

public class T2SDKBaseException
extends Exception
implements IT2SDKBaseErrorMessage {
    private static final long serialVersionUID = 1L;
    protected String errorNo;
    protected String message;

    public T2SDKBaseException() {
    }

    public T2SDKBaseException(String message) {
        super(message);
        this.errorNo = "0";
        this.message = message;
    }

    public T2SDKBaseException(Throwable cause, String message) {
        super(cause);
        this.errorNo = "0";
        this.message = ErrorFormatter.format(this.errorNo, message);
    }

    public T2SDKBaseException(String errorNo, String message) {
        super(message);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, message);
    }

    public T2SDKBaseException(String errorNo, String message, Throwable cause) {
        super(cause);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, message);
    }

    public T2SDKBaseException(String errorNo, Throwable cause, Object ... messages) {
        super(cause);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, messages);
    }

    public String getErrorNo() {
        return this.errorNo;
    }

    public String getMessage() {
        return "[" + this.errorNo + "] " + this.message;
    }

    public String getErrorMessage() {
        return this.getMessage();
    }

    public void setErrorNo(String errorNo) {
        this.errorNo = errorNo;
    }

    public void setErrorMessage(String message) {
        this.message = message;
    }
}

