/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.interfaces.exception;

import com.hundsun.t2sdk.interfaces.exception.ErrorFormatter;
import com.hundsun.t2sdk.interfaces.exception.IT2SDKBaseErrorMessage;

public class T2SDKBaseRuntimeException
extends RuntimeException
implements IT2SDKBaseErrorMessage {
    private static final long serialVersionUID = 1L;
    protected String errorNo;
    protected String message;

    public T2SDKBaseRuntimeException() {
    }

    public T2SDKBaseRuntimeException(String message) {
        super(message);
        this.errorNo = "0";
        this.message = message;
    }

    public T2SDKBaseRuntimeException(Throwable cause, String message) {
        super(cause);
        this.errorNo = "0";
        this.message = ErrorFormatter.format(this.errorNo, message);
    }

    public T2SDKBaseRuntimeException(String errorNo, String message) {
        super(message);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, message);
    }

    public T2SDKBaseRuntimeException(String errorNo, String message, Throwable cause) {
        super(cause);
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, message);
    }

    public T2SDKBaseRuntimeException(String errorNo, Throwable cause, Object ... messages) {
        this.errorNo = errorNo;
        this.message = ErrorFormatter.format(errorNo, messages);
    }

    public String getErrorNo() {
        return this.errorNo;
    }

    public String getMessage() {
        return "[" + this.errorNo + "] " + this.message;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public void setErrorNo(String errorNo) {
        this.errorNo = errorNo;
    }

    public void setErrorMessage(String message) {
        this.message = message;
    }
}

