/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQC;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;

class BatchMatchingCriteria
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/BatchMatchingCriteria.java, java.classes, k701, k701-112-140304 1.30.1.1 09/08/17 09:05:57";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int options;
    private int matchOptions;
    private String msgId;
    private String correlId;
    private String groupId;
    protected int hcon;
    protected int hobj;
    private int msgSeqNum;
    private int offset;

    public BatchMatchingCriteria() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        boolean fid = true;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 1);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 1);
        }
    }

    public String toString() {
        int fid = 2;
        String retString = "MatchingCriteria: msgId=" + this.msgId + " correlId=" + this.correlId + " groupId=" + this.groupId + " hcon=" + this.hcon + " hobj=" + this.hobj + " msgSeqNum=" + this.msgSeqNum + " offset=" + this.offset + " options=" + this.options + " matchOptions=" + this.matchOptions;
        return retString;
    }

    protected void set(BatchMatchingCriteria m) {
        int traceContext = 0;
        int fid = 3;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 3, new Object[]{m});
        }
        this.options = m.options;
        this.matchOptions = m.matchOptions;
        this.msgId = new String(m.msgId);
        this.correlId = new String(m.correlId);
        this.groupId = new String(m.groupId);
        this.hcon = m.hcon;
        this.hobj = m.hobj;
        this.msgSeqNum = m.msgSeqNum;
        this.offset = m.offset;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 3);
        }
    }

    protected void set(int _hcon, int _hobj, MQMsg2 msg, MQGetMessageOptions gmo) {
        int traceContext = 0;
        int fid = 4;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 4, new Object[]{new Integer(_hcon), new Integer(_hobj), msg, gmo});
        }
        this.hcon = _hcon;
        this.hobj = _hobj;
        this.options = gmo.options;
        this.matchOptions = gmo.matchOptions;
        if ((this.matchOptions & 1) == 1) {
            this.msgId = new String(msg.getMessageId());
            if (this.msgId.equals(MQC.MQMI_NONE)) {
                this.matchOptions &= 0xFFFFFFFE;
            }
        } else {
            this.msgId = "";
        }
        if ((this.matchOptions & 2) == 2) {
            this.correlId = new String(msg.getCorrelationId());
            if (this.correlId.equals(MQC.MQCI_NONE)) {
                this.matchOptions &= 0xFFFFFFFD;
            }
        } else {
            this.correlId = "";
        }
        if ((this.matchOptions & 4) == 4) {
            this.groupId = new String(msg.getGroupId());
            if (this.groupId.equals(MQC.MQGI_NONE)) {
                this.matchOptions &= 0xFFFFFFFB;
            }
        } else {
            this.groupId = "";
        }
        this.msgSeqNum = (this.matchOptions & 8) == 8 ? msg.getMessageSequenceNumber() : 0;
        this.offset = (this.matchOptions & 0x10) == 16 ? msg.getOffset() : 0;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 4);
        }
    }

    protected boolean matches(BatchMatchingCriteria m) {
        int traceContext = 0;
        int fid = 5;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 5, new Object[]{m});
        }
        boolean match = false;
        if (this.hobj == m.hobj && this.hcon == m.hcon && this.options == m.options && this.matchOptions == m.matchOptions) {
            match = true;
            if ((this.matchOptions & 1) == 1) {
                boolean bl = match = match && this.msgId.equals(m.msgId);
            }
            if ((this.matchOptions & 2) == 2) {
                boolean bl = match = match && this.correlId.equals(m.correlId);
            }
            if ((this.matchOptions & 4) == 4) {
                boolean bl = match = match && this.groupId.equals(m.groupId);
            }
            if ((this.matchOptions & 8) == 8) {
                boolean bl = match = match && this.msgSeqNum == m.msgSeqNum;
            }
            if ((this.matchOptions & 0x10) == 16) {
                boolean bl = match = match && this.offset == m.offset;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 5, (Object)match);
        }
        return match;
    }
}

