/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionRequestInfo;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionJ11;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.spi.ConnectionRequestInfo;

class ClientConnectionRequestInfo
extends MQConnectionRequestInfo
implements Cloneable,
ConnectionRequestInfo {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/ClientConnectionRequestInfo.java, java.classes, k701, k701-112-140304 1.38.1.3 10/12/03 15:01:43";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public int connectOptions;
    public Object securityExit;
    public String securityExitUserData;
    public Object sendExit;
    public String sendExitUserData;
    public Object receiveExit;
    public String receiveExitUserData;
    public Object exitClasspath;
    public String userName;
    public String password;
    public boolean xaRequired;
    public boolean useQmCcsid;
    public String sslCipherSuite = null;
    public String sslPeername = null;
    public Object sslCertStores = null;
    public Object sslSocketFactory = null;
    public Object hdrCompList = null;
    public Object msgCompList = null;
    public Integer sslResetCount = null;
    public Boolean sslFipsRequired = null;
    public String localAddress = "";
    public byte[] connTag = null;
    public URL ccdtUrl = null;
    public int sharingConversations = 10;
    public int jmqiFlags;

    ClientConnectionRequestInfo(Hashtable props, URL ccdtUrl) throws MQException {
        int traceContext = 0;
        int fid = 10;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 10, new Object[]{props, ccdtUrl});
        }
        this.ccdtUrl = ccdtUrl;
        this.complexPopulate(props, ccdtUrl);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 10);
        }
    }

    private void complexPopulate(Hashtable props, URL ccdtUrl) throws MQException {
        Object jmqiFlagsObj;
        int traceContext = 0;
        int fid = 11;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 11, new Object[]{props, ccdtUrl});
        }
        this.hasVariablePortion = true;
        this.connectOptions = MQEnvironment.getIntegerProperty("connectOptions", props);
        if (ccdtUrl == null) {
            if (MQEnvironment.getObjectProperty("channelSecurityExit", props) != null) {
                this.securityExit = MQEnvironment.getObjectProperty("channelSecurityExit", props);
                this.securityExitUserData = (String)MQEnvironment.getObjectProperty("channelSecurityExitUserData", props);
            } else {
                this.securityExit = MQEnvironment.getObjectProperty("securityExit", props);
                this.securityExitUserData = (String)MQEnvironment.getObjectProperty("securityExitUserData", props);
            }
            if (MQEnvironment.getObjectProperty("channelReceiveExit", props) != null) {
                this.receiveExit = MQEnvironment.getObjectProperty("channelReceiveExit", props);
                this.receiveExitUserData = (String)MQEnvironment.getObjectProperty("channelReceiveExitUserData", props);
            } else {
                this.receiveExit = MQEnvironment.getObjectProperty("receiveExit", props);
                this.receiveExitUserData = (String)MQEnvironment.getObjectProperty("receiveExitUserData", props);
            }
            if (MQEnvironment.getObjectProperty("channelSendExit", props) != null) {
                this.sendExit = MQEnvironment.getObjectProperty("channelSendExit", props);
                this.sendExitUserData = (String)MQEnvironment.getObjectProperty("channelSendExitUserData", props);
            } else {
                this.sendExit = MQEnvironment.getObjectProperty("sendExit", props);
                this.sendExitUserData = (String)MQEnvironment.getObjectProperty("sendExitUserData", props);
            }
            this.exitClasspath = MQEnvironment.getObjectProperty("exitClasspath", props);
            this.sslCipherSuite = MQEnvironment.getStringProperty("SSL Cipher Suite", props);
            this.sslPeername = MQEnvironment.getStringProperty("SSL Peer Name", props);
            this.hdrCompList = MQEnvironment.getObjectProperty("Header Compression Property", props);
            if (this.hdrCompList instanceof Vector) {
                this.hdrCompList = ((Vector)this.hdrCompList).clone();
                if (this.trace.isOn) {
                    this.trace.data(COMP_JN, 11, "Cloned hdrCompList", (Object)"");
                }
            }
            this.msgCompList = MQEnvironment.getObjectProperty("Message Compression Property", props);
            if (this.msgCompList instanceof Vector) {
                this.msgCompList = ((Vector)this.msgCompList).clone();
                if (this.trace.isOn) {
                    this.trace.data(COMP_JN, 11, "Cloned msgCompList", (Object)"");
                }
            }
            this.connTag = (byte[])MQEnvironment.getObjectProperty("ConnTag Property", props);
            this.localAddress = MQEnvironment.getStringProperty("Local Address Property", props);
            this.sharingConversations = MQEnvironment.getIntegerProperty("sharingConversations", props);
        }
        this.userName = MQEnvironment.getStringProperty("userID", props);
        this.password = MQEnvironment.getStringProperty("password", props);
        this.sslCertStores = MQEnvironment.getObjectProperty("SSL CertStores", props);
        if (this.sslCertStores instanceof Vector) {
            this.sslCertStores = ((Vector)this.sslCertStores).clone();
            if (this.trace.isOn) {
                this.trace.data(COMP_JN, 11, "Cloned sslCertStores", (Object)"");
            }
        }
        this.sslSocketFactory = MQEnvironment.getObjectProperty("SSL Socket Factory", props);
        this.sslResetCount = (Integer)MQEnvironment.getObjectProperty("KeyResetCount", props);
        this.sslFipsRequired = (Boolean)MQEnvironment.getObjectProperty("SSL Fips Required", props);
        if (props != null && (jmqiFlagsObj = props.get("JMQI FLAGS")) != null && jmqiFlagsObj instanceof Integer) {
            this.jmqiFlags = (Integer)jmqiFlagsObj;
        }
        this.setClassFields(props);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 11);
        }
    }

    private void setClassFields(Hashtable props) {
        int traceContext = 0;
        int fid = 12;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 12, new Object[]{props});
        }
        if (props != null) {
            this.xaRequired = false;
            Object xar = props.get("XAReq");
            if (xar != null && xar instanceof Boolean) {
                this.xaRequired = (Boolean)xar;
            }
            this.useQmCcsid = false;
            Object object = props.get("Use QM CCSID");
            if (object != null && object instanceof Boolean) {
                this.useQmCcsid = (Boolean)object;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 12);
        }
    }

    public int variableHashCode() {
        int traceContext = 0;
        int fid = 13;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 13);
        }
        int out = 0;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 13, (Object)new Integer(out));
        }
        return out;
    }

    public int fixedHashCode() {
        int traceContext = 0;
        int fid = 14;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 14);
        }
        int out = 31 * this.connectOptions;
        if (this.userName != null) {
            out += 37 * this.userName.hashCode();
        }
        if (this.xaRequired) {
            out += 43;
        }
        if (this.useQmCcsid) {
            out += 47;
        }
        if (this.sslCipherSuite != null) {
            out += 79 * this.sslCipherSuite.hashCode();
        }
        if (this.sslPeername != null) {
            out += 83 * this.sslPeername.hashCode();
        }
        if (this.sslCertStores != null) {
            out += 89 * this.sslCertStores.hashCode();
        }
        if (this.localAddress != null) {
            out += 101 * this.localAddress.hashCode();
        }
        if (this.hdrCompList != null) {
            out += 103 * this.hdrCompList.hashCode();
        }
        if (this.msgCompList != null) {
            out += 107 * this.msgCompList.hashCode();
        }
        if (this.connTag != null) {
            out += 109 * new String(this.connTag).hashCode();
        }
        if (this.sslResetCount != null) {
            out += 113 * this.sslResetCount.hashCode();
        }
        if (this.sslFipsRequired != null) {
            out += 127 * this.sslFipsRequired.hashCode();
        }
        if (this.ccdtUrl != null) {
            out += 131 * this.ccdtUrl.toString().hashCode();
        }
        out += this.sharingConversations * 137;
        out += 139 * this.jmqiFlags;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 14, (Object)new Integer(out));
        }
        return out;
    }

    public boolean variableIsSuitable(MQManagedConnectionJ11 mc) {
        int traceContext = 0;
        int fid = 15;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 15, new Object[]{mc});
        }
        if (mc == null) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 15, (Object)false, 1);
            }
            return false;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 15, (Object)true, 2);
        }
        return true;
    }

    public boolean fixedEquals(Object obj) {
        int traceContext;
        block12: {
            traceContext = 0;
            int fid = 16;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 16, new Object[]{obj});
            }
            if (this == obj) {
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 16, (Object)true, 1);
                }
                return true;
            }
            if (obj == null) {
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 16, (Object)false, 2);
                }
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 16, (Object)false, 3);
                }
                return false;
            }
            ClientConnectionRequestInfo other = (ClientConnectionRequestInfo)obj;
            try {
                if (this.connectOptions == other.connectOptions && this.objEquals(this.userName, other.userName) && this.objEquals(this.password, other.password) && this.objEquals(this.securityExit, other.securityExit) && this.objEquals(this.sendExit, other.sendExit) && this.objEquals(this.receiveExit, other.receiveExit) && this.xaRequired == other.xaRequired && this.useQmCcsid == other.useQmCcsid && this.objEquals(this.sslCipherSuite, other.sslCipherSuite) && this.objEquals(this.sslPeername, other.sslPeername) && this.objEquals(this.sslCertStores, other.sslCertStores) && this.objEquals(this.hdrCompList, other.hdrCompList) && this.objEquals(this.msgCompList, other.msgCompList) && ClientConnectionRequestInfo.byteArrayEquals(this.connTag, other.connTag) && this.objEquals(this.sslResetCount, other.sslResetCount) && this.objEquals(this.sslFipsRequired, other.sslFipsRequired) && this.objEquals(this.localAddress, other.localAddress) && this.objEquals(this.ccdtUrl, other.ccdtUrl) && this.jmqiFlags == other.jmqiFlags && this.sharingConversations == other.sharingConversations) {
                    if (this.trace.isOn) {
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 16, (Object)true, 4);
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!this.trace.isOn) break block12;
                this.trace.catchBlock((Object)this, COMP_JN, 16, (Throwable)e);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 16, (Object)false, 5);
        }
        return false;
    }

    public boolean variableEquals(Object obj) {
        int traceContext = 0;
        int fid = 17;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 17, new Object[]{obj});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 17, (Object)true);
        }
        return true;
    }

    private static boolean byteArrayEquals(byte[] bytes1, byte[] bytes2) {
        if (bytes1 == bytes2) {
            return true;
        }
        if (bytes1 == null || bytes2 == null) {
            return false;
        }
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }
}

