/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.JmqiTraceHandlerAdapter;
import java.security.cert.LDAPCertStoreParameters;

class MQCrlInformation
extends LDAPCertStoreParameters {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQCrlInformation.java, java.classes, k701, k701-112-140304 1.29.1.1 09/08/17 09:09:26";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int COMP_JN = JmqiObject.COMP_JN;
    private String ldapUserName = "";
    private String ldapPassword = "";

    public MQCrlInformation(String connName, String ldapUserName, String ldapPassword, JmqiTraceHandlerAdapter trace) {
        super(MQCrlInformation.findServer(connName, trace), MQCrlInformation.findPort(connName, trace));
        int traceContext = 0;
        int fid = 81;
        if (trace.isOn) {
            traceContext = trace.entry_OO((Object)this, COMP_JN, 81, new Object[]{connName, ldapUserName, ldapPassword == null ? ldapPassword : "********", trace});
        }
        this.ldapUserName = ldapUserName;
        this.ldapPassword = ldapPassword;
        if (trace.isOn) {
            trace.exit(traceContext, (Object)this, COMP_JN, 81);
        }
    }

    private static int findPort(String connName, JmqiTraceHandlerAdapter trace) {
        int last;
        int traceContext = 0;
        int fid = 82;
        if (trace.isOn) {
            traceContext = trace.entry_OO(COMP_JN, 82, new Object[]{connName, trace});
        }
        int port = 389;
        int first = connName.indexOf(40);
        if (first > -1 && (last = connName.indexOf(41, first)) > first) {
            String portName = connName.substring(first + 1, last);
            port = new Integer(portName);
        }
        if (trace.isOn) {
            trace.exit(traceContext, COMP_JN, 82, (Object)new Integer(port));
        }
        return port;
    }

    private static String findServer(String connName, JmqiTraceHandlerAdapter trace) {
        int first;
        int traceContext = 0;
        int fid = 83;
        if (trace.isOn) {
            traceContext = trace.entry_OO(COMP_JN, 83, new Object[]{connName, trace});
        }
        if ((first = connName.indexOf(40)) > -1) {
            String traceRet1 = connName.substring(0, first);
            if (trace.isOn) {
                trace.exit(traceContext, COMP_JN, 83, (Object)traceRet1, 1);
            }
            return traceRet1;
        }
        if (trace.isOn) {
            trace.exit(traceContext, COMP_JN, 83, (Object)connName, 2);
        }
        return connName;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof MQCrlInformation)) {
            return false;
        }
        MQCrlInformation newOther = (MQCrlInformation)other;
        return MQCrlInformation.objEquals(this.ldapUserName, newOther.ldapUserName) && MQCrlInformation.objEquals(this.ldapPassword, newOther.ldapPassword) && MQCrlInformation.objEquals(this.getServerName(), newOther.getServerName()) && this.getPort() == newOther.getPort();
    }

    private static boolean objEquals(Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }
}

