/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.MQPMO;
import com.ibm.mq.jmqi.handles.PbyteBuffer;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.internal.Configuration;
import com.ibm.mq.jmqi.internal.JmqiDC;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.SpiOpenOptions;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;

public abstract class MQDestination
extends MQManagedObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQDestination.java, java.classes, k701, k701-112-140304 1.68.1.6 13/01/11 17:12:21";
    private com.ibm.mq.Pint pMsgTooSmallForBufferCount = new com.ibm.mq.Pint(0);
    private PbyteBuffer pByteBuffer = this.env.newPbyteBuffer();
    private int destinationType;
    protected com.ibm.mq.Pint completionCode = new com.ibm.mq.Pint();
    protected com.ibm.mq.Pint reason = new com.ibm.mq.Pint();
    protected int propControl = -1;
    protected boolean cfgPropControl = false;
    private int queueManagerCmdLevel;

    protected MQDestination(int destType) {
        int traceContext = 0;
        int fid = 667;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 667, new Object[]{new Integer(destType)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 667, "sccsid = ", (Object)sccsid);
        }
        this.destinationType = destType;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 667);
        }
    }

    protected MQDestination(int destType, MQQueueManager qMgr, String objectName, int options, String altUserId) throws MQException {
        this(destType);
        int traceContext = 0;
        int fid = 668;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 668, new Object[]{new Integer(destType), qMgr, objectName, new Integer(options), altUserId});
        }
        if (qMgr == null) {
            MQException exception = new MQException(2, 2018, (Object)this, "MQJI001");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 668, (Throwable)exception, 1);
            }
            throw exception;
        }
        if (!qMgr.connected) {
            MQException exception = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 668, (Throwable)exception, 2);
            }
            throw exception;
        }
        this.parentQmgr = qMgr;
        this.Hconn = qMgr.Hconn;
        this.connected = qMgr.connected;
        this.osession = qMgr.osession;
        this.setConnectionReference(qMgr);
        this.setName(objectName);
        this.setOpenOptions(options);
        this.setAlternateUserId(altUserId);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 668);
        }
    }

    protected MQOD createMQOD() throws MQException {
        int traceContext = 0;
        int fid = 669;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 669);
        }
        MQOD mqObjectDescriptor = this.env.newMQOD();
        mqObjectDescriptor.setObjectType(this.destinationType);
        String objectName = this.getName();
        if (this.isValidStringParameter(objectName)) {
            mqObjectDescriptor.setObjectName(objectName);
        } else {
            objectName = mqObjectDescriptor.getObjectName();
            this.setName(objectName);
        }
        String altUserId = this.getAlternateUserId();
        if (this.isValidStringParameter(altUserId)) {
            mqObjectDescriptor.setAlternateUserId(altUserId);
        } else {
            altUserId = mqObjectDescriptor.getAlternateUserId();
            this.setAlternateUserId(altUserId);
        }
        mqObjectDescriptor.getResolvedObjectString().setVsBufSize(10240);
        mqObjectDescriptor.getSelectionString().setVsBufSize(10240);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 669, (Object)mqObjectDescriptor);
        }
        return mqObjectDescriptor;
    }

    protected boolean isValidParameter(Object parameter) {
        boolean valid;
        int traceContext = 0;
        int fid = 670;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 670, new Object[]{parameter});
        }
        boolean bl = valid = parameter != null;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 670, (Object)valid);
        }
        return valid;
    }

    protected boolean isValidStringParameter(String parameter) {
        boolean valid;
        int traceContext = 0;
        int fid = 671;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 671, new Object[]{parameter});
        }
        boolean bl = valid = this.isValidParameter(parameter) && parameter.length() > 0;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 671, (Object)valid);
        }
        return valid;
    }

    protected void open(MQOD mqObjectDescriptor) throws MQException {
        int traceContext = 0;
        int fid = 672;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 672, new Object[]{mqObjectDescriptor});
        }
        com.ibm.mq.Pint cc = new com.ibm.mq.Pint();
        com.ibm.mq.Pint rc = new com.ibm.mq.Pint();
        JmqiMQ jmqi = this.osession.getJmqi();
        int options = this.getOpenOptions();
        try {
            this.queueManagerCmdLevel = this.Hconn.getHconn().getCmdLevel();
        }
        catch (JmqiException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 672, (Throwable)e);
            }
            MQException traceRet1 = new MQException(e.getCompCode(), e.getReason(), (Object)this, e);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 672, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.queueManagerCmdLevel >= 700) {
            JmqiSP jmqiSP = (JmqiSP)jmqi;
            mqObjectDescriptor.setVersion(4);
            SpiOpenOptions openOptions = ((JmqiSystemEnvironment)this.env).newSpiOpenOptions();
            openOptions.setOptions(options);
            jmqiSP.spiOpen(this.Hconn.getHconn(), mqObjectDescriptor, openOptions, this.Hobj, (Pint)cc, (Pint)rc);
            this.propControl = openOptions.getPropertyControl();
            this.cfgPropControl = this.env.getConfiguration().getBoolValue(Configuration.MESSAGEPROPERTIES_FORCE_RFH2);
        } else {
            jmqi.MQOPEN(this.Hconn.getHconn(), mqObjectDescriptor, options, this.Hobj, (Pint)cc, (Pint)rc);
        }
        if (cc.x != 0 || rc.x != 0) {
            this.resourceOpen = false;
            MQException exception = new MQException(cc.x, rc.x, (Object)this, this.osession.getLastJmqiException());
            this.parentQmgr.errorOccurred(exception);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 672, (Throwable)exception, 2);
            }
            throw exception;
        }
        this.setResolvedType(mqObjectDescriptor.getResolvedType());
        this.setResolvedQName(mqObjectDescriptor.getResolvedQName());
        this.setResolvedObjectString(mqObjectDescriptor.getResolvedObjectString().getVsString());
        this.resourceOpen = true;
        this.setOpen(true);
        String newName = mqObjectDescriptor.getObjectName();
        this.setName(newName);
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 672, "Opened destination name = ", (Object)this.getName());
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 672);
        }
    }

    private void validateDestination() throws MQException {
        int traceContext = 0;
        int fid = 673;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 673);
        }
        if (this.osession == null && this.parentQmgr != null) {
            this.osession = this.parentQmgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException exception = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 673, (Throwable)exception, 1);
            }
            throw exception;
        }
        if (!this.resourceOpen) {
            MQException exception = new MQException(2, 2019, (Object)this, "MQJI027");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 673, (Throwable)exception, 2);
            }
            throw exception;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 673);
        }
    }

    public void get(MQMessage message) throws MQException {
        int traceContext = 0;
        int fid = 674;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 674, new Object[]{message});
        }
        this.get(message, new MQGetMessageOptions());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 674);
        }
    }

    public void get(MQMessage message, MQGetMessageOptions getMessageOptions) throws MQException {
        int bufferSizeHint;
        int traceContext = 0;
        int fid = 675;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 675, new Object[]{message, getMessageOptions});
        }
        int expectedMsgLength = -1;
        int maxMsgLength = Integer.MAX_VALUE;
        if (message != null && (bufferSizeHint = message.getBufferSizeHint()) != -1) {
            expectedMsgLength = bufferSizeHint;
        }
        this.getInt(message, getMessageOptions, expectedMsgLength, maxMsgLength);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 675);
        }
    }

    public void get(MQMessage message, MQGetMessageOptions getMessageOptions, int maxMsgSize) throws MQException {
        int traceContext = 0;
        int fid = 676;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 676, new Object[]{message, getMessageOptions, new Integer(maxMsgSize)});
        }
        int expectedMsgLength = -1;
        int maxMsgLength = maxMsgSize;
        if (getMessageOptions != null && (getMessageOptions.options & 0x40) == 64) {
            expectedMsgLength = maxMsgLength;
        }
        this.getInt(message, getMessageOptions, expectedMsgLength, maxMsgLength);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 676);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInt(MQMessage message, MQGetMessageOptions getMessageOptions, int expectedMsgLength, int maxMsgLength) throws MQException {
        int originalGmoOpts;
        int traceContext;
        block30: {
            traceContext = 0;
            int fid = 677;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 677, new Object[]{message, getMessageOptions, new Integer(expectedMsgLength), new Integer(maxMsgLength)});
            }
            boolean bCanConvert = false;
            boolean propGmoAsQDef = true;
            this.validateGetParameters(message, getMessageOptions, maxMsgLength);
            this.validateDestination();
            originalGmoOpts = getMessageOptions.options;
            try {
                MQException exception = null;
                MQDestination mQDestination = this;
                synchronized (mQDestination) {
                    ByteBuffer messageData;
                    com.ibm.mq.Pint rc;
                    com.ibm.mq.Pint compCode;
                    com.ibm.mq.Pint messageLength;
                    block29: {
                        if (this.queueManagerCmdLevel >= 700) {
                            boolean bl = propGmoAsQDef = (originalGmoOpts & 0x1E000000) == 0;
                            if ((originalGmoOpts & 0x8000000) != 0 || propGmoAsQDef) {
                                getMessageOptions.options &= 0xF7FFFFFF;
                                getMessageOptions.options |= 0x2000000;
                            }
                        }
                        JmqiMQ jmqi = this.osession.getJmqi();
                        getMessageOptions.calcVersion(this.osession.mqManCon);
                        MQGMO jmqiGetMessageOptions = getMessageOptions.getJMQIStructure();
                        MQMD jmqiMessage = message.getJMQIStructure(0);
                        messageLength = new com.ibm.mq.Pint(-1);
                        compCode = new com.ibm.mq.Pint();
                        rc = new com.ibm.mq.Pint();
                        messageData = this.internalGetMessage(jmqi, jmqiMessage, jmqiGetMessageOptions, messageLength, expectedMsgLength, maxMsgLength, compCode, rc);
                        if (rc.x == 2190 && (getMessageOptions.options & 0x4000) == 16384 && messageData.limit() < maxMsgLength) {
                            JmqiDC jmqiDataConvert = ((JmqiSystemEnvironment)this.env).getDC();
                            JmqiCodepage cpSource = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)jmqiMessage.getCodedCharSetId());
                            JmqiCodepage cpTarget = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)message.characterSet);
                            try {
                                ByteBuffer convertedMessageData = jmqiDataConvert.convertBuffer(messageData, cpSource, cpTarget);
                                if (convertedMessageData.limit() < maxMsgLength) {
                                    messageData = convertedMessageData;
                                    messageLength.x = messageData.limit();
                                    rc.x = 0;
                                    compCode.x = 0;
                                }
                            }
                            catch (JmqiException e) {
                                if (!this.trace.isOn) break block29;
                                this.trace.catchBlock((Object)this, COMP_JN, 677, (Throwable)e);
                            }
                        }
                    }
                    message.updateFromJMQIStructure(0);
                    getMessageOptions.updateFromJMQIStructure();
                    message.setMessageData(messageData, messageData.limit(), messageLength.x);
                    if (compCode.x == 0 || compCode.x == 1) {
                        boolean removeRfh2 = false;
                        if (this.queueManagerCmdLevel >= 700) {
                            if (propGmoAsQDef) {
                                if (this.propControl != 3) {
                                    removeRfh2 = true;
                                }
                            } else if ((originalGmoOpts & 0x8000000) != 0) {
                                removeRfh2 = true;
                            }
                            if (this.cfgPropControl) {
                                removeRfh2 = false;
                            }
                        }
                        message.setRemoveRfh2AfterGet(removeRfh2);
                        if (removeRfh2) {
                            message.performProcessingAfterGet();
                        }
                    }
                    if (compCode.x != 0) {
                        exception = new MQException(compCode.x, rc.x, (Object)this, this.osession.getLastJmqiException());
                    }
                }
                if (exception != null) {
                    this.parentQmgr.errorOccurred(exception);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 677, (Throwable)exception);
                    }
                    throw exception;
                }
                Object var25_26 = null;
                if (!this.trace.isOn) break block30;
            }
            catch (Throwable throwable) {
                Object var25_27 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 677);
                }
                if ((originalGmoOpts & 0x8000000) != 0) {
                    getMessageOptions.options |= 0x8000000;
                }
                if ((originalGmoOpts & 0x2000000) == 0) {
                    getMessageOptions.options &= 0xFDFFFFFF;
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 677);
        }
        if ((originalGmoOpts & 0x8000000) != 0) {
            getMessageOptions.options |= 0x8000000;
        }
        if ((originalGmoOpts & 0x2000000) == 0) {
            getMessageOptions.options &= 0xFDFFFFFF;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 677);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMsg2(MQMsg2 message, MQGetMessageOptions getMessageOptions, int MaxMsgSize) throws MQException {
        int traceContext = 0;
        int fid = 678;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 678, new Object[]{message, getMessageOptions, new Integer(MaxMsgSize)});
        }
        MQException mqe = null;
        MQDestination mQDestination = this;
        synchronized (mQDestination) {
            int expectedMsgLength = -1;
            int maxMsgLength = MaxMsgSize;
            if ((getMessageOptions.options & 0x40) == 64) {
                expectedMsgLength = maxMsgLength;
            }
            this.getMsg2Int(message, getMessageOptions, expectedMsgLength, maxMsgLength, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this, this.osession.getLastJmqiException());
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 678, (Throwable)mqe);
            }
            throw mqe;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 678);
        }
    }

    public synchronized int getMsg2NoExc(MQMsg2 message, MQGetMessageOptions getMessageOptions, int MaxMsgSize) {
        int traceContext = 0;
        int fid = 679;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 679, new Object[]{message, getMessageOptions, new Integer(MaxMsgSize)});
        }
        int expectedMsgLength = -1;
        int maxMsgLength = MaxMsgSize;
        if ((getMessageOptions.options & 0x40) == 64) {
            expectedMsgLength = maxMsgLength;
        }
        try {
            this.getMsg2Int(message, getMessageOptions, expectedMsgLength, maxMsgLength, this.completionCode, this.reason);
        }
        catch (MQException mqe) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 679, (Throwable)mqe);
            }
            this.completionCode.x = mqe.completionCode;
            this.reason.x = mqe.reasonCode;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 679, (Object)new Integer(this.reason.x));
        }
        return this.reason.x;
    }

    private void getMsg2Int(MQMsg2 message, MQGetMessageOptions getMessageOptions, int expectedMsgLength, int maxMsgLength, com.ibm.mq.Pint compCode, com.ibm.mq.Pint reasonCode) throws MQException {
        int traceContext = 0;
        int fid = 680;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 680, new Object[]{message, getMessageOptions, new Integer(expectedMsgLength), new Integer(maxMsgLength), compCode, reasonCode});
        }
        this.validateGetParameters((Object)message, getMessageOptions, maxMsgLength);
        this.validateDestination();
        com.ibm.mq.Pint msgLength = new com.ibm.mq.Pint(-1);
        if (expectedMsgLength > 0) {
            msgLength.x = expectedMsgLength;
        }
        JmqiMQ jmqi = this.osession.getJmqi();
        getMessageOptions.calcVersion(this.osession.mqManCon);
        MQGMO jmqiGetMessageOptions = getMessageOptions.getJMQIStructure();
        MQMD jmqiMessage = message.getJMQIStructure();
        ByteBuffer messageData = this.internalGetMessage(jmqi, jmqiMessage, jmqiGetMessageOptions, msgLength, expectedMsgLength, maxMsgLength, compCode, reasonCode);
        getMessageOptions.updateFromJMQIStructure();
        if (compCode.x == 0) {
            message.setMessageData(messageData.array(), Math.min(maxMsgLength, msgLength.x));
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 680, "getMsg2Int completed with cc, rc= ", (Object)(Integer.toString(compCode.x) + "," + Integer.toString(reasonCode.x)));
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 680);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMsg2(MQMsg2 message, MQGetMessageOptions getMessageOptions) throws MQException {
        int traceContext = 0;
        int fid = 681;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 681, new Object[]{message, getMessageOptions});
        }
        MQException mqe = null;
        MQDestination mQDestination = this;
        synchronized (mQDestination) {
            int expectedMsgLength = -1;
            int maxMsgLength = Integer.MAX_VALUE;
            this.getMsg2Int(message, getMessageOptions, expectedMsgLength, maxMsgLength, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this, this.osession.getLastJmqiException());
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 681, (Throwable)mqe);
            }
            throw mqe;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 681);
        }
    }

    public synchronized int getMsg2NoExc(MQMsg2 message, MQGetMessageOptions getMessageOptions) {
        int traceContext = 0;
        int fid = 682;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 682, new Object[]{message, getMessageOptions});
        }
        int expectedMsgLength = -1;
        int maxMsgLength = Integer.MAX_VALUE;
        try {
            this.getMsg2Int(message, getMessageOptions, expectedMsgLength, maxMsgLength, this.completionCode, this.reason);
        }
        catch (MQException mqe) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 682, (Throwable)mqe);
            }
            this.completionCode.x = mqe.completionCode;
            this.reason.x = mqe.reasonCode;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 682, (Object)new Integer(this.reason.x));
        }
        return this.reason.x;
    }

    public void getMsg2(MQMsg2 message) throws MQException {
        int traceContext = 0;
        int fid = 684;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 684, new Object[]{message});
        }
        this.getMsg2(message, new MQGetMessageOptions(true));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 684);
        }
    }

    private void validateGetParameters(Object message, MQGetMessageOptions getMessageOptions, int maxMsgSize) throws MQException {
        int traceContext = 0;
        int fid = 685;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 685, new Object[]{message, getMessageOptions, new Integer(maxMsgSize)});
        }
        if (message == null) {
            MQException exception = new MQException(2, 2026, (Object)this, "MQJI025");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 685, (Throwable)exception, 1);
            }
            throw exception;
        }
        if (getMessageOptions == null) {
            MQException exception = new MQException(2, 2186, (Object)this, "MQJI026");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 685, (Throwable)exception, 2);
            }
            throw exception;
        }
        if (maxMsgSize < 0) {
            MQException exception = new MQException(2, 2005, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 685, (Throwable)exception, 3);
            }
            throw exception;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 685);
        }
    }

    protected synchronized ByteBuffer internalGetMessage(JmqiMQ jmqi, MQMD messageDescriptor, MQGMO getMessageOptions, com.ibm.mq.Pint pMessageLength, int expectedMsgLength, int maxMsgLength, com.ibm.mq.Pint pCompletionCode, com.ibm.mq.Pint pReason) {
        int traceContext = 0;
        int fid = 686;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 686, new Object[]{jmqi, messageDescriptor, getMessageOptions, pMessageLength, new Integer(expectedMsgLength), new Integer(maxMsgLength), pCompletionCode, pReason});
        }
        int prevMatchOptions = getMessageOptions.getMatchOptions();
        ByteBuffer buffer = ((JmqiSP)jmqi).jmqiGet(this.Hconn.getHconn(), this.Hobj.getHobj(), messageDescriptor, getMessageOptions, expectedMsgLength, maxMsgLength, this.pByteBuffer, (Pint)this.pMsgTooSmallForBufferCount, (Pint)pMessageLength, (Pint)pCompletionCode, (Pint)pReason);
        getMessageOptions.setMatchOptions(prevMatchOptions);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 686, (Object)buffer);
        }
        return buffer;
    }

    public synchronized void put(MQMessage message) throws MQException {
        int traceContext = 0;
        int fid = 687;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 687, new Object[]{message});
        }
        this.put(message, new MQPutMessageOptions());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 687);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void put(MQMessage message, MQPutMessageOptions putMessageOptions) throws MQException {
        int traceContext;
        block43: {
            traceContext = 0;
            int fid = 688;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 688, new Object[]{message, putMessageOptions});
            }
            this.validatePutParameters(message, putMessageOptions);
            this.validateDestination();
            MQMessage mQMessage = message;
            synchronized (mQMessage) {
                MQException exception;
                block40: {
                    block39: {
                        int qmCcsid;
                        exception = null;
                        try {
                            qmCcsid = this.Hconn.getHconn().getCcsid();
                        }
                        catch (JmqiException e) {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, COMP_JN, 688, (Throwable)e, 1);
                            }
                            qmCcsid = 0;
                        }
                        message.performProcessingBeforePut(qmCcsid);
                        JmqiMQ jmqi = this.osession.getJmqi();
                        if ((putMessageOptions.options & 0x300) != 0) {
                            if (putMessageOptions.contextReference != null) {
                                putMessageOptions.contextReferenceHandle = putMessageOptions.contextReference.getHandle();
                                if (putMessageOptions.contextReferenceHandle == -1) {
                                    MQException traceRet5 = new MQException(2, 2097, (Object)this);
                                    if (this.trace.isOn) {
                                        this.trace.throwing((Object)this, COMP_JN, 688, (Throwable)traceRet5, 1);
                                    }
                                    throw traceRet5;
                                }
                                if (this.parentQmgr != putMessageOptions.contextReference.mgr) {
                                    if (this.trace.isOn) {
                                        this.trace.dataFmt(this.env, COMP_JN, 688, "Connection references do not match", (Object)"");
                                    }
                                    MQException traceRet6 = new MQException(2, 2097, (Object)this);
                                    if (this.trace.isOn) {
                                        this.trace.throwing((Object)this, COMP_JN, 688, (Throwable)traceRet6, 2);
                                    }
                                    throw traceRet6;
                                }
                                if (this.trace.isOn) {
                                    this.trace.dataFmt(this.env, COMP_JN, 688, "Obtained context reference handle:", (Object)Integer.toString(putMessageOptions.contextReferenceHandle));
                                }
                            } else {
                                if (this.trace.isOn) {
                                    this.trace.dataFmt(this.env, COMP_JN, 688, "Context reference queue is null", (Object)"");
                                }
                                MQException traceRet7 = new MQException(2, 2097, (Object)this);
                                if (this.trace.isOn) {
                                    this.trace.throwing((Object)this, COMP_JN, 688, (Throwable)traceRet7, 3);
                                }
                                throw traceRet7;
                            }
                        }
                        MQPMO jmqiPutMessageOptions = putMessageOptions.getJMQIStructure();
                        int options = jmqiPutMessageOptions.getOptions();
                        MQMD jmqiMessage = message.getJMQIStructure(options);
                        ByteBuffer messageData = message.getBuffer();
                        this.internalMQPUT(jmqi, jmqiMessage, jmqiPutMessageOptions, messageData);
                        message.updateFromJMQIStructure(options);
                        jmqiPutMessageOptions.setOptions(options);
                        putMessageOptions.updateFromJMQIStructure();
                        Object var14_18 = null;
                        if (!this.trace.isOn) break block39;
                        this.trace.finallyBlock((Object)this, COMP_JN, 688);
                    }
                    try {
                        message.performProcessingAfterPut();
                    }
                    catch (MQException e2) {
                        if (this.trace.isOn) {
                            this.trace.catchBlock((Object)this, COMP_JN, 688, (Throwable)e2, 3);
                        }
                        if (exception != null) break block40;
                        exception = e2;
                    }
                }
                if (exception != null) {
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 688, (Throwable)exception, 4);
                    }
                    throw exception;
                }
                break block43;
                {
                    catch (MQException e) {
                        block41: {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, COMP_JN, 688, (Throwable)e, 2);
                            }
                            exception = e;
                            Object var14_19 = null;
                            if (this.trace.isOn) {
                                this.trace.finallyBlock((Object)this, COMP_JN, 688);
                            }
                            try {
                                message.performProcessingAfterPut();
                            }
                            catch (MQException e2) {
                                if (this.trace.isOn) {
                                    this.trace.catchBlock((Object)this, COMP_JN, 688, (Throwable)e2, 3);
                                }
                                if (exception != null) break block41;
                                exception = e2;
                            }
                        }
                        if (exception != null) {
                            if (this.trace.isOn) {
                                this.trace.throwing((Object)this, COMP_JN, 688, (Throwable)exception, 4);
                            }
                            throw exception;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block42: {
                        Object var14_20 = null;
                        if (this.trace.isOn) {
                            this.trace.finallyBlock((Object)this, COMP_JN, 688);
                        }
                        try {
                            message.performProcessingAfterPut();
                        }
                        catch (MQException e2) {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, COMP_JN, 688, (Throwable)e2, 3);
                            }
                            if (exception != null) break block42;
                            exception = e2;
                        }
                    }
                    if (exception != null) {
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 688, (Throwable)exception, 4);
                        }
                        throw exception;
                    }
                    throw throwable;
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 688);
        }
    }

    private void validatePutParameters(MQMessage message, MQPutMessageOptions putMessageOptions) throws MQException {
        int traceContext = 0;
        int fid = 689;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 689, new Object[]{message, putMessageOptions});
        }
        if (message == null) {
            MQException exception = new MQException(2, 2026, (Object)this, "MQJI028");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 689, (Throwable)exception, 1);
            }
            throw exception;
        }
        if (putMessageOptions == null) {
            MQException exception = new MQException(2, 2173, (Object)this, "MQJI029");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 689, (Throwable)exception, 2);
            }
            throw exception;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 689);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMQPUT(JmqiMQ jmqi, MQMD message, MQPMO putMessageOptions, ByteBuffer messageData) throws MQException {
        int traceContext = 0;
        int fid = 757;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 757, new Object[]{jmqi, message, putMessageOptions, messageData});
        }
        MQException exception = null;
        MQDestination mQDestination = this;
        synchronized (mQDestination) {
            putMessageOptions.setInvalidDestCount(1);
            putMessageOptions.setKnownDestCount(0);
            putMessageOptions.setUnknownDestCount(0);
            int options = putMessageOptions.getOptions();
            if ((options & 6) == 0) {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 757, "No SyncPoint action specified- implicit MQPMO_NO_SYNCPOINT...", (Object)"");
                }
                putMessageOptions.setOptions(options | 4);
            }
            int bufferLength = messageData.limit();
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 757, "Message length = ", (Object)Integer.toString(messageData.capacity()));
                this.trace.dataFmt(this.env, COMP_JN, 757, "put options = " + putMessageOptions.getOptions() + "\nmessage type = " + message.getMsgType() + "\nencoding = " + message.getEncoding() + "\ncharacter set = " + message.getCodedCharSetId() + "\nformat = " + message.getFormat() + "\nmessage id, correlation id follow:", (Object)"");
                this.trace.dataFmt(this.env, COMP_JN, 757, "messageId = ", (Object)message.getMsgId());
                this.trace.dataFmt(this.env, COMP_JN, 757, "correlId = ", (Object)message.getCorrelId());
            }
            com.ibm.mq.Pint completionCode = new com.ibm.mq.Pint();
            com.ibm.mq.Pint reason = new com.ibm.mq.Pint();
            jmqi.MQPUT(this.Hconn.getHconn(), this.Hobj.getHobj(), message, putMessageOptions, bufferLength, messageData, (Pint)completionCode, (Pint)reason);
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 757, "Returned Id = ", (Object)message.getMsgId());
            }
            if (completionCode.x != 0 || reason.x != 0) {
                exception = new MQException(completionCode.x, reason.x, (Object)this, this.osession.getLastJmqiException());
            }
        }
        if (exception != null) {
            this.parentQmgr.errorOccurred(exception);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 757, (Throwable)exception);
            }
            throw exception;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 757);
        }
    }

    public int getDestinationType() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 909, "returning: ", (Object)new Integer(this.destinationType));
        }
        return this.destinationType;
    }

    public GregorianCalendar getCreationDateTime() throws MQException {
        int traceContext = 0;
        int fid = 691;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 691);
        }
        String date = this.getString(2004, 12);
        String time = this.getString(2005, 8);
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 691, "date = " + date + " time = " + time, (Object)"");
        }
        GregorianCalendar retVal = MQSESSION.getInquireCalendar();
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            int month = Integer.parseInt(date.substring(5, 7));
            int day = Integer.parseInt(date.substring(8, 10));
            int hour = Integer.parseInt(time.substring(0, 2));
            int minute = Integer.parseInt(time.substring(3, 5));
            int second = Integer.parseInt(time.substring(6, 8));
            retVal.set(year, month - 1, day, hour, minute, second);
        }
        catch (StringIndexOutOfBoundsException ex) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 691, (Throwable)ex, 1);
            }
            retVal = new GregorianCalendar();
        }
        catch (NumberFormatException ex) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 691, (Throwable)ex, 2);
            }
            retVal = new GregorianCalendar();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 691, (Object)retVal);
        }
        return retVal;
    }

    public int getQueueManagerCmdLevel() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 910, "returning: ", (Object)new Integer(this.queueManagerCmdLevel));
        }
        return this.queueManagerCmdLevel;
    }

    public void setQueueManagerCmdLevel(int queueManagerCmdLevel) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 911, "setting to: ", (Object)new Integer(queueManagerCmdLevel));
        }
        this.queueManagerCmdLevel = queueManagerCmdLevel;
    }
}

