/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.jmqi.JmqiTraceHandlerAdapter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class MQExitClassLoader
extends ClassLoader {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQExitClassLoader.java, java.classes, k701, k701-112-140304 1.30.1.1 09/08/17 09:10:32";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int COMP_JN = 60;
    private String root;

    public MQExitClassLoader(String rootDir, JmqiTraceHandlerAdapter trace) {
        super(MQExitClassLoader.class.getClassLoader());
        int traceContext = 0;
        int fid = 97;
        if (trace.isOn) {
            traceContext = trace.entry_OO((Object)this, COMP_JN, 97, new Object[]{rootDir, trace});
        }
        this.root = rootDir;
        if (trace.isOn) {
            trace.exit(traceContext, (Object)this, COMP_JN, 97);
        }
    }

    protected Class loadClass(String name, boolean resolve, JmqiTraceHandlerAdapter trace) throws ClassNotFoundException {
        Class<?> c;
        int traceContext;
        block12: {
            traceContext = 0;
            int fid = 98;
            if (trace.isOn) {
                traceContext = trace.entry_OO((Object)this, COMP_JN, 98, new Object[]{name, resolve, trace});
            }
            if ((c = this.findLoadedClass(name)) == null) {
                try {
                    c = this.findSystemClass(name);
                }
                catch (Exception e) {
                    if (!trace.isOn) break block12;
                    trace.catchBlock((Object)this, COMP_JN, 98, (Throwable)e, 1);
                }
            }
        }
        if (c == null) {
            String filename = name.replace('.', File.separatorChar) + ".class";
            try {
                byte[] data = this.loadClassData(filename, trace);
                c = this.defineClass(name, data, 0, data.length);
                if (c == null) {
                    ClassNotFoundException e = new ClassNotFoundException(name);
                    if (trace.isOn) {
                        trace.throwing((Object)this, COMP_JN, 98, (Throwable)e);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                if (trace.isOn) {
                    trace.catchBlock((Object)this, COMP_JN, 98, (Throwable)e, 2);
                }
                c = MQExitClassLoader.class.getClassLoader().loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (trace.isOn) {
            trace.exit(traceContext, (Object)this, COMP_JN, 98, c);
        }
        return c;
    }

    private byte[] loadClassData(String filename, JmqiTraceHandlerAdapter trace) throws IOException {
        int traceContext = 0;
        int fid = 99;
        if (trace.isOn) {
            traceContext = trace.entry_OO((Object)this, COMP_JN, 99, new Object[]{filename, trace});
        }
        byte[] buff = null;
        try {
            File f = new File(this.root, filename);
            int size = (int)f.length();
            buff = new byte[size];
            FileInputStream fis = new FileInputStream(f);
            DataInputStream dis = new DataInputStream(fis);
            dis.readFully(buff);
            dis.close();
        }
        catch (IOException e) {
            if (trace.isOn) {
                trace.catchBlock((Object)this, COMP_JN, 99, (Throwable)e);
            }
            if (trace.isOn) {
                trace.throwing((Object)this, COMP_JN, 99, (Throwable)e);
            }
            throw e;
        }
        if (trace.isOn) {
            trace.exit(traceContext, (Object)this, COMP_JN, 99, (Object)buff);
        }
        return buff;
    }
}

