/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;
import java.util.NoSuchElementException;

public class MQJavaLevel
extends JmqiObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQJavaLevel.java, java.classes, k701, k701-112-140304 1.21.1.1 09/08/17 09:11:52";
    private static final String VERSION_TITLE = "Version:     ";
    private static final String CMVCLEVEL_TITLE = "CMVC Level:  ";
    private static final String BUILDTYPE_TITLE = "Build Type:  ";
    private static final String NAME_TITLE = "Name:        ";
    protected static final String[] TITLES = new String[]{"Name:        ", "Version:     ", "CMVC Level:  ", "Build Type:  "};
    public static final int mqjCMVCLEVEL = 2;
    private static String[] values = new String[TITLES.length];
    private static boolean valuesDefined = false;
    private static final int DEFAULT_FIELDS = 15;
    protected static int fields = 15;
    protected static boolean withTitles = true;

    public MQJavaLevel() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 125;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 125);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 125);
        }
    }

    public static void main(String[] args) {
        MQJavaLevel.parseCommandLine(args);
        MQJavaLevel.printMQVERInfo();
        System.exit(0);
    }

    protected static final void parseCommandLine(String[] args) {
        if (args.length == 0) {
            fields = 15;
        } else {
            boolean fDefined = false;
            for (int i = 0; i < args.length; ++i) {
                String thisArg = args[i];
                if (!thisArg.startsWith("-")) continue;
                if (thisArg.charAt(1) == 'b') {
                    withTitles = false;
                    continue;
                }
                if (thisArg.charAt(1) != 'f') continue;
                fDefined = true;
                String num = null;
                num = thisArg.length() > 2 ? thisArg.substring(2) : args[i + 1];
                try {
                    fields = Integer.parseInt(num);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    fields = 15;
                }
            }
            if (!fDefined) {
                fields = 15;
            }
        }
    }

    protected static void printMQVERInfo() {
        int i = 0;
        int j = 1;
        while (i < 4) {
            if ((fields & j) != 0) {
                if (withTitles) {
                    System.out.print(TITLES[i]);
                }
                System.out.println(MQJavaLevel.queryValue(i));
            }
            ++i;
            j *= 2;
        }
    }

    public static void traceBuildInfo() {
    }

    protected static String queryValue(int id) {
        Package thisPackage = Package.getPackage("com.ibm.mq");
        if (thisPackage != null) {
            return MQJavaLevel.queryValue(id, thisPackage);
        }
        return "package error";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final String queryValue(int id, Package thisPackage) {
        String buffer = null;
        if (thisPackage == null) return "missing package data";
        String versionInfo = thisPackage.getImplementationVersion();
        if (versionInfo == null) {
            return "Unable to retrieve ImplementationVersion data";
        }
        if (valuesDefined) return values[id];
        try {
            int firstDash = versionInfo.indexOf(" - ");
            String fullVersion = versionInfo.substring(0, firstDash);
            String cmvcLevel = versionInfo.substring(firstDash + 3);
            MQJavaLevel.values[0] = thisPackage.getImplementationTitle();
            MQJavaLevel.values[1] = fullVersion;
            MQJavaLevel.values[2] = cmvcLevel;
            MQJavaLevel.values[3] = "Production";
        }
        catch (NoSuchElementException nsee) {
            for (int i = 0; i < TITLES.length; ++i) {
                if (values[i] != null) continue;
                MQJavaLevel.values[i] = "UNKNOWN";
            }
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            MQJavaLevel.values[i] = values[i].trim();
        }
        valuesDefined = true;
        return values[id];
    }
}

