/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQInternalException;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MQMD
extends JmqiObject {
    static final String sccsid = "@(#)  com.ibm.mq/src/com/ibm/mq/MQMD.java, java.classes, k701, k701-112-140304 1.45.1.3 13/01/14 17:25:01";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private com.ibm.mq.jmqi.MQMD jmqiStructure = MQSESSION.getJmqiEnv().newMQMD();
    public int report = 0;
    public int messageType = 8;
    public int expiry = -1;
    public int feedback = 0;
    public int encoding = 273;
    public int characterSet = 0;
    public String format = "        ";
    public int priority = -1;
    public int persistence = 2;
    public byte[] messageId = new byte[24];
    public byte[] correlationId = new byte[24];
    public int backoutCount = 0;
    public String replyToQueueName = "";
    public String replyToQueueManagerName = "";
    public String userId = "";
    public byte[] accountingToken = new byte[32];
    public String applicationIdData = "";
    public int putApplicationType = 0;
    public String putApplicationName = "";
    public GregorianCalendar putDateTime = null;
    public String applicationOriginData = "";
    public byte[] groupId = new byte[24];
    public int messageSequenceNumber = 1;
    public int offset = 0;
    public int messageFlags = 0;
    public int originalLength = -1;
    private int version = 2;
    protected static final int sizeofMQMDv1 = 324;
    protected static final int sizeofMQMDv2 = 364;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final GregorianCalendar gmtConverter = new GregorianCalendar(GMT);

    public int getVersion() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 942, "returning: ", (Object)new Integer(this.version));
        }
        return this.version;
    }

    public void setVersion(int version) throws MQException {
        int traceContext = 0;
        int fid = 175;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 175, new Object[]{new Integer(version)});
        }
        if (version > 2 || version < 1) {
            MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI013", "" + version);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 175, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        this.version = version;
        if (version == 1) {
            boolean invalidGroupId = false;
            if (this.groupId != null) {
                for (int i = 0; i < this.groupId.length; ++i) {
                    if (this.groupId[i] == 0) continue;
                    invalidGroupId = true;
                    break;
                }
            }
            if (invalidGroupId || this.messageSequenceNumber != 1 || this.offset != 0 || this.messageFlags != 0 || this.originalLength != -1) {
                MQException traceRet2 = new MQException(2, 2026, (Object)this, "MQJE055");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 175, (Throwable)traceRet2, 2);
                }
                throw traceRet2;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 175);
        }
    }

    public MQMD() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 176;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 176);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 176, "sccsid = ", (Object)sccsid);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 176);
        }
    }

    protected final int sizeOfMQMD() {
        int traceContext = 0;
        int fid = 177;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 177);
        }
        if (this.version == 1) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 177, (Object)new Integer(324), 1);
            }
            return 324;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 177, (Object)new Integer(364), 2);
        }
        return 364;
    }

    protected final byte[] setArrayToLength(byte[] array, int length) throws MQException {
        byte[] retVal;
        int traceContext = 0;
        int fid = 178;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 178, new Object[]{array, new Integer(length)});
        }
        try {
            retVal = new byte[length];
            if (array == null || array.length == 0) {
                for (int i = 0; i < length; ++i) {
                    retVal[i] = 0;
                }
            } else if (array.length < length) {
                System.arraycopy(array, 0, retVal, 0, array.length);
                for (int i = array.length; i < length; ++i) {
                    retVal[i] = 0;
                }
            } else {
                System.arraycopy(array, 0, retVal, 0, length);
            }
        }
        catch (Exception ex) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 178, (Throwable)ex);
            }
            MQInternalException traceRet1 = new MQInternalException(2, 2195, "MQJE044", null);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 178, (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 178, (Object)retVal);
        }
        return retVal;
    }

    protected final GregorianCalendar getDateAndTime(String date, String time) {
        int traceContext = 0;
        int fid = 179;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 179, new Object[]{date, time});
        }
        GregorianCalendar retVal = null;
        char[] rawPutDate = "00010101".toCharArray();
        char[] rawPutTime = "00000000".toCharArray();
        boolean someDateTimeProvided = false;
        if (date != null && date.trim().length() == 8) {
            rawPutDate = date.toCharArray();
            someDateTimeProvided = true;
        }
        if (time != null && time.trim().length() == 8) {
            rawPutTime = time.toCharArray();
            someDateTimeProvided = true;
        }
        if (someDateTimeProvided) {
            int year = (rawPutDate[0] - 48) * 1000;
            year += (rawPutDate[1] - 48) * 100;
            year += (rawPutDate[2] - 48) * 10;
            year += rawPutDate[3] - 48;
            int month = (rawPutDate[4] - 48) * 10;
            month += rawPutDate[5] - 48;
            --month;
            int day = (rawPutDate[6] - 48) * 10;
            day += rawPutDate[7] - 48;
            int hour = (rawPutTime[0] - 48) * 10;
            int minute = (rawPutTime[2] - 48) * 10;
            int second = (rawPutTime[4] - 48) * 10;
            int millisecond = (rawPutTime[6] - 48) * 10;
            millisecond += rawPutTime[7] - 48;
            retVal = new GregorianCalendar(year, month, day, hour += rawPutTime[1] - 48, minute += rawPutTime[3] - 48, second += rawPutTime[5] - 48);
            retVal.setTimeZone(GMT);
            retVal.set(14, millisecond *= 10);
        } else {
            this.trace.dataFmt(this.env, COMP_JN, 179, "Invalid Date/Time. Date:", (Object)date);
            this.trace.dataFmt(this.env, COMP_JN, 179, "Invalid Date/Time. Time:", (Object)time);
            retVal = null;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 179, retVal);
        }
        return retVal;
    }

    static final String getDate(GregorianCalendar dateTime) {
        String strDate = dateTime != null ? MQMD.setNumberToLength(new Integer(dateTime.get(1)).toString(), 4) + MQMD.setNumberToLength(new Integer(dateTime.get(2) + 1).toString(), 2) + MQMD.setNumberToLength(new Integer(dateTime.get(5)).toString(), 2) : "        ";
        return strDate;
    }

    static final String getTime(GregorianCalendar dateTime) {
        String strTime = dateTime != null ? MQMD.setNumberToLength(new Integer(dateTime.get(11)).toString(), 2) + MQMD.setNumberToLength(new Integer(dateTime.get(12)).toString(), 2) + MQMD.setNumberToLength(new Integer(dateTime.get(13)).toString(), 2) + MQMD.setNumberToLength(new Integer(dateTime.get(14) / 10).toString(), 2) : "        ";
        return strTime;
    }

    private static final String setNumberToLength(String strNumber, int iNewLength) {
        String strPadded;
        int iOldLength = strNumber.length();
        if (iOldLength > iNewLength) {
            strPadded = strNumber.substring(0, iNewLength);
        } else {
            strPadded = new String(strNumber);
            for (int i = iOldLength; i < iNewLength; ++i) {
                strPadded = "0" + strPadded;
            }
        }
        return strPadded;
    }

    protected final void setDateAndTime(int year, int month, int day, int hour, int minute, int second, int millis) {
        int traceContext = 0;
        int fid = 180;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 180, new Object[]{new Integer(year), new Integer(month), new Integer(day), new Integer(hour), new Integer(minute), new Integer(second), new Integer(millis)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 180, "Year = " + year + " Month = " + month + " Day = " + day + " Time " + hour + ":" + minute + ":" + second + " Milliseconds = " + millis, (Object)"");
        }
        if (this.putDateTime == null) {
            this.putDateTime = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        } else {
            this.putDateTime.set(year, month - 1, day, hour, minute, second);
        }
        this.putDateTime.setTimeZone(GMT);
        this.putDateTime.set(14, millis);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 180);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] convertCalendarToStrings(GregorianCalendar calendar) {
        int traceContext = 0;
        int fid = 181;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 181, new Object[]{calendar});
        }
        String[] jmqiPutDateTime = new String[2];
        char[] rawPutDate = new char[8];
        char[] rawPutTime = new char[8];
        if (calendar == null) {
            Arrays.fill(rawPutDate, ' ');
            Arrays.fill(rawPutTime, ' ');
        } else {
            int hundredth;
            int second;
            int minute;
            int hour;
            int day;
            int month;
            int year;
            GregorianCalendar gregorianCalendar = gmtConverter;
            synchronized (gregorianCalendar) {
                gmtConverter.setTime(calendar.getTime());
                year = gmtConverter.get(1);
                month = gmtConverter.get(2) + 1;
                day = gmtConverter.get(5);
                hour = gmtConverter.get(11);
                minute = gmtConverter.get(12);
                second = gmtConverter.get(13);
                hundredth = gmtConverter.get(14) / 10;
            }
            int contrib = year / 1000;
            rawPutDate[0] = (char)(48 + contrib);
            year -= contrib * 1000;
            contrib = year / 100;
            rawPutDate[1] = (char)(48 + contrib);
            year -= contrib * 100;
            contrib = year / 10;
            rawPutDate[2] = (char)(48 + contrib);
            year -= contrib * 10;
            contrib = year;
            rawPutDate[3] = (char)(48 + contrib);
            contrib = month / 10;
            rawPutDate[4] = (char)(48 + contrib);
            month -= contrib * 10;
            contrib = month;
            rawPutDate[5] = (char)(48 + contrib);
            contrib = day / 10;
            rawPutDate[6] = (char)(48 + contrib);
            day -= contrib * 10;
            contrib = day;
            rawPutDate[7] = (char)(48 + contrib);
            contrib = hour / 10;
            rawPutTime[0] = (char)(48 + contrib);
            hour -= contrib * 10;
            contrib = hour;
            rawPutTime[1] = (char)(48 + contrib);
            contrib = minute / 10;
            rawPutTime[2] = (char)(48 + contrib);
            minute -= contrib * 10;
            contrib = minute;
            rawPutTime[3] = (char)(48 + contrib);
            contrib = second / 10;
            rawPutTime[4] = (char)(48 + contrib);
            second -= contrib * 10;
            contrib = second;
            rawPutTime[5] = (char)(48 + contrib);
            contrib = hundredth / 10;
            rawPutTime[6] = (char)(48 + contrib);
            hundredth -= contrib * 10;
            contrib = hundredth;
            rawPutTime[7] = (char)(48 + contrib);
        }
        jmqiPutDateTime[0] = new String(rawPutDate);
        jmqiPutDateTime[1] = new String(rawPutTime);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 181, (Object)jmqiPutDateTime);
        }
        return jmqiPutDateTime;
    }

    protected com.ibm.mq.jmqi.MQMD getJMQIStructure(int pmoFlags) {
        boolean setIdCts;
        this.jmqiStructure.setVersion(this.version);
        this.jmqiStructure.setReport(this.report);
        this.jmqiStructure.setMsgType(this.messageType);
        this.jmqiStructure.setExpiry(this.expiry);
        this.jmqiStructure.setFeedback(this.feedback);
        this.jmqiStructure.setEncoding(this.encoding);
        this.jmqiStructure.setCodedCharSetId(this.characterSet);
        this.jmqiStructure.setFormat(this.format);
        this.jmqiStructure.setPriority(this.priority);
        this.jmqiStructure.setPersistence(this.persistence);
        this.jmqiStructure.setMsgId(this.messageId);
        this.jmqiStructure.setCorrelId(this.correlationId);
        this.jmqiStructure.setBackoutCount(this.backoutCount);
        this.jmqiStructure.setReplyToQ(this.replyToQueueName);
        this.jmqiStructure.setReplyToQMgr(this.replyToQueueManagerName);
        boolean setAllCtx = (pmoFlags & 0x800) != 0;
        boolean bl = setIdCts = setAllCtx || (pmoFlags & 0x400) != 0;
        if (setIdCts) {
            this.jmqiStructure.setUserIdentifier(this.userId);
            this.jmqiStructure.setAccountingToken(this.accountingToken);
            this.jmqiStructure.setApplIdentityData(this.applicationIdData);
        }
        if (setAllCtx) {
            this.jmqiStructure.setPutApplType(this.putApplicationType);
            this.jmqiStructure.setPutApplName(this.putApplicationName);
            this.jmqiStructure.setApplOriginData(this.applicationOriginData);
            String[] jmqiPutDateTime = this.convertCalendarToStrings(this.putDateTime);
            this.jmqiStructure.setPutDate(jmqiPutDateTime[0]);
            this.jmqiStructure.setPutTime(jmqiPutDateTime[1]);
        }
        if (this.version >= 2) {
            this.jmqiStructure.setGroupId(this.groupId);
            this.jmqiStructure.setMsgSeqNumber(this.messageSequenceNumber);
            this.jmqiStructure.setOffset(this.offset);
            this.jmqiStructure.setMsgFlags(this.messageFlags);
            this.jmqiStructure.setOriginalLength(this.originalLength);
        }
        return this.jmqiStructure;
    }

    protected void updateFromJMQIStructure(int pmoFlags) {
        boolean nSetIdCts;
        this.version = this.jmqiStructure.getVersion();
        this.report = this.jmqiStructure.getReport();
        this.messageType = this.jmqiStructure.getMsgType();
        this.expiry = this.jmqiStructure.getExpiry();
        this.feedback = this.jmqiStructure.getFeedback();
        this.encoding = this.jmqiStructure.getEncoding();
        this.characterSet = this.jmqiStructure.getCodedCharSetId();
        this.format = this.jmqiStructure.getFormat();
        this.priority = this.jmqiStructure.getPriority();
        this.persistence = this.jmqiStructure.getPersistence();
        this.messageId = new byte[24];
        System.arraycopy(this.jmqiStructure.getMsgId(), 0, this.messageId, 0, 24);
        this.correlationId = new byte[24];
        System.arraycopy(this.jmqiStructure.getCorrelId(), 0, this.correlationId, 0, 24);
        this.backoutCount = this.jmqiStructure.getBackoutCount();
        this.replyToQueueName = this.jmqiStructure.getReplyToQ();
        this.replyToQueueManagerName = this.jmqiStructure.getReplyToQMgr();
        boolean nSetAllCtx = (pmoFlags & 0x800) == 0;
        boolean bl = nSetIdCts = nSetAllCtx && (pmoFlags & 0x400) == 0;
        if (nSetIdCts) {
            this.userId = this.jmqiStructure.getUserIdentifier();
            this.accountingToken = new byte[32];
            System.arraycopy(this.jmqiStructure.getAccountingToken(), 0, this.accountingToken, 0, 32);
            this.applicationIdData = this.jmqiStructure.getApplIdentityData();
        }
        if (nSetAllCtx) {
            this.putApplicationType = this.jmqiStructure.getPutApplType();
            this.putApplicationName = this.jmqiStructure.getPutApplName();
            this.applicationOriginData = this.jmqiStructure.getApplOriginData();
            this.putDateTime = this.getDateAndTime(this.jmqiStructure.getPutDate(), this.jmqiStructure.getPutTime());
        }
        if (this.version >= 2) {
            this.groupId = new byte[24];
            System.arraycopy(this.jmqiStructure.getGroupId(), 0, this.groupId, 0, 24);
            this.messageSequenceNumber = this.jmqiStructure.getMsgSeqNumber();
            this.offset = this.jmqiStructure.getOffset();
            this.messageFlags = this.jmqiStructure.getMsgFlags();
            this.originalLength = this.jmqiStructure.getOriginalLength();
        }
    }
}

