/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.ClientConnectionRequestInfo;
import com.ibm.mq.MQChannelDefinition;
import com.ibm.mq.MQConnectionEventListener;
import com.ibm.mq.MQConnectionOptions;
import com.ibm.mq.MQConnectionSecurityParameters;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionMetaData;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSSLConfigurationOptions;
import com.ibm.mq.Pint;
import com.ibm.mq.ReasonCodeInfo;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.JmqiUtils;
import com.ibm.mq.jmqi.handles.Phconn;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.system.JmqiConnectOptions;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.transaction.xa.XAResource;

public class MQManagedConnectionJ11
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQManagedConnectionJ11.java, java.classes, k701, k701-112-140304 1.59.1.9 13/01/14 17:25:00";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String qmgrName;
    private MQSESSION session;
    private Phconn Hconn = MQSESSION.getJmqiEnv().newPhconn();
    private boolean connected = false;
    private Hashtable properties = new Hashtable();
    private boolean reusable = true;
    Vector qmgrs = new Vector();
    ConnectionRequestInfo initialCxReqInf;
    MQManagedConnectionFactory initialMCF;
    PrintWriter logWriter;
    ManagedConnectionMetaData metaData = null;
    Vector mqListeners = new Vector();
    boolean allowErrorEvents = false;
    private int cmdLevel = -1;
    private int platform = -1;

    public MQManagedConnectionJ11(String qmgrName, Hashtable properties, ConnectionRequestInfo cxRequestInfo, MQManagedConnectionFactory mcf) throws MQException {
        super(MQSESSION.getJmqiEnv());
        Object ccdtUrlObject;
        int traceContext = 0;
        int fid = 132;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 132, new Object[]{qmgrName, properties, cxRequestInfo, mcf});
        }
        Pint pCompCode = new Pint();
        Pint pReason = new Pint();
        if (qmgrName == null) {
            qmgrName = "";
        }
        this.qmgrName = qmgrName;
        if (properties == null || cxRequestInfo == null || mcf == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 132, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 132, (Object)traceRet1, 1);
            }
            throw traceRet1;
        }
        this.initialCxReqInf = cxRequestInfo;
        this.initialMCF = (MQManagedConnectionFactory)mcf.clone();
        this.properties = properties;
        this.connected = false;
        this.session = MQSESSION.getSession(this);
        String transport = this.getStringProperty("transport");
        URL ccdtUrl = null;
        if (transport.equals("MQSeries Client") && (ccdtUrlObject = this.getProperty("CCDT URL")) != null && ccdtUrlObject instanceof URL) {
            ccdtUrl = (URL)ccdtUrlObject;
        }
        MQConnectionOptions cno = this.constructCNO(transport, ccdtUrl);
        JmqiConnectOptions jmqiCno = this.constructJmqiCNO(transport, ccdtUrl);
        this.session.MQCONNX_j(qmgrName, jmqiCno, cno, this.Hconn, pCompCode, pReason);
        if (pCompCode.x == 1 && pReason.x == 2267) {
            pCompCode.x = 0;
            pReason.x = 0;
        }
        if (pCompCode.x != 0 || pReason.x != 0) {
            MQException me = new MQException(pCompCode.x, pReason.x, (Object)this, this.session.getLastJmqiException());
            this.session = null;
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 132, (Throwable)me, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 132, (Object)me, 2);
            }
            throw me;
        }
        this.platform = jmqiCno.getPlatform();
        this.cmdLevel = jmqiCno.getCmdLevel();
        if (this.platform < 0 || this.cmdLevel < 0) {
            Phobj pQmgrHobj = MQSESSION.getJmqiEnv().newPhobj();
            MQOD qmgrOD = new MQOD();
            qmgrOD.ObjectType = 5;
            int[] selectors = new int[]{32, 31};
            int[] intAttrs = new int[2];
            this.session.MQOPEN(this.Hconn.getHconn(), qmgrOD, 32, pQmgrHobj, pCompCode, pReason);
            if (pCompCode.x != 2) {
                this.session.MQINQ(this.Hconn.getHconn(), pQmgrHobj.getHobj(), 2, selectors, 2, intAttrs, 0, null, pCompCode, pReason);
                if (pCompCode.x == 0) {
                    this.platform = intAttrs[0];
                    this.cmdLevel = intAttrs[1];
                }
                this.session.MQCLOSE(this.Hconn.getHconn(), pQmgrHobj, 0, pCompCode, pReason);
            }
        }
        this.connected = true;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 132, 3);
        }
    }

    public void addMQConnectionEventListener(MQConnectionEventListener listener) {
        int traceContext = 0;
        int fid = 133;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 133, new Object[]{listener});
        }
        if (listener == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 133, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 133, (Object)traceRet1, 1);
            }
            throw traceRet1;
        }
        this.mqListeners.addElement(listener);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 133, 2);
        }
    }

    public void removeMQConnectionEventListener(MQConnectionEventListener listener) {
        int traceContext = 0;
        int fid = 134;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 134, new Object[]{listener});
        }
        if (listener == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 134, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 134, (Object)traceRet1, 1);
            }
            throw traceRet1;
        }
        this.mqListeners.removeElement(listener);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 134, 2);
        }
    }

    public synchronized Object getConnection(ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        MQQueueManager qm;
        int traceContext = 0;
        int fid = 135;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 135, new Object[]{cxRequestInfo});
        }
        if (!this.connected) {
            String msg = MQException.getNLSMsg((String)"MQJI040");
            IllegalStateException re = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 135, (Throwable)re, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 135, (Object)re, 1);
            }
            throw re;
        }
        if (!this.reusable) {
            String msg = MQException.getNLSMsg((String)"MQJI042");
            IllegalStateException re = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 135, (Throwable)re, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 135, (Object)re, 2);
            }
            throw re;
        }
        if (!this.isSuitable(cxRequestInfo, this.initialMCF)) {
            String msg = MQException.getNLSMsg((String)"MQJI039");
            IllegalStateException re = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 135, (Throwable)re, 3);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 135, (Object)re, 3);
            }
            throw re;
        }
        try {
            qm = new MQQueueManager(this);
        }
        catch (MQException mqe) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 135, (Throwable)mqe);
            }
            ResourceException re = ReasonCodeInfo.getResourceException(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 135, (Throwable)re, 4);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 135, (Object)re, 4);
            }
            throw re;
        }
        this.qmgrs.addElement(qm);
        this.allowErrorEvents = true;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 135, (Object)qm, 5);
        }
        return qm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() throws ResourceException {
        int traceContext = 0;
        int fid = 136;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 136);
        }
        Pint pCompCode = new Pint();
        Pint pReason = new Pint();
        this.allowErrorEvents = false;
        Enumeration e = this.qmgrs.elements();
        while (e.hasMoreElements()) {
            MQQueueManager qm;
            MQQueueManager mQQueueManager = qm = (MQQueueManager)((Object)e.nextElement());
            synchronized (mQQueueManager) {
                if (qm.isConnected()) {
                    qm.cleanup();
                }
            }
        }
        this.qmgrs.removeAllElements();
        if (!this.connected) {
            String msg = MQException.getNLSMsg((String)"MQJI040");
            IllegalStateException traceRet1 = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 136, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 136, (Object)traceRet1, 1);
            }
            throw traceRet1;
        }
        this.session.MQDISC(this.Hconn, pCompCode, pReason);
        JmqiException jmqiE = null;
        if (this.session != null) {
            jmqiE = this.session.getLastJmqiException();
        }
        this.connected = false;
        this.session = null;
        if (pCompCode.x != 0 || pReason.x != 0) {
            MQException mqe = new MQException(pCompCode.x, pReason.x, (Object)this, jmqiE);
            ResourceException re = ReasonCodeInfo.getResourceException(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 136, (Throwable)re, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 136, (Object)re, 2);
            }
            throw re;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 136, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanup() throws ResourceException {
        String msg;
        int traceContext = 0;
        int fid = 137;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 137);
        }
        Pint pCompCode = new Pint();
        Pint pReason = new Pint();
        this.allowErrorEvents = false;
        Enumeration e = this.qmgrs.elements();
        while (e.hasMoreElements()) {
            MQQueueManager qm;
            MQQueueManager mQQueueManager = qm = (MQQueueManager)((Object)e.nextElement());
            synchronized (mQQueueManager) {
                if (qm.isConnected()) {
                    qm.cleanup();
                }
            }
        }
        this.qmgrs.removeAllElements();
        String mtsupp = this.getStringProperty("Thread access");
        if (mtsupp != null && mtsupp.equals("SINGLE_THREAD")) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 137, "cleanup attempted on SINGLE_THREAD MQManagedConnection", (Object)"");
            }
            msg = MQException.getNLSMsg((String)"MQJI042");
            IllegalStateException traceRet1 = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 137, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 137, (Object)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (!this.connected) {
            msg = MQException.getNLSMsg((String)"MQJI040");
            IllegalStateException traceRet2 = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 137, (Throwable)traceRet2, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 137, (Object)traceRet2, 2);
            }
            throw traceRet2;
        }
        this.session.MQBACK(this.Hconn.getHconn(), pCompCode, pReason);
        if (!this.reusable) {
            msg = MQException.getNLSMsg((String)"MQJI042");
            IllegalStateException traceRet3 = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 137, (Throwable)traceRet3, 3);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 137, (Object)traceRet3, 3);
            }
            throw traceRet3;
        }
        if ((pCompCode.x != 0 || pReason.x != 0) && pReason.x != 2012) {
            MQException mqe = new MQException(pCompCode.x, pReason.x, (Object)this, this.session.getLastJmqiException());
            ResourceException re = ReasonCodeInfo.getResourceException(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 137, (Throwable)re, 4);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 137, (Object)re, 4);
            }
            throw re;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 137, 5);
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        int traceContext = 0;
        int fid = 138;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 138, new Object[]{connection});
        }
        String msg = MQException.getNLSMsg((String)"MQJI041", (String)"associateConnection");
        NotSupportedException traceRet1 = new NotSupportedException(msg);
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 138, (Throwable)traceRet1);
            this.trace.exit(traceContext, (Object)this, COMP_JN, 138, (Object)traceRet1);
        }
        throw traceRet1;
    }

    public XAResource getXAResource() throws ResourceException {
        int traceContext = 0;
        int fid = 501;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 501);
        }
        String msg = MQException.getNLSMsg((String)"MQJI041", (String)"getXAResource");
        NotSupportedException traceRet1 = new NotSupportedException(msg);
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 501, (Throwable)traceRet1);
            this.trace.exit(traceContext, (Object)this, COMP_JN, 501, (Object)traceRet1);
        }
        throw traceRet1;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        int traceContext = 0;
        int fid = 502;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 502);
        }
        String msg = MQException.getNLSMsg((String)"MQJI041", (String)"getLocalTransaction");
        NotSupportedException traceRet1 = new NotSupportedException(msg);
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 502, (Throwable)traceRet1);
            this.trace.exit(traceContext, (Object)this, COMP_JN, 502, (Object)traceRet1);
        }
        throw traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.metaData == null) {
            MQManagedConnectionJ11 mQManagedConnectionJ11 = this;
            synchronized (mQManagedConnectionJ11) {
                if (this.metaData == null) {
                    this.metaData = new MQManagedConnectionMetaData(this);
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 935, "returning: ", (Object)this.metaData);
        }
        return this.metaData;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 936, "setting to: ", (Object)out);
        }
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 937, "returning: ", (Object)this.logWriter);
        }
        return this.logWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireConnectionClosedEvent(MQQueueManager qmgr) {
        Vector ls;
        int traceContext = 0;
        int fid = 139;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 139, new Object[]{qmgr});
        }
        this.qmgrs.removeElement((Object)qmgr);
        MQManagedConnectionJ11 mQManagedConnectionJ11 = this;
        synchronized (mQManagedConnectionJ11) {
            ls = (Vector)this.mqListeners.clone();
        }
        Enumeration e = ls.elements();
        while (e.hasMoreElements()) {
            MQConnectionEventListener l = (MQConnectionEventListener)e.nextElement();
            l.connectionClosed(this, qmgr);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 139);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireConnectionErrorEvent(MQQueueManager qmgr, Exception exception) {
        int traceContext = 0;
        int fid = 140;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 140, new Object[]{qmgr, exception});
        }
        if (this.allowErrorEvents) {
            Vector ls;
            MQManagedConnectionJ11 mQManagedConnectionJ11 = this;
            synchronized (mQManagedConnectionJ11) {
                ls = (Vector)this.mqListeners.clone();
            }
            Enumeration e = ls.elements();
            while (e.hasMoreElements()) {
                MQConnectionEventListener l = (MQConnectionEventListener)e.nextElement();
                l.connectionErrorOccurred(this, qmgr, exception);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 140);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        int traceContext;
        block19: {
            traceContext = 0;
            int fid = 141;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 141);
            }
            Pint pCompCode = new Pint();
            Pint pReason = new Pint();
            Enumeration e = this.qmgrs.elements();
            while (e.hasMoreElements()) {
                MQQueueManager qm;
                MQQueueManager mQQueueManager = qm = (MQQueueManager)((Object)e.nextElement());
                synchronized (mQQueueManager) {
                    if (qm.isConnected()) {
                        qm.cleanup();
                    }
                }
            }
            this.qmgrs.removeAllElements();
            if (this.connected) {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 141, "implicit disconnect", (Object)"");
                }
                try {
                    if (MQSESSION.backoutOnImplicitDisc()) {
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 141, "Backout on implicit disconnect", (Object)"");
                        }
                        this.session.MQBACK(this.Hconn.getHconn(), pCompCode, pReason);
                        if (pCompCode.x != 0) {
                            if (pReason.x == 2012) {
                                if (this.trace.isOn) {
                                    this.trace.dataFmt(this.env, COMP_JN, 141, "Backout on implicit disconnect not performed due to environment", (Object)"");
                                }
                            } else {
                                if (this.trace.isOn) {
                                    this.trace.dataFmt(this.env, COMP_JN, 141, "Backout on implicit disconnect failed", (Object)"");
                                }
                                MQException traceRet1 = new MQException(pCompCode.x, pReason.x, (Object)this, this.session.getLastJmqiException());
                                if (this.trace.isOn) {
                                    this.trace.throwing((Object)this, COMP_JN, 141, (Throwable)traceRet1);
                                }
                                throw traceRet1;
                            }
                        }
                    }
                    this.destroy();
                }
                catch (Exception ex) {
                    if (!this.trace.isOn) break block19;
                    this.trace.catchBlock((Object)this, COMP_JN, 141, (Throwable)ex);
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 141);
        }
    }

    public boolean isConnected() {
        int fid = 142;
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 142, "isConnected()", (Object)this.connected);
        }
        return this.connected;
    }

    public MQSESSION getMQSESSION() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 938, "returning: ", (Object)this.session);
        }
        return this.session;
    }

    public Phconn getHConn() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 939, "returning: ", (Object)this.Hconn);
        }
        return this.Hconn;
    }

    public String getQmgrName() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 940, "returning: ", (Object)this.qmgrName);
        }
        return this.qmgrName;
    }

    public Object getProperty(Object key) {
        int traceContext = 0;
        int fid = 143;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 143, new Object[]{key});
        }
        Object traceRet1 = this.properties.get(key);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 143, (Object)(key == "password" ? "********" : traceRet1));
        }
        return traceRet1;
    }

    int getIntegerProperty(Object key) {
        int traceContext = 0;
        int fid = 144;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 144, new Object[]{key});
        }
        int traceRet1 = this.getIntegerProperty(key, 0);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 144, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getIntegerProperty(Object key, int defaultValue) {
        Object object;
        int traceContext = 0;
        int fid = 145;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 145, new Object[]{key, new Integer(defaultValue)});
        }
        int value = (object = this.getProperty(key)) != null && object instanceof Integer ? (Integer)object : defaultValue;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 145, (Object)new Integer(value));
        }
        return value;
    }

    public String getStringProperty(Object key) {
        int traceContext = 0;
        int fid = 146;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 146, new Object[]{key});
        }
        String traceRet1 = this.getStringProperty(key, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 146, (Object)(key == "password" ? "********" : traceRet1));
        }
        return traceRet1;
    }

    public String getStringProperty(Object key, String defaultValue) {
        Object object;
        int traceContext = 0;
        int fid = 147;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 147, new Object[]{key, defaultValue});
        }
        String value = (object = this.getProperty(key)) != null && object instanceof String ? (String)object : defaultValue;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 147, (Object)(key == "password" ? "********" : value));
        }
        return value;
    }

    String getStringProperty(Object key, String defaultValue, int length) {
        int traceContext = 0;
        int fid = 148;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 148, new Object[]{key, defaultValue, new Integer(length)});
        }
        String traceRet1 = MQSESSION.setStringToLength(this.getStringProperty(key, defaultValue), length);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 148, (Object)(key == "password" ? "********" : traceRet1));
        }
        return traceRet1;
    }

    public void setNotReusable() {
        int traceContext = 0;
        int fid = 149;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 149);
        }
        this.reusable = false;
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 149, "MQManagedConnection set to be non-reusable", (Object)"");
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 149);
        }
    }

    boolean isReusable() {
        int fid = 150;
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 150, "isReusable()", (Object)this.reusable);
        }
        return this.reusable;
    }

    boolean isSuitable(ConnectionRequestInfo cxRequestInfo, MQManagedConnectionFactory mcf) {
        int traceContext = 0;
        int fid = 151;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 151, new Object[]{cxRequestInfo, mcf});
        }
        if (this.connected && this.reusable && ((Object)this.initialMCF).equals(mcf)) {
            if (cxRequestInfo instanceof ClientConnectionRequestInfo) {
                boolean traceRet1 = ((ClientConnectionRequestInfo)cxRequestInfo).isSuitable(this);
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 151, (Object)traceRet1, 1);
                }
                return traceRet1;
            }
            boolean traceRet2 = this.initialCxReqInf.equals(cxRequestInfo);
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 151, (Object)traceRet2, 2);
            }
            return traceRet2;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 151, (Object)false, 3);
        }
        return false;
    }

    protected boolean authenticate(Pint pCompCode, Pint pReason) throws MQException {
        boolean bl;
        block20: {
            int traceContext = 0;
            int fid = 152;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 152, new Object[]{pCompCode, pReason});
            }
            try {
                int level;
                MQSESSION session = MQSESSION.getSession(this);
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 152, "Session associated with this managed connection is ", (Object)session);
                }
                MQManagedConnectionMetaData metaData = (MQManagedConnectionMetaData)this.getMetaData();
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 152, "MetaData associated with this managed connection is ", (Object)metaData.toString());
                }
                if ((level = metaData.getCommandLevel()) >= 531) {
                    session.setAuthenticateBindings(true);
                } else {
                    session.setAuthenticateBindings(false);
                }
                String userId = this.getStringProperty("userID", "");
                String password = this.getStringProperty("password", "");
                pCompCode.x = 0;
                if (null != userId && !userId.trim().equals("")) {
                    session.authenticate(this.Hconn.getHconn(), userId, password, pCompCode, pReason);
                }
                if (pCompCode.x == 2) {
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, COMP_JN, 152, "Failed to authenticate userId and Password: rc=", (Object)Integer.toString(pReason.x));
                    }
                    MQException me = new MQException(pCompCode.x, pReason.x, (Object)this, session.getLastJmqiException());
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 152, (Throwable)me, 1);
                    }
                    throw me;
                }
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 152, (Object)true, 1);
                }
                bl = true;
                Object var12_16 = null;
                if (!this.trace.isOn) break block20;
            }
            catch (Exception e) {
                try {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 152, (Throwable)e);
                    }
                    if (e instanceof MQException) {
                        MQException traceRet1 = (MQException)((Object)e);
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 152, (Throwable)traceRet1, 2);
                            this.trace.exit(traceContext, (Object)this, COMP_JN, 152, (Object)traceRet1, 2);
                        }
                        throw traceRet1;
                    }
                    if (e instanceof ResourceException && ((ResourceException)e).getLinkedException() != null && ((ResourceException)e).getLinkedException() instanceof MQException) {
                        MQException traceRet2 = (MQException)((Object)((ResourceException)e).getLinkedException());
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 152, (Throwable)traceRet2, 3);
                            this.trace.exit(traceContext, (Object)this, COMP_JN, 152, (Object)traceRet2, 3);
                        }
                        throw traceRet2;
                    }
                    MQException mqe = new MQException(2, 2102, (Object)this);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 152, (Throwable)mqe, 4);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 152, (Object)mqe, 4);
                    }
                    throw mqe;
                }
                catch (Throwable throwable) {
                    block21: {
                        Object var12_17 = null;
                        if (!this.trace.isOn) break block21;
                        this.trace.finallyBlock((Object)this, COMP_JN, 152);
                    }
                    throw throwable;
                }
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 152);
        }
        return bl;
    }

    private MQChannelDefinition constructMQCD() throws MQException {
        String sslCiphersSuite;
        int port;
        int traceContext = 0;
        int fid = 153;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 153);
        }
        MQChannelDefinition cd = new MQChannelDefinition();
        cd.maxMessageLength = 0x6400000;
        cd.channelName = this.getStringProperty("channel", "", 20);
        cd.queueManagerName = this.qmgrName;
        cd.connectionName = this.getStringProperty("hostname", "");
        if (cd.connectionName == null || cd.connectionName.equals("")) {
            cd.connectionName = "localhost";
        }
        if ((port = this.getIntegerProperty("port", -1)) == -1) {
            port = 1414;
        }
        cd.connectionName = cd.connectionName + "(" + Integer.toString(port) + ")";
        String userID = this.getStringProperty("userID", "");
        String password = this.getStringProperty("password", "");
        cd.remoteUserId = userID;
        cd.remotePassword = password;
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 153, "Setting CD.userID = ", (Object)userID);
        }
        if ((sslCiphersSuite = this.getStringProperty("SSL Cipher Suite")) != null) {
            boolean sslFipsboolean;
            Boolean sslFips = (Boolean)this.getProperty("SSL Fips Required");
            boolean bl = sslFipsboolean = sslFips != null ? sslFips : false;
            if (JmqiUtils.toCipherSpec((String)sslCiphersSuite, (boolean)sslFipsboolean) == null) {
                MQException traceRet1 = new MQException(2, 2400, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 153, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 153, (Object)traceRet1, 1);
                }
                throw traceRet1;
            }
        }
        cd.sslCipherSuite = sslCiphersSuite;
        cd.sslPeerName = this.getStringProperty("SSL Peer Name");
        Vector hdrCompList = (Vector)this.getProperty("Header Compression Property");
        cd.hdrCompList = hdrCompList;
        Vector msgCompList = (Vector)this.getProperty("Message Compression Property");
        cd.msgCompList = msgCompList;
        cd.localAddress = this.getStringProperty("Local Address Property");
        cd.sharingConversations = this.getIntegerProperty("sharingConversations", 10);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 153, (Object)cd, 2);
        }
        return cd;
    }

    private MQConnectionOptions constructCNO(String transport, URL ccdtUrl) throws MQException {
        int traceContext = 0;
        int fid = 154;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 154, new Object[]{transport, ccdtUrl});
        }
        MQConnectionOptions mqcno = new MQConnectionOptions();
        int options = this.getIntegerProperty("connectOptions");
        int shareOpts = options & 0xE0;
        if (shareOpts == 0) {
            options |= 0x40;
        }
        mqcno.setOptions(options);
        mqcno.setVersion(1);
        if (transport.equals("MQSeries Client") && ccdtUrl == null) {
            mqcno.setMQCD(this.constructMQCD());
        }
        Object obj = this.getProperty("ConnTag Property");
        boolean set = false;
        if (obj != null && obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == 0) continue;
                set = true;
            }
            if (set) {
                mqcno.setVersion(3);
                mqcno.setConnTag(b);
            }
        }
        if (transport.equals("MQSeries Client")) {
            int i = this.getIntegerProperty("KeyResetCount", 0);
            boolean sslFipsRequired = false;
            Boolean sslFips = (Boolean)this.getProperty("SSL Fips Required");
            if (sslFips != null) {
                sslFipsRequired = sslFips;
            }
            if (i < 0 || i > 999999999) {
                MQException traceRet2 = new MQException(2, 2409, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 154, (Throwable)traceRet2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 154, (Object)traceRet2, 1);
                }
                throw traceRet2;
            }
            if (i > 0 || sslFipsRequired) {
                mqcno.setVersion(4);
                MQSSLConfigurationOptions sco = new MQSSLConfigurationOptions();
                sco.setKeyResetCount(i);
                if (sslFipsRequired) {
                    sco.setFipsRequired(sslFipsRequired);
                }
                sco.setVersion(2);
                mqcno.setMQSCO(sco);
            }
        }
        if (transport.equals("MQSeries Bindings")) {
            String username = this.getStringProperty("userID", null);
            String password = this.getStringProperty("password", null);
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 154, "MQCSP UserName = ", (Object)username);
            }
            if (username != null && this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 154, "MQCSP UserName length = ", (Object)Integer.toString(username.length()));
            }
            if (username != null && password != null && username.trim().length() > 0) {
                mqcno.setVersion(5);
                MQConnectionSecurityParameters csp = new MQConnectionSecurityParameters();
                csp.setCSPUserId(username);
                csp.setCSPPassword(password);
                csp.setAuthenticationType(1);
                mqcno.setMQCSP(csp);
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 154, " Constructed CSP AuthType ", (Object)Integer.toString(csp.getAuthenticationType()));
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 154, (Object)mqcno, 2);
        }
        return mqcno;
    }

    private JmqiConnectOptions constructJmqiCNO(String transport, URL ccdtUrl) throws MQException {
        int jmqiFlags;
        Object sslSocketFactory;
        Object crlCertStores;
        int ccsid;
        String userId;
        int traceContext = 0;
        int fid = 155;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 155, new Object[]{transport, ccdtUrl});
        }
        JmqiSystemEnvironment jmqiSystemEnv = (JmqiSystemEnvironment)MQSESSION.getJmqiEnv();
        JmqiConnectOptions jmqiCNO = jmqiSystemEnv.newJmqiConnectOptions();
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.forceUserID");
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        boolean bForceUserID = false;
        if (o != null) {
            bForceUserID = (Boolean)o;
            if (this.trace.isOn) {
                this.trace.data((Object)this, COMP_JN, 155, "forceUserID: ", (Object)bForceUserID);
            }
        }
        if ((userId = this.getStringProperty("userID")) != null && userId.length() > 0) {
            jmqiCNO.setUserIdentifier(userId);
        } else if (!bForceUserID) {
            jmqiCNO.setUserIdentifier("");
        }
        String password = this.getStringProperty("password");
        if (password != null && password.length() > 0) {
            jmqiCNO.setPassword(password);
        }
        jmqiCNO.setCcdtUrl(ccdtUrl);
        if (this.getProperty("channelSecurityExit") != null) {
            jmqiCNO.setSecurityExit(this.getProperty("channelSecurityExit"));
            jmqiCNO.setSecurityExitUserData((String)this.getProperty("channelSecurityExitUserData"));
        } else {
            jmqiCNO.setSecurityExit(this.getProperty("securityExit"));
            jmqiCNO.setSecurityExitUserData((String)this.getProperty("securityExitUserData"));
        }
        if (this.getProperty("channelReceiveExit") != null) {
            jmqiCNO.setReceiveExits(this.getProperty("channelReceiveExit"));
            jmqiCNO.setReceiveExitsUserData((String)this.getProperty("channelReceiveExitUserData"));
        } else {
            jmqiCNO.setReceiveExits(this.getProperty("receiveExit"));
            jmqiCNO.setReceiveExitsUserData((String)this.getProperty("receiveExitUserData"));
        }
        if (this.getProperty("channelSendExit") != null) {
            jmqiCNO.setSendExits(this.getProperty("channelSendExit"));
            jmqiCNO.setSendExitsUserData((String)this.getProperty("channelSendExitUserData"));
        } else {
            jmqiCNO.setSendExits(this.getProperty("sendExit"));
            jmqiCNO.setSendExitsUserData((String)this.getProperty("sendExitUserData"));
        }
        if (this.getProperty("exitClasspath") != null) {
            jmqiCNO.setExitClassPath((String)this.getProperty("exitClasspath"));
        }
        if ((ccsid = this.getIntegerProperty("CCSID")) > 0) {
            jmqiCNO.setQueueManagerCCSID(ccsid);
        }
        if ((crlCertStores = this.getProperty("SSL CertStores")) != null && crlCertStores instanceof Collection) {
            jmqiCNO.setCrlCertStores((Collection)crlCertStores);
        }
        if ((sslSocketFactory = this.getProperty("SSL Socket Factory")) != null && sslSocketFactory instanceof SSLSocketFactory) {
            jmqiCNO.setSslSocketFactory((SSLSocketFactory)sslSocketFactory);
        }
        if ((jmqiFlags = this.getIntegerProperty("JMQI FLAGS")) != 0) {
            jmqiCNO.setFlags(jmqiFlags);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 155, (Object)jmqiCNO);
        }
        return jmqiCNO;
    }

    public int getCmdLevel() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 941, "returning: ", (Object)new Integer(this.cmdLevel));
        }
        return this.cmdLevel;
    }

    public int getPlatform() {
        int traceContext = 0;
        int fid = 503;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 503);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 503, (Object)new Integer(this.platform));
        }
        return this.platform;
    }
}

