/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mq.ReasonCodeInfo;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.handles.Phconn;
import com.ibm.mq.jmqi.handles.Phobj;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionMetaData;

class MQManagedConnectionMetaData
extends JmqiObject
implements ManagedConnectionMetaData {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQManagedConnectionMetaData.java, java.classes, k701, k701-112-140304 1.38.1.1 09/08/17 09:12:39";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MQManagedConnectionJ11 mancon;
    private static final String NLS_PRODUCT_NAME = "MID_ProductName";
    private static final String NLS_COMMAND_LEVEL = "MID_MngCon_CmdLvl";
    private final String productName = MQException.getNLSMsg((String)"MID_ProductName");
    private int commandLevel = 0;
    private String productVersion = null;
    private Object productVersionLock = new Object();
    private final int maxConnections = 0;
    private String userName = null;

    MQManagedConnectionMetaData(MQManagedConnectionJ11 mancon) {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 156;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 156, new Object[]{mancon});
        }
        this.mancon = mancon;
        this.userName = mancon.getStringProperty("userID");
        if (this.userName == null) {
            this.userName = "";
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 156, "userName = ", (Object)this.userName);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 156);
        }
    }

    public String getEISProductName() throws ResourceException {
        int traceContext = 0;
        int fid = 157;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 157);
        }
        if (this.mancon.isConnected()) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 157, (Object)this.productName);
            }
            return this.productName;
        }
        String msg = MQException.getNLSMsg((String)"MQJI040");
        IllegalStateException traceRet1 = new IllegalStateException(msg);
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 157, (Throwable)traceRet1);
        }
        throw traceRet1;
    }

    public String getEISProductVersion() throws ResourceException {
        int traceContext = 0;
        int fid = 158;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 158);
        }
        if (!this.mancon.isConnected()) {
            String msg = MQException.getNLSMsg((String)"MQJI040");
            IllegalStateException traceRet1 = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 158, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (this.productVersion == null) {
            int level = this.getCommandLevel();
            this.productVersion = MQException.getNLSMsg((String)NLS_COMMAND_LEVEL, (String)("" + level));
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 158, (Object)this.productVersion);
        }
        return this.productVersion;
    }

    public int getMaxConnections() throws ResourceException {
        int traceContext = 0;
        int fid = 159;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 159);
        }
        if (this.mancon.isConnected()) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 159, (Object)new Integer(0));
            }
            return 0;
        }
        String msg = MQException.getNLSMsg((String)"MQJI040");
        IllegalStateException traceRet1 = new IllegalStateException(msg);
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 159, (Throwable)traceRet1);
        }
        throw traceRet1;
    }

    public String getUserName() throws ResourceException {
        int traceContext = 0;
        int fid = 160;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 160);
        }
        if (this.mancon.isConnected()) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 160, (Object)this.userName);
            }
            return this.userName;
        }
        String msg = MQException.getNLSMsg((String)"MQJI040");
        IllegalStateException traceRet1 = new IllegalStateException(msg);
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 160, (Throwable)traceRet1);
        }
        throw traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCommandLevel() throws ResourceException {
        int traceContext = 0;
        int fid = 161;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 161);
        }
        if (!this.mancon.isConnected()) {
            String msg = MQException.getNLSMsg((String)"MQJI040");
            IllegalStateException traceRet1 = new IllegalStateException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 161, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        int level = 0;
        Object object = this.productVersionLock;
        synchronized (object) {
            if (this.commandLevel == 0) {
                MQSESSION session = this.mancon.getMQSESSION();
                Phconn hConn = this.mancon.getHConn();
                Phobj hObj = MQSESSION.getJmqiEnv().newPhobj();
                Pint compcode = new Pint();
                Pint reason = new Pint();
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 161, "Determining Queue Manager command level", (Object)"");
                }
                MQOD objDesc = new MQOD();
                objDesc.ObjectType = 5;
                session.MQOPEN(hConn.getHconn(), objDesc, 32, hObj, compcode, reason);
                if (compcode.x != 0) {
                    MQException mqe = new MQException(compcode.x, reason.x, (Object)this, session.getLastJmqiException());
                    ResourceException re = ReasonCodeInfo.getResourceException(mqe);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 161, (Throwable)re, 2);
                    }
                    throw re;
                }
                int[] selectors = new int[]{31};
                int[] intattr = new int[1];
                session.MQINQ(hConn.getHconn(), hObj.getHobj(), 1, selectors, 1, intattr, 0, null, compcode, reason);
                if (compcode.x != 0) {
                    MQException mqe = new MQException(compcode.x, reason.x, (Object)this, session.getLastJmqiException());
                    ResourceException re = ReasonCodeInfo.getResourceException(mqe);
                    session.MQCLOSE(hConn.getHconn(), hObj, 0, compcode, reason);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 161, (Throwable)re, 3);
                    }
                    throw re;
                }
                level = intattr[0];
                session.MQCLOSE(hConn.getHconn(), hObj, 0, compcode, reason);
                if (compcode.x != 0) {
                    MQException mqe = new MQException(compcode.x, reason.x, (Object)this, session.getLastJmqiException());
                    ResourceException re = ReasonCodeInfo.getResourceException(mqe);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 161, (Throwable)re, 4);
                    }
                    throw re;
                }
            }
        }
        this.commandLevel = level;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 161, (Object)new Integer(level));
        }
        return level;
    }

    public String toString() {
        int fid = 162;
        String buffer = "[commandLevel = " + this.commandLevel + ", ";
        buffer = buffer + "manCon = " + (Object)((Object)this.mancon) + ", ";
        buffer = buffer + "maxConnections = " + 0 + ", ";
        buffer = buffer + "productName = " + this.productName + ", ";
        buffer = buffer + "productVersion = " + this.productVersion + ", ";
        buffer = buffer + "productVersionLock = " + this.productVersionLock + ", ";
        buffer = buffer + "userName = " + this.userName + "]";
        return buffer;
    }
}

