/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQObjectInputStream;
import com.ibm.mq.MQPropertyDescriptor;
import com.ibm.mq.MQS390FloatSupport;
import com.ibm.mq.MQS390PackedDecimalSupport;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.headers.MQChainable;
import com.ibm.mq.headers.MQHeaderList;
import com.ibm.mq.headers.MQMD1;
import com.ibm.mq.headers.MQRFH2;
import com.ibm.mq.headers.MQXQH;
import com.ibm.mq.headers.internal.Header;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class MQMessage
extends MQMD
implements DataInput,
DataOutput {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQMessage.java, java.classes, k701, k701-112-140304 1.99.1.16 13/01/14 17:25:02";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int READ_MODE = 1;
    protected static final int WRITE_MODE = 2;
    private boolean multiStreamStyleObjectStream = false;
    private boolean oneStreamStyleObjectStream = false;
    private static final int CODESET_UCS = 1200;
    private MQMessageOutputStream proxyOutputStream = null;
    private MQMessageInputStream proxyInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private ByteBuffer dataBuffer;
    private static final int ALLOCATION_STEP = 128;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private int _totalMessageLength = 0;
    private int _bufferSizeHint = -1;
    private static char[] codepage1051 = null;
    private String formatBeforePut;
    private ByteBuffer dataBufferBeforePut;
    private Map properties = new HashMap();
    private boolean removeRfh2PropertyHeaders;
    private Map propertyDescTable = new HashMap();
    private static Map JMSPropertySynonyms = null;
    private int propertyValidation;
    private static final Set PROPERTIES_FOLDER_NAMES;
    private static final Set SETTABLE_JMS_PROPERTY_NAMES;
    private static final Set QUERY_ONLY_JMS_PROPERTY_NAMES;
    private static final Set ALL_JMS_PROPERTY_NAMES;
    private static final Set TYPE_MCD_ELEMENTS;
    private static final Set RESERVED_SQL_PROPERTY_NAMES;
    private static final Set RESERVED_HIERARCHY_PROPERTY_NAME_PREFIXES;
    private static final Set ALLOWED_HIERARCHY_PROPERTY_NAMES;
    private static final Set RESTRICTED_HIERARCHY_FOLDER_NAMES;
    private static final String replyToURI = "queue://";
    private static final String mcdURI = "mcd://";
    private static final char[] BIN2HEX;
    private static final long JMS_UNLIMITED_EXPIRATION = 0L;
    private static final Long UNLIMITED_EXPIRY;
    private static final int JMS_DEFAULT_PRIORITY = 4;

    public MQMessage() {
        int traceContext = 0;
        int fid = 193;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 193);
        }
        this.dataBuffer = EMPTY_BUFFER;
        this.dataBuffer.position(0);
        this.dataBuffer.limit(0);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 193);
        }
    }

    public int getTotalMessageLength() {
        int traceRet1 = Math.max(this.dataBuffer.limit(), this._totalMessageLength);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 943, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getMessageLength() throws IOException {
        int traceRet1 = this.dataBuffer.limit();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 944, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    private void ensureWriteSpace(int bytesToWrite) {
        int requiredSize;
        int traceContext = 0;
        int fid = 194;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 194, new Object[]{new Integer(bytesToWrite)});
        }
        if ((requiredSize = this.dataBuffer.position() + bytesToWrite) > this.dataBuffer.limit()) {
            if (requiredSize < this.dataBuffer.capacity()) {
                this.dataBuffer.limit(requiredSize);
            } else {
                int multiplesInRequired = requiredSize / 128;
                int newMultiple = multiplesInRequired + 1;
                if (requiredSize % 128 > 64) {
                    ++newMultiple;
                }
                ByteBuffer newDataBuffer = ByteBuffer.allocate(newMultiple * 128);
                int oldPosition = this.dataBuffer.position();
                this.dataBuffer.position(0);
                newDataBuffer.put(this.dataBuffer);
                this.dataBuffer = newDataBuffer;
                this.dataBuffer.position(oldPosition);
                this.dataBuffer.limit(requiredSize);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 194);
        }
    }

    public int getDataLength() throws IOException {
        int traceRet1 = this.dataBuffer.remaining();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 945, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void seek(int offset) throws EOFException {
        int traceContext = 0;
        int fid = 195;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 195, new Object[]{new Integer(offset)});
        }
        if (offset > this.dataBuffer.limit()) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.seek()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 195, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 195, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        this.dataBuffer.position(offset);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 195, 1);
        }
    }

    public void setDataOffset(int offset) throws EOFException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 946, "setting to: ", (Object)new Integer(offset));
        }
        this.seek(offset);
    }

    public int getDataOffset() throws IOException {
        int traceRet1 = this.dataBuffer.position();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 947, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void clearMessage() throws IOException {
        int traceContext = 0;
        int fid = 196;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 196);
        }
        this.dataBuffer = EMPTY_BUFFER;
        this.dataBuffer.position(0);
        this.dataBuffer.limit(0);
        this._totalMessageLength = 0;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 196);
        }
    }

    public void resizeBuffer(int size) throws IOException {
        int traceContext = 0;
        int fid = 197;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 197, new Object[]{new Integer(size)});
        }
        if (size < this.dataBuffer.limit()) {
            ByteBuffer tmpBuffer = ByteBuffer.allocate(size);
            int oldPosition = this.dataBuffer.position();
            this.dataBuffer.position(0);
            this.dataBuffer.limit(size);
            tmpBuffer.put(this.dataBuffer);
            this.dataBuffer = tmpBuffer;
            if (oldPosition >= size) {
                oldPosition = size;
            }
            this.dataBuffer.limit(size);
            this.dataBuffer.position(oldPosition);
        } else if (size > this.dataBuffer.limit()) {
            this._bufferSizeHint = size;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 197);
        }
    }

    public boolean readBoolean() throws IOException, EOFException {
        boolean retVal;
        int traceContext = 0;
        int fid = 198;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 198);
        }
        if (this.dataBuffer.remaining() < 1) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readBoolean()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 198, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 198, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        boolean bl = retVal = this.dataBuffer.get() != 0;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 198, (Object)retVal, 1);
        }
        return retVal;
    }

    public byte readByte() throws IOException, EOFException {
        int traceContext = 0;
        int fid = 199;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 199);
        }
        if (this.dataBuffer.remaining() < 1) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readByte()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 199, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 199, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        byte retVal = this.dataBuffer.get();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 199, (Object)new Byte(retVal), 1);
        }
        return retVal;
    }

    public char readChar() throws IOException, EOFException {
        int traceContext = 0;
        int fid = 200;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 200);
        }
        char retVal = '\u0000';
        if (this.dataBuffer.remaining() < 2) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readChar()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 200, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 200, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 200, "Invalid encoding : ", (Object)Integer.toString(this.encoding & 0xF00));
                }
                IOException traceRet2 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.readChar()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 200, (Throwable)traceRet2, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 200, (Object)traceRet2, 3);
                }
                throw traceRet2;
            }
        }
        retVal = this.dataBuffer.getChar();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 200, (Object)new Character(retVal), 1);
        }
        return retVal;
    }

    public double readDouble() throws IOException, EOFException {
        int traceContext = 0;
        int fid = 201;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 201);
        }
        double retVal = 0.0;
        if (this.dataBuffer.remaining() < 8) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readDouble()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 201, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 201, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        switch (this.encoding & 0xF00) {
            case 0: 
            case 256: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                retVal = this.dataBuffer.getDouble();
                break;
            }
            case 512: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                retVal = this.dataBuffer.getDouble();
                break;
            }
            case 768: {
                long doubleBits = this.dataBuffer.getLong();
                retVal = MQS390FloatSupport.longS390BitsToDouble(doubleBits, this.trace);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 201, "Invalid encoding : ", (Object)Integer.toString(this.encoding & 0xF00));
                }
                IOException traceRet2 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.readDouble()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 201, (Throwable)traceRet2, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 201, (Object)traceRet2, 3);
                }
                throw traceRet2;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 201, (Object)new Double(retVal), 1);
        }
        return retVal;
    }

    public float readFloat() throws IOException, EOFException {
        int traceContext = 0;
        int fid = 202;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 202);
        }
        float retVal = 0.0f;
        if (this.dataBuffer.remaining() < 4) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readFloat()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 202, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 202, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        switch (this.encoding & 0xF00) {
            case 0: 
            case 256: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                retVal = this.dataBuffer.getFloat();
                break;
            }
            case 512: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                retVal = this.dataBuffer.getFloat();
                break;
            }
            case 768: {
                int floatBits = this.dataBuffer.getInt();
                retVal = MQS390FloatSupport.intS390BitsToFloat(floatBits, this.trace);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 202, "Invalid encoding : ", (Object)Integer.toString(this.encoding & 0xF00));
                }
                IOException traceRet2 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.readFloat()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 202, (Throwable)traceRet2, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 202, (Object)traceRet2, 3);
                }
                throw traceRet2;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 202, (Object)new Float(retVal), 1);
        }
        return retVal;
    }

    public void readFully(byte[] b) throws IOException {
        int traceContext = 0;
        int fid = 203;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 203, new Object[]{b});
        }
        if (this.dataBuffer.remaining() < b.length) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readFully()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 203, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 203, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        this.dataBuffer.get(b);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 203, 1);
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int traceContext = 0;
        int fid = 204;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 204, new Object[]{b, new Integer(off), new Integer(len)});
        }
        if (this.dataBuffer.remaining() < len) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readFully()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 204, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 204, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        this.dataBuffer.get(b, off, len);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 204, 1);
        }
    }

    public String readStringOfByteLength(int numberOfBytes) throws IOException, EOFException {
        int traceContext = 0;
        int fid = 205;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 205, new Object[]{new Integer(numberOfBytes)});
        }
        if (this.dataBuffer.remaining() < numberOfBytes) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readString()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 205, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 205, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        byte[] b = new byte[numberOfBytes];
        String result = null;
        int originalDataOffset = this.dataBuffer.position();
        try {
            this.dataBuffer.get(b, 0, numberOfBytes);
            result = new String(b, this.getCharacterSetString(this.characterSet));
        }
        catch (IOException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 205, (Throwable)e, 1);
            }
            this.dataBuffer.position(originalDataOffset);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 205, (Throwable)e, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 205, (Object)e, 3);
            }
            throw e;
        }
        catch (UnsupportedCharsetException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 205, (Throwable)e, 2);
            }
            UnsupportedEncodingException traceRet1 = new UnsupportedEncodingException(Integer.toString(this.characterSet));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 205, (Throwable)traceRet1, 3);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 205, (Object)traceRet1, 4);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 205, (Object)result, 1);
        }
        return result;
    }

    public String readStringOfCharLength(int numberOfChars) throws IOException, EOFException {
        String retVal;
        int traceContext = 0;
        int fid = 206;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 206, new Object[]{new Integer(numberOfChars)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 206, "numberOfChars = ", (Object)Integer.toString(numberOfChars));
        }
        int originalDataOffset = this.getDataOffset();
        try {
            switch (this.characterSet) {
                case 1200: {
                    char[] c = new char[numberOfChars];
                    for (int i = 0; i < numberOfChars; ++i) {
                        c[i] = this.readChar();
                    }
                    retVal = new String(c);
                    break;
                }
                default: {
                    retVal = this.readConvertedString(numberOfChars);
                    break;
                }
            }
        }
        catch (EOFException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 206, (Throwable)e);
            }
            this.setDataOffset(originalDataOffset);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 206, (Throwable)e);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 206, (Object)e, 2);
            }
            throw e;
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 206, "Returning ", (Object)retVal);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 206, (Object)retVal, 1);
        }
        return retVal;
    }

    public int readInt() throws IOException {
        int traceContext = 0;
        int fid = 207;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 207);
        }
        int retVal = 0;
        if (this.dataBuffer.remaining() < 4) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readInt()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 207, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 207, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 207, "Invalid encoding : ", (Object)Integer.toString(this.encoding & 0xF00));
                }
                IOException traceRet2 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.readInt()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 207, (Throwable)traceRet2, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 207, (Object)traceRet2, 3);
                }
                throw traceRet2;
            }
        }
        retVal = this.dataBuffer.getInt();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 207, (Object)new Integer(retVal), 1);
        }
        return retVal;
    }

    public int readInt4() throws IOException {
        int traceContext = 0;
        int fid = 208;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 208);
        }
        int retVal = this.readInt();
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 208, "Returning ", (Object)Integer.toString(retVal));
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 208, (Object)new Integer(retVal));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine() throws IOException {
        String string;
        block9: {
            String string2;
            block8: {
                int traceContext = 0;
                int fid = 209;
                if (this.trace.isOn) {
                    traceContext = this.trace.entry_OO((Object)this, COMP_JN, 209);
                }
                try {
                    switch (this.characterSet) {
                        case 1200: {
                            String traceRet1 = this.readUnicodeLine();
                            if (this.trace.isOn) {
                                this.trace.exit(traceContext, (Object)this, COMP_JN, 209, (Object)traceRet1, 1);
                            }
                            string2 = traceRet1;
                            Object var6_7 = null;
                            if (!this.trace.isOn) return string2;
                            break block8;
                        }
                        default: {
                            String traceRet3 = this.readConvertedLine();
                            if (this.trace.isOn) {
                                this.trace.exit(traceContext, (Object)this, COMP_JN, 209, (Object)traceRet3, 2);
                            }
                            string = traceRet3;
                            break;
                        }
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (!this.trace.isOn) throw throwable;
                    this.trace.finallyBlock((Object)this, COMP_JN, 209);
                    throw throwable;
                }
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 209);
            return string2;
        }
        Object var6_8 = null;
        if (!this.trace.isOn) return string;
        this.trace.finallyBlock((Object)this, COMP_JN, 209);
        return string;
    }

    private String readUnicodeLine() throws IOException {
        StringBuffer retVal;
        int traceContext;
        block10: {
            traceContext = 0;
            int fid = 211;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 211);
            }
            retVal = new StringBuffer(this.getDataLength() / 2);
            try {
                boolean endOfLine = false;
                block6: while (!endOfLine) {
                    char thisChar = this.readChar();
                    switch (thisChar) {
                        case '\n': {
                            endOfLine = true;
                            continue block6;
                        }
                        case '\r': {
                            char anotherChar;
                            endOfLine = true;
                            if (this.getDataLength() < 2 || (anotherChar = this.readChar()) == '\n') continue block6;
                            this.seek(this.getDataOffset() - 2);
                            continue block6;
                        }
                    }
                    retVal.append(thisChar);
                }
            }
            catch (EOFException ex) {
                if (!this.trace.isOn) break block10;
                this.trace.catchBlock((Object)this, COMP_JN, 211, (Throwable)ex);
            }
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 211, "Read Unicode string: ", (Object)retVal);
        }
        String traceRet1 = retVal.toString();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 211, (Object)traceRet1);
        }
        return traceRet1;
    }

    public long readLong() throws IOException {
        int traceContext = 0;
        int fid = 212;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 212);
        }
        if (this.dataBuffer.remaining() < 8) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readLong()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 212, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 212, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 212, "Invalid encoding : ", (Object)Integer.toString(this.encoding & 0xF));
                }
                IOException traceRet2 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.readLong()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 212, (Throwable)traceRet2, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 212, (Object)traceRet2, 3);
                }
                throw traceRet2;
            }
        }
        long retVal = this.dataBuffer.getLong();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 212, (Object)new Long(retVal), 1);
        }
        return retVal;
    }

    public long readInt8() throws IOException {
        int traceContext = 0;
        int fid = 213;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 213);
        }
        long retVal = this.readLong();
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 213, "Returning ", (Object)Long.toString(retVal));
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 213, (Object)new Long(retVal));
        }
        return retVal;
    }

    public short readShort() throws IOException {
        int traceContext = 0;
        int fid = 214;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 214);
        }
        if (this.dataBuffer.remaining() < 2) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readShort()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 214, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 214, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 214, "Invalid encoding : ", (Object)Integer.toString(this.encoding & 0xF));
                }
                IOException traceRet2 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.readShort()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 214, (Throwable)traceRet2, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 214, (Object)traceRet2, 3);
                }
                throw traceRet2;
            }
        }
        short retVal = this.dataBuffer.getShort();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 214, (Object)new Short(retVal), 1);
        }
        return retVal;
    }

    public short readInt2() throws IOException {
        int traceContext = 0;
        int fid = 215;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 215);
        }
        short retVal = this.readShort();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 215, (Object)new Short(retVal));
        }
        return retVal;
    }

    public String readUTF() throws IOException {
        String retVal;
        int traceContext = 0;
        int fid = 216;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 216);
        }
        if (this.dataBuffer.remaining() < 2) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readUTF()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 216, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 216, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
        char utfLength = this.dataBuffer.getChar();
        if (utfLength > this.dataBuffer.remaining()) {
            EOFException traceRet2 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readUTF()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 216, (Throwable)traceRet2, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 216, (Object)traceRet2, 3);
            }
            throw traceRet2;
        }
        byte[] utfBytes = new byte[utfLength];
        this.dataBuffer.get(utfBytes);
        try {
            retVal = new String(utfBytes, "UTF-8J");
        }
        catch (UnsupportedCharsetException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 216, (Throwable)e, 1);
            }
            this.dataBuffer.position(this.dataBuffer.position() - utfLength - 2);
            if (this.proxyInputStream == null) {
                this.proxyInputStream = new MQMessageInputStream(this);
            }
            DataInputStream dataStream = new DataInputStream(this.proxyInputStream);
            retVal = dataStream.readUTF();
        }
        catch (UnsupportedEncodingException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 216, (Throwable)e, 2);
            }
            this.dataBuffer.position(this.dataBuffer.position() - utfLength - 2);
            if (this.proxyInputStream == null) {
                this.proxyInputStream = new MQMessageInputStream(this);
            }
            DataInputStream dataStream = new DataInputStream(this.proxyInputStream);
            retVal = dataStream.readUTF();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 216, (Object)retVal, 1);
        }
        return retVal;
    }

    public int readUnsignedByte() throws IOException {
        int traceContext = 0;
        int fid = 217;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 217);
        }
        if (this.dataBuffer.remaining() < 1) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readUnsignedByte()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 217, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 217, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        int retVal = this.dataBuffer.get() & 0xFF;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 217, (Object)new Integer(retVal), 1);
        }
        return retVal;
    }

    public int readUnsignedShort() throws IOException {
        int traceContext = 0;
        int fid = 218;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 218);
        }
        if (this.dataBuffer.remaining() < 2) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readUnsignedShort()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 218, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 218, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 218, "Invalid encoding : ", (Object)Integer.toString(this.encoding & 0xF));
                }
                IOException traceRet2 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.readUnsignedShort()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 218, (Throwable)traceRet2, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 218, (Object)traceRet2, 3);
                }
                throw traceRet2;
            }
        }
        char retVal = this.dataBuffer.getChar();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 218, (Object)new Integer(retVal), 1);
        }
        return retVal;
    }

    public int readUInt2() throws IOException {
        int traceContext = 0;
        int fid = 219;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 219);
        }
        int retVal = this.readUnsignedShort();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 219, (Object)new Integer(retVal));
        }
        return retVal;
    }

    public String readString(int length) throws IOException {
        int traceContext = 0;
        int fid = 220;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 220, new Object[]{new Integer(length)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 220, "length = ", (Object)Integer.toString(length));
        }
        String retVal = this.readStringOfCharLength(length);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 220, (Object)retVal);
        }
        return retVal;
    }

    public short readDecimal2() throws IOException {
        int traceContext = 0;
        int fid = 221;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 221);
        }
        if (this.dataBuffer.remaining() < 2) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readDecimal2()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 221, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 221, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        byte[] packedDecimalBytes = new byte[2];
        this.dataBuffer.get(packedDecimalBytes);
        if ((this.encoding & 0xF0) == 32) {
            byte reverseByte = packedDecimalBytes[0];
            packedDecimalBytes[0] = packedDecimalBytes[1];
            packedDecimalBytes[1] = reverseByte;
        }
        long packedDecimal = MQS390PackedDecimalSupport.convertToBinary(packedDecimalBytes);
        short traceRet2 = (short)packedDecimal;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 221, (Object)new Short(traceRet2), 1);
        }
        return traceRet2;
    }

    public int readDecimal4() throws IOException {
        int traceContext = 0;
        int fid = 222;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 222);
        }
        if (this.dataBuffer.remaining() < 4) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readDecimal4()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 222, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 222, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        byte[] packedDecimalBytes = new byte[4];
        this.dataBuffer.get(packedDecimalBytes);
        if ((this.encoding & 0xF0) == 32) {
            byte reverseByte = packedDecimalBytes[0];
            packedDecimalBytes[0] = packedDecimalBytes[3];
            packedDecimalBytes[3] = reverseByte;
            reverseByte = packedDecimalBytes[1];
            packedDecimalBytes[1] = packedDecimalBytes[2];
            packedDecimalBytes[2] = reverseByte;
        }
        long packedDecimal = MQS390PackedDecimalSupport.convertToBinary(packedDecimalBytes);
        int traceRet2 = (int)packedDecimal;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 222, (Object)new Integer(traceRet2), 1);
        }
        return traceRet2;
    }

    public long readDecimal8() throws IOException {
        long packedDecimal;
        int traceContext = 0;
        int fid = 223;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 223);
        }
        if (this.dataBuffer.remaining() < 8) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.readDecimal8()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 223, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 223, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        byte[] packedDecimalBytes = new byte[8];
        this.dataBuffer.get(packedDecimalBytes);
        if ((this.encoding & 0xF0) == 32) {
            byte reverseByte = packedDecimalBytes[0];
            packedDecimalBytes[0] = packedDecimalBytes[7];
            packedDecimalBytes[7] = reverseByte;
            reverseByte = packedDecimalBytes[1];
            packedDecimalBytes[1] = packedDecimalBytes[6];
            packedDecimalBytes[6] = reverseByte;
            reverseByte = packedDecimalBytes[2];
            packedDecimalBytes[2] = packedDecimalBytes[5];
            packedDecimalBytes[5] = reverseByte;
            reverseByte = packedDecimalBytes[3];
            packedDecimalBytes[3] = packedDecimalBytes[4];
            packedDecimalBytes[4] = reverseByte;
        }
        long traceRet2 = packedDecimal = MQS390PackedDecimalSupport.convertToBinary(packedDecimalBytes);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 223, (Object)new Long(traceRet2), 1);
        }
        return traceRet2;
    }

    public Object readObject() throws ClassNotFoundException, InvalidClassException, StreamCorruptedException, OptionalDataException, IOException {
        int traceContext = 0;
        int fid = 225;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 225);
        }
        Object retVal = null;
        if (this.proxyInputStream == null) {
            this.proxyInputStream = new MQMessageInputStream(this);
        }
        if (this.objectInputStream == null || this.multiStreamStyleObjectStream) {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            this.objectInputStream = new MQObjectInputStream(this.proxyInputStream, classloader, this.trace);
            retVal = this.objectInputStream.readObject();
        } else if (this.oneStreamStyleObjectStream) {
            retVal = this.objectInputStream.readObject();
        } else {
            try {
                this.proxyInputStream.mark(2000);
                retVal = this.objectInputStream.readObject();
                this.oneStreamStyleObjectStream = true;
                this.multiStreamStyleObjectStream = false;
                if (this.trace.isOn) {
                    this.trace.data((Object)this, COMP_JN, 225, "readObject()", (Object)"Message contains OneStream style ByteBuffer");
                }
            }
            catch (StreamCorruptedException sce) {
                this.proxyInputStream.reset();
                this.objectInputStream = null;
                this.oneStreamStyleObjectStream = false;
                this.multiStreamStyleObjectStream = true;
                if (this.trace.isOn) {
                    this.trace.data((Object)this, COMP_JN, 225, "readObject()", (Object)"Message contains MultiStream style ByteBuffer");
                }
                retVal = this.readObject();
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 225, retVal);
        }
        return retVal;
    }

    public int skipBytes(int n) throws IOException, EOFException {
        int actualPosition;
        int traceContext = 0;
        int fid = 226;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 226, new Object[]{new Integer(n)});
        }
        if (n == 0) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 226, (Object)new Integer(0), 1);
            }
            return 0;
        }
        int requestedPosition = this.dataBuffer.position() + n;
        int n2 = actualPosition = requestedPosition < this.dataBuffer.limit() ? requestedPosition : this.dataBuffer.limit();
        if (actualPosition >= 0) {
            this.dataBuffer.position(actualPosition);
        }
        if (actualPosition < 0 || actualPosition != requestedPosition) {
            EOFException traceRet1 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessage.skipBytes()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 226, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 226, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 226, (Object)new Integer(n), 3);
        }
        return n;
    }

    public void write(int b) throws IOException {
        int traceContext = 0;
        int fid = 227;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 227, new Object[]{new Integer(b)});
        }
        this.ensureWriteSpace(1);
        this.dataBuffer.put((byte)(b & 0xFF));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 227);
        }
    }

    public void write(byte[] b) throws IOException {
        int traceContext = 0;
        int fid = 228;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 228, new Object[]{b});
        }
        this.ensureWriteSpace(b.length);
        this.dataBuffer.put(b);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 228);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int traceContext = 0;
        int fid = 229;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 229, new Object[]{b, new Integer(off), new Integer(len)});
        }
        this.ensureWriteSpace(len);
        this.dataBuffer.put(b, off, len);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 229);
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        int traceContext = 0;
        int fid = 230;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 230, new Object[]{v});
        }
        this.ensureWriteSpace(1);
        this.dataBuffer.put(v ? (byte)1 : 0);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 230);
        }
    }

    public void writeByte(int v) throws IOException {
        int traceContext = 0;
        int fid = 231;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 231, new Object[]{new Integer(v)});
        }
        this.ensureWriteSpace(1);
        this.dataBuffer.put((byte)v);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 231);
        }
    }

    public void writeBytes(String s) throws IOException {
        int traceContext = 0;
        int fid = 232;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 232, new Object[]{s});
        }
        char[] stringChars = s.toCharArray();
        this.ensureWriteSpace(stringChars.length);
        for (int i = 0; i < stringChars.length; ++i) {
            this.dataBuffer.put((byte)(stringChars[i] & 0xFF));
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 232);
        }
    }

    public void writeChar(int v) throws IOException {
        int traceContext = 0;
        int fid = 233;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 233, new Object[]{new Integer(v)});
        }
        this.ensureWriteSpace(2);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 233, "Unsupported encoding: ", (Object)Integer.toString(this.encoding & 0xF));
                }
                IOException traceRet1 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.writeChar()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 233, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 233, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        this.dataBuffer.putChar((char)v);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 233, 1);
        }
    }

    public void writeChars(String s) throws IOException {
        int traceContext = 0;
        int fid = 234;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 234, new Object[]{s});
        }
        char[] stringChars = s.toCharArray();
        this.ensureWriteSpace(stringChars.length * 2);
        this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < stringChars.length; ++i) {
            this.dataBuffer.putChar(stringChars[i]);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 234);
        }
    }

    public void writeDouble(double v) throws IOException {
        int traceContext = 0;
        int fid = 235;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 235, new Object[]{new Double(v)});
        }
        this.ensureWriteSpace(8);
        switch (this.encoding & 0xF00) {
            case 0: 
            case 256: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                this.dataBuffer.putDouble(v);
                break;
            }
            case 512: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.dataBuffer.putDouble(v);
                break;
            }
            case 768: {
                long s390Double = MQS390FloatSupport.doubleToS390LongBits(v, this.trace);
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                this.dataBuffer.putLong(s390Double);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 235, "Unsupported encoding: ", (Object)Integer.toString(this.encoding & 0xF00));
                }
                IOException traceRet1 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.writeDouble()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 235, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 235, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 235, 1);
        }
    }

    public void writeFloat(float v) throws IOException {
        int traceContext = 0;
        int fid = 236;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 236, new Object[]{new Float(v)});
        }
        this.ensureWriteSpace(4);
        switch (this.encoding & 0xF00) {
            case 0: 
            case 256: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                this.dataBuffer.putFloat(v);
                break;
            }
            case 512: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.dataBuffer.putFloat(v);
                break;
            }
            case 768: {
                int s390Float = MQS390FloatSupport.floatToS390IntBits(v, this.trace);
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                this.dataBuffer.putInt(s390Float);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 236, "Unsupported encoding: ", (Object)Integer.toString(this.encoding & 0xF00));
                }
                IOException traceRet1 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.writeFloat()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 236, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 236, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 236, 1);
        }
    }

    public void writeInt(int v) throws IOException {
        int traceContext = 0;
        int fid = 237;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 237, new Object[]{new Integer(v)});
        }
        this.ensureWriteSpace(4);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 237, "Unsupported encoding: ", (Object)Integer.toString(this.encoding & 0xF));
                }
                IOException traceRet1 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.writeInt()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 237, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 237, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        this.dataBuffer.putInt(v);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 237, 1);
        }
    }

    public void writeInt4(int v) throws IOException {
        int traceContext = 0;
        int fid = 238;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 238, new Object[]{new Integer(v)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 238, "v = ", (Object)Integer.toString(v));
        }
        this.writeInt(v);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 238);
        }
    }

    public void writeLong(long v) throws IOException {
        int traceContext = 0;
        int fid = 239;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 239, new Object[]{new Long(v)});
        }
        this.ensureWriteSpace(8);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 239, "Unsupported encoding: ", (Object)Integer.toString(this.encoding & 0xF00));
                }
                IOException traceRet1 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.writeLong()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 239, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 239, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        this.dataBuffer.putLong(v);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 239, 1);
        }
    }

    public void writeInt8(long v) throws IOException {
        int traceContext = 0;
        int fid = 240;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 240, new Object[]{new Long(v)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 240, "v = ", (Object)Long.toString(v));
        }
        this.writeLong(v);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 240);
        }
    }

    public void writeShort(int v) throws IOException {
        int traceContext = 0;
        int fid = 241;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 241, new Object[]{new Integer(v)});
        }
        this.ensureWriteSpace(2);
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 2: {
                this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 241, "Unsupported encoding: ", (Object)Integer.toString(this.encoding & 0xF00));
                }
                IOException traceRet1 = new IOException(MQException.getNLSMsg((String)"MQIOEXCEPTION", (String)"MQMessage.writeShort()"));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 241, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 241, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        this.dataBuffer.putShort((short)v);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 241, 1);
        }
    }

    public void writeInt2(int v) throws IOException {
        int traceContext = 0;
        int fid = 242;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 242, new Object[]{new Integer(v)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 242, "v = ", (Object)Integer.toString(v));
        }
        this.writeShort(v);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 242);
        }
    }

    public void writeDecimal2(short v) throws IOException {
        int traceContext = 0;
        int fid = 243;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 243, new Object[]{new Short(v)});
        }
        this.ensureWriteSpace(2);
        byte[] packedDecimalBytes = MQS390PackedDecimalSupport.convertToPackedDecimal(v);
        if ((this.encoding & 0xF0) == 32) {
            byte reverseByte = packedDecimalBytes[0];
            packedDecimalBytes[0] = packedDecimalBytes[1];
            packedDecimalBytes[1] = reverseByte;
        }
        this.dataBuffer.put(packedDecimalBytes);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 243);
        }
    }

    public void writeDecimal4(int v) throws IOException {
        int traceContext = 0;
        int fid = 244;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 244, new Object[]{new Integer(v)});
        }
        this.ensureWriteSpace(4);
        byte[] packedDecimalBytes = MQS390PackedDecimalSupport.convertToPackedDecimal(v);
        if ((this.encoding & 0xF0) == 32) {
            byte reverseByte = packedDecimalBytes[0];
            packedDecimalBytes[0] = packedDecimalBytes[3];
            packedDecimalBytes[3] = reverseByte;
            reverseByte = packedDecimalBytes[1];
            packedDecimalBytes[1] = packedDecimalBytes[2];
            packedDecimalBytes[2] = reverseByte;
        }
        this.dataBuffer.put(packedDecimalBytes);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 244);
        }
    }

    public void writeDecimal8(long v) throws IOException {
        int traceContext = 0;
        int fid = 245;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 245, new Object[]{new Long(v)});
        }
        this.ensureWriteSpace(8);
        byte[] packedDecimalBytes = MQS390PackedDecimalSupport.convertToPackedDecimal(v);
        if ((this.encoding & 0xF0) == 32) {
            byte reverseByte = packedDecimalBytes[0];
            packedDecimalBytes[0] = packedDecimalBytes[7];
            packedDecimalBytes[7] = reverseByte;
            reverseByte = packedDecimalBytes[1];
            packedDecimalBytes[1] = packedDecimalBytes[6];
            packedDecimalBytes[6] = reverseByte;
            reverseByte = packedDecimalBytes[2];
            packedDecimalBytes[2] = packedDecimalBytes[5];
            packedDecimalBytes[5] = reverseByte;
            reverseByte = packedDecimalBytes[3];
            packedDecimalBytes[3] = packedDecimalBytes[4];
            packedDecimalBytes[4] = reverseByte;
        }
        this.dataBuffer.put(packedDecimalBytes);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 245);
        }
    }

    public void writeUTF(String str) throws IOException {
        int traceContext = 0;
        int fid = 246;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 246, new Object[]{str});
        }
        try {
            byte[] utfBytes = str.getBytes("UTF-8J");
            char utfLength = (char)utfBytes.length;
            this.ensureWriteSpace(utfLength + 2);
            this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
            this.dataBuffer.putChar(utfLength);
            this.dataBuffer.put(utfBytes);
        }
        catch (UnsupportedCharsetException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 246, (Throwable)e, 1);
            }
            if (this.proxyOutputStream == null) {
                this.proxyOutputStream = new MQMessageOutputStream(this);
            }
            DataOutputStream dataStream = new DataOutputStream(this.proxyOutputStream);
            dataStream.writeUTF(str);
        }
        catch (UnsupportedEncodingException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 246, (Throwable)e, 2);
            }
            if (this.proxyOutputStream == null) {
                this.proxyOutputStream = new MQMessageOutputStream(this);
            }
            DataOutputStream dataStream = new DataOutputStream(this.proxyOutputStream);
            dataStream.writeUTF(str);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 246);
        }
    }

    public void writeString(String s) throws IOException {
        int traceContext = 0;
        int fid = 247;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 247, new Object[]{s});
        }
        switch (this.characterSet) {
            case 1200: {
                this.writeChars(s);
                break;
            }
            case 0: {
                this.characterSet = MQSESSION.getDefaultCCSID();
            }
            default: {
                try {
                    byte[] convertedBytes = s.getBytes(this.getCharacterSetString(this.characterSet));
                    this.ensureWriteSpace(convertedBytes.length);
                    this.dataBuffer.put(convertedBytes);
                    break;
                }
                catch (UnsupportedCharsetException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 247, (Throwable)e);
                    }
                    UnsupportedEncodingException traceRet1 = new UnsupportedEncodingException(Integer.toString(this.characterSet));
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 247, (Throwable)traceRet1);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 247, (Object)traceRet1, 2);
                    }
                    throw traceRet1;
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 247, 1);
        }
    }

    public void writeObject(Object obj) throws IOException {
        int traceContext = 0;
        int fid = 249;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 249, new Object[]{obj});
        }
        if (this.proxyOutputStream == null) {
            this.proxyOutputStream = new MQMessageOutputStream(this);
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.proxyOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.close();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 249);
        }
    }

    protected final ByteBuffer getBuffer() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 948, "returning: ", (Object)this.dataBuffer);
        }
        return this.dataBuffer;
    }

    protected final void setMessageData(ByteBuffer messageData, int messageLength, int totalMessageLength) {
        int traceContext;
        block5: {
            traceContext = 0;
            int fid = 251;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 251, new Object[]{messageData, new Integer(messageLength), new Integer(totalMessageLength)});
            }
            this._totalMessageLength = totalMessageLength;
            ByteBuffer newBuffer = ByteBuffer.allocate(messageLength);
            int originalPosition = messageData.position();
            int originalLimit = messageData.limit();
            messageData.position(0);
            messageData.limit(messageLength);
            newBuffer.put(messageData);
            this.dataBuffer = newBuffer;
            this.dataBuffer.position(0);
            this.dataBuffer.limit(messageLength);
            messageData.limit(originalLimit);
            messageData.position(originalPosition);
            try {
                if (this.objectInputStream != null) {
                    this.objectInputStream.close();
                }
                this.objectInputStream = null;
            }
            catch (IOException ie) {
                if (!this.trace.isOn) break block5;
                this.trace.catchBlock((Object)this, COMP_JN, 251, (Throwable)ie);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 251);
        }
    }

    protected int getBufferSizeHint() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 949, "returning: ", (Object)new Integer(this._bufferSizeHint));
        }
        return this._bufferSizeHint;
    }

    protected void setTotalMessageLength(int tMsgLength) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 950, "setting to: ", (Object)new Integer(tMsgLength));
        }
        this._totalMessageLength = tMsgLength;
    }

    private String readConvertedLine() throws IOException {
        int traceContext = 0;
        int fid = 253;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 253);
        }
        CharBuffer charBuffer = CharBuffer.allocate(256);
        Charset charSet = null;
        try {
            charSet = Charset.forName(this.getCharacterSetString(this.characterSet));
        }
        catch (UnsupportedCharsetException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 253, (Throwable)e);
            }
            UnsupportedEncodingException traceRet1 = new UnsupportedEncodingException(Integer.toString(this.characterSet));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 253, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 253, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        CharsetDecoder decoder = charSet.newDecoder();
        int charsRead = 0;
        int stringLength = 0;
        boolean readLine = false;
        boolean carriageReturnFound = false;
        int crReadPos = -1;
        while (!readLine) {
            if (charsRead >= charBuffer.capacity()) {
                CharBuffer newCharBuffer = CharBuffer.allocate(charBuffer.capacity() * 2);
                charBuffer.position(0);
                newCharBuffer.put(charBuffer);
                charBuffer = newCharBuffer;
            }
            if (this.dataBuffer.remaining() > 0) {
                charBuffer.limit(charsRead + 1);
                CoderResult result = decoder.decode(this.dataBuffer, charBuffer, false);
                if (result.isError()) {
                    IOException traceRet1 = new IOException(MQException.getNLSMsg((String)"MQDECODEERROR", (String)("MQMessag2.readConvertedLine():" + result.toString())));
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 253, (Throwable)traceRet1, 2);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 253, (Object)traceRet1, 3);
                    }
                    throw traceRet1;
                }
                char aChar = charBuffer.get(charsRead);
                switch (aChar) {
                    case '\n': {
                        readLine = true;
                        break;
                    }
                    case '\r': {
                        carriageReturnFound = true;
                        crReadPos = this.dataBuffer.position();
                        break;
                    }
                    default: {
                        if (carriageReturnFound) {
                            readLine = true;
                            this.dataBuffer.position(crReadPos);
                            break;
                        }
                        ++stringLength;
                    }
                }
                ++charsRead;
                continue;
            }
            readLine = true;
        }
        charBuffer.position(0);
        String traceRet2 = ((Object)charBuffer.subSequence(0, stringLength)).toString();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 253, (Object)traceRet2, 1);
        }
        return traceRet2;
    }

    private String readConvertedString(int length) throws IOException, EOFException {
        int traceContext = 0;
        int fid = 254;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 254, new Object[]{new Integer(length)});
        }
        CharBuffer charBuffer = CharBuffer.allocate(length);
        Charset charSet = null;
        try {
            charSet = Charset.forName(this.getCharacterSetString(this.characterSet));
        }
        catch (UnsupportedCharsetException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 254, (Throwable)e);
            }
            UnsupportedEncodingException traceRet1 = new UnsupportedEncodingException(Integer.toString(this.characterSet));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 254, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 254, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        CharsetDecoder decoder = charSet.newDecoder();
        for (int charsRead = 0; charsRead < length; ++charsRead) {
            if (this.dataBuffer.remaining() > 0) {
                charBuffer.limit(charsRead + 1);
                CoderResult result = decoder.decode(this.dataBuffer, charBuffer, false);
                if (!result.isError()) continue;
                IOException traceRet1 = new IOException(MQException.getNLSMsg((String)"MQDECODEERROR", (String)("MQMessag2.readConvertedString():" + result.toString())));
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 254, (Throwable)traceRet1, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 254, (Object)traceRet1, 3);
                }
                throw traceRet1;
            }
            EOFException traceRet2 = new EOFException(MQException.getNLSMsg((String)"MQEOFEXCEPTION", (String)"MQMessag2.readConvertedString()"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 254, (Throwable)traceRet2, 3);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 254, (Object)traceRet2, 4);
            }
            throw traceRet2;
        }
        charBuffer.position(0);
        String traceRet3 = charBuffer.toString();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 254, (Object)traceRet3, 1);
        }
        return traceRet3;
    }

    private String getCharacterSetString(int charSet) throws UnsupportedCharsetException {
        JmqiCodepage jmqiCodepage;
        int traceContext = 0;
        int fid = 255;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 255, new Object[]{new Integer(charSet)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 255, "charSet = ", (Object)Integer.toString(charSet));
        }
        if (charSet == 0) {
            charSet = MQSESSION.getDefaultCCSID();
        }
        if ((jmqiCodepage = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)charSet)) == null) {
            UnsupportedCharsetException traceRet1 = new UnsupportedCharsetException(Integer.toString(charSet));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 255, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 255, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        String retVal = jmqiCodepage.charsetId;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 255, (Object)retVal, 1);
        }
        return retVal;
    }

    public int getPropertyValidation() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 951, "returning: ", (Object)new Integer(this.propertyValidation));
        }
        return this.propertyValidation;
    }

    public void setPropertyValidation(int propertyValidation) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 952, "setting to: ", (Object)new Integer(propertyValidation));
        }
        this.propertyValidation = propertyValidation;
    }

    protected void performProcessingBeforePut(int ccsid) throws MQException {
        int numberOfProperties;
        int traceContext = 0;
        int fid = 513;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 513, new Object[]{new Integer(ccsid)});
        }
        if ((numberOfProperties = this.properties.size()) > 0) {
            this.formatBeforePut = this.format;
            this.dataBufferBeforePut = this.copyDataBuffer(this.dataBuffer);
            this.writePropertiesRfh2(ccsid);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 513);
        }
    }

    private ByteBuffer copyDataBuffer(ByteBuffer oldBuffer) {
        int traceContext = 0;
        int fid = 514;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 514, new Object[]{oldBuffer});
        }
        int dataBufferPosition = oldBuffer.position();
        int dataBufferLimit = oldBuffer.limit();
        int dataBufferCapacity = oldBuffer.capacity();
        ByteBuffer newBuffer = ByteBuffer.allocate(dataBufferCapacity);
        newBuffer.limit(dataBufferLimit);
        oldBuffer.position(0);
        newBuffer.put(oldBuffer);
        newBuffer.position(dataBufferPosition);
        oldBuffer.position(dataBufferPosition);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 514, (Object)newBuffer);
        }
        return newBuffer;
    }

    protected void performProcessingAfterPut() throws MQException {
        int numberOfProperties;
        int traceContext = 0;
        int fid = 515;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 515);
        }
        if ((numberOfProperties = this.properties.size()) > 0) {
            this.format = this.formatBeforePut;
            this.dataBuffer = this.dataBufferBeforePut;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 515);
        }
    }

    protected void performProcessingBeforeGet() throws MQException {
        int traceContext = 0;
        int fid = 516;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 516);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 516);
        }
    }

    protected void performProcessingAfterGet() throws MQException {
        int traceContext = 0;
        int fid = 517;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 517);
        }
        this.readPropertiesRfh2();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 517);
        }
    }

    protected void setRemoveRfh2AfterGet(boolean value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 953, "setting to: ", (Object)value);
        }
        this.removeRfh2PropertyHeaders = value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePropertiesRfh2(int ccsid) throws MQException {
        int traceContext;
        block26: {
            traceContext = 0;
            int fid = 518;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 518, new Object[]{new Integer(ccsid)});
            }
            if (this.characterSet == 0) {
                this.characterSet = ccsid;
            }
            try {
                try {
                    this.seek(0);
                    MQHeaderList headers = null;
                    try {
                        headers = new MQHeaderList((DataInput)this, true);
                    }
                    catch (Exception e) {
                        if (this.trace.isOn) {
                            this.trace.catchBlock((Object)this, COMP_JN, 518, (Throwable)e, 1);
                        }
                        MQException traceRet1 = new MQException(2, 2142, (Object)this);
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 518, (Throwable)traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                    MQRFH2 rfh2 = this.createPropertiesRfh2();
                    String mqxqhType = new MQXQH().type();
                    int positionOfMQXQH = headers.indexOf(mqxqhType);
                    if (positionOfMQXQH == -1) {
                        if (this.trace.isOn) {
                            this.trace.data((Object)this.env, COMP_JN, 518, "No MQXQH header detected on the message. Adding RFH2 as the first header in the header list", null);
                            this.trace.data((Object)this.env, COMP_JN, 518, "Copying CCSID=" + ccsid + " and Encoding=" + this.encoding + " from the MQMD to the RFH2 header", null);
                        }
                        rfh2.setCodedCharSetId(this.characterSet);
                        rfh2.setEncoding(this.encoding);
                        if (this.trace.isOn) {
                            this.trace.data((Object)this.env, COMP_JN, 518, "Setting CCSID=1208 and Encoding=1 in the MQMD to allow header chaining to work correctly", null);
                        }
                        this.characterSet = 1208;
                        this.encoding = 1;
                        if (this.trace.isOn) {
                            this.trace.data((Object)this.env, COMP_JN, 518, "Modified RFH2", (Object)rfh2);
                        }
                        headers.add(0, (Object)rfh2);
                    } else {
                        if (this.trace.isOn) {
                            this.trace.data((Object)this.env, COMP_JN, 518, "MQXQH header detected at position " + positionOfMQXQH + " in the header list. Adding the RFH2 as the next header", null);
                        }
                        MQXQH mqxqhHeader = (MQXQH)headers.remove(positionOfMQXQH);
                        MQMD1 mqxqhMqmd = mqxqhHeader.getMsgDesc();
                        int mqxqhMqmdCharacterSet = mqxqhMqmd.getCodedCharSetId();
                        int mqxqhMqmdEncoding = mqxqhMqmd.getEncoding();
                        if (this.trace.isOn) {
                            this.trace.data((Object)this.env, COMP_JN, 518, "Copying CCSID=" + mqxqhMqmdCharacterSet + " and Encoding=" + mqxqhMqmdEncoding + " from the MQMD in the MQXQH into" + " the RFH2 header", null);
                        }
                        rfh2.setCodedCharSetId(mqxqhMqmdCharacterSet);
                        rfh2.setEncoding(mqxqhMqmdEncoding);
                        if (this.trace.isOn) {
                            this.trace.data((Object)this.env, COMP_JN, 518, "Setting CCSID=1208 and Encoding=1 in the MQMD in the MQXQH to allow header chaining to work correctly", null);
                        }
                        mqxqhMqmd.setCodedCharSetId(1208);
                        mqxqhMqmd.setEncoding(1);
                        mqxqhHeader.setMsgDesc(mqxqhMqmd);
                        if (this.trace.isOn) {
                            this.trace.data((Object)this.env, COMP_JN, 518, "Modified MQXQH", (Object)mqxqhHeader);
                            this.trace.data((Object)this.env, COMP_JN, 518, "Modified RFH2", (Object)rfh2);
                        }
                        headers.add(positionOfMQXQH, (Object)mqxqhHeader);
                        headers.add(positionOfMQXQH + 1, (Object)rfh2);
                    }
                    this.format = headers.updateHeaderChaining();
                    this.seek(0);
                    headers.write((DataOutput)this, true);
                }
                catch (MQException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 518, (Throwable)e, 2);
                    }
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 518, (Throwable)e, 2);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 518, (Object)e, 2);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 518, (Throwable)e, 3);
                    }
                    this.trace.ffst((Object)this, COMP_JN, 518, 0, 2195, 0, 0, "An unexpected error occurred while creating the message properties RFH2 header", e.toString(), null);
                    MQException traceRet2 = new MQException(2, 2195, (Object)this);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 518, (Throwable)traceRet2, 3);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 518, (Object)traceRet2, 3);
                    }
                    throw traceRet2;
                }
                Object var13_17 = null;
                if (!this.trace.isOn) break block26;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 518);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 518);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 518, 1);
        }
    }

    private MQRFH2 createPropertiesRfh2() throws MQException, IOException {
        int traceContext = 0;
        int fid = 519;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 519);
        }
        int count = 0;
        MQRFH2 rfh2 = new MQRFH2();
        Iterator propertyNames = this.properties.keySet().iterator();
        while (propertyNames.hasNext()) {
            String name = (String)propertyNames.next();
            Vector valueList = (Vector)this.properties.get(name);
            Vector pdList = null;
            if (this.propertyDescTable.containsKey(name)) {
                pdList = (Vector)this.propertyDescTable.get(name);
            }
            String folder = this.getPropertyFolder(name);
            name = name.substring(folder.length() + ".".length());
            MQRFH2.Element rfh2Folder = rfh2.getFolder(folder, true);
            StringTokenizer tok = new StringTokenizer(name, ".");
            MQRFH2.Element currentFolder = rfh2Folder;
            while (tok.hasMoreTokens()) {
                String currentName = tok.nextToken();
                if (tok.hasMoreTokens()) {
                    currentFolder = currentFolder.getElement(currentName, true);
                    continue;
                }
                name = currentName;
            }
            if (valueList != null) {
                count = valueList.size();
            }
            if (count == 0) {
                currentFolder.addElement(name, null, true);
            }
            for (int i = 0; i < count; ++i) {
                currentFolder.addElement(name, valueList.elementAt(i), true);
            }
            if (!PROPERTIES_FOLDER_NAMES.contains(folder)) {
                rfh2Folder.setAttributeValue("content", "properties");
            }
            MQRFH2.Element element = rfh2Folder.getElement(name, false);
            if (pdList == null || pdList.size() <= 0) continue;
            MQPropertyDescriptor pd = (MQPropertyDescriptor)((Object)pdList.elementAt(0));
            if (pdList.size() > 1) {
                pdList.remove((Object)pd);
                pdList.addElement(pd);
            }
            if (pd == null) continue;
            this.appendMQPDToRfhElement(element, name, folder, pd);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 519, (Object)rfh2);
        }
        return rfh2;
    }

    private void appendMQPDToRfhElement(MQRFH2.Element element, String name, String folder, MQPropertyDescriptor pd) throws MQException {
        int traceContext = 0;
        int fid = 637;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 637, new Object[]{element, name, folder, pd});
        }
        if (element != null) {
            if (folder.equals("mq")) {
                int value = pd.support;
                byte[] b = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    int offset = (b.length - 1 - i) * 8;
                    b[i] = (byte)(value >>> offset & 0xFF);
                }
                StringBuffer hex = new StringBuffer();
                this.binToHex(b, 0, b.length, hex);
                element.setAttributeValue("support", hex.toString());
            }
            if (pd.context == 0) {
                element.setAttributeValue("context", "none");
            } else if (pd.context == 1) {
                element.setAttributeValue("context", "user");
            } else {
                MQException traceRet1 = new MQException(2, 2482, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 637, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 637, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
            int copyOption = pd.copyOptions;
            String copyValue = null;
            if (copyOption - 22 != 0) {
                if (copyOption == 0) {
                    copyValue = "none";
                } else if ((copyOption & 1) != 0) {
                    copyValue = "all";
                } else {
                    if ((copyOption & 2) != 0) {
                        copyValue = copyValue == null ? "forward" : copyValue + "," + "forward";
                    }
                    if ((copyOption & 4) != 0) {
                        copyValue = copyValue == null ? "publish" : copyValue + "," + "publish";
                    }
                    if ((copyOption & 0x10) != 0) {
                        copyValue = copyValue == null ? "report" : copyValue + "," + "report";
                    }
                    if ((copyOption & 8) != 0) {
                        copyValue = copyValue == null ? "reply" : copyValue + "," + "reply";
                    }
                }
            }
            if (copyValue != null) {
                element.setAttributeValue("copy", copyValue.trim());
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 637, 1);
        }
    }

    private String getPropertyFolder(String name) throws MQException {
        int firstFolderSeparatorIndex;
        int traceContext = 0;
        int fid = 520;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 520, new Object[]{name});
        }
        if ((firstFolderSeparatorIndex = name.indexOf(".")) < 0) {
            MQException traceRet1 = new MQException(2, 2195, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 520, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 520, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        String folder = name.substring(0, firstFolderSeparatorIndex);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 520, (Object)folder, 1);
        }
        return folder;
    }

    private void readPropertiesRfh2() {
        int traceContext;
        block18: {
            traceContext = 0;
            int fid = 521;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 521);
            }
            try {
                if (this.format == null || !this.format.equals("MQHRF2  ") && (this.format.equals("MQADMIN ") || this.format.equals("MQPCF   ") || this.format.equals("        "))) break block18;
                this.seek(0);
                MQHeaderList headers = null;
                boolean headersModified = false;
                try {
                    MQChainable lastHeader = null;
                    headers = new MQHeaderList((DataInput)this, true);
                    Iterator headersIterator = headers.iterator();
                    while (headersIterator.hasNext()) {
                        try {
                            Header header = (Header)headersIterator.next();
                            if (header instanceof MQRFH2) {
                                boolean containsOnlyProperties;
                                MQRFH2 headerAsMQRFH2 = (MQRFH2)header;
                                boolean modified = this.parsePropertiesRfh2(headerAsMQRFH2);
                                if (!modified) continue;
                                MQRFH2.Element[] folders = headerAsMQRFH2.getFolders();
                                boolean bl = containsOnlyProperties = folders == null || folders.length == 0;
                                if (this.removeRfh2PropertyHeaders && containsOnlyProperties) {
                                    headersIterator.remove();
                                    if (lastHeader != null) {
                                        lastHeader.nextCharacterSet(headerAsMQRFH2.nextCharacterSet());
                                        lastHeader.nextEncoding(headerAsMQRFH2.nextEncoding());
                                    } else {
                                        this.characterSet = headerAsMQRFH2.nextCharacterSet();
                                        this.encoding = headerAsMQRFH2.nextEncoding();
                                    }
                                } else {
                                    lastHeader = headerAsMQRFH2;
                                }
                                headersModified = true;
                                continue;
                            }
                            if (!(header instanceof MQChainable)) continue;
                            lastHeader = (MQChainable)header;
                        }
                        catch (Exception e) {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, COMP_JN, 521, (Throwable)e, 1);
                            }
                            this.trace.data((Object)this, COMP_JN, 521, "Failed to parse a message header while retrieving properties", (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 521, (Throwable)e, 2);
                    }
                    this.trace.data((Object)this, COMP_JN, 521, "Failed to parse the message header list while retrieving properties", (Object)e);
                }
                if (headersModified) {
                    this.format = headers.updateHeaderChaining();
                    this.seek(0);
                    headers.write((DataOutput)this, true);
                }
                this.seek(0);
            }
            catch (Exception e) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 521, (Throwable)e, 3);
                }
                this.trace.ffst((Object)this, COMP_JN, 521, 0, 2195, 0, 0, "An unexpected error occurred while parsing message properties", e.toString(), null);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 521);
        }
    }

    private boolean parsePropertiesRfh2(MQRFH2 rfh2) throws IOException {
        int traceContext = 0;
        int fid = 522;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 522, new Object[]{rfh2});
        }
        boolean modified = false;
        MQRFH2.Element[] elements = rfh2.getFolders();
        for (int i = 0; i < elements.length; ++i) {
            try {
                if (elements[i].getName().equals("ibm_rfp")) {
                    rfh2.setFolderContent(elements[i].getName(), null);
                    modified = true;
                    continue;
                }
                boolean isPropertiesFolder = this.parsePropertiesRfh2Folder(elements[i]);
                if (!isPropertiesFolder || !this.removeRfh2PropertyHeaders) continue;
                rfh2.setFolderContent(elements[i].getName(), null);
                modified = true;
                continue;
            }
            catch (Exception e) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 522, (Throwable)e);
                }
                this.trace.data((Object)this, COMP_JN, 522, "Failed to parse an RFH2 folder while retrieving properties", (Object)e);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 522, (Object)modified);
        }
        return modified;
    }

    private boolean parsePropertiesRfh2Folder(MQRFH2.Element element) {
        boolean isPropertiesFolder;
        int traceContext = 0;
        int fid = 523;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 523, new Object[]{element});
        }
        String name = element.getName();
        String contentAttribute = element.getAttributeValue("content");
        boolean bl = isPropertiesFolder = contentAttribute != null && contentAttribute.equals("properties") || PROPERTIES_FOLDER_NAMES.contains(name);
        if (isPropertiesFolder) {
            MQRFH2.Element[] elements = element.getChildren();
            for (int i = 0; i < elements.length; ++i) {
                try {
                    this.parsePropertiesRfh2Element(name, elements[i]);
                    continue;
                }
                catch (Exception e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 523, (Throwable)e);
                    }
                    this.trace.data((Object)this, COMP_JN, 523, "Failed to parse an RFH2 element while retrieving properties", (Object)e);
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 523, (Object)isPropertiesFolder);
        }
        return isPropertiesFolder;
    }

    private void parsePropertiesRfh2Element(String folder, MQRFH2.Element element) throws MQException {
        int traceContext = 0;
        int fid = 524;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 524, new Object[]{folder, element});
        }
        Vector valueList = null;
        Vector pdList = null;
        String name = element.getName();
        Object value = element.getValue();
        MQRFH2.Element[] elements = element.getChildren();
        MQPropertyDescriptor pd = this.getMQPDFromRfhElement(element);
        if (name != null && (elements == null || elements.length == 0)) {
            String fullName = folder + "." + name;
            if (!this.properties.containsKey(fullName)) {
                valueList = new Vector();
                valueList.addElement(value);
                this.properties.put(fullName, valueList);
            } else {
                valueList = (Vector)this.properties.get(fullName);
                if (valueList != null) {
                    valueList.add(value);
                    this.properties.put(fullName, valueList);
                }
            }
            if (!this.propertyDescTable.containsKey(fullName)) {
                pdList = new Vector();
                pdList.addElement(pd);
                this.propertyDescTable.put(fullName, pdList);
            } else {
                pdList = (Vector)this.propertyDescTable.get(fullName);
                if (pdList != null) {
                    pdList.addElement(pd);
                    this.propertyDescTable.put(fullName, pdList);
                }
            }
        }
        for (int i = 0; i < elements.length; ++i) {
            try {
                this.parsePropertiesRfh2Element(folder + "." + name, elements[i]);
                continue;
            }
            catch (Exception e) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 524, (Throwable)e);
                }
                this.trace.data((Object)this, COMP_JN, 524, "Failed to parse an RFH2 element while retrieving properties", (Object)e);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 524);
        }
    }

    private MQPropertyDescriptor getMQPDFromRfhElement(MQRFH2.Element element) throws MQException {
        int i;
        int traceContext = 0;
        int fid = 638;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 638, new Object[]{element});
        }
        MQPropertyDescriptor pd = new MQPropertyDescriptor();
        String[] list = null;
        String support = element.getAttributeValue("support");
        String context = element.getAttributeValue("context");
        String copy = element.getAttributeValue("copy");
        if (copy != null) {
            list = copy.split(",");
        }
        if (support != null) {
            byte[] b = this.hexToBin(support, 0);
            int value = 0;
            for (i = 0; i < 4; ++i) {
                int shift = (3 - i) * 8;
                value += (b[i + this.offset] & 0xFF) << shift;
            }
            pd.support = value;
        }
        if (context != null) {
            if (context.trim().equalsIgnoreCase("none")) {
                pd.context = 0;
            } else if (context.trim().equalsIgnoreCase("user")) {
                pd.context = 1;
            }
        }
        if (list != null) {
            int value = 0;
            int size = Arrays.asList(list).size();
            for (i = 0; i < size; ++i) {
                if (list[i].trim().equals("none")) {
                    value = 0;
                    break;
                }
                if (list[i].trim().equals("all")) {
                    value = 1;
                    break;
                }
                if (list[i].trim().equals("forward")) {
                    value += 2;
                }
                if (list[i].trim().equals("reply")) {
                    value += 8;
                }
                if (list[i].trim().equals("publish")) {
                    value += 4;
                }
                if (!list[i].trim().equals("report")) continue;
                value += 16;
            }
            pd.copyOptions = value;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 638, (Object)pd);
        }
        return pd;
    }

    private void setProperty(String name, MQPropertyDescriptor descriptor, Object value) throws MQException {
        int traceContext = 0;
        Vector valueList = null;
        int fid = 525;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 525, new Object[]{name, descriptor, value});
        }
        if (name != null) {
            if (name.startsWith("mq")) {
                name = this.makeMqFolderExplicit(name);
            } else {
                if (TYPE_MCD_ELEMENTS.contains(name)) {
                    int MQRC_PROPERTY_READ_ONLY = 2471;
                    MQException traceRet1 = new MQException(2, MQRC_PROPERTY_READ_ONLY, (Object)this);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 525, (Throwable)traceRet1);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 525, (Object)traceRet1, 2);
                    }
                    throw traceRet1;
                }
                if (!name.toLowerCase().startsWith("jms")) {
                    name = this.makeUsrFolderExplicit(name);
                }
            }
        }
        if (this.propertyValidation != 1) {
            this.validatePropertyName(name);
        }
        if (descriptor != null) {
            this.validatePropertyDescriptor(descriptor);
        }
        if (descriptor != null) {
            if (this.propertyDescTable.containsKey(name)) {
                Vector pdList = (Vector)this.propertyDescTable.get(name);
                if (pdList != null) {
                    pdList.addElement(descriptor);
                    this.propertyDescTable.put(name, pdList);
                }
            } else {
                Vector<MQPropertyDescriptor> pdList = new Vector<MQPropertyDescriptor>();
                pdList.addElement(descriptor);
                this.propertyDescTable.put(name, pdList);
            }
        }
        if (name.startsWith("Root.MQMD.")) {
            this.setMQMDProperty(name.substring(10), value);
        } else if (ALL_JMS_PROPERTY_NAMES.contains(name)) {
            this.setJmsProperty(name, value);
        } else {
            if (this.properties.containsKey(name)) {
                valueList = (Vector)this.properties.get(name);
                if (valueList != null) {
                    valueList.addElement(value);
                }
            } else {
                valueList = new Vector();
                valueList.addElement(value);
            }
            this.properties.put(name, valueList);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 525, 1);
        }
    }

    private void validatePropertyDescriptor(MQPropertyDescriptor descriptor) throws MQException {
        int traceContext = 0;
        int fid = 639;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 639, new Object[]{descriptor});
        }
        int context = descriptor.context;
        int version = descriptor.version;
        boolean throwException = false;
        if ((context & 0) != 0 && (context & 1) != 0) {
            throwException = true;
        }
        if (version > 1) {
            throwException = true;
        }
        if (throwException) {
            MQException traceRet1 = new MQException(2, 2482, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 639, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 639, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 639, 1);
        }
    }

    private void setMQMDProperty(String propName, Object value) throws MQException {
        int traceContext = 0;
        int fid = 640;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 640, new Object[]{propName, value});
        }
        if (propName.equalsIgnoreCase("report")) {
            this.report = (Integer)value;
        } else if (propName.equalsIgnoreCase("msgType")) {
            this.messageType = (Integer)value;
        } else if (propName.equalsIgnoreCase("expiry")) {
            this.expiry = (Integer)value;
        } else if (propName.equalsIgnoreCase("feedback")) {
            this.feedback = (Integer)value;
        } else if (propName.equalsIgnoreCase("encoding")) {
            this.encoding = (Integer)value;
        } else if (propName.equalsIgnoreCase("characterSet")) {
            this.characterSet = (Integer)value;
        } else if (propName.equalsIgnoreCase("format")) {
            this.format = value.toString();
        } else if (propName.equalsIgnoreCase("priority")) {
            this.priority = (Integer)value;
        } else if (propName.equalsIgnoreCase("persistence")) {
            this.persistence = (Integer)value;
        } else if (propName.equalsIgnoreCase("MsgId")) {
            this.setMessageId((byte[])value);
        } else if (propName.equalsIgnoreCase("correlId")) {
            this.setCorrelationId((byte[])value);
        } else if (propName.equalsIgnoreCase("ReplyToQ")) {
            this.replyToQueueName = value.toString();
        } else if (propName.equalsIgnoreCase("ReplyToQMgr")) {
            this.replyToQueueManagerName = value.toString();
        } else if (propName.equalsIgnoreCase("UserIdentifier")) {
            this.setJMSXUserID(value);
        } else if (propName.equalsIgnoreCase("accoundingToken")) {
            this.accountingToken = (byte[])value;
        } else if (propName.equalsIgnoreCase("applicationIdData")) {
            this.applicationIdData = value.toString();
        } else if (propName.equalsIgnoreCase("putApplicationType")) {
            this.putApplicationType = (Integer)value;
        } else if (propName.equalsIgnoreCase("putApplName")) {
            this.putApplicationName = (String)value;
        } else if (propName.equalsIgnoreCase("applicationOrginData")) {
            this.applicationOriginData = value.toString();
        } else if (propName.equalsIgnoreCase("groupId")) {
            if (value instanceof byte[]) {
                byte[] valueArray = (byte[])value;
                System.arraycopy(valueArray, 0, this.groupId, 0, Math.min(valueArray.length, this.groupId.length));
            }
        } else if (propName.equalsIgnoreCase("MsgSeqNumber")) {
            this.messageSequenceNumber = (Integer)value;
        } else if (propName.equalsIgnoreCase("offset")) {
            this.offset = (Integer)value;
        } else if (propName.equalsIgnoreCase("messageFlags")) {
            this.messageFlags = (Integer)value;
        } else if (propName.equalsIgnoreCase("originalLength")) {
            this.originalLength = (Integer)value;
        } else if (propName.equalsIgnoreCase("BackoutCount")) {
            this.backoutCount = (Integer)value;
        } else {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 640, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 640, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 640, 1);
        }
    }

    private Object getMQMDProperty(String propName) throws MQException {
        int traceContext = 0;
        int fid = 641;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 641, new Object[]{propName});
        }
        Object retvalue = null;
        if (propName.equalsIgnoreCase("report")) {
            retvalue = new Integer(this.report);
        } else if (propName.equalsIgnoreCase("msgType")) {
            retvalue = new Integer(this.messageType);
        } else if (propName.equalsIgnoreCase("expiry")) {
            retvalue = new Long(this.expiry);
        } else if (propName.equalsIgnoreCase("feedback")) {
            retvalue = new Integer(this.feedback);
        } else if (propName.equalsIgnoreCase("encoding")) {
            retvalue = new Integer(this.encoding);
        } else if (propName.equalsIgnoreCase("characterSet")) {
            retvalue = new Integer(this.characterSet);
        } else if (propName.equalsIgnoreCase("format")) {
            retvalue = new Integer(this.format);
        } else if (propName.equalsIgnoreCase("priority")) {
            retvalue = new Integer(this.priority);
        } else if (propName.equalsIgnoreCase("persistence")) {
            retvalue = new Integer(this.persistence);
        } else if (propName.equalsIgnoreCase("MsgId")) {
            retvalue = this.messageId;
        } else if (propName.equalsIgnoreCase("correlId")) {
            retvalue = this.correlationId;
        } else if (propName.equalsIgnoreCase("ReplyToQ")) {
            retvalue = this.replyToQueueName;
        } else if (propName.equalsIgnoreCase("ReplyToQMgr")) {
            retvalue = this.replyToQueueManagerName;
        } else if (propName.equalsIgnoreCase("UserIdentifier")) {
            retvalue = this.userId;
        } else if (propName.equalsIgnoreCase("accoundingToken")) {
            retvalue = this.accountingToken;
        } else if (propName.equalsIgnoreCase("applicationIdData")) {
            retvalue = this.applicationIdData;
        } else if (propName.equalsIgnoreCase("putApplicationType")) {
            retvalue = new Integer(this.putApplicationType);
        } else if (propName.equalsIgnoreCase("putApplName")) {
            retvalue = this.putApplicationName;
        } else if (propName.equalsIgnoreCase("putDate")) {
            retvalue = MQMessage.getDate(this.putDateTime);
        } else if (propName.equalsIgnoreCase("putTime")) {
            retvalue = MQMessage.getTime(this.putDateTime);
        } else if (propName.equalsIgnoreCase("applicationOrginData")) {
            retvalue = this.applicationOriginData;
        } else if (propName.equalsIgnoreCase("groupId")) {
            retvalue = this.groupId;
        } else if (propName.equalsIgnoreCase("MsgSeqNumber")) {
            retvalue = new Integer(this.messageSequenceNumber);
        } else if (propName.equalsIgnoreCase("offset")) {
            retvalue = new Integer(this.offset);
        } else if (propName.equalsIgnoreCase("messageFlags")) {
            retvalue = new Integer(this.messageFlags);
        } else if (propName.equalsIgnoreCase("originalLength")) {
            retvalue = new Integer(this.originalLength);
        } else if (propName.equalsIgnoreCase("BackoutCount")) {
            retvalue = new Integer(this.backoutCount);
        } else {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 641, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 641, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 641, retvalue, 1);
        }
        return retvalue;
    }

    private byte[] hexToBin(String hex, int start) throws MQException {
        int length;
        int traceContext = 0;
        int fid = 642;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 642, new Object[]{hex, new Integer(start)});
        }
        if ((length = hex.length() - start) == 0) {
            byte[] result = new byte[]{};
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 642, (Object)result, 1);
            }
            return result;
        }
        if (length < 0 || length % 2 != 0) {
            MQException traceRet1 = new MQException(2, 2207, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 642, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 642, (Object)traceRet1, 3);
            }
            throw traceRet1;
        }
        byte[] retval = new byte[length /= 2];
        for (int i = 0; i < length; ++i) {
            int digit1 = Character.digit(hex.charAt(2 * i + start), 16) << 4;
            int digit2 = Character.digit(hex.charAt(2 * i + start + 1), 16);
            if (digit1 < 0 || digit2 < 0) {
                MQException traceRet1 = new MQException(2, 2207, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 642, (Throwable)traceRet1, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 642, (Object)traceRet1, 4);
                }
                throw traceRet1;
            }
            retval[i] = (byte)(digit1 + digit2);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 642, (Object)retval, 2);
        }
        return retval;
    }

    private int binToHex(byte[] bin, int start, int length, StringBuffer hex) {
        int traceContext = 0;
        int fid = 643;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 643, new Object[]{bin, new Integer(start), new Integer(length), hex});
        }
        int binByte = 0;
        int sum = 0;
        for (int i = start; i < start + length; ++i) {
            binByte = bin[i];
            if (binByte < 0) {
                binByte += 256;
            }
            sum += binByte;
            hex.append(BIN2HEX[binByte / 16]);
            hex.append(BIN2HEX[binByte % 16]);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 643, (Object)new Integer(sum));
        }
        return sum;
    }

    private void setMessageId(byte[] msgId) {
        int i;
        int traceContext = 0;
        int fid = 644;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 644, new Object[]{msgId});
        }
        byte[] mid = new byte[24];
        int length = msgId.length;
        if (length > 24) {
            length = 24;
        }
        for (i = 0; i < length; ++i) {
            mid[i] = msgId[i];
        }
        for (i = length; i < 24; ++i) {
            mid[i] = 0;
        }
        this.messageId = mid;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 644);
        }
    }

    private void setCorrelationId(byte[] correlId) {
        int i;
        int traceContext = 0;
        int fid = 645;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 645, new Object[]{correlId});
        }
        byte[] cid = new byte[24];
        int length = correlId.length;
        if (length > 24) {
            length = 24;
        }
        for (i = 0; i < length; ++i) {
            cid[i] = correlId[i];
        }
        for (i = length; i < 24; ++i) {
            cid[i] = 0;
        }
        this.correlationId = cid;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 645);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setJmsProperty(String name, Object value) throws MQException {
        int traceContext;
        block8: {
            block9: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                traceContext = 0;
                                                                int fid = 646;
                                                                if (this.trace.isOn) {
                                                                    traceContext = this.trace.entry_OO((Object)this, COMP_JN, 646, new Object[]{name, value});
                                                                }
                                                                if (!SETTABLE_JMS_PROPERTY_NAMES.contains(name)) break block9;
                                                                if (!name.equalsIgnoreCase("JMSCorrelationID")) break block10;
                                                                this.setJMSCorrelationID(value);
                                                                break block8;
                                                            }
                                                            if (!name.equalsIgnoreCase("JMSDeliveryMode")) break block11;
                                                            this.setJMSDeliveryMode(value);
                                                            break block8;
                                                        }
                                                        if (!name.equalsIgnoreCase("JMSDestination")) break block12;
                                                        this.setJMSDestination(value);
                                                        break block8;
                                                    }
                                                    if (!name.equalsIgnoreCase("JMSExpiration")) break block13;
                                                    this.setJMSExpiration(value);
                                                    break block8;
                                                }
                                                if (!name.equalsIgnoreCase("JMSMessageID")) break block14;
                                                this.setJMSMessageID(value);
                                                break block8;
                                            }
                                            if (!name.equalsIgnoreCase("JMSPriority")) break block15;
                                            this.setJMSPriority(value);
                                            break block8;
                                        }
                                        if (!name.equalsIgnoreCase("JMSReplyTo")) break block16;
                                        this.setJMSReplyTo(value);
                                        break block8;
                                    }
                                    if (!name.equalsIgnoreCase("JMSType")) break block17;
                                    this.setJMSType(value);
                                    break block8;
                                }
                                if (!name.equalsIgnoreCase("JMSTimestamp")) break block18;
                                this.setJMSTimeStamp(value);
                                break block8;
                            }
                            if (!name.equalsIgnoreCase("JMSXAppID")) break block19;
                            this.setJMSXAppID(value);
                            break block8;
                        }
                        if (!name.equalsIgnoreCase("JMSXDeliveryCount")) break block20;
                        this.setJMSXDeliveryCount(value);
                        break block8;
                    }
                    if (!name.equalsIgnoreCase("JMSXGroupID")) break block21;
                    this.setJMSXGroupID(value);
                    break block8;
                }
                if (name.equalsIgnoreCase("JMSXGroupSeq")) {
                    this.setJMSXGroupSeq(value);
                    break block8;
                } else if (name.equalsIgnoreCase("JMSXUserID")) {
                    this.setJMSXUserID(value);
                    break block8;
                } else {
                    MQException traceRet1 = new MQException(2, 2442, (Object)this);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 646, (Throwable)traceRet1, 1);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 646, (Object)traceRet1, 2);
                    }
                    throw traceRet1;
                }
            }
            int MQRC_PROPERTY_READ_ONLY = 2471;
            MQException traceRet1 = new MQException(2, MQRC_PROPERTY_READ_ONLY, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 646, (Throwable)traceRet1, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 646, (Object)traceRet1, 3);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 646, 1);
        }
    }

    private Object getJmsProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 647;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 647, new Object[]{name});
        }
        Object result = null;
        if (ALL_JMS_PROPERTY_NAMES.contains(name)) {
            if (name.equalsIgnoreCase("JMSXAppID")) {
                result = this.getJMSXAppID();
            } else if (name.equalsIgnoreCase("JMSXDeliveryCount")) {
                result = this.getJMSXDeliveryCount();
            } else if (name.equalsIgnoreCase("JMSXUserID")) {
                result = this.getJMSXUserID();
            } else if (name.equalsIgnoreCase("JMSCorrelationID")) {
                result = this.getJMSCorrelationID();
            } else if (name.equalsIgnoreCase("JMSDeliveryMode")) {
                result = this.getJMSDeliveryMode();
            } else if (name.equalsIgnoreCase("JMSDestination")) {
                result = this.getJMSDestination();
            } else if (name.equalsIgnoreCase("JMSExpiration")) {
                result = this.getJMSExpiration();
            } else if (name.equalsIgnoreCase("JMSMessageID")) {
                result = this.getJMSMessageID();
            } else if (name.equalsIgnoreCase("JMSPriority")) {
                result = this.getJMSPriority();
            } else if (name.equalsIgnoreCase("JMSReplyTo")) {
                result = this.getJMSReplyTo();
            } else if (name.equalsIgnoreCase("JMSTimestamp")) {
                result = this.getJMSTimestamp();
            } else if (name.equalsIgnoreCase("JMSType")) {
                result = this.getJMSType();
            } else if (name.equalsIgnoreCase("JMSXGroupID")) {
                result = this.getJMSXGroupID();
            } else if (name.equalsIgnoreCase("JMSXGroupSeq")) {
                result = this.getJMSXGroupSeq();
            }
        } else {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 647, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 647, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 647, result, 1);
        }
        return result;
    }

    private void setJMSCorrelationID(Object value) throws MQException {
        int traceContext;
        block14: {
            traceContext = 0;
            int fid = 694;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 694, new Object[]{value});
            }
            try {
                if (value instanceof String) {
                    String jmsCorrelId = value.toString();
                    if (jmsCorrelId.length() >= 3 && jmsCorrelId.substring(0, 3).equalsIgnoreCase("id:")) {
                        jmsCorrelId = jmsCorrelId.substring(3, jmsCorrelId.length() - 3);
                        this.setMQMDProperty("correlId", this.hexToBin(jmsCorrelId, 0));
                        break block14;
                    }
                    try {
                        this.setMQMDProperty("correlId", jmsCorrelId.getBytes("UTF-8"));
                        Vector<Object> valueList = new Vector<Object>();
                        valueList.addElement(value);
                        this.properties.put("jms.Cid", valueList);
                        break block14;
                    }
                    catch (UnsupportedEncodingException ex) {
                        if (this.trace.isOn) {
                            this.trace.catchBlock((Object)this, COMP_JN, 694, (Throwable)ex, 1);
                        }
                        MQException traceRet1 = new MQException(2, 6106, (Object)this);
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 694, (Throwable)traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                }
                if (value instanceof byte[]) {
                    this.setMQMDProperty("correlId", value);
                    break block14;
                }
                MQException traceRet1 = new MQException(2, 2207, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 694, (Throwable)traceRet1, 2);
                }
                throw traceRet1;
            }
            catch (Exception ex) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 694, (Throwable)ex, 2);
                }
                MQException traceRet1 = new MQException(2, 2473, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 694, (Throwable)traceRet1, 3);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 694, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 694, 1);
        }
    }

    private Object getJMSCorrelationID() throws MQException {
        Object result;
        int traceContext = 0;
        int fid = 695;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 695);
        }
        if (this.properties.containsKey("jms.Cid")) {
            Vector valueList = (Vector)this.properties.get("jms.Cid");
            result = valueList.elementAt(0);
        } else {
            StringBuffer hex = new StringBuffer();
            byte[] correlId = (byte[])this.getMQMDProperty("correlId");
            this.binToHex(correlId, 0, correlId.length, hex);
            hex.insert(0, "ID:");
            result = new String(hex);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 695, result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setJMSDeliveryMode(Object value) throws MQException {
        block8: {
            int traceContext;
            block9: {
                block7: {
                    traceContext = 0;
                    int fid = 696;
                    if (this.trace.isOn) {
                        traceContext = this.trace.entry_OO((Object)this, COMP_JN, 696, new Object[]{value});
                    }
                    if (!(value instanceof Integer)) break block7;
                    if ((Integer)value == 1) {
                        this.setMQMDProperty("persistence", value);
                    } else if ((Integer)value == 0) {
                        this.setMQMDProperty("persistence", value);
                    } else {
                        MQException traceRet1 = new MQException(2, 2047, (Object)this);
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 696, (Throwable)traceRet1, 1);
                            this.trace.exit(traceContext, (Object)this, COMP_JN, 696, (Object)traceRet1, 2);
                        }
                        throw traceRet1;
                    }
                    Vector<Object> valueList = new Vector<Object>();
                    valueList.addElement(value);
                    this.properties.put("jms.Dlv", valueList);
                    if (!this.trace.isOn) break block8;
                    break block9;
                }
                MQException traceRet1 = new MQException(2, 2473, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 696, (Throwable)traceRet1, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 696, (Object)traceRet1, 3);
                }
                throw traceRet1;
            }
            this.trace.exit(traceContext, (Object)this, COMP_JN, 696, 1);
        }
    }

    private Object getJMSDeliveryMode() throws MQException {
        Object result;
        int traceContext = 0;
        int fid = 697;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 697);
        }
        if (this.properties.containsKey("jms.Dlv")) {
            Vector valueList = (Vector)this.properties.get("jms.Dlv");
            result = valueList.elementAt(0);
        } else {
            result = this.getMQMDProperty("persistence");
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 697, result);
        }
        return result;
    }

    private void setJMSDestination(Object value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 954, "setting to: ", value);
        }
        Vector<Object> valueList = new Vector<Object>();
        valueList.addElement(value);
        this.properties.put("jms.Dst", valueList);
    }

    private Object getJMSDestination() throws MQException {
        int traceContext = 0;
        int fid = 698;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 698);
        }
        if (!this.properties.containsKey("jms.Dst")) {
            MQException traceRet1 = new MQException(2, 2471, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 698, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 698, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        Vector valueList = (Vector)this.properties.get("jms.Dst");
        Object result = valueList.elementAt(0);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 698, result, 1);
        }
        return result;
    }

    private void setJMSExpiration(Object value) throws MQException {
        int traceContext = 0;
        int fid = 699;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 699, new Object[]{value});
        }
        try {
            if (!(value instanceof Long)) {
                MQException traceRet1 = new MQException(2, 2473, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 699, (Throwable)traceRet1, 1);
                }
                throw traceRet1;
            }
            long ttl = (Long)value;
            if (ttl == 0L) {
                this.setMQMDProperty("expiry", UNLIMITED_EXPIRY);
            } else {
                long timeToLive = ttl - System.currentTimeMillis();
                if (timeToLive < 0L || timeToLive > 214748364700L) {
                    this.setMQMDProperty("expiry", UNLIMITED_EXPIRY);
                } else {
                    this.setMQMDProperty("expiry", new Long((int)((timeToLive + 100L) / 100L)));
                }
                Vector<Object> valueList = new Vector<Object>();
                valueList.addElement(value);
                this.properties.put("jms.Exp", valueList);
            }
        }
        catch (Exception ex) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 699, (Throwable)ex);
            }
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 699, (Throwable)traceRet1, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 699, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 699, 1);
        }
    }

    private Object getJMSExpiration() {
        Long result;
        int traceContext = 0;
        int fid = 700;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 700);
        }
        if (this.properties.containsKey("jms.Exp")) {
            Vector valueList = (Vector)this.properties.get("jms.Exp");
            result = valueList.elementAt(0);
        } else {
            result = new Long(0L);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 700, (Object)result);
        }
        return result;
    }

    private void setJMSMessageID(Object value) throws MQException {
        int traceContext;
        block10: {
            traceContext = 0;
            int fid = 701;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 701, new Object[]{value});
            }
            try {
                if (value instanceof String) {
                    String jmsMsgId = value.toString();
                    if (jmsMsgId.length() >= 3 && jmsMsgId.substring(0, 3).equalsIgnoreCase("ID:")) {
                        jmsMsgId = jmsMsgId.substring(3, jmsMsgId.length() - 3);
                        this.setMQMDProperty("MsgId", this.hexToBin(jmsMsgId, 0));
                    }
                    break block10;
                }
                if (value instanceof byte[]) {
                    this.setMQMDProperty("MsgId", value);
                    break block10;
                }
                MQException traceRet1 = new MQException(2, 2473, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 701, (Throwable)traceRet1, 1);
                }
                throw traceRet1;
            }
            catch (Exception ex) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 701, (Throwable)ex);
                }
                MQException traceRet1 = new MQException(2, 2206, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 701, (Throwable)traceRet1, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 701, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 701, 1);
        }
    }

    private Object getJMSMessageID() throws MQException {
        int traceContext = 0;
        int fid = 702;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 702);
        }
        StringBuffer hex = new StringBuffer();
        byte[] msgId = (byte[])this.getMQMDProperty("MsgId");
        this.binToHex(msgId, 0, msgId.length, hex);
        hex.insert(0, "ID:");
        String result = new String(hex);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 702, (Object)result);
        }
        return result;
    }

    private void setJMSPriority(Object value) throws MQException {
        int traceContext = 0;
        int fid = 703;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 703, new Object[]{value});
        }
        if (value instanceof Integer) {
            this.setMQMDProperty("priority", value);
            if ((Integer)value != 4) {
                Vector<Object> valueList = new Vector<Object>();
                valueList.addElement(value);
                this.properties.put("jms.Pri", valueList);
            }
        } else {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 703, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 703, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 703, 1);
        }
    }

    private Object getJMSPriority() throws MQException {
        Object result;
        int traceContext = 0;
        int fid = 704;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 704);
        }
        if (this.properties.containsKey("jms.Pri")) {
            Vector valueList = (Vector)this.properties.get("jms.Pri");
            result = valueList.elementAt(0);
        } else {
            result = this.getMQMDProperty("priority");
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 704, result);
        }
        return result;
    }

    private void setJMSReplyTo(Object value) throws MQException {
        int traceContext = 0;
        int fid = 705;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 705, new Object[]{value});
        }
        String uri = value.toString();
        try {
            if (uri.startsWith(replyToURI)) {
                String[] uriSubstrings = uri.trim().split("/");
                if (uriSubstrings[2].length() != 0) {
                    this.setMQMDProperty("ReplyToQMgr", uriSubstrings[2]);
                }
                this.setMQMDProperty("ReplyToQ", uriSubstrings[3]);
            } else {
                this.setMQMDProperty("ReplyToQ", uri.trim());
            }
            Vector<Object> valueList = new Vector<Object>();
            valueList.addElement(value);
            this.properties.put("jms.Rto", valueList);
        }
        catch (Exception ex) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 705, (Throwable)ex);
            }
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 705, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 705, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 705, 1);
        }
    }

    private Object getJMSReplyTo() throws MQException {
        int traceContext = 0;
        int fid = 706;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 706);
        }
        Object result = null;
        if (!this.properties.containsKey("jms.Rto")) {
            MQException traceRet1 = new MQException(2, 2471, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 706, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 706, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        Vector valueList = (Vector)this.properties.get("jms.Rto");
        result = valueList.elementAt(0);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 706, result, 1);
        }
        return result;
    }

    private void setJMSTimeStamp(Object value) throws MQException {
        int traceContext = 0;
        int fid = 707;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 707, new Object[]{value});
        }
        if (!(value instanceof Long)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 707, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 707, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        Vector<Object> valueList = new Vector<Object>();
        valueList.addElement(value);
        this.properties.put("jms.Tms", valueList);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 707, 1);
        }
    }

    private Object getJMSTimestamp() throws MQException {
        int traceContext = 0;
        int fid = 708;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 708);
        }
        Long result = null;
        if (this.properties.containsKey("jms.Tms")) {
            Vector valueList = (Vector)this.properties.get("jms.Tms");
            Object jts = valueList.elementAt(0);
            if (jts instanceof Long) {
                result = jts;
            } else if (jts instanceof String) {
                String jtsAsString = (String)jts;
                result = new Long(Long.parseLong(jtsAsString));
            }
        } else {
            result = new Long(this.putDateTime.getTimeInMillis());
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 708, (Object)result);
        }
        return result;
    }

    private void setJMSType(Object value) throws MQException {
        String uri;
        int traceContext = 0;
        int fid = 709;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 709, new Object[]{value});
        }
        if (!(uri = value.toString()).startsWith(mcdURI)) {
            Vector<Object> valueList = new Vector<Object>();
            valueList.addElement(value);
            String domain = "";
            Vector<String> domainVector = new Vector<String>();
            this.properties.put("mcd.Type", valueList);
            domain = "MQSTR   ".equals(this.format) ? "jms_text" : "jms_bytes";
            domainVector.addElement(domain);
            this.properties.put("mcd.Msd", domainVector);
        } else {
            try {
                String myFormat;
                String[] uriSubstrings = uri.split("[/?=]");
                String domain = uriSubstrings[2];
                String set = uriSubstrings[3];
                String type = uriSubstrings[4];
                String string = myFormat = uriSubstrings[5].equalsIgnoreCase("format") ? uriSubstrings[6] : null;
                if (domain.length() == 0) {
                    domain = "MQSTR   ".equals(myFormat) ? "jms_text" : "jms_bytes";
                }
                Vector<String> valueList = new Vector<String>();
                valueList.addElement(type);
                this.properties.put("mcd.Type", valueList);
                Vector<String> valueListSet = new Vector<String>();
                valueListSet.addElement(set);
                this.properties.put("mcd.Set", valueListSet);
                Vector<String> valueListFmt = new Vector<String>();
                valueListFmt.addElement(myFormat);
                this.properties.put("mcd.Fmt", valueListFmt);
                Vector<String> domainVector = new Vector<String>();
                domainVector.addElement(domain);
                this.properties.put("mcd.Msd", domainVector);
            }
            catch (Exception ex) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 709, (Throwable)ex);
                }
                MQException traceRet1 = new MQException(2, 2473, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 709, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 709, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 709, 1);
        }
    }

    private Object getJMSType() throws MQException {
        int traceContext = 0;
        int fid = 710;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 710);
        }
        String result = null;
        String domain = null;
        int domainlen = 0;
        String type = null;
        String set = null;
        String fmt = null;
        if (!this.properties.containsKey("mcd.Type")) {
            MQException traceRet1 = new MQException(2, 2471, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 710, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 710, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        Vector valueList = (Vector)this.properties.get("mcd.Type");
        result = type = (String)valueList.elementAt(0);
        if (this.properties.containsKey("mcd.Msd")) {
            valueList = (Vector)this.properties.get("mcd.Msd");
            domain = (String)valueList.elementAt(0);
            domainlen = domain.length();
        } else {
            domain = "MQSTR   ".equals(this.format) ? "jms_text" : "jms_bytes";
        }
        if (this.properties.containsKey("mcd.Set")) {
            valueList = (Vector)this.properties.get("mcd.Set");
            set = (String)valueList.elementAt(0);
        }
        if (this.properties.containsKey("mcd.Fmt")) {
            valueList = (Vector)this.properties.get("mcd.Fmt");
            fmt = (String)valueList.elementAt(0);
        }
        if (set != null || fmt != null) {
            String mcdFormatString = fmt == null || fmt.equals("") ? "mcd://{0}/{1}/{2}" : "mcd://{0}/{1}/{2}?format={3}";
            result = MessageFormat.format(mcdFormatString, domain, set, type, fmt);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 710, (Object)result, 1);
        }
        return result;
    }

    private void setJMSXAppID(Object value) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 955, "setting to: ", value);
        }
        this.setMQMDProperty("putApplName", value);
    }

    private Object getJMSXAppID() throws MQException {
        Object traceRet1 = this.getMQMDProperty("putApplName");
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 956, "returning: ", traceRet1);
        }
        return traceRet1;
    }

    private void setJMSXDeliveryCount(Object value) throws MQException {
        int traceContext = 0;
        int fid = 711;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 711, new Object[]{value});
        }
        if (!(value instanceof Integer)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 711, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 711, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        this.setMQMDProperty("BackoutCount", value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 711, 1);
        }
    }

    private Object getJMSXDeliveryCount() throws MQException {
        Object traceRet1 = this.getMQMDProperty("BackoutCount");
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 957, "returning: ", traceRet1);
        }
        return traceRet1;
    }

    private void setJMSXGroupID(Object value) throws MQException {
        int traceContext = 0;
        int fid = 712;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 712, new Object[]{value});
        }
        if (value instanceof String) {
            Vector<Object> valueList = new Vector<Object>();
            valueList.add(value);
            this.properties.put("jms.Gid", valueList);
            try {
                this.setMQMDProperty("groupId", ((String)value).getBytes(this.getCharacterSetString(this.characterSet)));
            }
            catch (UnsupportedEncodingException e) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 712, (Throwable)e, 1);
                }
                MQException traceRet1 = new MQException(2, 2330, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 712, (Throwable)traceRet1, 1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 712, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
            catch (UnsupportedCharsetException e) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 712, (Throwable)e, 2);
                }
                MQException traceRet1 = new MQException(2, 2330, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 712, (Throwable)traceRet1, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 712, (Object)traceRet1, 3);
                }
                throw traceRet1;
            }
        } else {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 712, (Throwable)traceRet1, 3);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 712, (Object)traceRet1, 4);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 712, 1);
        }
    }

    private Object getJMSXGroupID() throws MQException {
        int traceContext = 0;
        int fid = 713;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 713);
        }
        String result = null;
        if (this.properties.containsKey("jms.Gid")) {
            Vector valueList = (Vector)this.properties.get("jms.Gid");
            result = (String)valueList.elementAt(0);
        } else {
            byte[] groupIdProperty = (byte[])this.getMQMDProperty("groupId");
            if (groupIdProperty != null) {
                try {
                    result = new String(groupIdProperty, this.getCharacterSetString(this.characterSet));
                }
                catch (UnsupportedEncodingException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 713, (Throwable)e);
                    }
                    MQException traceRet1 = new MQException(2, 2330, (Object)this);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 713, (Throwable)traceRet1);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 713, (Object)traceRet1, 2);
                    }
                    throw traceRet1;
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 713, (Object)result, 1);
        }
        return result;
    }

    private void setJMSXGroupSeq(Object value) throws MQException {
        int traceContext = 0;
        int fid = 714;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 714, new Object[]{value});
        }
        if (!(value instanceof Integer)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 714, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 714, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        Vector<Object> valueList = new Vector<Object>();
        valueList.add(value);
        this.properties.put("jms.Seq", valueList);
        this.setMQMDProperty("MsgSeqNumber", value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 714, 1);
        }
    }

    private Object getJMSXGroupSeq() throws MQException {
        Object result;
        int traceContext = 0;
        int fid = 715;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 715);
        }
        if (this.properties.containsKey("jms.Seq")) {
            Vector valueList = (Vector)this.properties.get("jms.Seq");
            result = valueList.elementAt(0);
        } else {
            result = this.getMQMDProperty("MsgSeqNumber");
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 715, result);
        }
        return result;
    }

    private void setJMSXUserID(Object value) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 958, "setting to: ", value);
        }
        this.setMQMDProperty("UserIdentifier", value);
    }

    private Object getJMSXUserID() throws MQException {
        Object traceRet1 = this.getMQMDProperty("UserIdentifier");
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 959, "returning: ", traceRet1);
        }
        return traceRet1;
    }

    private String makeUsrFolderExplicit(String name) throws MQException {
        int traceContext = 0;
        int fid = 526;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 526, new Object[]{name});
        }
        if (name == null || name.length() <= 0) {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 526, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 526, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (name.indexOf(".") < 0) {
            name = "usr." + name;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 526, (Object)name, 1);
        }
        return name;
    }

    private String makeMqFolderExplicit(String name) throws MQException {
        int traceContext = 0;
        int fid = 648;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 648, new Object[]{name});
        }
        if (name == null || name.length() <= 0) {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 648, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 648, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (name.equalsIgnoreCase("top") || name.equalsIgnoreCase("topicstring")) {
            name = "mqps." + name;
        } else if (name.indexOf(".") < 0) {
            name = "mq." + name;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 648, (Object)name, 1);
        }
        return name;
    }

    private String removeExplicitUsrFolder(String name) throws MQException {
        int traceContext = 0;
        int fid = 527;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 527, new Object[]{name});
        }
        if (name == null || name.length() <= 0) {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 527, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 527, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (name.startsWith("usr.")) {
            name = name.substring("usr".length() + ".".length());
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 527, (Object)name, 1);
        }
        return name;
    }

    private void validatePropertyName(String name) throws MQException {
        int traceContext = 0;
        int fid = 528;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 528, new Object[]{name});
        }
        if (!ALL_JMS_PROPERTY_NAMES.contains(name)) {
            this.validatePropertyNameReservedJmsNames(name);
            this.validatePropertyNameReservedJmsInternalNames(name);
            this.validatePropertyNameReservedSqlNames(name);
            this.validatePropertyNameReservedHierarchyNames(name);
            this.validatePropertyNameJavaIdentifiers(name);
            this.validatePropertyNameForNestedGroupsInReservedFolders(name);
            this.validatePropertyNameSeperators(name);
            this.validatePropertyNameMixedContent(name);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 528);
        }
    }

    private void validatePropertyNameReservedJmsNames(String name) throws MQException {
        int traceContext = 0;
        int fid = 529;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 529, new Object[]{name});
        }
        if ((name = this.removeExplicitUsrFolder(name)).startsWith("JMS") && !ALL_JMS_PROPERTY_NAMES.contains(name)) {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 529, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 529, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 529, 1);
        }
    }

    private void validatePropertyNameReservedJmsInternalNames(String name) throws MQException {
        int traceContext = 0;
        int fid = 758;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 758, new Object[]{name});
        }
        if ((name = this.removeExplicitUsrFolder(name)).startsWith("jms.") && !JMSPropertySynonyms.containsKey(name)) {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 758, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 758, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 758, 1);
        }
    }

    private void validatePropertyNameReservedSqlNames(String name) throws MQException {
        int traceContext = 0;
        int fid = 530;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 530, new Object[]{name});
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            if (!RESERVED_SQL_PROPERTY_NAMES.contains(currentToken.toUpperCase())) continue;
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 530, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 530, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 530, 1);
        }
    }

    private void validatePropertyNameReservedHierarchyNames(String name) throws MQException {
        int traceContext = 0;
        int fid = 531;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 531, new Object[]{name});
        }
        Iterator reservedHierarchyNamePrefixes = RESERVED_HIERARCHY_PROPERTY_NAME_PREFIXES.iterator();
        if (!ALLOWED_HIERARCHY_PROPERTY_NAMES.contains(name)) {
            while (reservedHierarchyNamePrefixes.hasNext()) {
                String reservedHierarchyNamePrefix = (String)reservedHierarchyNamePrefixes.next();
                if (!name.startsWith(reservedHierarchyNamePrefix) || name.startsWith("Root.MQMD.")) continue;
                MQException traceRet1 = new MQException(2, 2442, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 531, (Throwable)traceRet1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 531, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 531, 1);
        }
    }

    private void validatePropertyNameJavaIdentifiers(String name) throws MQException {
        int traceContext = 0;
        int fid = 532;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 532, new Object[]{name});
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            if (!Character.isJavaIdentifierStart(currentToken.charAt(0))) {
                MQException traceRet1 = new MQException(2, 2442, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 532, (Throwable)traceRet1, 1);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 532, (Object)traceRet1, 2);
                }
                throw traceRet1;
            }
            for (int i = 1; i < currentToken.length(); ++i) {
                if (Character.isJavaIdentifierPart(currentToken.charAt(i))) continue;
                MQException traceRet2 = new MQException(2, 2442, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 532, (Throwable)traceRet2, 2);
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 532, (Object)traceRet2, 3);
                }
                throw traceRet2;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 532, 1);
        }
    }

    private void validatePropertyNameForNestedGroupsInReservedFolders(String name) throws MQException {
        int fid = 533;
        int traceContext = 0;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 533, new Object[]{name});
        }
        String folder = this.getPropertyFolder(name);
        Iterator restricedHierarchyFolderNames = RESTRICTED_HIERARCHY_FOLDER_NAMES.iterator();
        while (restricedHierarchyFolderNames.hasNext()) {
            int hierarchyDepth;
            String currentRestrictedHierarchyFolderName = (String)restricedHierarchyFolderNames.next();
            if (!folder.startsWith(currentRestrictedHierarchyFolderName) || (hierarchyDepth = new StringTokenizer(name, ".").countTokens() - 1) <= 1) continue;
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 533, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 533, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 533, 1);
        }
    }

    private void validatePropertyNameSeperators(String name) throws MQException {
        int traceContext = 0;
        int fid = 534;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 534, new Object[]{name});
        }
        if (name.indexOf("..") >= 0 || name.startsWith(".") || name.endsWith(".")) {
            MQException traceRet1 = new MQException(2, 2442, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 534, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 534, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 534, 1);
        }
    }

    private void validatePropertyNameMixedContent(String name) throws MQException {
        int traceContext = 0;
        int fid = 535;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 535, new Object[]{name});
        }
        Iterator propertiesIterator = this.properties.keySet().iterator();
        while (propertiesIterator.hasNext()) {
            String currentProperty = (String)propertiesIterator.next();
            if (name.equalsIgnoreCase(currentProperty)) continue;
            String newPropertyAsGroup = name + ".";
            String newPropertyOwningGroup = name.substring(0, name.lastIndexOf("."));
            if (!currentProperty.startsWith(newPropertyAsGroup) && !currentProperty.equals(newPropertyOwningGroup)) continue;
            MQException traceRet1 = new MQException(2, 2498, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 535, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 535, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 535, 1);
        }
    }

    private Object getProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        Vector pdList;
        int traceContext = 0;
        int fid = 536;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 536, new Object[]{name, descriptor});
        }
        Object result = null;
        Vector valueList = null;
        MQPropertyDescriptor pd = null;
        if (name == null) {
            MQException traceRet1 = new MQException(2, 2471, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 536, (Throwable)traceRet1, 1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 536, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (name.startsWith("Root.MQMD.")) {
            result = this.getMQMDProperty(name.substring("Root.MQMD.".length()));
        } else if (ALL_JMS_PROPERTY_NAMES.contains(name)) {
            result = this.getJmsProperty(name);
        } else if (name.toLowerCase().startsWith("mq")) {
            name = this.makeMqFolderExplicit(name);
        } else if (!(TYPE_MCD_ELEMENTS.contains(name) || JMSPropertySynonyms.containsKey(name) || this.properties.containsKey(name = this.makeUsrFolderExplicit(name)))) {
            MQException traceRet1 = new MQException(2, 2471, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 536, (Throwable)traceRet1, 2);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 536, (Object)traceRet1, 3);
            }
            throw traceRet1;
        }
        valueList = (Vector)this.properties.get(name);
        if (valueList != null && valueList.size() > 0) {
            result = valueList.elementAt(0);
            valueList.remove(result);
            valueList.addElement(result);
        }
        if (this.propertyDescTable.containsKey(name) && (pdList = (Vector)this.propertyDescTable.get(name)) != null && pdList.size() > 0) {
            pd = (MQPropertyDescriptor)((Object)pdList.elementAt(0));
            if (pdList.size() > 1) {
                pdList.remove((Object)descriptor);
                pdList.addElement(descriptor);
            }
            if (descriptor != null) {
                descriptor.context = pd.context;
                descriptor.copyOptions = pd.copyOptions;
                descriptor.support = pd.support;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 536, result, 1);
        }
        return result;
    }

    public void setBooleanProperty(String name, boolean value) throws MQException {
        int traceContext = 0;
        int fid = 537;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 537, new Object[]{name, value});
        }
        this.setBooleanProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 537);
        }
    }

    public void setBooleanProperty(String name, MQPropertyDescriptor descriptor, boolean value) throws MQException {
        int traceContext = 0;
        int fid = 538;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 538, new Object[]{name, descriptor, value});
        }
        this.setProperty(name, descriptor, new Boolean(value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 538);
        }
    }

    public void setBytesProperty(String name, byte[] value) throws MQException {
        int traceContext = 0;
        int fid = 539;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 539, new Object[]{name, value});
        }
        this.setBytesProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 539);
        }
    }

    public void setBytesProperty(String name, MQPropertyDescriptor descriptor, byte[] value) throws MQException {
        int traceContext = 0;
        int fid = 540;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 540, new Object[]{name, descriptor, value});
        }
        this.setProperty(name, descriptor, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 540);
        }
    }

    public void setByteProperty(String name, byte value) throws MQException {
        int traceContext = 0;
        int fid = 541;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 541, new Object[]{name, new Byte(value)});
        }
        this.setByteProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 541);
        }
    }

    public void setByteProperty(String name, MQPropertyDescriptor descriptor, byte value) throws MQException {
        int traceContext = 0;
        int fid = 542;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 542, new Object[]{name, descriptor, new Byte(value)});
        }
        this.setProperty(name, descriptor, new Byte(value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 542);
        }
    }

    public void setShortProperty(String name, short value) throws MQException {
        int traceContext = 0;
        int fid = 543;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 543, new Object[]{name, new Short(value)});
        }
        this.setShortProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 543);
        }
    }

    public void setShortProperty(String name, MQPropertyDescriptor descriptor, short value) throws MQException {
        int traceContext = 0;
        int fid = 544;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 544, new Object[]{name, descriptor, new Short(value)});
        }
        this.setProperty(name, descriptor, new Short(value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 544);
        }
    }

    public void setInt2Property(String name, short value) throws MQException {
        int traceContext = 0;
        int fid = 545;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 545, new Object[]{name, new Short(value)});
        }
        this.setShortProperty(name, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 545);
        }
    }

    public void setInt2Property(String name, MQPropertyDescriptor descriptor, short value) throws MQException {
        int traceContext = 0;
        int fid = 546;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 546, new Object[]{name, descriptor, new Short(value)});
        }
        this.setShortProperty(name, descriptor, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 546);
        }
    }

    public void setIntProperty(String name, int value) throws MQException {
        int traceContext = 0;
        int fid = 547;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 547, new Object[]{name, new Integer(value)});
        }
        this.setIntProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 547);
        }
    }

    public void setIntProperty(String name, MQPropertyDescriptor descriptor, int value) throws MQException {
        int traceContext = 0;
        int fid = 548;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 548, new Object[]{name, descriptor, new Integer(value)});
        }
        this.setProperty(name, descriptor, new Integer(value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 548);
        }
    }

    public void setInt4Property(String name, int value) throws MQException {
        int traceContext = 0;
        int fid = 549;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 549, new Object[]{name, new Integer(value)});
        }
        this.setIntProperty(name, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 549);
        }
    }

    public void setInt4Property(String name, MQPropertyDescriptor descriptor, int value) throws MQException {
        int traceContext = 0;
        int fid = 550;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 550, new Object[]{name, descriptor, new Integer(value)});
        }
        this.setIntProperty(name, descriptor, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 550);
        }
    }

    public void setLongProperty(String name, long value) throws MQException {
        int traceContext = 0;
        int fid = 551;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 551, new Object[]{name, new Long(value)});
        }
        this.setLongProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 551);
        }
    }

    public void setLongProperty(String name, MQPropertyDescriptor descriptor, long value) throws MQException {
        int traceContext = 0;
        int fid = 552;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 552, new Object[]{name, descriptor, new Long(value)});
        }
        this.setProperty(name, descriptor, new Long(value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 552);
        }
    }

    public void setInt8Property(String name, long value) throws MQException {
        int traceContext = 0;
        int fid = 553;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 553, new Object[]{name, new Long(value)});
        }
        this.setLongProperty(name, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 553);
        }
    }

    public void setInt8Property(String name, MQPropertyDescriptor descriptor, long value) throws MQException {
        int traceContext = 0;
        int fid = 554;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 554, new Object[]{name, descriptor, new Long(value)});
        }
        this.setLongProperty(name, descriptor, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 554);
        }
    }

    public void setFloatProperty(String name, float value) throws MQException {
        int traceContext = 0;
        int fid = 555;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 555, new Object[]{name, new Float(value)});
        }
        this.setFloatProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 555);
        }
    }

    public void setFloatProperty(String name, MQPropertyDescriptor descriptor, float value) throws MQException {
        int traceContext = 0;
        int fid = 556;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 556, new Object[]{name, descriptor, new Float(value)});
        }
        this.setProperty(name, descriptor, new Float(value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 556);
        }
    }

    public void setDoubleProperty(String name, double value) throws MQException {
        int traceContext = 0;
        int fid = 557;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 557, new Object[]{name, new Double(value)});
        }
        this.setDoubleProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 557);
        }
    }

    public void setDoubleProperty(String name, MQPropertyDescriptor descriptor, double value) throws MQException {
        int traceContext = 0;
        int fid = 558;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 558, new Object[]{name, descriptor, new Double(value)});
        }
        this.setProperty(name, descriptor, new Double(value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 558);
        }
    }

    public void setStringProperty(String name, String value) throws MQException {
        int traceContext = 0;
        int fid = 559;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 559, new Object[]{name, value});
        }
        this.setStringProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 559);
        }
    }

    public void setStringProperty(String name, MQPropertyDescriptor descriptor, String value) throws MQException {
        int traceContext = 0;
        int fid = 560;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 560, new Object[]{name, descriptor, value});
        }
        this.setProperty(name, descriptor, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 560);
        }
    }

    public void setObjectProperty(String name, Object value) throws MQException {
        int traceContext = 0;
        int fid = 561;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 561, new Object[]{name, value});
        }
        this.setObjectProperty(name, null, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 561);
        }
    }

    public void setObjectProperty(String name, MQPropertyDescriptor descriptor, Object value) throws MQException {
        int traceContext = 0;
        int fid = 562;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 562, new Object[]{name, descriptor, value});
        }
        this.setProperty(name, descriptor, value);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 562);
        }
    }

    public boolean getBooleanProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 563;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 563, new Object[]{name});
        }
        boolean traceRet1 = this.getBooleanProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 563, (Object)traceRet1);
        }
        return traceRet1;
    }

    public boolean getBooleanProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        Object resultObject;
        int traceContext = 0;
        int fid = 564;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 564, new Object[]{name, descriptor});
        }
        if (!((resultObject = this.getProperty(name, descriptor)) instanceof Boolean)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 564, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 564, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        boolean result = (Boolean)resultObject;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 564, (Object)result, 1);
        }
        return result;
    }

    public byte[] getBytesProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 565;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 565, new Object[]{name});
        }
        byte[] traceRet1 = this.getBytesProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 565, (Object)traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytesProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        void var5_6;
        byte[] result;
        Object resultObject;
        int traceContext = 0;
        int fid = 566;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 566, new Object[]{name, descriptor});
        }
        if ((resultObject = this.getProperty(name, descriptor)) == null) {
            result = null;
        } else if (resultObject instanceof byte[]) {
            result = (byte[])resultObject;
        } else {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 566, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 566, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 566, (Object)var5_6, 1);
        }
        return var5_6;
    }

    public byte getByteProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 567;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 567, new Object[]{name});
        }
        byte traceRet1 = this.getByteProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 567, (Object)new Byte(traceRet1));
        }
        return traceRet1;
    }

    public byte getByteProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        Object resultObject;
        int traceContext = 0;
        int fid = 568;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 568, new Object[]{name, descriptor});
        }
        if (!((resultObject = this.getProperty(name, descriptor)) instanceof Byte)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 568, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 568, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        byte result = (Byte)resultObject;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 568, (Object)new Byte(result), 1);
        }
        return result;
    }

    public short getShortProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 569;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 569, new Object[]{name});
        }
        short traceRet1 = this.getShortProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 569, (Object)new Short(traceRet1));
        }
        return traceRet1;
    }

    public short getShortProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        Object resultObject;
        int traceContext = 0;
        int fid = 570;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 570, new Object[]{name, descriptor});
        }
        if (!((resultObject = this.getProperty(name, descriptor)) instanceof Short)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 570, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 570, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        short result = (Short)resultObject;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 570, (Object)new Short(result), 1);
        }
        return result;
    }

    public short getInt2Property(String name) throws MQException {
        int traceContext = 0;
        int fid = 571;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 571, new Object[]{name});
        }
        short traceRet1 = this.getShortProperty(name);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 571, (Object)new Short(traceRet1));
        }
        return traceRet1;
    }

    public short getInt2Property(String name, MQPropertyDescriptor descriptor) throws MQException {
        int traceContext = 0;
        int fid = 572;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 572, new Object[]{name, descriptor});
        }
        short traceRet1 = this.getShortProperty(name, descriptor);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 572, (Object)new Short(traceRet1));
        }
        return traceRet1;
    }

    public int getIntProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 573;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 573, new Object[]{name});
        }
        int traceRet1 = this.getIntProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 573, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getIntProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        Object resultObject;
        int traceContext = 0;
        int fid = 574;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 574, new Object[]{name, descriptor});
        }
        if (!((resultObject = this.getProperty(name, descriptor)) instanceof Integer)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 574, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 574, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        int result = (Integer)resultObject;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 574, (Object)new Integer(result), 1);
        }
        return result;
    }

    public int getInt4Property(String name) throws MQException {
        int traceContext = 0;
        int fid = 575;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 575, new Object[]{name});
        }
        int traceRet1 = this.getIntProperty(name);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 575, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getInt4Property(String name, MQPropertyDescriptor descriptor) throws MQException {
        int traceContext = 0;
        int fid = 576;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 576, new Object[]{name, descriptor});
        }
        int traceRet1 = this.getIntProperty(name, descriptor);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 576, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public long getLongProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 577;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 577, new Object[]{name});
        }
        long traceRet1 = this.getLongProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 577, (Object)new Long(traceRet1));
        }
        return traceRet1;
    }

    public long getLongProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        Object resultObject;
        int traceContext = 0;
        int fid = 578;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 578, new Object[]{name, descriptor});
        }
        if (!((resultObject = this.getProperty(name, descriptor)) instanceof Long)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 578, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 578, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        long result = (Long)resultObject;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 578, (Object)new Long(result), 1);
        }
        return result;
    }

    public long getInt8Property(String name) throws MQException {
        int traceContext = 0;
        int fid = 579;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 579, new Object[]{name});
        }
        long traceRet1 = this.getLongProperty(name);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 579, (Object)new Long(traceRet1));
        }
        return traceRet1;
    }

    public long getInt8Property(String name, MQPropertyDescriptor descriptor) throws MQException {
        int traceContext = 0;
        int fid = 580;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 580, new Object[]{name, descriptor});
        }
        long traceRet1 = this.getLongProperty(name, descriptor);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 580, (Object)new Long(traceRet1));
        }
        return traceRet1;
    }

    public float getFloatProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 581;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 581, new Object[]{name});
        }
        float traceRet1 = this.getFloatProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 581, (Object)new Float(traceRet1));
        }
        return traceRet1;
    }

    public float getFloatProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        Object resultObject;
        int traceContext = 0;
        int fid = 582;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 582, new Object[]{name, descriptor});
        }
        if (!((resultObject = this.getProperty(name, descriptor)) instanceof Float)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 582, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 582, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        float result = ((Float)resultObject).floatValue();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 582, (Object)new Float(result), 1);
        }
        return result;
    }

    public double getDoubleProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 583;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 583, new Object[]{name});
        }
        double traceRet1 = this.getDoubleProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 583, (Object)new Double(traceRet1));
        }
        return traceRet1;
    }

    public double getDoubleProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        Object resultObject;
        int traceContext = 0;
        int fid = 584;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 584, new Object[]{name, descriptor});
        }
        if (!((resultObject = this.getProperty(name, descriptor)) instanceof Double)) {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 584, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 584, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        double result = (Double)resultObject;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 584, (Object)new Double(result), 1);
        }
        return result;
    }

    public String getStringProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 585;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 585, new Object[]{name});
        }
        String traceRet1 = this.getStringProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 585, (Object)traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - void declaration
     */
    public String getStringProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        void var5_6;
        String result;
        Object resultObject;
        int traceContext = 0;
        int fid = 586;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 586, new Object[]{name, descriptor});
        }
        if ((resultObject = this.getProperty(name, descriptor)) == null) {
            result = null;
        } else if (resultObject instanceof String) {
            result = (String)resultObject;
        } else {
            MQException traceRet1 = new MQException(2, 2473, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 586, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 586, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 586, (Object)var5_6, 1);
        }
        return var5_6;
    }

    public Object getObjectProperty(String name) throws MQException {
        int traceContext = 0;
        int fid = 587;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 587, new Object[]{name});
        }
        Object traceRet1 = this.getObjectProperty(name, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 587, traceRet1);
        }
        return traceRet1;
    }

    public Object getObjectProperty(String name, MQPropertyDescriptor descriptor) throws MQException {
        int traceContext = 0;
        int fid = 588;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 588, new Object[]{name, descriptor});
        }
        Object result = this.getProperty(name, descriptor);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 588, result);
        }
        return result;
    }

    public Enumeration getPropertyNames(String name) throws MQException {
        int traceContext = 0;
        int fid = 589;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 589, new Object[]{name});
        }
        Vector<String> matchingPropertyNames = new Vector<String>();
        if (!name.equals("%")) {
            name = this.makeUsrFolderExplicit(name);
        }
        Iterator propertyNames = this.properties.keySet().iterator();
        while (propertyNames.hasNext()) {
            Object namedProperty_;
            boolean matching = false;
            String propertyName = (String)propertyNames.next();
            if (name.endsWith("%")) {
                String nameWithoutWildcard = name.substring(0, name.length() - 1);
                if (propertyName.startsWith(nameWithoutWildcard)) {
                    matching = true;
                }
            } else if (propertyName.equals(name)) {
                matching = true;
            }
            if (!matching) continue;
            if (((propertyName = this.removeExplicitUsrFolder(propertyName)).toLowerCase().startsWith("jms") || propertyName.toLowerCase().startsWith("mcd")) && (namedProperty_ = JMSPropertySynonyms.get(propertyName)) != null) {
                propertyName = namedProperty_.toString();
            }
            if (matchingPropertyNames.contains(propertyName)) continue;
            matchingPropertyNames.add(propertyName);
        }
        Enumeration traceRet1 = matchingPropertyNames.elements();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 589, traceRet1);
        }
        return traceRet1;
    }

    public void deleteProperty(String name) throws MQException {
        Object deletedProperty;
        int traceContext = 0;
        int fid = 590;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 590, new Object[]{name});
        }
        if ((deletedProperty = this.properties.remove(name = this.makeUsrFolderExplicit(name))) == null) {
            MQException traceRet1 = new MQException(2, 2471, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 590, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 590, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 590, 1);
        }
    }

    static {
        JMSPropertySynonyms = new HashMap();
        JMSPropertySynonyms.put("jms.Cid", "JMSCorrelationID");
        JMSPropertySynonyms.put("jms.Dlv", "JMSDeliveryMode");
        JMSPropertySynonyms.put("jms.Dst", "JMSDestination");
        JMSPropertySynonyms.put("jms.Exp", "JMSExpiration");
        JMSPropertySynonyms.put("jms.Pri", "JMSPriority");
        JMSPropertySynonyms.put("jms.Rto", "JMSReplyTo");
        JMSPropertySynonyms.put("jms.Tms", "JMSTimestamp");
        JMSPropertySynonyms.put("jms.Gid", "JMSXGroupID");
        JMSPropertySynonyms.put("jms.Seq", "JMSXGroupSeq");
        PROPERTIES_FOLDER_NAMES = new HashSet<String>(Arrays.asList("mq", "mq_usr", "mqext", "jms", "mcd", "usr", "sib", "sib_usr", "sib_context", "mqema", "mqps"));
        SETTABLE_JMS_PROPERTY_NAMES = new HashSet<String>(Arrays.asList("JMSCorrelationID", "JMSReplyTo", "JMSType", "JMSXGroupID", "JMSXGroupSeq"));
        QUERY_ONLY_JMS_PROPERTY_NAMES = new HashSet<String>(Arrays.asList("JMSDeliveryMode", "JMSXDeliveryCount", "JMSDestination", "JMSExpiration", "JMSMessageID", "JMSPriority", "JMSRedelivered", "JMSTimestamp", "JMSXAppID", "JMSXUserID"));
        ALL_JMS_PROPERTY_NAMES = new HashSet();
        ALL_JMS_PROPERTY_NAMES.addAll(SETTABLE_JMS_PROPERTY_NAMES);
        ALL_JMS_PROPERTY_NAMES.addAll(QUERY_ONLY_JMS_PROPERTY_NAMES);
        TYPE_MCD_ELEMENTS = new HashSet<String>(Arrays.asList("mcd.Type", "mcd.Fmt", "mcd.Set"));
        RESERVED_SQL_PROPERTY_NAMES = new HashSet<String>(Arrays.asList("NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "IS", "ESCAPE"));
        RESERVED_HIERARCHY_PROPERTY_NAME_PREFIXES = new HashSet<String>(Arrays.asList("Body.", "Root."));
        ALLOWED_HIERARCHY_PROPERTY_NAMES = new HashSet<String>(Arrays.asList("Root.MQMD"));
        RESTRICTED_HIERARCHY_FOLDER_NAMES = new HashSet<String>(Arrays.asList("mq", "jms", "mcd", "usr", "sib"));
        BIN2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        UNLIMITED_EXPIRY = new Long(-1L);
    }

    private class MQMessageInputStream
    extends InputStream {
        private MQMessage parent;

        public MQMessageInputStream(MQMessage parent) {
            int traceContext = 0;
            int fid = 188;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 188, new Object[]{parent});
            }
            this.parent = parent;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 188);
            }
        }

        public void mark(int readlimit) {
            this.parent.dataBuffer.mark();
        }

        public void reset() {
            this.parent.dataBuffer.reset();
        }

        public boolean markSupported() {
            return true;
        }

        public int read() throws IOException {
            int traceContext = 0;
            int fid = 189;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 189);
            }
            int traceRet1 = this.parent.readUnsignedByte();
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 189, (Object)new Integer(traceRet1));
            }
            return traceRet1;
        }

        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            int traceContext = 0;
            int fid = 190;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 190, new Object[]{arg0, new Integer(arg1), new Integer(arg2)});
            }
            this.parent.readFully(arg0, arg1, arg2);
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 190, (Object)new Integer(arg2));
            }
            return arg2;
        }

        public int read(byte[] arg0) throws IOException {
            int traceContext = 0;
            int fid = 191;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 191, new Object[]{arg0});
            }
            this.parent.readFully(arg0);
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 191, (Object)new Integer(arg0.length));
            }
            return arg0.length;
        }

        public long skip(long arg0) throws IOException {
            int traceContext = 0;
            int fid = 192;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 192, new Object[]{new Long(arg0)});
            }
            if (arg0 > Integer.MAX_VALUE) {
                arg0 = Integer.MAX_VALUE;
            }
            if (arg0 < 0L) {
                arg0 = 0L;
            }
            this.parent.skipBytes((int)arg0);
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 192, (Object)new Long(arg0));
            }
            return arg0;
        }
    }

    private class MQMessageOutputStream
    extends OutputStream {
        private MQMessage parent;

        public MQMessageOutputStream(MQMessage parent) {
            int traceContext = 0;
            int fid = 184;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 184, new Object[]{parent});
            }
            this.parent = parent;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 184);
            }
        }

        public void write(byte[] arg0, int arg1, int arg2) throws IOException {
            int traceContext = 0;
            int fid = 185;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 185, new Object[]{arg0, new Integer(arg1), new Integer(arg2)});
            }
            this.parent.write(arg0, arg1, arg2);
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 185);
            }
        }

        public void write(byte[] arg0) throws IOException {
            int traceContext = 0;
            int fid = 186;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 186, new Object[]{arg0});
            }
            this.parent.write(arg0);
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 186);
            }
        }

        public void write(int arg0) throws IOException {
            int traceContext = 0;
            int fid = 187;
            if (((MQMessage)MQMessage.this).trace.isOn) {
                traceContext = MQMessage.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 187, new Object[]{new Integer(arg0)});
            }
            this.parent.write(arg0);
            if (((MQMessage)MQMessage.this).trace.isOn) {
                MQMessage.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 187);
            }
        }
    }
}

