/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQC;
import com.ibm.mq.MQDateConverter;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQInternalException;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.MQMD;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MQMsg2
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQMsg2.java, java.classes, k701, k701-112-140304 1.45.1.3 13/01/23 14:32:39";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final byte[] blank8 = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private static final byte[] eyecatcherMQMD = new byte[]{77, 68, 32, 32};
    private static final byte[] pad = new byte[48];
    private MQMD jmqiStructure = MQSESSION.getJmqiEnv().newMQMD();
    private long putTimeMillis;
    private boolean putTimeCached = false;
    private ByteBuffer messageData = null;
    private int messageDataLength = 0;

    public MQMsg2() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 258;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 258);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 258, "sccsid = ", (Object)sccsid);
        }
        this.jmqiStructure.setCodedCharSetId(MQSESSION.getDefaultCCSID());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 258);
        }
    }

    public String getFormat() throws MQException {
        String traceRet1 = this.jmqiStructure.getFormat();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 827, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setFormat(String s) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 828, "setting to: ", (Object)s);
        }
        this.jmqiStructure.setFormat(s);
    }

    public String getReplyToQueueName() throws MQException {
        String traceRet1 = this.jmqiStructure.getReplyToQ();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 829, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setReplyToQueueName(String s) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 830, "setting to: ", (Object)s);
        }
        this.jmqiStructure.setReplyToQ(s);
    }

    public String getReplyToQueueManagerName() throws MQException {
        String traceRet1 = this.jmqiStructure.getReplyToQMgr();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 831, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setReplyToQueueManagerName(String s) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 832, "setting to: ", (Object)s);
        }
        this.jmqiStructure.setReplyToQMgr(s);
    }

    public String getUserId() throws MQException {
        String traceRet1 = this.jmqiStructure.getUserIdentifier();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 833, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setUserId(String s) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 834, "setting to: ", (Object)s);
        }
        this.jmqiStructure.setUserIdentifier(s);
    }

    public String getApplicationIdData() throws MQException {
        String traceRet1 = this.jmqiStructure.getApplIdentityData();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 835, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setApplicationIdData(String s) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 836, "setting to: ", (Object)s);
        }
        this.jmqiStructure.setApplIdentityData(s);
    }

    public String getPutApplicationName() throws MQException {
        String traceRet1 = this.jmqiStructure.getPutApplName();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 837, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setPutApplicationName(String s) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 838, "setting to: ", (Object)s);
        }
        this.jmqiStructure.setPutApplName(s);
    }

    public String getApplicationOriginData() throws MQException {
        String traceRet1 = this.jmqiStructure.getApplOriginData();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 839, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setApplicationOriginData(String s) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 840, "setting to: ", (Object)s);
        }
        this.jmqiStructure.setApplOriginData(s);
    }

    public int getReport() {
        int traceRet1 = this.jmqiStructure.getReport();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 841, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setReport(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 842, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setReport(i);
    }

    public int getMessageType() {
        int traceRet1 = this.jmqiStructure.getMsgType();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 843, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setMessageType(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 844, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setMsgType(i);
    }

    public int getExpiry() {
        int traceRet1 = this.jmqiStructure.getExpiry();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 845, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setExpiry(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 846, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setExpiry(i);
    }

    public int getFeedback() {
        int traceRet1 = this.jmqiStructure.getFeedback();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 847, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setFeedback(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 848, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setFeedback(i);
    }

    public int getEncoding() {
        int traceRet1 = this.jmqiStructure.getEncoding();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 849, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setEncoding(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 850, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setEncoding(i);
    }

    public int getCharacterSet() {
        int traceRet1 = this.jmqiStructure.getCodedCharSetId();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 851, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setCharacterSet(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 852, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setCodedCharSetId(i);
    }

    public int getPriority() {
        int traceRet1 = this.jmqiStructure.getPriority();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 853, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setPriority(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 854, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setPriority(i);
    }

    public int getPersistence() {
        int traceRet1 = this.jmqiStructure.getPersistence();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 855, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setPersistence(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 856, "returning: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setPersistence(i);
    }

    public int getBackoutCount() {
        int traceRet1 = this.jmqiStructure.getBackoutCount();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 857, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setBackoutCount(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 858, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setBackoutCount(i);
    }

    public int getPutApplicationType() {
        int traceRet1 = this.jmqiStructure.getPutApplType();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 859, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setPutApplicationType(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 860, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setPutApplType(i);
    }

    public int getMessageSequenceNumber() {
        int traceRet1 = this.jmqiStructure.getMsgSeqNumber();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 861, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setMessageSequenceNumber(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 862, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setMsgSeqNumber(i);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public int getOffset() {
        int traceRet1 = this.jmqiStructure.getOffset();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 863, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setOffset(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 864, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setOffset(i);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public int getMessageFlags() {
        int traceRet1 = this.jmqiStructure.getMsgFlags();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 865, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setMessageFlags(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 866, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setMsgFlags(i);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public int getOriginalLength() {
        int traceRet1 = this.jmqiStructure.getOriginalLength();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 867, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setOriginalLength(int i) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 868, "setting to: ", (Object)new Integer(i));
        }
        this.jmqiStructure.setOriginalLength(i);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public byte[] getMessageId() {
        int traceContext = 0;
        int fid = 505;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 505);
        }
        byte[] returnValue = new byte[24];
        System.arraycopy(this.jmqiStructure.getMsgId(), 0, returnValue, 0, 24);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 505, (Object)returnValue);
        }
        return returnValue;
    }

    public void setMessageId(byte[] value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 869, "setting to: ", (Object)value);
        }
        this.jmqiStructure.setMsgId(value);
    }

    public byte[] getCorrelationId() {
        int traceContext = 0;
        int fid = 506;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 506);
        }
        byte[] returnValue = new byte[24];
        System.arraycopy(this.jmqiStructure.getCorrelId(), 0, returnValue, 0, 24);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 506, (Object)returnValue);
        }
        return returnValue;
    }

    public void setCorrelationId(byte[] value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 870, "setting to: ", (Object)value);
        }
        this.jmqiStructure.setCorrelId(value);
    }

    public byte[] getAccountingToken() {
        int traceContext = 0;
        int fid = 507;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 507);
        }
        byte[] returnValue = new byte[32];
        System.arraycopy(this.jmqiStructure.getAccountingToken(), 0, returnValue, 0, 32);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 507, (Object)returnValue);
        }
        return returnValue;
    }

    public void setAccountingToken(byte[] value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 871, "setting to: ", (Object)value);
        }
        this.jmqiStructure.setAccountingToken(value);
    }

    public byte[] getGroupId() {
        int traceContext = 0;
        int fid = 508;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 508);
        }
        byte[] returnValue = new byte[24];
        System.arraycopy(this.jmqiStructure.getGroupId(), 0, returnValue, 0, 24);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 508, (Object)returnValue);
        }
        return returnValue;
    }

    public void setGroupId(byte[] value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 872, "setting to: ", (Object)value);
        }
        this.jmqiStructure.setGroupId(value);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public byte[] getPutDateAsBytes() {
        byte[] traceRet1 = this.jmqiStructure.getPutDate().getBytes();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 873, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public byte[] getPutTimeAsBytes() {
        byte[] traceRet1 = this.jmqiStructure.getPutTime().getBytes();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 874, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public int getVersion() {
        int traceRet1 = this.jmqiStructure.getVersion();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 875, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public long getPutTimeMillis() throws MQException {
        if (!this.putTimeCached) {
            this.putTimeMillis = MQDateConverter.mqDateTimeToMillis(this.jmqiStructure.getPutTime(), this.jmqiStructure.getPutDate());
            this.putTimeCached = true;
        }
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 876, "returning: ", (Object)new Long(this.putTimeMillis));
        }
        return this.putTimeMillis;
    }

    public byte[] getMessageData() {
        int traceContext = 0;
        int fid = 268;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 268);
        }
        byte[] returnData = new byte[this.messageDataLength];
        if (this.messageDataLength > 0) {
            this.messageData.position(0);
            this.messageData.get(returnData, 0, this.messageDataLength);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 268, (Object)returnData);
        }
        return returnData;
    }

    public byte[] getMessageDataRef() {
        byte[] traceRet1 = null;
        if (this.messageData != null) {
            traceRet1 = this.messageData.array();
        }
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 877, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setMessageData(byte[] data) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 878, "setting to: ", (Object)data);
        }
        this.setMessageData(data, data.length);
    }

    public void setMessageData(byte[] data, int messageLength) {
        int traceContext = 0;
        int fid = 269;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 269, new Object[]{data, new Integer(messageLength)});
        }
        this.messageData = ByteBuffer.allocate(messageLength);
        this.messageData.put(data, 0, messageLength);
        this.messageDataLength = messageLength;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 269);
        }
    }

    protected void setInternalBuffer(byte[] data, int len) {
        int traceContext = 0;
        int fid = 270;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 270, new Object[]{data, new Integer(len)});
        }
        this.messageData = ByteBuffer.wrap(data);
        this.messageDataLength = len;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 270);
        }
    }

    protected ByteBuffer getInternalBuffer() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 879, "returning: ", (Object)this.messageData);
        }
        return this.messageData;
    }

    public int getMessageDataLength() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 880, "returning: ", (Object)new Integer(this.messageDataLength));
        }
        return this.messageDataLength;
    }

    public void clearMessageData() {
        int traceContext = 0;
        int fid = 275;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 275);
        }
        this.messageData = null;
        this.messageDataLength = 0;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 275);
        }
    }

    protected MQMD getJMQIStructure() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 881, "returning: ", (Object)this.jmqiStructure);
        }
        return this.jmqiStructure;
    }

    public final DataInputStream readFrom(DataInputStream dataBuffer, int ccsid, boolean ccsidIsAscii) throws IOException, MQException {
        int traceContext = 0;
        int fid = 591;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 591, new Object[]{dataBuffer, new Integer(ccsid), ccsidIsAscii});
        }
        int bufferLen = dataBuffer.available();
        if (bufferLen < MQMD.getSizeV1((int)4)) {
            MQInternalException traceRet1 = new MQInternalException(2, 2195, "MQJE043", null);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 591, (Throwable)((Object)traceRet1), 1);
            }
            throw traceRet1;
        }
        byte[] eyecatcherBytes = new byte[4];
        dataBuffer.read(eyecatcherBytes, 0, 4);
        if (eyecatcherBytes[0] != 77 || eyecatcherBytes[1] != 68 || eyecatcherBytes[2] != 32 || eyecatcherBytes[3] != 32) {
            MQInternalException traceRet2 = new MQInternalException(2, 2195, "MQJE042", MQEnvironment.stringFromBytes(eyecatcherBytes), null);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 591, (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        String ccsidStr = null;
        try {
            ccsidStr = this.env.getJavaCharacterSet(1208);
        }
        catch (Exception e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 591, (Throwable)e);
            }
            ccsidStr = "1208";
        }
        this.jmqiStructure.setVersion(dataBuffer.readInt());
        this.jmqiStructure.setReport(dataBuffer.readInt());
        this.jmqiStructure.setMsgType(dataBuffer.readInt());
        this.jmqiStructure.setExpiry(dataBuffer.readInt());
        this.jmqiStructure.setFeedback(dataBuffer.readInt());
        this.jmqiStructure.setEncoding(dataBuffer.readInt());
        this.jmqiStructure.setCodedCharSetId(dataBuffer.readInt());
        byte[] format = new byte[8];
        dataBuffer.read(format, 0, 8);
        this.jmqiStructure.setFormat(new String(format, ccsidStr));
        this.jmqiStructure.setPriority(dataBuffer.readInt());
        this.jmqiStructure.setPersistence(dataBuffer.readInt());
        byte[] messageId = new byte[24];
        dataBuffer.read(messageId, 0, 24);
        this.jmqiStructure.setMsgId(messageId);
        byte[] correlationId = new byte[24];
        dataBuffer.read(correlationId, 0, 24);
        this.jmqiStructure.setCorrelId(correlationId);
        this.jmqiStructure.setBackoutCount(dataBuffer.readInt());
        byte[] replyToQueueName = new byte[48];
        dataBuffer.read(replyToQueueName, 0, 48);
        this.jmqiStructure.setReplyToQ(new String(replyToQueueName, ccsidStr));
        byte[] replyToQueueManagerName = new byte[48];
        dataBuffer.read(replyToQueueManagerName, 0, 48);
        this.jmqiStructure.setReplyToQMgr(new String(replyToQueueManagerName, ccsidStr));
        byte[] userId = new byte[12];
        dataBuffer.read(userId, 0, 12);
        this.jmqiStructure.setUserIdentifier(new String(userId, ccsidStr));
        byte[] accountingToken = new byte[32];
        dataBuffer.read(accountingToken, 0, 32);
        this.jmqiStructure.setAccountingToken(accountingToken);
        byte[] applicationIdData = new byte[32];
        dataBuffer.read(applicationIdData, 0, 32);
        this.jmqiStructure.setApplIdentityData(new String(applicationIdData, ccsidStr));
        this.jmqiStructure.setPutApplType(dataBuffer.readInt());
        byte[] putApplicationName = new byte[28];
        dataBuffer.read(putApplicationName, 0, 28);
        this.jmqiStructure.setPutApplName(new String(putApplicationName, ccsidStr));
        byte[] dateText = new byte[8];
        dataBuffer.read(dateText, 0, 8);
        this.jmqiStructure.setPutDate(new String(dateText, ccsidStr));
        byte[] timeText = new byte[8];
        dataBuffer.read(timeText, 0, 8);
        this.jmqiStructure.setPutTime(new String(timeText, ccsidStr));
        this.putTimeCached = false;
        byte[] applicationOriginData = new byte[4];
        dataBuffer.read(applicationOriginData, 0, 4);
        this.jmqiStructure.setApplOriginData(new String(applicationOriginData, ccsidStr));
        if (this.jmqiStructure.getVersion() > 1) {
            byte[] groupId = new byte[24];
            dataBuffer.read(groupId, 0, 24);
            this.jmqiStructure.setGroupId(groupId);
            this.jmqiStructure.setMsgSeqNumber(dataBuffer.readInt());
            this.jmqiStructure.setOffset(dataBuffer.readInt());
            this.jmqiStructure.setMsgFlags(dataBuffer.readInt());
            this.jmqiStructure.setOriginalLength(dataBuffer.readInt());
        } else {
            this.jmqiStructure.setGroupId(MQC.MQGI_NONE);
            this.jmqiStructure.setMsgSeqNumber(1);
            this.jmqiStructure.setOffset(0);
            this.jmqiStructure.setMsgFlags(0);
            this.jmqiStructure.setOriginalLength(-1);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 591, (Object)dataBuffer);
        }
        return dataBuffer;
    }

    public final DataOutputStream writeTo(DataOutputStream dataBuffer, int ccsid, boolean ccsidIsAscii) throws IOException, MQException {
        int traceContext = 0;
        int fid = 592;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 592, new Object[]{dataBuffer, new Integer(ccsid), ccsidIsAscii});
        }
        dataBuffer = this.writeToWithoutConversion(dataBuffer);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 592, (Object)dataBuffer);
        }
        return dataBuffer;
    }

    private DataOutputStream writeToWithoutConversion(DataOutputStream dataBuffer) throws IOException {
        int traceContext = 0;
        int fid = 593;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 593, new Object[]{dataBuffer});
        }
        boolean i = false;
        dataBuffer.write(eyecatcherMQMD);
        dataBuffer.writeInt(this.jmqiStructure.getVersion());
        dataBuffer.writeInt(this.jmqiStructure.getReport());
        dataBuffer.writeInt(this.jmqiStructure.getMsgType());
        dataBuffer.writeInt(this.jmqiStructure.getExpiry());
        dataBuffer.writeInt(this.jmqiStructure.getFeedback());
        dataBuffer.writeInt(this.jmqiStructure.getEncoding());
        dataBuffer.writeInt(this.jmqiStructure.getCodedCharSetId());
        this.writeStringValueToBuffer(dataBuffer, this.jmqiStructure.getFormat(), 8);
        dataBuffer.writeInt(this.jmqiStructure.getPriority());
        dataBuffer.writeInt(this.jmqiStructure.getPersistence());
        dataBuffer.write(this.jmqiStructure.getMsgId());
        dataBuffer.write(this.jmqiStructure.getCorrelId());
        dataBuffer.writeInt(this.jmqiStructure.getBackoutCount());
        this.writeStringValueToBuffer(dataBuffer, this.jmqiStructure.getReplyToQ(), 48);
        this.writeStringValueToBuffer(dataBuffer, this.jmqiStructure.getReplyToQMgr(), 48);
        this.writeStringValueToBuffer(dataBuffer, this.jmqiStructure.getUserIdentifier(), 12);
        dataBuffer.write(this.jmqiStructure.getAccountingToken());
        this.writeStringValueToBuffer(dataBuffer, this.jmqiStructure.getApplIdentityData(), 32);
        dataBuffer.writeInt(this.jmqiStructure.getPutApplType());
        this.writeStringValueToBuffer(dataBuffer, this.jmqiStructure.getPutApplName(), 28);
        dataBuffer.write(blank8);
        dataBuffer.write(blank8);
        this.writeStringValueToBuffer(dataBuffer, this.jmqiStructure.getApplOriginData(), 4);
        if (this.jmqiStructure.getVersion() > 1) {
            dataBuffer.write(this.jmqiStructure.getGroupId());
            dataBuffer.writeInt(this.jmqiStructure.getMsgSeqNumber());
            dataBuffer.writeInt(this.jmqiStructure.getOffset());
            dataBuffer.writeInt(this.jmqiStructure.getMsgFlags());
            dataBuffer.writeInt(this.jmqiStructure.getOriginalLength());
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 593, (Object)dataBuffer);
        }
        return dataBuffer;
    }

    private final void writeStringValueToBuffer(DataOutputStream buffer, String value, int fieldLength) throws IOException {
        int traceContext = 0;
        int fid = 716;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 716, new Object[]{buffer, value, new Integer(fieldLength)});
        }
        if (value != null) {
            int len = value.length();
            if (len <= fieldLength) {
                buffer.write(value.getBytes());
                if (len < fieldLength) {
                    buffer.write(pad, 0, fieldLength - len);
                }
            } else {
                buffer.write(value.substring(0, fieldLength).getBytes());
            }
        } else {
            buffer.write(pad, 0, fieldLength);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 716);
        }
    }

    static {
        for (int i = 0; i < pad.length; ++i) {
            MQMsg2.pad[i] = 0;
        }
    }
}

