/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQJavaLevel;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.QMElt;
import com.ibm.mq.QMTree;
import com.ibm.mq.QMTreeException;
import com.ibm.mq.QueueManagerFactoryProperties;
import com.ibm.mq.TreeElt;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public final class MQQueueManagerFactory
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQQueueManagerFactory.java, java.classes, k701, k701-112-140304 1.29.1.3 12/07/09 12:54:52";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static MQQueueManagerFactory theFactory = null;
    private static QMTree qmTree = null;
    private static final Object lock = new Object();

    private MQQueueManagerFactory() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 717;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 717);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 717);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQQueueManagerFactory getInstance() {
        MQJavaLevel.traceBuildInfo();
        Object object = lock;
        synchronized (object) {
            if (theFactory == null) {
                theFactory = new MQQueueManagerFactory();
                qmTree = new QMTree();
            }
        }
        return theFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected MQQueueManager createQueueManager(int options, QueueManagerFactoryProperties properties, URL ccdtUrl) throws MQException {
        traceContext = 0;
        fid = 718;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, MQQueueManagerFactory.COMP_JN, 718, new Object[]{new Integer(options), properties, ccdtUrl});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, MQQueueManagerFactory.COMP_JN, 718, "options: ", (Object)Integer.toString(options));
        }
        qMgr = null;
        if (properties == null || !properties.isValid()) {
            e = new MQException(2, 2046, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)e, 1);
                this.trace.exit(traceContext, (Object)this, MQQueueManagerFactory.COMP_JN, 718, (Object)e, 2);
            }
            throw e;
        }
        v0 = fromMQEnvironment = options < 0;
        if (fromMQEnvironment) {
            options ^= -1;
        }
        switch (options) {
            case 0: {
                if (!fromMQEnvironment && properties != null) {
                    qMgr = this.constructQueueManager(properties, ccdtUrl);
                    break;
                }
                traceRet1 = new MQException(1, 2046, (Object)"no available queue manager");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)traceRet1, 2);
                    this.trace.exit(traceContext, (Object)this, MQQueueManagerFactory.COMP_JN, 718, (Object)traceRet1, 3);
                }
                throw traceRet1;
            }
            case 8: 
            case 32: {
                traceRet1 = MQQueueManagerFactory.lock;
                synchronized (traceRet1) {
                    t = Thread.currentThread();
                    mgrName = properties.getName();
                    if (mgrName != null && !mgrName.trim().equals("")) ** GOTO lbl55
                    qmTmp = this.createQueueManager(0, properties, ccdtUrl);
                    b = new byte[48];
                    c = new int[1];
                    i = new int[]{2015, 2};
                    qmTmp.inquire((int[])i, c, b);
                    qmTmp.disconnect();
                    cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)c[0]);
                    try {
                        mgrName = new String(b, cp.charsetId);
                    }
                    catch (UnsupportedEncodingException e1) {
                        if (!this.trace.isOn) ** GOTO lbl47
                        this.trace.catchBlock((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)e1, 1);
                    }
lbl47:
                    // 3 sources

                    if (mgrName != null) {
                        mgrName = mgrName.trim();
                    } else {
                        traceRet2 = new MQException(2, 2195, (Object)"could not resolve default queue manager");
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)traceRet2, 3);
                            this.trace.exit(traceContext, (Object)this, MQQueueManagerFactory.COMP_JN, 718, (Object)traceRet2, 4);
                        }
                        throw traceRet2;
                    }
lbl55:
                    // 2 sources

                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, MQQueueManagerFactory.COMP_JN, 718, "thread: " + t + ", qMgrName: " + mgrName, (Object)"");
                    }
                    treePtr = MQQueueManagerFactory.qmTree.getAssociateBranch(options);
                    c /* !! */  = treePtr.children();
                    threadFound = false;
                    if (options == 8) {
                        i = c /* !! */ .iterator();
                        while (!threadFound && i.hasNext()) {
                            t1 = (TreeElt)i.next();
                            if (t == (Thread)t1.getElement()) {
                                t2 = MQQueueManagerFactory.qmTree.getChild(treePtr, t);
                                if (t2 != null) {
                                    treePtr = t2;
                                    c /* !! */  = treePtr.children();
                                    threadFound = true;
                                    continue;
                                }
                                c /* !! */  = new ArrayList<E>();
                                continue;
                            }
                            c /* !! */  = new ArrayList<E>();
                        }
                    }
                    i = c /* !! */ .iterator();
                    found = false;
                    while (!found && i.hasNext()) {
                        t3 = (TreeElt)i.next();
                        q = (QMElt)t3.getElement();
                        if (!mgrName.equals(q.name)) continue;
                        found = true;
                        treePtr = t3;
                    }
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, MQQueueManagerFactory.COMP_JN, 718, "matching queue manager " + (found != false ? "found" : "not found"), (Object)"");
                    }
                    if (found) {
                        q = (QMElt)treePtr.getElement();
                        qMgr = q.mgr;
                        properties.getMgr().association = options;
                        try {
                            MQQueueManagerFactory.qmTree.addChild(treePtr, (Object)properties.getMgr());
                        }
                        catch (QMTreeException qte) {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)qte, 2);
                            }
                            me = new MQException(2, 2195, (Object)"failed to update qmTree");
                            me.initCause((Throwable)qte);
                            if (this.trace.isOn) {
                                this.trace.throwing((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)me, 4);
                                this.trace.exit(traceContext, (Object)this, MQQueueManagerFactory.COMP_JN, 718, (Object)me, 5);
                            }
                            throw me;
                        }
                    }
                    if (fromMQEnvironment) {
                        traceRet3 = new MQException(1, 2046, (Object)"no available queue manager");
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)traceRet3, 5);
                            this.trace.exit(traceContext, (Object)this, MQQueueManagerFactory.COMP_JN, 718, (Object)traceRet3, 6);
                        }
                        throw traceRet3;
                    }
                    qMgr = this.constructQueueManager(properties, ccdtUrl);
                    try {
                        if (options == 8 && !threadFound) {
                            MQQueueManagerFactory.qmTree.addChild(treePtr, t);
                            treePtr = MQQueueManagerFactory.qmTree.getChild(treePtr, t);
                        }
                        q = new QMElt(mgrName, qMgr);
                        MQQueueManagerFactory.qmTree.addChild(treePtr, q);
                        treePtr = MQQueueManagerFactory.qmTree.getChild(treePtr, q);
                        MQQueueManagerFactory.qmTree.addChild(treePtr, (Object)properties.getMgr());
                        properties.getMgr().association = options;
                    }
                    catch (QMTreeException qte) {
                        if (this.trace.isOn) {
                            this.trace.catchBlock((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)qte, 3);
                        }
                        me = new MQException(2, 2195, (Object)"failed to update qmTree");
                        me.initCause((Throwable)qte);
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)me, 6);
                            this.trace.exit(traceContext, (Object)this, MQQueueManagerFactory.COMP_JN, 718, (Object)me, 7);
                        }
                        throw me;
                    }
                    break;
                }
            }
            default: {
                e = new MQException(2, 2046, (Object)this);
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, MQQueueManagerFactory.COMP_JN, 718, "bad context value: ", (Object)Integer.toString(options));
                }
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, MQQueueManagerFactory.COMP_JN, 718, (Throwable)e, 7);
                    this.trace.exit(traceContext, (Object)this, MQQueueManagerFactory.COMP_JN, 718, (Object)e, 8);
                }
                throw e;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, MQQueueManagerFactory.COMP_JN, 718, (Object)qMgr, 1);
        }
        return qMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(MQQueueManager qm) throws MQException {
        int traceContext = 0;
        int fid = 719;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 719, new Object[]{qm});
        }
        Object object = lock;
        synchronized (object) {
            if (qmTree.leafContains((Object)qm)) {
                switch (qm.association) {
                    case 0: {
                        break;
                    }
                    case 8: 
                    case 32: {
                        TreeElt treePtr = MQQueueManagerFactory.find(qm);
                        if (treePtr != null) {
                            try {
                                qmTree.removeChild(treePtr, (Object)qm);
                                while (treePtr.children().size() == 0 && treePtr.depth() != 1) {
                                    Object o = treePtr.getElement();
                                    if (o instanceof MQQueueManager) {
                                        ((MQQueueManager)((Object)o)).connected = false;
                                    }
                                    treePtr = qmTree.parent(treePtr);
                                    qmTree.removeChild(treePtr, o);
                                }
                                break;
                            }
                            catch (QMTreeException qte) {
                                if (this.trace.isOn) {
                                    this.trace.catchBlock((Object)this, COMP_JN, 719, (Throwable)qte);
                                }
                                MQException me = new MQException(2, 2195, (Object)("failed to remove qm: " + (Object)((Object)qm)));
                                me.initCause((Throwable)qte);
                                if (this.trace.isOn) {
                                    this.trace.throwing((Object)this, COMP_JN, 719, (Throwable)me, 1);
                                    this.trace.exit(traceContext, (Object)this, COMP_JN, 719, (Object)me, 2);
                                }
                                throw me;
                            }
                        }
                        if (qm.association != 8 || !qmTree.leafContains((Object)qm)) break;
                        MQException me = new MQException(2, 2042, (Object)this);
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 719, (Throwable)me, 2);
                            this.trace.exit(traceContext, (Object)this, COMP_JN, 719, (Object)me, 3);
                        }
                        throw me;
                    }
                    default: {
                        MQException e = new MQException(2, 2046, (Object)this);
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 719, "bad association value: ", (Object)Integer.toString(qm.association));
                        }
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 719, (Throwable)e, 3);
                            this.trace.exit(traceContext, (Object)this, COMP_JN, 719, (Object)e, 4);
                        }
                        throw e;
                    }
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 719, 1);
        }
    }

    public static boolean isReferenced(MQQueueManager qm) {
        return qmTree != null ? qmTree.leafContains((Object)qm) : false;
    }

    public static boolean isLastReference(MQQueueManager qm) {
        return MQQueueManagerFactory.getReferenceCount(qm) <= 1;
    }

    public static int getReferenceCount(MQQueueManager qm) {
        TreeElt t;
        int references = 0;
        if (qm != null && qm.association != 0 && (t = MQQueueManagerFactory.find(qm)) != null && t.getParent() != null) {
            references = t.getParent().children().size();
        }
        return references;
    }

    public static boolean compare(MQQueueManager qm1, MQQueueManager qm2) {
        boolean equal = false;
        if (qm1 == null || qm2 == null) {
            equal = false;
        } else if (qm1.association == qm2.association && qm1.association != 0) {
            TreeElt e1 = MQQueueManagerFactory.find(qm1);
            TreeElt e2 = MQQueueManagerFactory.find(qm2);
            equal = e1 != null && e2 != null && e1.getParent() == e2.getParent();
        } else {
            equal = qm1 == qm2;
        }
        return equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeElt find(MQQueueManager qm) {
        TreeElt treePtr = null;
        Object object = lock;
        synchronized (object) {
            if (qmTree != null && qm != null) {
                treePtr = qmTree.root();
                treePtr = qmTree.getChild(treePtr, new Integer(qm.association));
                if (qm.association == 8) {
                    Thread t = Thread.currentThread();
                    treePtr = qmTree.getChild(treePtr, t);
                }
                if (treePtr != null) {
                    Collection c = treePtr.children();
                    Iterator i = c.iterator();
                    boolean found = false;
                    while (!found && i.hasNext()) {
                        QMElt q = (QMElt)((TreeElt)i.next()).getElement();
                        TreeElt t2 = qmTree.getChild(treePtr, q);
                        Collection c2 = t2.children();
                        Iterator i2 = c2.iterator();
                        while (!found && i2.hasNext()) {
                            MQQueueManager qx = (MQQueueManager)((Object)((TreeElt)i2.next()).getElement());
                            if (qx != qm) continue;
                            found = true;
                            treePtr = qmTree.getChild(t2, (Object)qm);
                        }
                    }
                    if (!found) {
                        treePtr = null;
                    }
                }
            }
        }
        return treePtr;
    }

    private MQQueueManager constructQueueManager(QueueManagerFactoryProperties props, URL ccdtUrl) throws MQException {
        int traceContext = 0;
        int fid = 720;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 720, new Object[]{props, ccdtUrl});
        }
        MQQueueManager qm = null;
        Object obj = props.getConMgr();
        qm = obj != null ? (obj instanceof MQConnectionManager ? this.procure(props.getName(), props.getProperties(), (MQConnectionManager)obj, null, ccdtUrl) : this.procure(props.getName(), props.getProperties(), null, (ConnectionManager)obj, ccdtUrl)) : this.procure(props.getName(), props.getProperties(), null, null, ccdtUrl);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 720, (Object)qm);
        }
        return qm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MQQueueManager procure(String queueManagerName, Hashtable properties, MQConnectionManager mqCxMan, ConnectionManager cxMan, URL ccdtUrl) throws MQException {
        MQQueueManager mQQueueManager;
        block9: {
            int traceContext = 0;
            int fid = 721;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 721, new Object[]{queueManagerName, properties, mqCxMan, cxMan, ccdtUrl});
            }
            try {
                if (mqCxMan == null && cxMan == null) {
                    Vector vector = MQEnvironment.poolTokenSet;
                    synchronized (vector) {
                        mqCxMan = MQEnvironment.defaultMQCxManager;
                        cxMan = MQEnvironment.defaultCxManager;
                    }
                }
                if (mqCxMan == null && cxMan instanceof MQConnectionManager) {
                    mqCxMan = (MQConnectionManager)cxMan;
                    cxMan = null;
                }
                MQQueueManager baseQM = null;
                baseQM = mqCxMan != null ? this.obtainBaseMQQueueManager(queueManagerName, properties, mqCxMan, ccdtUrl) : this.obtainBaseMQQueueManager(queueManagerName, properties, cxMan, ccdtUrl);
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JN, 721, (Object)baseQM);
                }
                mQQueueManager = baseQM;
                Object var11_11 = null;
                if (!this.trace.isOn) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var11_12 = null;
                    if (!this.trace.isOn) break block10;
                    this.trace.finallyBlock((Object)this, COMP_JN, 721);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 721);
        }
        return mQQueueManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQQueueManager obtainBaseMQQueueManager(String qmgr, Hashtable properties, ConnectionManager cxMan, URL ccdtUrl) throws MQException {
        MQQueueManager traceRet1;
        int traceContext;
        block9: {
            traceContext = 0;
            int fid = 722;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 722, new Object[]{qmgr, properties, cxMan, ccdtUrl});
            }
            String transport = this.determineTransport(properties);
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)MQSESSION.getMQManagedConnectionFactory(transport, qmgr, properties, false);
            ConnectionRequestInfo cxReqInf = MQSESSION.getConnectionRequestInfo(transport, properties, ccdtUrl);
            try {
                try {
                    traceRet1 = (MQQueueManager)((Object)cxMan.allocateConnection(mcf, cxReqInf));
                }
                catch (ResourceException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 722, (Throwable)e);
                    }
                    MQException traceRet2 = this.processException(e);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 722, (Throwable)traceRet2);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 722, (Object)traceRet2, 2);
                    }
                    throw traceRet2;
                }
                Object var14_11 = null;
                if (!this.trace.isOn) break block9;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 722);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 722);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 722, (Object)traceRet1, 1);
        }
        return traceRet1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQQueueManager obtainBaseMQQueueManager(String qmgr, Hashtable properties, MQConnectionManager cxMan, URL ccdtUrl) throws MQException {
        MQQueueManager m;
        int traceContext;
        block9: {
            traceContext = 0;
            int fid = 723;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 723, new Object[]{qmgr, properties, cxMan, ccdtUrl});
            }
            String transport = this.determineTransport(properties);
            MQManagedConnectionFactory mcf = MQSESSION.getMQManagedConnectionFactory(transport, qmgr, properties, true);
            ConnectionRequestInfo cxReqInf = MQSESSION.getConnectionRequestInfo(transport, properties, ccdtUrl);
            try {
                try {
                    m = (MQQueueManager)((Object)cxMan.allocateConnection(mcf, cxReqInf));
                }
                catch (ResourceException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 723, (Throwable)e);
                    }
                    MQException traceRet1 = this.processException(e);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 723, (Throwable)traceRet1);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 723, (Object)traceRet1, 2);
                    }
                    throw traceRet1;
                }
                Object var14_11 = null;
                if (!this.trace.isOn) break block9;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 723);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 723);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 723, (Object)m, 1);
        }
        return m;
    }

    private String determineTransport(Hashtable properties) throws MQException {
        String scphs;
        String trans;
        int traceContext = 0;
        int fid = 724;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 724, new Object[]{properties});
        }
        if ((trans = MQEnvironment.getStringProperty("transport", properties)).equals("MQSeries")) {
            String hostname = MQEnvironment.getStringProperty("hostname", properties);
            trans = hostname == null || hostname.trim().equals("") ? "MQSeries Bindings" : "MQSeries Client";
        }
        if (!trans.equals("MQSeries Client") && (scphs = MQEnvironment.getStringProperty("SSL Cipher Suite", properties)) != null && !scphs.trim().equals("")) {
            MQException traceRet1 = new MQException(2, 2396, null);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 724, (Throwable)traceRet1);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 724, (Object)traceRet1, 2);
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 724, (Object)trans, 1);
        }
        return trans;
    }

    private MQException processException(ResourceException e) {
        int traceContext = 0;
        int fid = 725;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 725, new Object[]{e});
        }
        if (e.getMessage().indexOf("allocateConnection") != -1) {
            MQException traceRet1 = new MQException(2, 2025, (Object)"no more connections available");
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 725, (Object)traceRet1, 1);
            }
            return traceRet1;
        }
        Exception le = e.getLinkedException();
        if (le instanceof MQException) {
            MQException traceRet2 = (MQException)((Object)le);
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 725, (Object)traceRet2, 2);
            }
            return traceRet2;
        }
        MQException traceRet3 = new MQException(2, 2195, (Object)this);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 725, (Object)traceRet3, 3);
        }
        return traceRet3;
    }
}

