/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQPoolServices;
import com.ibm.mq.MQPoolServicesEvent;
import com.ibm.mq.MQPoolServicesEventListener;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.ManagedConnectionStore;
import com.ibm.mq.PoolScavenger;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mq.jmqi.JmqiObject;
import java.util.Enumeration;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

public final class MQSimpleConnectionManager
extends JmqiObject
implements MQConnectionManager {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQSimpleConnectionManager.java, java.classes, k701, k701-112-140304 1.36.1.5 13/01/15 13:30:10";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManagedConnectionStore mcs = new ManagedConnectionStore();
    private PoolScavenger scavenger = new PoolScavenger();
    private Vector ownedSMCs = new Vector();
    private boolean active = false;
    private int mode;
    private MQPoolServices poolServices = new MQPoolServices();
    private PSAdapter adapter = new PSAdapter();
    private int maxCons = 0;
    private int gestating = 0;
    public static final int MODE_AUTO = 0;
    public static final int MODE_ACTIVE = 1;
    public static final int MODE_INACTIVE = 2;

    public MQSimpleConnectionManager() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 422;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 422);
        }
        this.mode = 0;
        this.poolServices.addMQPoolServicesEventListener(this.adapter);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 422);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object allocateConnection(MQManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        int traceContext = 0;
        int fid = 423;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 423, new Object[]{mcf, cxRequestInfo});
        }
        String methodName = "allocateConnection";
        StoredManagedConnection smc = null;
        Object connection = null;
        boolean fromPool = true;
        while (fromPool) {
            smc = this.mcs.chooseOne(mcf, cxRequestInfo);
            if (smc != null && smc.mqManCon != null) {
                try {
                    connection = smc.mqManCon.getConnection(cxRequestInfo);
                    break;
                }
                catch (ResourceException re) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 423, (Throwable)re, 1);
                    }
                    smc.destroy();
                    continue;
                }
            }
            fromPool = false;
        }
        if (!fromPool) {
            int toShed;
            if (this.maxCons > 0 && (toShed = 1 + this.currentSize() + this.gestating - this.maxCons) > 0) {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 423, "Scavenger asked to lose " + toShed + " connections", (Object)"");
                }
                this.scavenger.destroyNext(toShed);
            }
            smc = null;
            boolean createNewSMC = false;
            boolean gestatingIncremented = false;
            MQSimpleConnectionManager mQSimpleConnectionManager = this;
            // MONITORENTER : mQSimpleConnectionManager
            if (this.maxCons == 0 || this.maxCons > this.currentSize() + this.gestating) {
                createNewSMC = true;
                ++this.gestating;
                gestatingIncremented = true;
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 423, "New SMC will be created, maxCons: " + this.maxCons + ", currentSize: " + this.currentSize() + ", gestating: " + this.gestating, (Object)"");
                }
            }
            // MONITOREXIT : mQSimpleConnectionManager
            if (!createNewSMC) {
                ResourceException traceRet1 = new ResourceException(MQException.getNLSMsg((String)"MQRESOURCE_ERROR", (String)methodName));
                if (!this.trace.isOn) throw traceRet1;
                this.trace.throwing((Object)this, COMP_JN, 423, (Throwable)traceRet1, 2);
                throw traceRet1;
            }
            try {
                try {
                    smc = new StoredManagedConnection(mcf, cxRequestInfo, this.mcs, this.scavenger, this);
                    mQSimpleConnectionManager = this;
                    // MONITORENTER : mQSimpleConnectionManager
                    smc.initializePoolActive(this.active);
                    --this.gestating;
                    // MONITOREXIT : mQSimpleConnectionManager
                    gestatingIncremented = false;
                    connection = smc.mqManCon.getConnection(cxRequestInfo);
                }
                catch (ResourceException re) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 423, (Throwable)re, 2);
                    }
                    if (smc != null) {
                        smc.destroy();
                    }
                    if (!this.trace.isOn) throw re;
                    this.trace.throwing((Object)this, COMP_JN, 423, (Throwable)re, 1);
                    throw re;
                }
                Object var15_15 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 423);
                }
                if (gestatingIncremented) {
                    MQSimpleConnectionManager mQSimpleConnectionManager2 = this;
                    // MONITORENTER : mQSimpleConnectionManager2
                    --this.gestating;
                    // MONITOREXIT : mQSimpleConnectionManager2
                    gestatingIncremented = false;
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 423);
                }
                if (!gestatingIncremented) throw throwable;
                MQSimpleConnectionManager mQSimpleConnectionManager3 = this;
                // MONITORENTER : mQSimpleConnectionManager3
                --this.gestating;
                // MONITOREXIT : mQSimpleConnectionManager3
                gestatingIncremented = false;
                throw throwable;
            }
        }
        if (!this.trace.isOn) return connection;
        this.trace.exit(traceContext, (Object)this, COMP_JN, 423, connection);
        return connection;
    }

    public Object recycleConnection(MQManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) {
        int traceContext = 0;
        int fid = 424;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 424, new Object[]{mcf, cxRequestInfo});
        }
        StoredManagedConnection smc = null;
        Object connection = null;
        while ((smc = this.mcs.chooseOne(mcf, cxRequestInfo)) != null && smc.mqManCon != null) {
            try {
                connection = smc.mqManCon.getConnection(cxRequestInfo);
                break;
            }
            catch (ResourceException re) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 424, (Throwable)re);
                }
                smc.destroy();
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 424, connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object createConnection(MQManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        int toShed;
        int traceContext = 0;
        int fid = 425;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 425, new Object[]{mcf, cxRequestInfo});
        }
        String methodName = "createConnection";
        StoredManagedConnection smc = null;
        Object connection = null;
        if (this.maxCons > 0 && (toShed = 1 + this.currentSize() + this.gestating - this.maxCons) > 0) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 425, "Scavenger asked to lose " + toShed + " connections", (Object)"");
            }
            this.scavenger.destroyNext(toShed);
        }
        smc = null;
        boolean createNewSMC = false;
        boolean gestatingIncremented = false;
        MQSimpleConnectionManager mQSimpleConnectionManager = this;
        // MONITORENTER : mQSimpleConnectionManager
        if (this.maxCons == 0 || this.maxCons > this.currentSize() + this.gestating) {
            createNewSMC = true;
            ++this.gestating;
            gestatingIncremented = true;
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 425, "New SMC will be created, maxCons: " + this.maxCons + ", currentSize: " + this.currentSize() + ", gestating: " + this.gestating, (Object)"");
            }
        }
        // MONITOREXIT : mQSimpleConnectionManager
        if (!createNewSMC) {
            ResourceException traceRet1 = new ResourceException(MQException.getNLSMsg((String)"MQRESOURCE_ERROR", (String)methodName));
            if (!this.trace.isOn) throw traceRet1;
            this.trace.throwing((Object)this, COMP_JN, 425, (Throwable)traceRet1, 2);
            throw traceRet1;
        }
        try {
            try {
                smc = new StoredManagedConnection(mcf, cxRequestInfo, this.mcs, this.scavenger, this);
                mQSimpleConnectionManager = this;
                // MONITORENTER : mQSimpleConnectionManager
                smc.initializePoolActive(this.active);
                --this.gestating;
                // MONITOREXIT : mQSimpleConnectionManager
                gestatingIncremented = false;
                connection = smc.mqManCon.getConnection(cxRequestInfo);
            }
            catch (ResourceException re) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 425, (Throwable)re);
                }
                if (smc != null) {
                    smc.destroy();
                }
                if (!this.trace.isOn) throw re;
                this.trace.throwing((Object)this, COMP_JN, 425, (Throwable)re, 1);
                throw re;
            }
            Object var14_12 = null;
            if (this.trace.isOn) {
                this.trace.finallyBlock((Object)this, COMP_JN, 425);
            }
            if (gestatingIncremented) {
                MQSimpleConnectionManager mQSimpleConnectionManager2 = this;
                // MONITORENTER : mQSimpleConnectionManager2
                --this.gestating;
                // MONITOREXIT : mQSimpleConnectionManager2
                gestatingIncremented = false;
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            if (this.trace.isOn) {
                this.trace.finallyBlock((Object)this, COMP_JN, 425);
            }
            if (!gestatingIncremented) throw throwable;
            MQSimpleConnectionManager mQSimpleConnectionManager3 = this;
            // MONITORENTER : mQSimpleConnectionManager3
            --this.gestating;
            // MONITOREXIT : mQSimpleConnectionManager3
            gestatingIncremented = false;
            throw throwable;
        }
        if (!this.trace.isOn) return connection;
        this.trace.exit(traceContext, (Object)this, COMP_JN, 425, connection);
        return connection;
    }

    public synchronized void setActive(int mode) {
        int traceContext = 0;
        int fid = 426;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 426, new Object[]{new Integer(mode)});
        }
        if (mode != 0 && mode != 1 && mode != 2) {
            IllegalArgumentException traceRet1 = new IllegalArgumentException();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 426, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.mode = mode;
        switch (mode) {
            case 0: {
                if (MQEnvironment.defaultMQCxManager == this && this.poolServices.getTokenCount() > 0) {
                    this._setActive(true);
                } else {
                    this._setActive(false);
                }
                this.poolServices.addMQPoolServicesEventListener(this.adapter);
                break;
            }
            case 1: {
                this._setActive(true);
                this.poolServices.removeMQPoolServicesEventListener(this.adapter);
                break;
            }
            case 2: {
                this._setActive(false);
                this.poolServices.removeMQPoolServicesEventListener(this.adapter);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 426);
        }
    }

    public int getActive() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 1007, "returning: ", (Object)new Integer(this.mode));
        }
        return this.mode;
    }

    public void setTimeout(long timeout) {
        int traceContext = 0;
        int fid = 427;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 427, new Object[]{new Long(timeout)});
        }
        if (timeout < 0L) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 427, "setTimeout called with timeout < 0", (Object)"");
            }
            IllegalArgumentException traceRet1 = new IllegalArgumentException();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 427, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.scavenger.setTimeout(timeout);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 427);
        }
    }

    public long getTimeout() {
        long traceRet1 = this.scavenger.getTimeout();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 1008, "returning: ", (Object)new Long(traceRet1));
        }
        return traceRet1;
    }

    public void setMaxUnusedConnections(int limit) {
        int traceContext = 0;
        int fid = 428;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 428, new Object[]{new Integer(limit)});
        }
        if (limit < 0) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 428, "setHighThreshold called with thresdhold < 0", (Object)"");
            }
            IllegalArgumentException traceRet1 = new IllegalArgumentException();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 428, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.scavenger.setMaxUnusedConnections(limit);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 428);
        }
    }

    public void setHighThreshold(int limit) {
        int traceContext = 0;
        int fid = 429;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 429, new Object[]{new Integer(limit)});
        }
        if (limit < 0) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 429, "setHighThreshold called with thresdhold < 0", (Object)"");
            }
            IllegalArgumentException traceRet1 = new IllegalArgumentException();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 429, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.scavenger.setMaxUnusedConnections(limit);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 429);
        }
    }

    public int getMaxUnusedConnections() {
        int traceRet1 = this.scavenger.getMaxUnusedConnections();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 1009, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getHighThreshold() {
        int traceRet1 = this.scavenger.getMaxUnusedConnections();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 1010, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setActive(boolean active) {
        Enumeration e;
        Vector smcs;
        int traceContext = 0;
        int fid = 430;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 430, new Object[]{active});
        }
        MQSimpleConnectionManager mQSimpleConnectionManager = this;
        synchronized (mQSimpleConnectionManager) {
            this.active = active;
            smcs = (Vector)this.ownedSMCs.clone();
            e = smcs.elements();
            while (e.hasMoreElements()) {
                StoredManagedConnection smc = (StoredManagedConnection)e.nextElement();
                smc.poolActive(active);
            }
            if (active) {
                this.scavenger.start();
            } else {
                this.scavenger.quit();
            }
        }
        if (!active) {
            e = smcs.elements();
            while (e.hasMoreElements()) {
                StoredManagedConnection smc = (StoredManagedConnection)e.nextElement();
                smc.destroyIfMarked();
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 430);
        }
    }

    void addStoredManagedConnection(StoredManagedConnection smc) {
        int traceContext = 0;
        int fid = 431;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 431, new Object[]{smc});
        }
        this.ownedSMCs.addElement(smc);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 431);
        }
    }

    void removeStoredManagedConnection(StoredManagedConnection smc) {
        int traceContext = 0;
        int fid = 432;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 432, new Object[]{smc});
        }
        this.ownedSMCs.removeElement(smc);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 432);
        }
    }

    private int currentSize() {
        int traceContext = 0;
        int fid = 433;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 433);
        }
        int traceRet1 = this.ownedSMCs.size();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 433, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    private int inPool() {
        int traceContext = 0;
        int fid = 434;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 434);
        }
        int traceRet1 = this.scavenger.inPool();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 434, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setMaxConnections(int newLimit) throws IllegalArgumentException {
        int traceContext = 0;
        int fid = 435;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 435, new Object[]{new Integer(newLimit)});
        }
        if (newLimit < 0) {
            IllegalArgumentException traceRet1 = new IllegalArgumentException();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 435, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        int actualNum = this.currentSize();
        this.maxCons = newLimit;
        int inPool = this.inPool();
        int toShed = 0;
        if (newLimit < actualNum - inPool) {
            toShed = actualNum - inPool;
        } else if (newLimit < actualNum) {
            toShed = actualNum - newLimit;
        }
        this.scavenger.destroyNext(toShed);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 435);
        }
    }

    public int getMaxConnections() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 1011, "returning: ", (Object)new Integer(this.maxCons));
        }
        return this.maxCons;
    }

    synchronized void _tokenSetChanged(MQPoolServicesEvent event) {
        int traceContext = 0;
        int fid = 436;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 436, new Object[]{event});
        }
        if (this.mode == 0) {
            if (MQEnvironment.defaultMQCxManager == this && this.poolServices.getTokenCount() > 0) {
                if (!this.active) {
                    this._setActive(true);
                }
            } else if (this.active) {
                this._setActive(false);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 436);
        }
    }

    private class PSAdapter
    implements MQPoolServicesEventListener {
        private PSAdapter() {
        }

        public void tokenAdded(MQPoolServicesEvent event) {
            int traceContext = 0;
            int fid = 437;
            if (((MQSimpleConnectionManager)MQSimpleConnectionManager.this).trace.isOn) {
                traceContext = MQSimpleConnectionManager.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 437, new Object[]{event});
            }
            MQSimpleConnectionManager.this._tokenSetChanged(event);
            if (((MQSimpleConnectionManager)MQSimpleConnectionManager.this).trace.isOn) {
                MQSimpleConnectionManager.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 437);
            }
        }

        public void tokenRemoved(MQPoolServicesEvent event) {
            int traceContext = 0;
            int fid = 438;
            if (((MQSimpleConnectionManager)MQSimpleConnectionManager.this).trace.isOn) {
                traceContext = MQSimpleConnectionManager.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 438, new Object[]{event});
            }
            MQSimpleConnectionManager.this._tokenSetChanged(event);
            if (((MQSimpleConnectionManager)MQSimpleConnectionManager.this).trace.isOn) {
                MQSimpleConnectionManager.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 438);
            }
        }

        public void defaultConnectionManagerChanged(MQPoolServicesEvent event) {
            int traceContext = 0;
            int fid = 439;
            if (((MQSimpleConnectionManager)MQSimpleConnectionManager.this).trace.isOn) {
                traceContext = MQSimpleConnectionManager.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 439, new Object[]{event});
            }
            MQSimpleConnectionManager.this._tokenSetChanged(event);
            if (((MQSimpleConnectionManager)MQSimpleConnectionManager.this).trace.isOn) {
                MQSimpleConnectionManager.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 439);
            }
        }
    }
}

