/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionRequestInfo;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mq.jmqi.JmqiObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.spi.ConnectionRequestInfo;

class ManagedConnectionStore
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/ManagedConnectionStore.java, java.classes, k701, k701-112-140304 1.30.1.1 09/08/17 09:06:44";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Hashtable store = new Hashtable();

    public ManagedConnectionStore() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 18;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 18);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 18);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(StoredManagedConnection smc) {
        Vector<StoredManagedConnection> bucket;
        int traceContext = 0;
        int fid = 19;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 19, new Object[]{smc});
        }
        Object reqInfoKey = smc.cxReqInf;
        if (smc.cxReqInf instanceof MQConnectionRequestInfo) {
            reqInfoKey = ((MQConnectionRequestInfo)smc.cxReqInf).getKeyObject();
        }
        Tuple hash = new Tuple(smc.mqMcf, reqInfoKey);
        Hashtable hashtable = this.store;
        synchronized (hashtable) {
            bucket = (Vector<StoredManagedConnection>)this.store.get(hash);
            if (bucket == null) {
                bucket = new Vector<StoredManagedConnection>();
                this.store.put(hash, bucket);
            }
        }
        bucket.insertElementAt(smc, 0);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 19);
        }
    }

    void deregister(StoredManagedConnection smc) {
        Tuple hash;
        Vector bucket;
        int traceContext = 0;
        int fid = 20;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 20, new Object[]{smc});
        }
        Object reqInfoKey = smc.cxReqInf;
        if (smc.cxReqInf instanceof MQConnectionRequestInfo) {
            reqInfoKey = ((MQConnectionRequestInfo)smc.cxReqInf).getKeyObject();
        }
        if ((bucket = (Vector)this.store.get(hash = new Tuple(smc.mqMcf, reqInfoKey))) != null) {
            bucket.removeElement(smc);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoredManagedConnection chooseOne(MQManagedConnectionFactory mqMcf, ConnectionRequestInfo cxReqInf) {
        int traceContext = 0;
        int fid = 21;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 21, new Object[]{mqMcf, cxReqInf});
        }
        Object reqInfoKey = cxReqInf;
        if (cxReqInf instanceof MQConnectionRequestInfo) {
            reqInfoKey = ((MQConnectionRequestInfo)cxReqInf).getKeyObject();
        }
        StoredManagedConnection smc = null;
        boolean found = false;
        Enumeration elements = this.store.elements();
        Enumeration keys = this.store.keys();
        Object element = null;
        Tuple key = null;
        Vector bucket = null;
        while (elements.hasMoreElements() && keys.hasMoreElements()) {
            key = (Tuple)keys.nextElement();
            element = elements.nextElement();
            if (!((Object)mqMcf).equals(key.o1) || !reqInfoKey.equals(key.o2)) continue;
            bucket = element;
            break;
        }
        if (bucket != null) {
            bucket = (Vector)bucket.clone();
            Enumeration e = bucket.elements();
            while (!found && e.hasMoreElements()) {
                smc = (StoredManagedConnection)e.nextElement();
                if (smc.mqManCon == null) {
                    if (this.trace.isOn) {
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 21, null, 1);
                    }
                    return null;
                }
                MQManagedConnectionJ11 mQManagedConnectionJ11 = smc.mqManCon;
                synchronized (mQManagedConnectionJ11) {
                    if (cxReqInf instanceof MQConnectionRequestInfo) {
                        if (((MQConnectionRequestInfo)cxReqInf).variableIsSuitable(smc.mqManCon)) {
                            found = smc.use();
                        }
                    } else {
                        found = smc.use();
                    }
                }
            }
        }
        if (found && smc != null) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 21, (Object)smc, 2);
            }
            return smc;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 21, null, 3);
        }
        return null;
    }

    private class Tuple {
        Object o1;
        Object o2;

        Tuple(Object o1, Object o2) {
            int traceContext = 0;
            int fid = 22;
            if (((ManagedConnectionStore)ManagedConnectionStore.this).trace.isOn) {
                traceContext = ManagedConnectionStore.this.trace.entry_OO((Object)this, JmqiObject.COMP_JN, 22, new Object[]{o1, o2});
            }
            this.o1 = o1;
            this.o2 = o2;
            if (((ManagedConnectionStore)ManagedConnectionStore.this).trace.isOn) {
                ManagedConnectionStore.this.trace.exit(traceContext, (Object)this, JmqiObject.COMP_JN, 22);
            }
        }

        public boolean equals(Object o) {
            int fid = 23;
            Tuple t = (Tuple)o;
            boolean traceRet1 = this.o1.equals(t.o1) && this.o2.equals(t.o2);
            return traceRet1;
        }

        public int hashCode() {
            int fid = 24;
            int traceRet1 = 0;
            if (null != this.o1) {
                traceRet1 = 13 * this.o1.hashCode();
            }
            if (null != this.o2) {
                traceRet1 += 17 * this.o2.hashCode();
            }
            return traceRet1;
        }
    }
}

