/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BatchMatchingCriteria;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;
import java.util.Vector;

class MessageBufferManager
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MessageBufferManager.java, java.classes, k701, k701-112-140304 1.36.1.1 09/08/17 09:06:57";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector bufferedMsgs = null;
    private BatchMatchingCriteria bufferCriteria = null;
    private BatchMatchingCriteria testCriteria = null;

    protected MessageBufferManager() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 25;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 25);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 25, "sccsid = ", (Object)sccsid);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 25);
        }
    }

    protected void purgeBuffer(int hConn, int hObj) {
        int traceContext = 0;
        int fid = 26;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 26, new Object[]{new Integer(hConn), new Integer(hObj)});
        }
        if (this.bufferedMsgs != null && this.bufferCriteria.hcon == hConn && this.bufferCriteria.hobj == hObj && !this.bufferedMsgs.isEmpty()) {
            this.bufferedMsgs.clear();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 26);
        }
    }

    protected void purgeAllBuffers() {
        int traceContext = 0;
        int fid = 27;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 27);
        }
        if (this.bufferedMsgs != null) {
            this.bufferedMsgs.clear();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 27);
        }
    }

    protected boolean bufferExists(int hConn, int hObj, MQMsg2 msg2Desc, MQGetMessageOptions gmo) {
        int traceContext = 0;
        int fid = 28;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 28, new Object[]{new Integer(hConn), new Integer(hObj), msg2Desc, gmo});
        }
        boolean ret = false;
        if (this.bufferedMsgs != null && !this.bufferedMsgs.isEmpty()) {
            if (this.testCriteria == null) {
                this.testCriteria = new BatchMatchingCriteria();
            }
            this.testCriteria.set(hConn, hObj, msg2Desc, gmo);
            ret = this.testCriteria.matches(this.bufferCriteria);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 28, (Object)ret);
        }
        return ret;
    }

    protected void bufferMessage(byte[] replyData, BatchMatchingCriteria batchCriteria) throws MQException {
        int traceContext = 0;
        int fid = 29;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 29, new Object[]{replyData, batchCriteria});
        }
        if (this.testCriteria == null) {
            this.testCriteria = new BatchMatchingCriteria();
        }
        if (this.bufferCriteria == null) {
            this.bufferCriteria = new BatchMatchingCriteria();
        }
        if (this.bufferedMsgs == null) {
            this.bufferedMsgs = new Vector();
        }
        if (this.bufferedMsgs.isEmpty()) {
            this.bufferCriteria.set(batchCriteria);
        } else {
            this.testCriteria.set(batchCriteria);
            if (!this.bufferCriteria.matches(this.testCriteria)) {
                this.trace.ffst((Object)this, COMP_JN, 29, 1, 2195, 0, 0, "inconsistent buffering", null, null);
                MQException traceRet1 = new MQException(2, 2195, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 29, (Throwable)traceRet1);
                }
                throw traceRet1;
            }
        }
        this.bufferedMsgs.addElement(replyData);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 29);
        }
    }

    protected byte[] getBufferedMessage(int hConn, int hObj, MQMsg2 msg2Desc, MQGetMessageOptions gmo) throws MQException {
        int traceContext = 0;
        int fid = 30;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 30, new Object[]{new Integer(hConn), new Integer(hObj), msg2Desc, gmo});
        }
        if (this.bufferedMsgs == null || this.bufferedMsgs.isEmpty() || !this.bufferExists(hConn, hObj, msg2Desc, gmo)) {
            this.trace.ffst((Object)this, COMP_JN, 30, 2, 2195, 0, 0, "Batched buffer underflow", null, null);
            MQException traceRet1 = new MQException(2, 2195, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 30, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        byte[] msgBytes = (byte[])this.bufferedMsgs.firstElement();
        this.bufferedMsgs.remove(0);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 30, (Object)msgBytes);
        }
        return msgBytes;
    }

    protected boolean canCreateNewBuffer() {
        boolean traceRet1;
        int traceContext = 0;
        int fid = 31;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 31);
        }
        boolean bl = traceRet1 = this.bufferedMsgs == null || this.bufferedMsgs.isEmpty();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 31, (Object)traceRet1);
        }
        return traceRet1;
    }
}

