/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mq.jmqi.JmqiObject;
import java.util.Vector;

class PoolScavenger
extends JmqiObject
implements Runnable {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/PoolScavenger.java, java.classes, k701, k701-112-140304 1.37.1.3 13/01/15 13:30:14";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int tid = 0;
    private long timeout = 300000L;
    private int highThreshold = 10;
    private Vector smcs = new Vector();
    private Vector times = new Vector();
    private boolean quit = false;
    private boolean nonempty = false;
    private Object updateLock = new Object();
    private Thread thread = null;

    public PoolScavenger() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 472;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 472);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 472);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        int traceContext = 0;
        int fid = 473;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 473);
        }
        long expire = 0L;
        StoredManagedConnection smc = null;
        long count = 0L;
        while (!this.quit) {
            long currtime = System.currentTimeMillis();
            boolean trigger = false;
            Object object = this.updateLock;
            synchronized (object) {
                block18: {
                    block19: {
                        if (!this.smcs.isEmpty()) {
                            expire = (Long)this.times.firstElement() + this.timeout;
                            smc = (StoredManagedConnection)this.smcs.firstElement();
                            count = this.smcs.size();
                            this.nonempty = true;
                        } else {
                            this.nonempty = false;
                        }
                        if (this.quit) break block18;
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 473, "Pool count = " + count + "/" + this.highThreshold + ", timeout(ms) = " + this.timeout + ", " + "current time = " + currtime + ", expire time = " + expire, (Object)"");
                        }
                        if (!this.nonempty) break block19;
                        if (expire <= currtime || count > (long)this.highThreshold) {
                            if (this.trace.isOn) {
                                this.trace.dataFmt(this.env, COMP_JN, 473, "SMC expired; about to call trigger()", (Object)"");
                            }
                            trigger = true;
                            break block18;
                        } else {
                            try {
                                if (this.trace.isOn) {
                                    this.trace.dataFmt(this.env, COMP_JN, 473, "Waiting for SMC to expire", (Object)"");
                                }
                                this.updateLock.wait(expire - currtime);
                            }
                            catch (InterruptedException e) {
                                if (this.trace.isOn) {
                                    this.trace.catchBlock((Object)this, COMP_JN, 473, (Throwable)e, 1);
                                }
                                break block18;
                            }
                        }
                    }
                    try {
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 473, "No SMC in list; waiting", (Object)"");
                        }
                        this.updateLock.wait();
                    }
                    catch (InterruptedException e) {
                        if (!this.trace.isOn) break block18;
                        this.trace.catchBlock((Object)this, COMP_JN, 473, (Throwable)e, 2);
                    }
                }
                if (!trigger) continue;
            }
            smc.trigger();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 473);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(StoredManagedConnection smc) {
        int traceContext = 0;
        int fid = 474;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 474, new Object[]{smc});
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.smcs.addElement(smc);
            this.times.addElement(new Long(System.currentTimeMillis()));
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 474, "Notifying scavenger thread", (Object)"");
            }
            this.updateLock.notify();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 474);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregister(StoredManagedConnection smc) {
        int traceContext = 0;
        int fid = 475;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 475, new Object[]{smc});
        }
        Object object = this.updateLock;
        synchronized (object) {
            int p = this.smcs.indexOf(smc);
            if (p != -1) {
                this.smcs.removeElementAt(p);
                this.times.removeElementAt(p);
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 475, "Notifying scavenger thread", (Object)"");
                }
                this.updateLock.notify();
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 475);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeout(long timeout) {
        int traceContext = 0;
        int fid = 476;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 476, new Object[]{new Long(timeout)});
        }
        this.timeout = timeout;
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 476, "Notifying scavenger thread", (Object)"");
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.updateLock.notify();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 476);
        }
    }

    long getTimeout() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 1039, "returning: ", (Object)new Long(this.timeout));
        }
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxUnusedConnections(int threshold) {
        int traceContext = 0;
        int fid = 477;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 477, new Object[]{new Integer(threshold)});
        }
        this.highThreshold = threshold;
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 477, "Notifying scavenger thread", (Object)"");
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.updateLock.notify();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 477);
        }
    }

    int getMaxUnusedConnections() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 1040, "returning: ", (Object)new Integer(this.highThreshold));
        }
        return this.highThreshold;
    }

    void start() {
        int traceContext = 0;
        int fid = 478;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 478);
        }
        this.quit = false;
        if (this.thread == null) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 478, "Creating new Pool Scavenger thread", (Object)"");
            }
            String tName = "PoolScavenger" + tid;
            ++tid;
            this.thread = MQEnvironment.createThread(this, tName, true);
            this.thread.start();
        } else if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 478, "A thread has already been created for this Pool Scavenger", (Object)"");
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 478);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quit() {
        int traceContext;
        block12: {
            traceContext = 0;
            int fid = 479;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 479);
            }
            this.quit = true;
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 479, "Notifying scavenger thread", (Object)"");
            }
            Object object = this.updateLock;
            synchronized (object) {
                this.updateLock.notify();
            }
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 479, "Waiting for scavenger thread to end", (Object)"");
            }
            try {
                if (this.thread != null) {
                    this.thread.join();
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, COMP_JN, 479, "Setting thread to null", (Object)"");
                    }
                    this.thread = null;
                }
            }
            catch (InterruptedException e) {
                if (this.trace.isOn) {
                    this.trace.catchBlock((Object)this, COMP_JN, 479, (Throwable)e);
                }
                if (!this.trace.isOn) break block12;
                this.trace.dataFmt(this.env, COMP_JN, 479, "WARNING: Thread was interrupted", (Object)"");
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 479);
        }
    }

    public int inPool() {
        int traceContext = 0;
        int fid = 480;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 480);
        }
        int traceRet1 = this.smcs.size();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 480, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void destroyNext(int count) {
        int traceContext = 0;
        int fid = 481;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 481, new Object[]{new Integer(count)});
        }
        if (this.smcs.isEmpty()) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 481, 1);
            }
            return;
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 481, "destroying " + count + " inactive connections", (Object)"");
        }
        StoredManagedConnection smc = null;
        for (int i = 0; i < count && !this.smcs.isEmpty(); ++i) {
            smc = (StoredManagedConnection)this.smcs.firstElement();
            smc.trigger();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 481, 2);
        }
    }
}

