/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQXid;
import com.ibm.mq.internal.MQCommonServices;
import com.ibm.mq.internal.MQThreadLocalStorage;
import com.ibm.mq.jmqi.JmqiObject;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAtoJTA
extends JmqiObject
implements ConnectionEventListener {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/XAtoJTA.java, java.classes, k701, k701-112-140304 1.24.1.9 13/05/23 11:50:13";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int INITIAL_BEGINRC = 2121;
    public static final int TMNOFLAGS = 0;
    public static final int XA_NOMIGRATE = 9;
    public static final int XA_HEURHAZ = 8;
    public static final int XA_HEURCOM = 7;
    public static final int XA_HEURRB = 6;
    public static final int XA_HEURMIX = 5;
    public static final int XA_RETRY = 4;
    public static final int XA_RDONLY = 3;
    public static final int XA_OK = 0;
    public static final int XAER_ASYNC = -2;
    public static final int XAER_RMERR = -3;
    private static boolean useOra816;
    private Hashtable resourcesByRmid = new Hashtable(10);
    private Hashtable resourcesByConn = new Hashtable(10);
    private Hashtable spareRmids = new Hashtable();
    private Vector spareXAConns = new Stack();
    private Vector dirtyResources = new Vector();
    private int openCount = 0;
    private boolean inTransaction = false;
    private static int XATransactionTimeout;
    private static boolean removeCEL;
    private int beginRC;

    private XAtoJTA() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 745;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 745);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 745, "value of XATransactionTimeout: " + XATransactionTimeout, (Object)"");
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 745, "value of removeConnectionEventListener: " + removeCEL, (Object)"");
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 745);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectionClosed(ConnectionEvent event) {
        int traceContext;
        block15: {
            traceContext = 0;
            int fid = 746;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 746, new Object[]{event});
            }
            try {
                try {
                    if (useOra816) {
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 746, "ignoring event because useOra816 flag is set", (Object)"");
                        }
                    } else {
                        XAConnection conn = (XAConnection)event.getSource();
                        this._deregisterResource(conn);
                        if (removeCEL) {
                            if (this.trace.isOn) {
                                this.trace.dataFmt(this.env, COMP_JN, 746, "removing connectionEventListener", (Object)"");
                            }
                            conn.removeConnectionEventListener(this);
                        }
                        conn.close();
                    }
                }
                catch (Exception e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 746, (Throwable)e);
                    }
                    Object var6_7 = null;
                    if (this.trace.isOn) {
                        this.trace.finallyBlock((Object)this, COMP_JN, 746);
                    }
                    break block15;
                }
                Object var6_6 = null;
                if (!this.trace.isOn) break block15;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 746);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 746);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 746);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        int traceContext = 0;
        int fid = 747;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 747, new Object[]{event});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 747);
        }
    }

    protected static XAtoJTA getThreadInstance() {
        MQThreadLocalStorage tls = MQCommonServices.getTls();
        XAtoJTA instance = tls.getXaToJta();
        if (instance == null) {
            instance = new XAtoJTA();
        }
        tls.setXaToJta(instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void close() {
        int traceContext;
        block16: {
            traceContext = 0;
            int fid = 748;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 748);
            }
            try {
                XAConnection con;
                Enumeration<Object> en = this.spareXAConns.elements();
                while (en.hasMoreElements()) {
                    block15: {
                        con = (XAConnection)en.nextElement();
                        try {
                            con.removeConnectionEventListener(this);
                        }
                        catch (Exception e) {
                            if (!this.trace.isOn) break block15;
                            this.trace.catchBlock((Object)this, COMP_JN, 748, (Throwable)e, 1);
                        }
                    }
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        if (!this.trace.isOn) continue;
                        this.trace.catchBlock((Object)this, COMP_JN, 748, (Throwable)e, 2);
                    }
                }
                en = this.resourcesByConn.keys();
                while (en.hasMoreElements()) {
                    con = (XAConnection)en.nextElement();
                    if (removeCEL) {
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 748, "removing connectionEventListener", (Object)"");
                        }
                        con.removeConnectionEventListener(this);
                    }
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        if (!this.trace.isOn) continue;
                        this.trace.catchBlock((Object)this, COMP_JN, 748, (Throwable)e, 3);
                    }
                }
                this.spareRmids.clear();
                this.spareXAConns.removeAllElements();
                this.dirtyResources.removeAllElements();
                this.resourcesByRmid.clear();
                this.resourcesByConn.clear();
                Object var7_9 = null;
                if (!this.trace.isOn) break block16;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 748);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 748);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 748);
        }
    }

    public static XAConnection createRegisteredConnection(XADataSource xads, String user, String password) throws MQException, SQLException, XAException {
        XAConnection xaconn = null;
        xaconn = user != null ? xads.getXAConnection(user, password) : xads.getXAConnection();
        XAtoJTA instance = XAtoJTA.getThreadInstance();
        instance._registerResource(xaconn);
        return xaconn;
    }

    public static void deregisterResource(XAConnection xaconn) throws XAException {
        XAtoJTA instance = XAtoJTA.getThreadInstance();
        instance._deregisterResource(xaconn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int XAOpen(String openString, int rmid, int flags, int pid) {
        XAtoJTA instance;
        block3: {
            instance = XAtoJTA.getThreadInstance();
            if (instance != null) break block3;
            int n = -3;
            return n;
        }
        int n = instance.xa_open(rmid, flags);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int XAClose(String closeString, int rmid, int flags) {
        XAtoJTA instance;
        block3: {
            instance = XAtoJTA.getThreadInstance();
            if (instance != null) break block3;
            int n = -3;
            return n;
        }
        int n = instance.xa_close(rmid, flags);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int XAStart(byte[] gtrid, byte[] bqual, int format, int rmid, int flags) {
        XAtoJTA instance;
        block3: {
            instance = XAtoJTA.getThreadInstance();
            if (instance != null) break block3;
            int n = -3;
            return n;
        }
        int n = instance.xa_start(gtrid, bqual, format, rmid, flags);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int XAEnd(byte[] gtrid, byte[] bqual, int format, int rmid, int flags) {
        XAtoJTA instance;
        block3: {
            instance = XAtoJTA.getThreadInstance();
            if (instance != null) break block3;
            int n = -3;
            return n;
        }
        int n = instance.xa_end(gtrid, bqual, format, rmid, flags);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int XARollback(byte[] gtrid, byte[] bqual, int format, int rmid, int flags) {
        XAtoJTA instance;
        block3: {
            instance = XAtoJTA.getThreadInstance();
            if (instance != null) break block3;
            int n = -3;
            return n;
        }
        int n = instance.xa_rollback(gtrid, bqual, format, rmid, flags);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_open(int rmid, int flags) {
        int xa_rc;
        int traceContext;
        block10: {
            traceContext = 0;
            int fid = 749;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 749, new Object[]{new Integer(rmid), new Integer(flags)});
            }
            xa_rc = -3;
            try {
                try {
                    ++this.openCount;
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, COMP_JN, 749, "open count is now " + this.openCount, (Object)"");
                    }
                    Integer rmId = new Integer(rmid);
                    RR rr = new RR();
                    rr.rmId = rmId;
                    this.spareRmids.put(rmId, rr);
                    xa_rc = 0;
                }
                catch (Exception e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 749, (Throwable)e);
                    }
                    Object var9_10 = null;
                    if (this.trace.isOn) {
                        this.trace.finallyBlock((Object)this, COMP_JN, 749);
                    }
                    break block10;
                }
                Object var9_9 = null;
                if (!this.trace.isOn) break block10;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 749);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 749);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 749, (Object)new Integer(xa_rc));
        }
        return xa_rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_close(int rmid, int flags) {
        int xa_rc;
        int traceContext;
        block9: {
            traceContext = 0;
            int fid = 750;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 750, new Object[]{new Integer(rmid), new Integer(flags)});
            }
            xa_rc = -3;
            try {
                try {
                    this.close();
                    --this.openCount;
                    xa_rc = 0;
                }
                catch (Exception e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 750, (Throwable)e);
                    }
                    Object var8_7 = null;
                    if (this.trace.isOn) {
                        this.trace.finallyBlock((Object)this, COMP_JN, 750);
                    }
                    break block9;
                }
                Object var8_6 = null;
                if (!this.trace.isOn) break block9;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 750);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 750);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 750, (Object)new Integer(xa_rc));
        }
        return xa_rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_start(byte[] gtrid, byte[] bqual, int format, int rmid, int flags) {
        int xa_rc;
        int traceContext;
        block46: {
            block45: {
                int n;
                block44: {
                    int n2;
                    block43: {
                        int n3;
                        block42: {
                            int n4;
                            block41: {
                                int n5;
                                block40: {
                                    traceContext = 0;
                                    int fid = 751;
                                    if (this.trace.isOn) {
                                        traceContext = this.trace.entry_OO((Object)this, COMP_JN, 751, new Object[]{gtrid, bqual, new Integer(format), new Integer(rmid), new Integer(flags)});
                                    }
                                    xa_rc = -3;
                                    try {
                                        try {
                                            void var8_35;
                                            if (this.beginRC == 2121) {
                                                if (this.trace.isOn) {
                                                    this.trace.dataFmt(this.env, COMP_JN, 751, "resetting beginRc to MQRC_NONE", (Object)"");
                                                }
                                                this.beginRC = 0;
                                            }
                                            if (!this.inTransaction && this.spareXAConns.size() > this.spareRmids.size()) {
                                                if (this.trace.isOn) {
                                                    this.trace.dataFmt(this.env, COMP_JN, 751, "not enough rmids for registered connections", (Object)"");
                                                }
                                                this.beginRC = 2372;
                                                if (this.trace.isOn) {
                                                    this.trace.exit(traceContext, (Object)this, COMP_JN, 751, (Object)new Integer(-3), 1);
                                                }
                                                n5 = -3;
                                                Object var17_14 = null;
                                                if (!this.trace.isOn) return n5;
                                                break block40;
                                            }
                                            if (flags != 0) {
                                                if (this.trace.isOn) {
                                                    this.trace.dataFmt(this.env, COMP_JN, 751, "unexpected value of flags: ", (Object)(flags + ", returning RMERR"));
                                                }
                                                if (this.trace.isOn) {
                                                    this.trace.exit(traceContext, (Object)this, COMP_JN, 751, (Object)new Integer(-3), 2);
                                                }
                                                n4 = -3;
                                                break block41;
                                            }
                                            this.inTransaction = true;
                                            Integer rmId = new Integer(rmid);
                                            if (useOra816) {
                                                try {
                                                    if (this.trace.isOn) {
                                                        this.trace.dataFmt(this.env, COMP_JN, 751, "creating oracle xid", (Object)"");
                                                    }
                                                    Class<?> oraXidClass = Class.forName("oracle.jdbc.xa.OracleXid");
                                                    Class[] paramTypes = new Class[]{Integer.TYPE, [B.class, [B.class};
                                                    Constructor<?> con = oraXidClass.getConstructor(paramTypes);
                                                    Object[] params = new Object[]{new Integer(format), gtrid, bqual};
                                                    Xid xid = (Xid)con.newInstance(params);
                                                }
                                                catch (Exception e) {
                                                    if (this.trace.isOn) {
                                                        this.trace.catchBlock((Object)this, COMP_JN, 751, (Throwable)e, 1);
                                                    }
                                                    if (this.trace.isOn) {
                                                        this.trace.exit(traceContext, (Object)this, COMP_JN, 751, (Object)new Integer(-3), 3);
                                                    }
                                                    int n6 = -3;
                                                    Object var17_16 = null;
                                                    if (!this.trace.isOn) return n6;
                                                    this.trace.finallyBlock((Object)this, COMP_JN, 751);
                                                    return n6;
                                                }
                                            } else {
                                                if (this.trace.isOn) {
                                                    this.trace.dataFmt(this.env, COMP_JN, 751, "creating a standard xid", (Object)"");
                                                }
                                                MQXid mQXid = new MQXid(format, gtrid, bqual);
                                            }
                                            RR res = (RR)this.resourcesByRmid.get(rmId);
                                            if (res == null) {
                                                if (this.spareXAConns.isEmpty()) {
                                                    RR rr;
                                                    if (this.trace.isOn) {
                                                        this.trace.dataFmt(this.env, COMP_JN, 751, "no connection available for rmid ", (Object)(rmid + ", must be spare"));
                                                    }
                                                    if ((rr = (RR)this.spareRmids.get(rmId)) == null) {
                                                        if (this.trace.isOn) {
                                                            this.trace.dataFmt(this.env, COMP_JN, 751, "problem: rmId ", (Object)(rmId + " missing from the spareRmids list - returning error"));
                                                        }
                                                        if (this.trace.isOn) {
                                                            this.trace.exit(traceContext, (Object)this, COMP_JN, 751, (Object)new Integer(-3), 4);
                                                        }
                                                        n3 = -3;
                                                        break block42;
                                                    }
                                                    rr.xid = var8_35;
                                                    if (this.trace.isOn) {
                                                        this.trace.exit(traceContext, (Object)this, COMP_JN, 751, (Object)new Integer(0), 5);
                                                    }
                                                    n2 = 0;
                                                    break block43;
                                                }
                                                XAConnection con = (XAConnection)this.spareXAConns.lastElement();
                                                this.spareXAConns.removeElement(con);
                                                res = (RR)this.spareRmids.remove(rmId);
                                                if (res == null) {
                                                    if (this.trace.isOn) {
                                                        this.trace.dataFmt(this.env, COMP_JN, 751, "can't find rmid on spareRmids list (2nd position)", (Object)Integer.toString(rmid));
                                                    }
                                                    if (this.trace.isOn) {
                                                        this.trace.exit(traceContext, (Object)this, COMP_JN, 751, (Object)new Integer(-3), 6);
                                                    }
                                                    n = -3;
                                                    break block44;
                                                }
                                                res.res = con.getXAResource();
                                                res.rmId = rmId;
                                                this.resourcesByRmid.put(rmId, res);
                                                this.resourcesByConn.put(con, res);
                                            }
                                            XAResource xares = res.res;
                                            res.xid = var8_35;
                                            if (this.trace.isOn) {
                                                this.trace.dataFmt(this.env, COMP_JN, 751, "XAStart, xid '" + var8_35 + "', flags " + flags, (Object)"");
                                            }
                                            xares.start((Xid)var8_35, flags);
                                            xa_rc = 0;
                                            break block45;
                                        }
                                        catch (XAException e) {
                                            if (this.trace.isOn) {
                                                this.trace.catchBlock((Object)this, COMP_JN, 751, (Throwable)e, 2);
                                            }
                                            xa_rc = e.errorCode;
                                            Object var17_21 = null;
                                            if (this.trace.isOn) {
                                                this.trace.finallyBlock((Object)this, COMP_JN, 751);
                                            }
                                            break block46;
                                        }
                                        catch (Exception e) {
                                            if (this.trace.isOn) {
                                                this.trace.catchBlock((Object)this, COMP_JN, 751, (Throwable)e, 3);
                                            }
                                            xa_rc = -3;
                                            Object var17_22 = null;
                                            if (this.trace.isOn) {
                                                this.trace.finallyBlock((Object)this, COMP_JN, 751);
                                            }
                                            break block46;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var17_23 = null;
                                        if (this.trace.isOn) {
                                            this.trace.finallyBlock((Object)this, COMP_JN, 751);
                                        }
                                        throw throwable;
                                    }
                                }
                                this.trace.finallyBlock((Object)this, COMP_JN, 751);
                                return n5;
                            }
                            Object var17_15 = null;
                            if (!this.trace.isOn) return n4;
                            this.trace.finallyBlock((Object)this, COMP_JN, 751);
                            return n4;
                        }
                        Object var17_17 = null;
                        if (!this.trace.isOn) return n3;
                        this.trace.finallyBlock((Object)this, COMP_JN, 751);
                        return n3;
                    }
                    Object var17_18 = null;
                    if (!this.trace.isOn) return n2;
                    this.trace.finallyBlock((Object)this, COMP_JN, 751);
                    return n2;
                }
                Object var17_19 = null;
                if (!this.trace.isOn) return n;
                this.trace.finallyBlock((Object)this, COMP_JN, 751);
                return n;
            }
            Object var17_20 = null;
            if (this.trace.isOn) {
                this.trace.finallyBlock((Object)this, COMP_JN, 751);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 751, (Object)new Integer(xa_rc), 7);
        }
        return xa_rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_end(byte[] gtrid, byte[] bqual, int format, int rmid, int flags) {
        int xa_rc;
        int traceContext;
        block27: {
            block26: {
                int n;
                block25: {
                    int n2;
                    block24: {
                        int n3;
                        block23: {
                            traceContext = 0;
                            int fid = 752;
                            if (this.trace.isOn) {
                                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 752, new Object[]{gtrid, bqual, new Integer(format), new Integer(rmid), new Integer(flags)});
                            }
                            xa_rc = -3;
                            try {
                                try {
                                    this.inTransaction = false;
                                    this.dirtyResources.removeAllElements();
                                    Integer rmId = new Integer(rmid);
                                    RR rr = (RR)this.resourcesByRmid.get(rmId);
                                    if (rr == null) {
                                        if (this.trace.isOn) {
                                            this.trace.dataFmt(this.env, COMP_JN, 752, "rmid not assigned", (Object)"");
                                        }
                                        if (this.trace.isOn) {
                                            this.trace.exit(traceContext, (Object)this, COMP_JN, 752, (Object)new Integer(0), 1);
                                        }
                                        n3 = 0;
                                        Object var15_15 = null;
                                        if (!this.trace.isOn) return n3;
                                        break block23;
                                    }
                                    XAResource xares = rr.res;
                                    if (xares == null) {
                                        if (this.trace.isOn) {
                                            this.trace.dataFmt(this.env, COMP_JN, 752, "odd: assigned rmid with null XAResouce", (Object)"");
                                        }
                                        if (this.trace.isOn) {
                                            this.trace.exit(traceContext, (Object)this, COMP_JN, 752, (Object)new Integer(0), 2);
                                        }
                                        n2 = 0;
                                        break block24;
                                    }
                                    Xid xid = rr.xid;
                                    if (xid == null) {
                                        if (this.trace.isOn) {
                                            this.trace.dataFmt(this.env, COMP_JN, 752, "odd: assigned rmid with null xid", (Object)"");
                                        }
                                        if (this.trace.isOn) {
                                            this.trace.exit(traceContext, (Object)this, COMP_JN, 752, (Object)new Integer(0), 3);
                                        }
                                        n = 0;
                                        break block25;
                                    }
                                    if (this.trace.isOn) {
                                        this.trace.dataFmt(this.env, COMP_JN, 752, "xid is '" + xid + "', flags are " + flags, (Object)"");
                                    }
                                    xares.end(xid, flags);
                                    xa_rc = 0;
                                    break block26;
                                }
                                catch (XAException e) {
                                    if (this.trace.isOn) {
                                        this.trace.catchBlock((Object)this, COMP_JN, 752, (Throwable)e, 1);
                                    }
                                    xa_rc = e.errorCode;
                                    Object var15_19 = null;
                                    if (this.trace.isOn) {
                                        this.trace.finallyBlock((Object)this, COMP_JN, 752);
                                    }
                                    break block27;
                                }
                                catch (Exception e) {
                                    if (this.trace.isOn) {
                                        this.trace.catchBlock((Object)this, COMP_JN, 752, (Throwable)e, 2);
                                    }
                                    xa_rc = -3;
                                    Object var15_20 = null;
                                    if (this.trace.isOn) {
                                        this.trace.finallyBlock((Object)this, COMP_JN, 752);
                                    }
                                    break block27;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var15_21 = null;
                                if (this.trace.isOn) {
                                    this.trace.finallyBlock((Object)this, COMP_JN, 752);
                                }
                                throw throwable;
                            }
                        }
                        this.trace.finallyBlock((Object)this, COMP_JN, 752);
                        return n3;
                    }
                    Object var15_16 = null;
                    if (!this.trace.isOn) return n2;
                    this.trace.finallyBlock((Object)this, COMP_JN, 752);
                    return n2;
                }
                Object var15_17 = null;
                if (!this.trace.isOn) return n;
                this.trace.finallyBlock((Object)this, COMP_JN, 752);
                return n;
            }
            Object var15_18 = null;
            if (this.trace.isOn) {
                this.trace.finallyBlock((Object)this, COMP_JN, 752);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 752, (Object)new Integer(xa_rc), 4);
        }
        return xa_rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int xa_rollback(byte[] gtrid, byte[] bqual, int format, int rmid, int flags) {
        int xa_rc;
        int traceContext;
        block24: {
            int e2;
            block23: {
                int n;
                block22: {
                    traceContext = 0;
                    boolean fid = false;
                    if (this.trace.isOn) {
                        traceContext = this.trace.entry_OO((Object)this, COMP_JN, 0, new Object[]{gtrid, bqual, new Integer(format), new Integer(rmid), new Integer(flags)});
                    }
                    xa_rc = -3;
                    try {
                        try {
                            void var8_29;
                            if (this.trace.isOn) {
                                this.trace.data(COMP_JN, 0, "XARollback: rmid is ", (Object)new Integer(rmid));
                            }
                            if (flags != 0) {
                                if (this.trace.isOn) {
                                    this.trace.data(COMP_JN, 0, "unexpected value of flags: " + flags + ", returning RMERR", (Object)new Integer(flags));
                                    this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(-3), 1);
                                }
                                n = -3;
                                Object var17_13 = null;
                                if (!this.trace.isOn) return n;
                                break block22;
                            }
                            Integer rmId = new Integer(rmid);
                            if (useOra816) {
                                try {
                                    if (this.trace.isOn) {
                                        this.trace.dataFmt(this.env, COMP_JN, 0, "creating oracle xid", (Object)"");
                                    }
                                    Class oraXidClass = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                                        public Object run() {
                                            try {
                                                Class<?> oraXidClass = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.xa.OracleXid");
                                                return oraXidClass;
                                            }
                                            catch (AccessControlException ace) {
                                                if (((XAtoJTA)XAtoJTA.this).trace.isOn) {
                                                    XAtoJTA.this.trace.catchBlock((Object)this, JmqiObject.COMP_JN, 0, (Throwable)ace, 1);
                                                }
                                                return null;
                                            }
                                            catch (ClassNotFoundException e) {
                                                if (((XAtoJTA)XAtoJTA.this).trace.isOn) {
                                                    XAtoJTA.this.trace.catchBlock((Object)this, JmqiObject.COMP_JN, 0, (Throwable)e, 2);
                                                }
                                                return null;
                                            }
                                        }
                                    });
                                    Class[] paramTypes = new Class[]{Integer.TYPE, [B.class, [B.class};
                                    Constructor con = oraXidClass.getConstructor(paramTypes);
                                    Object[] params = new Object[]{new Integer(format), gtrid, bqual};
                                    Xid xid = (Xid)con.newInstance(params);
                                }
                                catch (Exception e2) {
                                    if (this.trace.isOn) {
                                        this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(-3), 2);
                                    }
                                    int n2 = -3;
                                    Object var17_14 = null;
                                    if (!this.trace.isOn) return n2;
                                    this.trace.finallyBlock((Object)this, COMP_JN, 0);
                                    this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(xa_rc), 4);
                                    return n2;
                                }
                            } else {
                                if (this.trace.isOn) {
                                    this.trace.data(COMP_JN, 0, "creating a standard xid", (Object)"");
                                }
                                MQXid mQXid = new MQXid(format, gtrid, bqual);
                            }
                            RR res = (RR)this.resourcesByRmid.get(rmId);
                            if (res == null) {
                                if (this.trace.isOn) {
                                    this.trace.data(COMP_JN, 0, "rmid not assigned", (Object)"");
                                    this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(-3), 3);
                                }
                                e2 = -3;
                                break block23;
                            }
                            XAResource xares = res.res;
                            if (this.trace.isOn) {
                                this.trace.data(COMP_JN, 0, "XARollback, xid '" + var8_29 + "'", (Object)"");
                            }
                            xares.rollback((Xid)var8_29);
                            xa_rc = 0;
                            break block24;
                        }
                        catch (XAException e3) {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, COMP_JN, 0, (Throwable)e3, 3);
                            }
                            xa_rc = e3.errorCode;
                            Object var17_17 = null;
                            if (!this.trace.isOn) return xa_rc;
                            this.trace.finallyBlock((Object)this, COMP_JN, 0);
                            this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(xa_rc), 4);
                            return xa_rc;
                        }
                        catch (Exception e4) {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, COMP_JN, 0, (Throwable)e4, 4);
                            }
                            xa_rc = -3;
                            Object var17_18 = null;
                            if (!this.trace.isOn) return xa_rc;
                            this.trace.finallyBlock((Object)this, COMP_JN, 0);
                            this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(xa_rc), 4);
                            return xa_rc;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_19 = null;
                        if (!this.trace.isOn) throw throwable;
                        this.trace.finallyBlock((Object)this, COMP_JN, 0);
                        this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(xa_rc), 4);
                        throw throwable;
                    }
                }
                this.trace.finallyBlock((Object)this, COMP_JN, 0);
                this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(xa_rc), 4);
                return n;
            }
            Object var17_15 = null;
            if (!this.trace.isOn) return e2;
            this.trace.finallyBlock((Object)this, COMP_JN, 0);
            this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(xa_rc), 4);
            return e2;
        }
        Object var17_16 = null;
        if (!this.trace.isOn) return xa_rc;
        this.trace.finallyBlock((Object)this, COMP_JN, 0);
        this.trace.exit(traceContext, (Object)this, COMP_JN, 0, (Object)new Integer(xa_rc), 4);
        return xa_rc;
    }

    private void _deregisterResource(XAConnection xaconn) throws XAException {
        RR rs;
        int traceContext = 0;
        int fid = 753;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 753, new Object[]{xaconn});
        }
        if ((rs = (RR)this.resourcesByConn.get(xaconn)) == null) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 753, "conn not assigned, checking spares", (Object)"");
            }
            if (!this.spareXAConns.removeElement(xaconn)) {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 753, "conn not found in spare list either", (Object)"");
                }
            } else if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 753, "found conn in spares list", (Object)"");
            }
        } else {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 753, "found RR for xaconn", (Object)"");
            }
            XAResource xares = rs.res;
            Integer rmId = rs.rmId;
            if (this.inTransaction) {
                Xid xid = rs.xid;
                if (xid == null) {
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, COMP_JN, 753, "odd - no xid for rmid ", (Object)rmId);
                    }
                } else {
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, COMP_JN, 753, "doing xa_end", (Object)"");
                    }
                    xares.end(xid, 0x4000000);
                    this.dirtyResources.addElement(xares);
                }
            } else if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 753, "not in transaction, skipping xa_end", (Object)"");
            }
            this.resourcesByConn.remove(xaconn);
            this.resourcesByRmid.remove(rmId);
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 753, "putting rmId " + rmId + " back onto spares list", (Object)"");
            }
            this.spareRmids.put(rmId, rs);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 753);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _registerResource(XAConnection xaconn) throws MQException, SQLException, XAException {
        int traceContext;
        block34: {
            traceContext = 0;
            int fid = 754;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 754, new Object[]{xaconn});
            }
            RR res = null;
            try {
                try {
                    XAResource other;
                    XAResource xaRes = xaconn.getXAResource();
                    if (XATransactionTimeout != -1) {
                        boolean result = xaRes.setTransactionTimeout(XATransactionTimeout);
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 754, "is XATransactionTimeout set successfully?: " + result + ", value of XATransactionTimeout: " + XATransactionTimeout, (Object)"");
                        }
                    }
                    Enumeration<Object> en = this.spareXAConns.elements();
                    while (en.hasMoreElements()) {
                        XAConnection con = (XAConnection)en.nextElement();
                        other = con.getXAResource();
                        if (!xaRes.isSameRM(other)) continue;
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 754, "xaResource matches previously registered connection, returning an error", (Object)"");
                        }
                        MQException traceRet1 = new MQException(2, 2195, (Object)this);
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 754, (Throwable)traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                    en = this.resourcesByConn.keys();
                    while (en.hasMoreElements()) {
                        XAConnection con = (XAConnection)en.nextElement();
                        other = con.getXAResource();
                        if (!xaRes.isSameRM(other)) continue;
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 754, "xaResource matches previously registered connection, returning an error", (Object)"");
                        }
                        MQException traceRet2 = new MQException(2, 2195, (Object)this);
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 754, (Throwable)traceRet2, 2);
                        }
                        throw traceRet2;
                    }
                    if (!this.inTransaction) {
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 754, "not in transaction, adding to spare conns", (Object)"");
                        }
                        this.spareXAConns.addElement(xaconn);
                        xaconn.addConnectionEventListener(this);
                    } else {
                        en = this.dirtyResources.elements();
                        while (en.hasMoreElements()) {
                            XAResource dirty = (XAResource)en.nextElement();
                            if (!xaRes.isSameRM(dirty)) continue;
                            if (this.trace.isOn) {
                                this.trace.dataFmt(this.env, COMP_JN, 754, "XAResource found on dirty list - app confused - throwing exception to tell MQSESSION to rollback", (Object)"");
                            }
                            MQException traceRet3 = new MQException(2, 2003, (Object)this);
                            if (this.trace.isOn) {
                                this.trace.throwing((Object)this, COMP_JN, 754, (Throwable)traceRet3, 3);
                            }
                            throw traceRet3;
                        }
                        if (this.spareRmids.isEmpty()) {
                            if (this.trace.isOn) {
                                this.trace.dataFmt(this.env, COMP_JN, 754, "no spare rmids available, throwing an exception", (Object)"");
                            }
                            MQException traceRet4 = new MQException(2, 2372, (Object)this);
                            if (this.trace.isOn) {
                                this.trace.throwing((Object)this, COMP_JN, 754, (Throwable)traceRet4, 4);
                            }
                            throw traceRet4;
                        }
                        en = this.spareRmids.keys();
                        Integer rmId = (Integer)en.nextElement();
                        res = (RR)this.spareRmids.remove(rmId);
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 754, "in transaction, driving xa_start", (Object)"");
                        }
                        res.res = xaRes;
                        xaRes.start(res.xid, 0);
                        this.resourcesByRmid.put(rmId, res);
                        this.resourcesByConn.put(xaconn, res);
                        xaconn.addConnectionEventListener(this);
                    }
                }
                catch (XAException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 754, (Throwable)e, 1);
                    }
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 754, (Throwable)e, 5);
                    }
                    throw e;
                }
                catch (SQLException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 754, (Throwable)e, 2);
                    }
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 754, (Throwable)e, 6);
                    }
                    throw e;
                }
                catch (MQException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JN, 754, (Throwable)e, 3);
                    }
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 754, (Throwable)e, 7);
                    }
                    throw e;
                }
                Object var12_19 = null;
                if (!this.trace.isOn) break block34;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, COMP_JN, 754);
                }
                throw throwable;
            }
            this.trace.finallyBlock((Object)this, COMP_JN, 754);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 754);
        }
    }

    protected void _resetRC() {
        int traceContext = 0;
        int fid = 755;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 755);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 755, "resetting beginRC", (Object)"");
        }
        this.beginRC = 2121;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 755);
        }
    }

    protected int _getRC() {
        int traceContext = 0;
        int fid = 756;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 756);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 756, "returning beginRC=", (Object)Integer.toString(this.beginRC));
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 756, (Object)new Integer(this.beginRC));
        }
        return this.beginRC;
    }

    static {
        Boolean close;
        XATransactionTimeout = -1;
        removeCEL = false;
        String ora816fix = (String)AccessController.doPrivileged(new PrivilegedActionImpl());
        useOra816 = ora816fix != null;
        Integer XATransact = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Integer.getInteger("com.ibm.mq.jdbc.XATransactionTimeoutPeriod");
                }
                catch (AccessControlException ace) {
                    return null;
                }
            }
        });
        if (XATransact != null) {
            XATransactionTimeout = XATransact;
        }
        if ((close = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new Boolean(Boolean.getBoolean("com.ibm.mq.jdbc.removeConnectionEventListener"));
                }
                catch (AccessControlException ace) {
                    return null;
                }
            }
        })) != null) {
            removeCEL = close;
        }
    }

    static class PrivilegedActionImpl
    implements PrivilegedAction {
        PrivilegedActionImpl() {
        }

        public Object run() {
            try {
                return System.getProperty("MQ_JDBC_ORA816");
            }
            catch (AccessControlException ace) {
                return null;
            }
        }
    }

    private class RR {
        public XAResource res;
        public Integer rmId;
        public Xid xid;

        private RR() {
        }
    }
}

