/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.internal;

import com.ibm.mq.internal.trace.Names;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.JmqiTraceHandlerAdapter;
import com.ibm.mq.jmqi.internal.MqiStructure;
import com.ibm.mq.jmqi.internal.trace.MQNames;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.JmqiTls;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class JMSCommonServicesTraceHandler
extends JmqiTraceHandlerAdapter
implements Trace.TraceHandler {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/internal/JMSCommonServicesTraceHandler.java, jmscc, k701, k701-112-140304 1.3.1.1 09/08/17 07:53:40";

    public static String right(String s, int width, char fillChar) {
        if (s.length() >= width) {
            return s;
        }
        StringBuffer sb = new StringBuffer(width);
        int i = width - s.length();
        while (--i >= 0) {
            sb.append(fillChar);
        }
        sb.append(s);
        return sb.toString();
    }

    public JMSCommonServicesTraceHandler() {
        Trace.registerTraceHandler((Trace.TraceHandler)this);
    }

    public void catchBlock(int compID, int funcID, Throwable thrown) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.catchBlock((String)className, (String)methodName, (Throwable)thrown);
    }

    public void catchBlock(int compID, int funcID, Throwable thrown, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.catchBlock((String)className, (String)methodName, (Throwable)thrown, (int)exitIndex);
    }

    public void catchBlock(Object parentClass, int compID, int funcID, Throwable thrown) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.catchBlock((Object)parentClass, (String)className, (String)methodName, (Throwable)thrown);
    }

    public void catchBlock(Object parentClass, int compID, int funcID, Throwable thrown, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.catchBlock((Object)parentClass, (String)className, (String)methodName, (Throwable)thrown, (int)exitIndex);
    }

    public void data(int compID, int funcID, String uniqueDescription, Object data) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.data((String)className, (String)methodName, (String)uniqueDescription, (Object)data);
    }

    public void data(Object parentClass, int compID, int funcID, String text, Object data) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.data((Object)parentClass, (String)className, (String)methodName, (String)text, (Object)data);
    }

    public void data(int jmqiTraceLevel, Object parentClass, int compID, int funcID, String text, Object data) {
        int jmsTraceLevel = jmqiTraceLevel >= 7 ? 1 : (jmqiTraceLevel >= 6 ? 3 : (jmqiTraceLevel >= 5 ? 6 : (jmqiTraceLevel >= 4 ? 6 : (jmqiTraceLevel >= 3 ? 8 : (jmqiTraceLevel >= 2 ? 9 : (jmqiTraceLevel >= 1 ? 10 : 10))))));
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.data((int)jmsTraceLevel, (Object)parentClass, (String)className, (String)methodName, (String)text, (Object)data);
    }

    public void dataFmt(JmqiEnvironment env, int compID, int funcID, String uniqueDescription, Object data) {
        this.dataFmt(env, null, compID, funcID, uniqueDescription, data);
    }

    public void dataFmt(JmqiEnvironment env, Object parentClass, int compID, int funcID, String uniqueDescription, Object data) {
        boolean bufferHexDump;
        JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)env;
        JmqiCodepage nativeCp = env.getNativeCharSet();
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        int offset = 0;
        int bytesToDump = 0;
        ByteBuffer buffer = null;
        byte[] array = null;
        boolean arrayHexDump = data instanceof byte[];
        if (arrayHexDump) {
            array = (byte[])data;
            offset = 0;
            bytesToDump = array.length;
        }
        if (bufferHexDump = data instanceof ByteBuffer) {
            buffer = (ByteBuffer)data;
            offset = buffer.position();
            bytesToDump = buffer.limit() - offset;
        }
        if (data instanceof MqiStructure) {
            try {
                MqiStructure mqiStruc = (MqiStructure)data;
                arrayHexDump = true;
                offset = 0;
                JmqiTls tls = sysenv.getJmqiTls(null);
                array = new byte[mqiStruc.getRequiredBufferSize(4, nativeCp)];
                bytesToDump = mqiStruc.writeToTraceBuffer(array, 0, 4, false, nativeCp, tls);
            }
            catch (Throwable e) {
                this.data((Object)this, JmqiObject.COMP_JN, 0, "Failed tracing MQI object", data.toString());
                this.throwing((Object)this, JmqiObject.COMP_JN, 0, e);
                return;
            }
        }
        if (data == null) {
            Trace.data((String)className, (String)methodName, (Object)(uniqueDescription + ": <null>"));
        } else if (arrayHexDump || bufferHexDump) {
            if (bytesToDump > 0) {
                StringBuffer dumpBuffer = null;
                dumpBuffer = bytesToDump < 512 ? new StringBuffer(4 * bytesToDump) : new StringBuffer(2048);
                if (uniqueDescription != null) {
                    Trace.data((String)className, (String)methodName, (Object)(uniqueDescription + ": " + data.toString()));
                }
                if (arrayHexDump) {
                    Trace.data((String)className, (String)methodName, (Object)array);
                }
                if (bufferHexDump) {
                    Trace.data((String)className, (String)methodName, (Object)buffer);
                }
            } else {
                Trace.data((String)className, (String)methodName, (Object)(uniqueDescription + ": " + data.toString()));
            }
        } else if (data instanceof int[]) {
            int[] intArr = (int[])data;
            StringBuffer dumpBuffer = new StringBuffer(intArr.length * 12);
            dumpBuffer.append("int[");
            for (int i = 0; i < intArr.length; ++i) {
                if (i != 0) {
                    dumpBuffer.append(",");
                }
                dumpBuffer.append(Integer.toString(intArr[i]));
                dumpBuffer.append("(0x");
                dumpBuffer.append(Integer.toHexString(intArr[i]));
                dumpBuffer.append(")");
            }
            dumpBuffer.append("]");
            Trace.data((String)className, (String)methodName, (Object)(uniqueDescription + ": " + data.toString()));
        } else {
            Trace.data((String)className, (String)methodName, (Object)(uniqueDescription + ": " + data.toString()));
        }
    }

    public void entry(int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.entry((String)className, (String)methodName);
    }

    public void entry(int compID, int funcID, Object[] parameters) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.entry((String)className, (String)methodName, (Object[])parameters);
    }

    public void entry(Object parentClass, int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.entry((Object)parentClass, (String)className, (String)methodName);
    }

    public void entry(Object parentClass, int compID, int funcID, Object[] parameters) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.entry((Object)parentClass, (String)className, (String)methodName, (Object[])parameters);
    }

    public int entry_OO(int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.entry((String)className, (String)methodName);
        return 0;
    }

    public int entry_OO(int compID, int funcID, Object[] parameters) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.entry((String)className, (String)methodName, (Object[])parameters);
        return 0;
    }

    public int entry_OO(Object parentClass, int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.entry((Object)parentClass, (String)className, (String)methodName);
        return 0;
    }

    public int entry_OO(Object parentClass, int compID, int funcID, Object[] parameters) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.entry((Object)parentClass, (String)className, (String)methodName, (Object[])parameters);
        return 0;
    }

    public void exit(int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((String)className, (String)methodName);
    }

    public void exit(int compID, int funcID, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((String)className, (String)methodName, (int)exitIndex);
    }

    public void exit(int compID, int funcID, Object returnValue) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((String)className, (String)methodName, (Object)returnValue);
    }

    public void exit(int compID, int funcID, Object returnValue, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((String)className, (String)methodName, (Object)returnValue, (int)exitIndex);
    }

    public void exit(Object parentClass, int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((Object)parentClass, (String)className, (String)methodName);
    }

    public void exit(Object parentClass, int compID, int funcID, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((Object)parentClass, (String)className, (String)methodName, (int)exitIndex);
    }

    public void exit(Object parentClass, int compID, int funcID, Object returnValue) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((Object)parentClass, (String)className, (String)methodName, (Object)returnValue);
    }

    public void exit(Object parentClass, int compID, int funcID, Object returnValue, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((Object)parentClass, (String)className, (String)methodName, (Object)returnValue, (int)exitIndex);
    }

    public void exit_OO(int ctx, int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((String)className, (String)methodName);
    }

    public void exit(int ctx, int compID, int funcID, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((String)className, (String)methodName, (int)exitIndex);
    }

    public void exit(int ctx, int compID, int funcID, Object returnValue) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((String)className, (String)methodName, (Object)returnValue);
    }

    public void exit(int ctx, int compID, int funcID, Object returnValue, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((String)className, (String)methodName, (Object)returnValue, (int)exitIndex);
    }

    public void exit(int ctx, Object parentClass, int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((Object)parentClass, (String)className, (String)methodName);
    }

    public void exit(int ctx, Object parentClass, int compID, int funcID, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((Object)parentClass, (String)className, (String)methodName, (int)exitIndex);
    }

    public void exit(int ctx, Object parentClass, int compID, int funcID, Object returnValue) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((Object)parentClass, (String)className, (String)methodName, (Object)returnValue);
    }

    public void exit(int ctx, Object parentClass, int compID, int funcID, Object returnValue, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.exit((Object)parentClass, (String)className, (String)methodName, (Object)returnValue, (int)exitIndex);
    }

    public void ffst(int compID, int funcID, int probe, int rc, int insert1, int insert2, String insert3, String insert4, String insert5) {
        this.ffst(null, compID, funcID, probe, rc, insert1, insert2, insert3, insert4, insert5);
    }

    public void ffst(Object parentClass, int compID, int funcID, int probe, int rc, int insert1, int insert2, String insert3, String insert4, String insert5) {
        this.ffst(parentClass, compID, funcID, probe, rc, insert1, insert2, insert3, insert4, insert5, null);
    }

    public void ffst(Object parentClass, int compID, int funcID, int probe, int rc, int insert1, int insert2, String insert3, String insert4, String insert5, Throwable throwable) {
        String methodName = this.getMethodName(compID, funcID);
        String probeString = this.getProbeString(compID, funcID, probe);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("RETURNCODE", new Integer(rc));
        data.put("INSERT1", new Integer(insert1));
        data.put("INSERT2", new Integer(insert2));
        if (insert3 != null) {
            data.put("INSERT3", insert3);
        }
        if (insert4 != null) {
            data.put("INSERT4", insert4);
        }
        if (insert5 != null) {
            data.put("INSERT5", insert5);
        }
        if (throwable != null) {
            data.put("THROWABLE", throwable);
        }
        try {
            Trace.ffst((Object)parentClass, (String)methodName, (String)probeString, data, null);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void finallyBlock(int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.finallyBlock((String)className, (String)methodName);
    }

    public void finallyBlock(int compID, int funcID, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.finallyBlock((String)className, (String)methodName, (int)exitIndex);
    }

    public void finallyBlock(Object parentClass, int compID, int funcID) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.finallyBlock((Object)parentClass, (String)className, (String)methodName);
    }

    public void finallyBlock(Object parentClass, int compID, int funcID, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.finallyBlock((Object)parentClass, (String)className, (String)methodName, (int)exitIndex);
    }

    private String getClassName(int compID, int funcID) {
        String name = null;
        name = JmqiObject.COMP_JM == compID ? com.ibm.mq.jmqi.internal.trace.Names.getClassName((int)funcID) : (JmqiObject.COMP_JO == compID ? MQNames.getClassName((int)funcID) : (JmqiObject.COMP_JN == compID ? Names.getClassName(funcID) : (JmqiObject.COMP_JH == compID ? com.ibm.mq.headers.internal.trace.Names.getClassName((int)funcID) : "compId=" + compID + " funcID=" + funcID)));
        return name;
    }

    private String getMethodName(int compID, int funcID) {
        String name = null;
        name = JmqiObject.COMP_JM == compID ? com.ibm.mq.jmqi.internal.trace.Names.getMethodName((int)funcID) : (JmqiObject.COMP_JO == compID ? MQNames.getMethodName((int)funcID) : (JmqiObject.COMP_JN == compID ? Names.getClassName(funcID) : (JmqiObject.COMP_JH == compID ? com.ibm.mq.headers.internal.trace.Names.getClassName((int)funcID) : "compId=" + compID + " funcID=" + funcID)));
        return name;
    }

    private String getProbeString(int compId, int funcId, int probe) {
        StringBuffer buffer = new StringBuffer();
        if (JmqiObject.COMP_JM == compId) {
            buffer.append("JM");
        } else if (JmqiObject.COMP_JO == compId) {
            buffer.append("JO");
        } else {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            data.put("compid", new Integer(compId));
            data.put("funcid", new Integer(funcId));
            Trace.ffst((Object)((Object)this), (String)"getClassName", (String)"JCT001001", data, null);
        }
        buffer.append(JMSCommonServicesTraceHandler.right(Integer.toString(funcId), 3, '0'));
        buffer.append(JMSCommonServicesTraceHandler.right(Integer.toString(probe), 3, '0'));
        return buffer.toString();
    }

    public void throwing(int compID, int funcID, Throwable thrown) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.throwing((String)className, (String)methodName, (Throwable)thrown);
    }

    public void throwing(int compID, int funcID, Throwable thrown, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.throwing((String)className, (String)methodName, (Throwable)thrown, (int)exitIndex);
    }

    public void throwing(Object parentClass, int compID, int funcID, Throwable thrown) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.throwing((Object)parentClass, (String)className, (String)methodName, (Throwable)thrown);
    }

    public void throwing(Object parentClass, int compID, int funcID, Throwable thrown, int exitIndex) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.throwing((Object)parentClass, (String)className, (String)methodName, (Throwable)thrown, (int)exitIndex);
    }

    public void trace(Object parentClass, int compID, int funcID, String text) {
        String className = this.getClassName(compID, funcID);
        String methodName = this.getMethodName(compID, funcID);
        Trace.data((Object)parentClass, (String)className, (String)methodName, (Object)text);
    }
}

