/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.internal;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.internal.JMSCommonServicesTraceHandler;
import com.ibm.mq.internal.MQThreadLocalStorage;
import com.ibm.mq.internal.trace.Names;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiFactory;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.JmqiPropertyHandler;
import com.ibm.mq.jmqi.JmqiThreadPool;
import com.ibm.mq.jmqi.JmqiThreadPoolFactory;
import com.ibm.mq.jmqi.JmqiTraceHandlerAdapter;
import com.ibm.mq.jmqi.JmqiUtils;
import com.ibm.mq.jmqi.internal.JmqiTools;
import com.ibm.mq.jmqi.internal.MqiStructure;
import com.ibm.mq.jmqi.internal.trace.MQNames;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiComponent;
import com.ibm.mq.jmqi.system.JmqiComponentTls;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.JmqiTls;
import com.ibm.msg.client.commonservices.cssystem.WASSupport;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class MQCommonServices
implements JmqiComponent {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/internal/MQCommonServices.java, java.classes, k701, k701-112-140304 1.45.1.2 13/01/14 17:25:00";
    private static int DETAIL;
    public static JmqiEnvironment jmqiEnv;
    public static int jmqiCompId;
    public static MQCommonServices jmqiComponent;
    public static JmqiTraceHandlerAdapter traceHandler;
    private static boolean classInitialisationComplete;
    public static JmqiThreadPool threads;
    public static JmqiThreadPoolFactory threadPool;
    public static JmqiPropertyHandler propertyHandler;
    private static boolean MqHeadersTrace;

    public static void enableTrace() {
        jmqiEnv.getTraceHandler().setOn(true);
    }

    public static void disableTrace() {
        jmqiEnv.getTraceHandler().setOn(false);
    }

    public String getJmqiComponentName() {
        return "com.ibm.mq";
    }

    public JmqiComponentTls newTlsObject() {
        return new MQThreadLocalStorage();
    }

    public static MQThreadLocalStorage getTls() {
        return (MQThreadLocalStorage)((JmqiSystemEnvironment)jmqiEnv).getComponentTls(jmqiCompId);
    }

    private static boolean traceOffForComp(int compid) {
        return !MqHeadersTrace && compid == 58;
    }

    private static boolean isJmsCommonServicesRequired() {
        boolean integrate = false;
        Helper helper = null;
        helper = new Helper(){

            public Object run() {
                Boolean integrate = Boolean.FALSE;
                WASSupport support = WASSupport.getWASSupport();
                integrate = support.isWASCommonServicesPresent() ? Boolean.TRUE : Boolean.FALSE;
                return integrate;
            }
        };
        Boolean bool = (Boolean)helper.runIgnoresNoClass();
        integrate = bool != null ? bool : false;
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.integrateJMSTrace");
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        if (o instanceof String) {
            integrate = Boolean.valueOf((String)o);
        }
        return integrate;
    }

    static {
        String prop;
        DETAIL = 500;
        jmqiEnv = null;
        jmqiCompId = -1;
        classInitialisationComplete = false;
        threads = new JmqiThreadPool(){

            public void enqueue(Runnable runnable) {
                Thread newThread = new Thread(runnable);
                newThread.setDaemon(true);
                newThread.start();
            }
        };
        threadPool = new JmqiThreadPoolFactory(){

            public JmqiThreadPool getThreadPool() {
                return threads;
            }
        };
        propertyHandler = new JmqiPropertyHandler(){
            private Class MQEnvironmentClass = null;
            private Field propertiesField = null;
            private Hashtable propertiesTable = null;

            public String getProperty(String name) {
                String result = System.getProperty(name);
                if (result == null && classInitialisationComplete) {
                    result = this.getMQEnvProperty(name);
                }
                return result;
            }

            private String getMQEnvProperty(String name) {
                if (this.MQEnvironmentClass == null) {
                    try {
                        this.MQEnvironmentClass = Class.forName("com.ibm.mq.MQEnvironment");
                        this.propertiesField = this.MQEnvironmentClass.getField("properties");
                        this.propertiesTable = (Hashtable)this.propertiesField.get(this.MQEnvironmentClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return (String)this.propertiesTable.get(name);
            }
        };
        MqHeadersTrace = false;
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.headers.trace.status");
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        if (o != null && o instanceof String && (prop = (String)o).equalsIgnoreCase("ON")) {
            MqHeadersTrace = true;
        }
        try {
            Trace t = new Trace("com.ibm.mq");
            CommonServices.processInitialize((Trace)t);
            CommonServices.registerTraceNames((int)58, (String[])com.ibm.mq.headers.internal.trace.Names.getNames());
            CommonServices.registerTraceNames((int)60, (String[])Names.getNames());
            CommonServices.registerTraceNames((int)59, (String[])com.ibm.mq.jmqi.internal.trace.Names.getNames());
            CommonServices.registerTraceNames((int)61, (String[])MQNames.getNames());
        }
        catch (CommonServicesException e) {
            throw new MQCommonServicesInitializationException(e);
        }
        traceHandler = null;
        if (MQCommonServices.isJmsCommonServicesRequired()) {
            traceHandler = (JmqiTraceHandlerAdapter)new Helper(){

                public Object run() {
                    return new JMSCommonServicesTraceHandler();
                }
            }.runIgnoresNoClass();
        }
        if (traceHandler == null) {
            traceHandler = new MQCommonServicesTraceHandler();
        }
        try {
            JmqiTraceHandlerAdapter trace = traceHandler;
            trace.setOn(Trace.isTracing || MQCommonServices.traceHandler.isOn);
            jmqiEnv = JmqiFactory.getInstance((JmqiTraceHandlerAdapter)trace, (JmqiThreadPoolFactory)threadPool, (JmqiPropertyHandler)propertyHandler);
            jmqiComponent = new MQCommonServices();
            jmqiCompId = ((JmqiSystemEnvironment)jmqiEnv).registerComponent((JmqiComponent)jmqiComponent);
        }
        catch (JmqiException e) {
            throw new MQCommonServicesInitializationException(e);
        }
        jmqiEnv.setCaller('B');
        classInitialisationComplete = true;
    }

    public static abstract class Helper {
        public Object runIgnoresNoClass() {
            Object o = null;
            try {
                o = this.run();
            }
            catch (NoClassDefFoundError e) {
                o = null;
            }
            return o;
        }

        public abstract Object run();
    }

    private static final class MQCommonServicesTraceHandler
    extends JmqiTraceHandlerAdapter {
        private MQCommonServicesTraceHandler() {
        }

        private String getObjectId(Object object) {
            String objectId = "";
            if (object != null) {
                if (object instanceof String) {
                    objectId = (String)object;
                } else {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("[0x");
                    int id = System.identityHashCode(object);
                    String hex = Integer.toHexString(id);
                    buffer.append(hex);
                    buffer.append("] ");
                    objectId = buffer.toString();
                }
            }
            return objectId;
        }

        public void dataFmt(JmqiEnvironment env, Object parentClass, int compID, int funcID, String description, Object data) {
            boolean bufferHexDump;
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)env;
            String uniqueDescription = this.getObjectId(parentClass);
            if (description != null) {
                uniqueDescription = uniqueDescription + description;
            }
            JmqiCodepage cp1208 = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)env, (int)1208);
            int offset = 0;
            int bytesToDump = 0;
            ByteBuffer buffer = null;
            byte[] array = null;
            boolean arrayHexDump = data instanceof byte[];
            if (arrayHexDump) {
                array = (byte[])data;
                offset = 0;
                bytesToDump = array.length;
            }
            if (bufferHexDump = data instanceof ByteBuffer) {
                buffer = (ByteBuffer)data;
                offset = buffer.position();
                bytesToDump = buffer.limit() - offset;
            }
            if (data instanceof MqiStructure) {
                try {
                    MqiStructure mqiStruc = (MqiStructure)data;
                    bufferHexDump = true;
                    offset = 0;
                    JmqiTls tls = sysenv.getJmqiTls(null);
                    array = new byte[mqiStruc.getRequiredBufferSize(4, cp1208)];
                    bytesToDump = mqiStruc.writeToTraceBuffer(array, 0, 4, false, cp1208, tls);
                }
                catch (Throwable e) {
                    this.data((Object)this, JmqiObject.COMP_JN, 934, "Failed to trace MQI object", data.toString());
                    this.throwing((Object)this, JmqiObject.COMP_JN, 934, e);
                    return;
                }
            }
            if (data == null) {
                wmqTrace.data(compID, funcID, DETAIL, uniqueDescription + ": <null>");
            } else if (arrayHexDump || bufferHexDump) {
                if (bytesToDump > 0) {
                    StringBuffer dumpBuffer = null;
                    dumpBuffer = bytesToDump < 512 ? new StringBuffer(4 * bytesToDump) : new StringBuffer(2048);
                    if (uniqueDescription != null) {
                        dumpBuffer.append(uniqueDescription + ": " + data.toString() + JmqiUtils.NL);
                    }
                    while (bytesToDump > 0) {
                        int thisDump = bytesToDump > 512 ? 512 : bytesToDump;
                        JmqiTools.hexDump((byte[])array, (ByteBuffer)buffer, (int)offset, (int)thisDump, (StringBuffer)dumpBuffer);
                        wmqTrace.data(compID, funcID, DETAIL, dumpBuffer.toString());
                        offset += thisDump;
                        bytesToDump -= thisDump;
                        dumpBuffer.setLength(0);
                    }
                } else {
                    wmqTrace.data(compID, funcID, DETAIL, uniqueDescription + ": " + data.toString());
                }
            } else if (data instanceof int[]) {
                int[] intArr = (int[])data;
                StringBuffer dumpBuffer = new StringBuffer(intArr.length * 12);
                dumpBuffer.append("int[");
                for (int i = 0; i < intArr.length; ++i) {
                    if (i != 0) {
                        dumpBuffer.append(",");
                    }
                    dumpBuffer.append(Integer.toString(intArr[i]));
                    dumpBuffer.append("(0x");
                    dumpBuffer.append(Integer.toHexString(intArr[i]));
                    dumpBuffer.append(")");
                }
                dumpBuffer.append("]");
                wmqTrace.data(compID, funcID, DETAIL, uniqueDescription + ": " + dumpBuffer.toString());
            } else {
                wmqTrace.data(compID, funcID, DETAIL, uniqueDescription + ": " + data.toString());
            }
        }

        public void dataFmt(JmqiEnvironment env, int compID, int funcID, String uniqueDescription, Object data) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            this.dataFmt(env, null, compID, funcID, uniqueDescription, data);
        }

        public void data(Object parentClass, int compID, int funcID, String description, Object data) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            String uniqueDescription = this.getObjectId(parentClass);
            if (description != null) {
                uniqueDescription = uniqueDescription + description;
            }
            Trace.getDefault().data(compID, funcID, DETAIL, uniqueDescription + ": " + (data != null ? data.toString() : "<null>"));
        }

        public void data(int jmqiTraceLevel, Object parentClass, int compID, int funcID, String uniqueDescription, Object data) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            int javaTraceLevel = jmqiTraceLevel >= 7 ? 1000 : (jmqiTraceLevel >= 6 ? 900 : (jmqiTraceLevel >= 5 ? 800 : (jmqiTraceLevel >= 4 ? 700 : (jmqiTraceLevel >= 3 ? 500 : (jmqiTraceLevel >= 2 ? 400 : (jmqiTraceLevel >= 1 ? 300 : 300))))));
            String text = uniqueDescription;
            if (data != null) {
                text = text + ": " + data.toString();
            }
            Trace.getDefault().data(compID, funcID, javaTraceLevel, text);
        }

        public void data(int compID, int funcID, String uniqueDescription, Object data) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().data(compID, funcID, DETAIL, uniqueDescription + ": " + (data != null ? data.toString() : "<null>"));
        }

        public void ffst(int compID, int funcID, int probe, int rc, int insert1, int insert2, String insert3, String insert4, String insert5) {
            Trace.getDefault().FFST(compID, funcID, probe, rc, insert1, insert2, insert3, insert4, insert5);
        }

        public void ffst(Object parentClass, int compID, int funcID, int probe, int rc, int insert1, int insert2, String insert3, String insert4, String insert5) {
            Trace.getDefault().data(compID, funcID, DETAIL, this.getObjectId(parentClass));
            Trace.getDefault().FFST(compID, funcID, probe, rc, insert1, insert2, insert3, insert4, insert5);
        }

        public void ffst(Object parentClass, int compID, int funcID, int probe, int rc, int insert1, int insert2, String insert3, String insert4, String insert5, Throwable throwable) {
            Trace.getDefault().data(compID, funcID, DETAIL, this.getObjectId(parentClass));
            Trace.getDefault().FFST(compID, funcID, probe, rc, insert1, insert2, insert3, insert4, insert5, throwable);
        }

        public void trace(Object parentClass, int compID, int funcID, String description) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            String uniqueDescription = this.getObjectId(parentClass);
            if (description != null) {
                uniqueDescription = uniqueDescription + description;
            }
            Trace.getDefault().data(compID, funcID, DETAIL, uniqueDescription);
        }

        public void catchBlock(int compID, int funcID, Throwable thrown, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            wmqTrace.data(compID, funcID, DETAIL, "Exception caught [idx=" + exitIndex + "]: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                wmqTrace.data(compID, funcID, DETAIL, elements[i].toString());
            }
        }

        public void catchBlock(int compID, int funcID, Throwable thrown) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            wmqTrace.data(compID, funcID, DETAIL, "Exception caught: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                wmqTrace.data(compID, funcID, DETAIL, elements[i].toString());
            }
        }

        public void catchBlock(Object parentClass, int compID, int funcID, Throwable thrown, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            String objectId = this.getObjectId(parentClass);
            wmqTrace.data(compID, funcID, DETAIL, objectId + "Exception caught [idx=" + exitIndex + "]: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                wmqTrace.data(compID, funcID, DETAIL, elements[i].toString());
            }
        }

        public void catchBlock(Object parentClass, int compID, int funcID, Throwable thrown) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            String objectId = this.getObjectId(parentClass);
            wmqTrace.data(compID, funcID, DETAIL, objectId + "Exception caught: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                wmqTrace.data(compID, funcID, DETAIL, elements[i].toString());
            }
        }

        public void entry(int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().entry(compID, funcID, DETAIL);
        }

        public void entry(int compID, int funcID, Object[] parameters) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            if (parameters != null) {
                StringBuffer traceBuff = new StringBuffer();
                traceBuff.append("params: ");
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        traceBuff.append(",");
                    }
                    if (parameters[i] != null) {
                        traceBuff.append(parameters[i].toString());
                        continue;
                    }
                    traceBuff.append("<null>");
                }
                wmqTrace.entry(compID, funcID, DETAIL, traceBuff.toString());
            } else {
                wmqTrace.entry(compID, funcID, DETAIL);
            }
        }

        public void entry(Object parentClass, int compID, int funcID, Object[] parameters) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            if (parameters != null) {
                StringBuffer traceBuff = new StringBuffer();
                traceBuff.append(this.getObjectId(parentClass));
                traceBuff.append(" params: ");
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        traceBuff.append(",");
                    }
                    if (parameters[i] != null) {
                        traceBuff.append(parameters[i].toString());
                        continue;
                    }
                    traceBuff.append("<null>");
                }
                wmqTrace.entry(compID, funcID, DETAIL, traceBuff.toString());
            } else {
                wmqTrace.entry(compID, funcID, DETAIL, this.getObjectId(parentClass));
            }
        }

        public void entry(Object parentClass, int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().entry(compID, funcID, DETAIL, this.getObjectId(parentClass));
        }

        public int entry_OO(int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return 0;
            }
            return Trace.getDefault().entry_OO(compID, funcID, DETAIL);
        }

        public int entry_OO(int compID, int funcID, Object[] parameters) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return 0;
            }
            Trace wmqTrace = Trace.getDefault();
            if (parameters != null) {
                StringBuffer traceBuff = new StringBuffer();
                traceBuff.append("params: ");
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        traceBuff.append(",");
                    }
                    if (parameters[i] != null) {
                        traceBuff.append(parameters[i].toString());
                        continue;
                    }
                    traceBuff.append("<null>");
                }
                return wmqTrace.entry_OO(compID, funcID, DETAIL, traceBuff.toString());
            }
            return wmqTrace.entry_OO(compID, funcID, DETAIL);
        }

        public int entry_OO(Object parentClass, int compID, int funcID, Object[] parameters) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return 0;
            }
            Trace wmqTrace = Trace.getDefault();
            if (parameters != null) {
                StringBuffer traceBuff = new StringBuffer();
                traceBuff.append(this.getObjectId(parentClass));
                traceBuff.append(" params: ");
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        traceBuff.append(",");
                    }
                    if (parameters[i] != null) {
                        traceBuff.append(parameters[i].toString());
                        continue;
                    }
                    traceBuff.append("<null>");
                }
                return wmqTrace.entry_OO(compID, funcID, DETAIL, traceBuff.toString());
            }
            return wmqTrace.entry_OO(compID, funcID, DETAIL, this.getObjectId(parentClass));
        }

        public int entry_OO(Object parentClass, int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return 0;
            }
            return Trace.getDefault().entry_OO(compID, funcID, DETAIL, this.getObjectId(parentClass));
        }

        public void exit(int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().exit(compID, funcID, DETAIL);
        }

        public void exit(int compID, int funcID, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("[idx");
            buffer.append(exitIndex);
            buffer.append("]");
            Trace.getDefault().exit(compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(int compID, int funcID, Object returnValue) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            if (null == returnValue) {
                buffer.append("<null>");
            } else {
                buffer.append(returnValue.toString());
            }
            Trace.getDefault().exit(compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(int compID, int funcID, Object returnValue, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("[idx");
            buffer.append(exitIndex);
            buffer.append("] ");
            if (null == returnValue) {
                buffer.append("<null>");
            } else {
                buffer.append(returnValue.toString());
            }
            Trace.getDefault().exit(compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(Object parentClass, int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().exit(compID, funcID, 0, DETAIL, this.getObjectId(parentClass));
        }

        public void exit(Object parentClass, int compID, int funcID, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getObjectId(parentClass));
            buffer.append(" [idx");
            buffer.append(exitIndex);
            buffer.append("]");
            Trace.getDefault().exit(compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(Object parentClass, int compID, int funcID, Object returnValue) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getObjectId(parentClass));
            buffer.append(" ");
            if (null == returnValue) {
                buffer.append("<null>");
            } else {
                buffer.append(returnValue.toString());
            }
            Trace.getDefault().exit(compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(Object parentClass, int compID, int funcID, Object returnValue, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getObjectId(parentClass));
            buffer.append(" [idx");
            buffer.append(exitIndex);
            buffer.append("] ");
            if (null == returnValue) {
                buffer.append("<null>");
            } else {
                buffer.append(returnValue.toString());
            }
            Trace.getDefault().exit(compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit_OO(int ctx, int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().exit_OO(ctx, compID, funcID, DETAIL);
        }

        public void exit(int ctx, int compID, int funcID, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("[idx");
            buffer.append(exitIndex);
            buffer.append("]");
            Trace.getDefault().exit_OO(ctx, compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(int ctx, int compID, int funcID, Object returnValue) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            if (null == returnValue) {
                buffer.append("<null>");
            } else {
                buffer.append(returnValue.toString());
            }
            Trace.getDefault().exit_OO(ctx, compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(int ctx, int compID, int funcID, Object returnValue, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("[idx");
            buffer.append(exitIndex);
            buffer.append("] ");
            if (null == returnValue) {
                buffer.append("<null>");
            } else {
                buffer.append(returnValue.toString());
            }
            Trace.getDefault().exit_OO(ctx, compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(int ctx, Object parentClass, int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().exit_OO(ctx, compID, funcID, 0, DETAIL, this.getObjectId(parentClass));
        }

        public void exit(int ctx, Object parentClass, int compID, int funcID, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getObjectId(parentClass));
            buffer.append(" [idx");
            buffer.append(exitIndex);
            buffer.append("]");
            Trace.getDefault().exit_OO(ctx, compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(int ctx, Object parentClass, int compID, int funcID, Object returnValue) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getObjectId(parentClass));
            buffer.append(" ");
            if (null == returnValue) {
                buffer.append("<null>");
            } else {
                buffer.append(returnValue.toString());
            }
            Trace.getDefault().exit_OO(ctx, compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void exit(int ctx, Object parentClass, int compID, int funcID, Object returnValue, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getObjectId(parentClass));
            buffer.append(" [idx");
            buffer.append(exitIndex);
            buffer.append("] ");
            if (null == returnValue) {
                buffer.append("<null>");
            } else {
                buffer.append(returnValue.toString());
            }
            Trace.getDefault().exit_OO(ctx, compID, funcID, 0, DETAIL, buffer.toString());
        }

        public void finallyBlock(int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().data(compID, funcID, DETAIL, "Finally block");
        }

        public void finallyBlock(int compID, int funcID, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("Finally block [idx=");
            buffer.append(exitIndex);
            buffer.append("]");
            Trace.getDefault().data(compID, funcID, DETAIL, buffer.toString());
        }

        public void finallyBlock(Object parentClass, int compID, int funcID) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace.getDefault().data(compID, funcID, DETAIL, this.getObjectId(parentClass) + "Finally block");
        }

        public void finallyBlock(Object parentClass, int compID, int funcID, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getObjectId(parentClass));
            buffer.append("Finally block [idx=");
            buffer.append(exitIndex);
            buffer.append("]");
            Trace.getDefault().data(compID, funcID, DETAIL, buffer.toString());
        }

        public void throwing(int compID, int funcID, Throwable thrown, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            wmqTrace.data(compID, funcID, DETAIL, "Throwing Exception [idx=" + exitIndex + "]: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                wmqTrace.data(compID, funcID, DETAIL, elements[i].toString());
            }
        }

        public void throwing(int compID, int funcID, Throwable thrown) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            wmqTrace.data(compID, funcID, DETAIL, "Throwing Exception: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                wmqTrace.data(compID, funcID, DETAIL, elements[i].toString());
            }
        }

        public void throwing(Object parentClass, int compID, int funcID, Throwable thrown, int exitIndex) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            String objectId = this.getObjectId(parentClass);
            wmqTrace.data(compID, funcID, DETAIL, objectId + "Throwing Exception [idx=" + exitIndex + "]: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                wmqTrace.data(compID, funcID, DETAIL, elements[i].toString());
            }
        }

        public void throwing(Object parentClass, int compID, int funcID, Throwable thrown) {
            if (MQCommonServices.traceOffForComp(compID)) {
                return;
            }
            Trace wmqTrace = Trace.getDefault();
            String objectId = this.getObjectId(parentClass);
            wmqTrace.data(compID, funcID, DETAIL, objectId + "Throwing Exception: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                wmqTrace.data(compID, funcID, DETAIL, elements[i].toString());
            }
        }
    }

    private static final class MQCommonServicesInitializationException
    extends RuntimeException {
        static final long serialVersionUID = -2451892550460914442L;

        public MQCommonServicesInitializationException(Throwable cause) {
            super(cause);
        }
    }
}

