/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasDeployInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasScriptInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PluginDeployJavaService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasDeployInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasScriptInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginDeployJavaDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.types.AppCategory;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskAppopsService;
import com.irdstudio.allinapaas.portal.console.facade.SummaryService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskAppopsDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.AppState;
import com.irdstudio.allinapaas.portal.console.types.AppopsType;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.FilterItem;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class AppStartTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private ILogger logger = null;
    private PaasTaskInfoDTO taskInfo;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (AppStartTask.this.logger != null) {
                AppStartTask.this.logger.info((Object)line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (AppStartTask.this.logger != null) {
                AppStartTask.this.logger.error((Object)line);
            } else {
                System.err.println(line);
            }
        }
    };

    public AppStartTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
        String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + taskInfo.getTaskId() + ".log";
        FileUtils.deleteQuietly((File)new File(fullLogFileName));
        ILogger fileLogger = LoggerFactory.makeTxtFileLogger((String)fullLogFileName, (boolean)true);
        fileLogger.setName(taskInfo.getTaskId());
        TLogger.registerCategoryLogger((String)taskInfo.getTaskId(), (ILogger)fileLogger);
        this.logger = TLogger.getLogger((String)taskInfo.getTaskId());
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            String startModelName;
            PaasTaskAppopsService paasTaskAppopsService = (PaasTaskAppopsService)SpringContextUtils.getBean(PaasTaskAppopsService.class);
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            PaasScriptInfoService paasScriptInfoService = (PaasScriptInfoService)SpringContextUtils.getBean(PaasScriptInfoService.class);
            PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            PaasDeployInfoService paasDeployInfoService = (PaasDeployInfoService)SpringContextUtils.getBean(PaasDeployInfoService.class);
            PaasTaskAppopsDTO taskScriptInfo = new PaasTaskAppopsDTO();
            taskScriptInfo.setTaskId(this.taskInfo.getTaskId());
            taskScriptInfo = (PaasTaskAppopsDTO)paasTaskAppopsService.queryByPk((Object)taskScriptInfo);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String scriptId = taskScriptInfo.getScriptId();
            String ecsId = taskScriptInfo.getEcsId();
            PaasScriptInfoDTO scriptInfo = new PaasScriptInfoDTO();
            scriptInfo.setScriptId(scriptId);
            scriptInfo = (PaasScriptInfoDTO)paasScriptInfoService.queryByPk((Object)scriptInfo);
            if (scriptInfo == null) {
                throw new RuntimeException(scriptId + "\u811a\u672c\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            String scriptContent = scriptInfo.getScriptContent();
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
            if (appInfo == null) {
                throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            PaasEcsInfoDTO ecsInfo = new PaasEcsInfoDTO();
            ecsInfo.setEcsId(ecsId);
            ecsInfo = (PaasEcsInfoDTO)paasEcsInfoService.queryByPk((Object)ecsInfo);
            if (ecsInfo == null) {
                throw new RuntimeException(ecsId + "\u670d\u52a1\u5668\u4e0d\u5b58\u5728");
            }
            String envId = ecsInfo.getEnvId();
            PaasEnvParamDTO deployRoot = paasEnvParamService.queryEnvParamByCodeReturnValue("deploy_root", ecsInfo.getEnvId());
            String deployRootDir = this.getDeployRootDir(deployRoot.getParamValue());
            this.logger.info((Object)("\u8fdc\u7a0b\u64cd\u4f5cLinux\u670d\u52a1\u5668 " + ecsInfo.getEcsIp()));
            RemoteSSHClient rsc = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
            boolean loginFlag = rsc.connect();
            if (!loginFlag) {
                this.logger.error((Object)"\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!rsc.fileExists("/" + deployRootDir)) {
                rsc.executeCommand("mkdir /" + deployRootDir, this.sshPrinter);
            }
            String bashFile = String.format("%s%s.sh", appInfo.getAppId(), scriptId);
            String tmpBashFilePath = SdEnvUtil.PROJECT_TMP_PATH + File.separator + bashFile;
            File tmpBashFile = new File(tmpBashFilePath);
            try (FileOutputStream output = new FileOutputStream(tmpBashFile);){
                IOUtils.write((String)scriptContent, (OutputStream)output, (String)"UTF-8");
            }
            if (!rsc.fileExists("/" + deployRootDir + "/" + bashFile)) {
                rsc.upload(tmpBashFile.getAbsolutePath(), "/" + deployRootDir);
                rsc.executeCommand("chmod 777 /" + deployRootDir + "/" + bashFile, this.sshPrinter);
            }
            String pluginDeployModel = this.queryAppStarterModule(appId);
            String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
            String string = startModelName = StringUtils.isNotBlank((CharSequence)pluginDeployModel) ? pluginDeployModel : String.format("%s-%s", appCode, "start");
            if (StringUtils.equals((CharSequence)AppCategory.Middleware.getCode(), (CharSequence)appInfo.getAppCategory())) {
                startModelName = deployRootDir + "/" + appCode;
            }
            this.logger.info((Object)("\u6267\u884c\u547d\u4ee4 " + deployRootDir + "/" + String.format("%s  %s %s", bashFile, startModelName, ecsInfo.getEcsPort())));
            int status = rsc.executeCommand("cd " + deployRootDir + String.format(" && bash ./%s  %s %s", bashFile, startModelName, ecsInfo.getEcsPort()), this.sshPrinter, 2000L);
            boolean flag = true;
            if (status == -1) {
                this.logger.info((Object)("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 /" + deployRootDir + "/" + bashFile + " \u72b6\u6001 " + status));
                flag = false;
            }
            rsc.executeCommand("rm -rf /" + deployRootDir + "/" + bashFile, this.sshPrinter);
            FileUtils.deleteQuietly((File)tmpBashFile);
            PaasDeployInfoDTO deployInfo = new PaasDeployInfoDTO();
            deployInfo.setAppId(appInfo.getAppId());
            deployInfo.setEnvId(ecsInfo.getEnvId());
            List deployInfoList = paasDeployInfoService.queryListByPage((Object)deployInfo);
            if (CollectionUtils.isNotEmpty((Collection)deployInfoList)) {
                deployInfo = (PaasDeployInfoDTO)deployInfoList.get(0);
                deployInfo.setAppState(this.getAppStatus(taskScriptInfo));
                paasDeployInfoService.updateByPk((Object)deployInfo);
                SummaryService summaryService = (SummaryService)SpringContextUtils.getBean(SummaryService.class);
                HashMap<String, String> summaryParam = new HashMap<String, String>();
                summaryParam.put("appId", appInfo.getAppId());
                summaryParam.put("subsId", appInfo.getSubsId());
                summaryService.updateMeasure("paasDeployAppWithRunSummary", summaryParam);
            }
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u5e94\u7528\u7ec4\u4ef6\u5bfc\u5165\u5f02\u5e38 " + e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5e94\u7528\u7ec4\u4ef6\u5bfc\u5165\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private String getDeployRootDir(String deployRootDir) {
        if (deployRootDir == null) {
            deployRootDir = "/agent";
        }
        return deployRootDir;
    }

    public String getAppStatus(PaasTaskAppopsDTO taskScriptInfo) {
        if (AppopsType.start.getCode().equals(taskScriptInfo.getAppopsType())) {
            return AppState.Running.getCode();
        }
        if (AppopsType.stop.getCode().equals(taskScriptInfo.getAppopsType())) {
            return AppState.Stop.getCode();
        }
        return AppState.Running.getCode();
    }

    public String queryAppStarterModule(String appId) {
        PluginDeployJavaService pluginDeployJavaService = (PluginDeployJavaService)SpringContextUtils.getBean(PluginDeployJavaService.class);
        PluginDeployJavaDTO param = new PluginDeployJavaDTO();
        FilterItem likeAppId = new FilterItem();
        likeAppId.setOp(FilterItem.FilterOpEnum.Like.getCode());
        likeAppId.setKey("pluginConfId");
        likeAppId.setValues(Arrays.asList(appId));
        param.setFilterCond(JSON.toJSONString(Arrays.asList(likeAppId)));
        List list = pluginDeployJavaService.queryListByPage((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return ((PluginDeployJavaDTO)list.get(0)).getModule();
        }
        return null;
    }
}

