/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PluginMavenConfService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginMavenConfDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MavenRunner;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppRepoPullTask;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;

public class ComponentAppDeployTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private ILogger logger = null;
    private PaasTaskInfoDTO taskInfo;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (ComponentAppDeployTask.this.logger != null) {
                ComponentAppDeployTask.this.logger.info((Object)line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (ComponentAppDeployTask.this.logger != null) {
                ComponentAppDeployTask.this.logger.error((Object)line);
            } else {
                System.err.println(line);
            }
        }
    };

    public ComponentAppDeployTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
        String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + taskInfo.getTaskId() + ".log";
        FileUtils.deleteQuietly((File)new File(fullLogFileName));
        ILogger fileLogger = LoggerFactory.makeTxtFileLogger((String)fullLogFileName, (boolean)true);
        fileLogger.setName(taskInfo.getTaskId());
        TLogger.registerCategoryLogger((String)taskInfo.getTaskId(), (ILogger)fileLogger);
        this.logger = TLogger.getLogger((String)taskInfo.getTaskId());
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        Connection conn = null;
        try {
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            PluginMavenConfService pluginMavenConfService = (PluginMavenConfService)SpringContextUtils.getBean(PluginMavenConfService.class);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String envId = this.taskInfo.getEnvId();
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
            PluginMavenConfDTO pluginMavenConfDTO = new PluginMavenConfDTO();
            pluginMavenConfDTO.setPluginConfId(taskId);
            pluginMavenConfDTO = (PluginMavenConfDTO)pluginMavenConfService.queryByPk((Object)pluginMavenConfDTO);
            this.logger.info((Object)String.format("\u7ec4\u4ef6\u5e94\u7528%s %s\u53d1\u5e03\u5230maven", appInfo.getAppCode(), appInfo.getAppName()));
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(appInfo.getAppId(), appInfo.getAppGitUrl());
            appRepoPullTask.syncRun();
            String appRootPath = appRepoPullTask.getAppPath();
            boolean result = this.runMaven(appRootPath, pluginMavenConfDTO.getMavenCompiler());
            rtn.setSuccessFlag(result);
            if (!result) {
                this.taskInfo.setTaskErrorMsg("\u7ec4\u4ef6\u5e94\u7528\u53d1\u5e03\u5931\u8d25");
            }
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u521d\u59cb\u5316\u57fa\u7840\u6570\u636e\u5f02\u5e38 " + e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316\u57fa\u7840\u6570\u636e\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            taskDebounce.put(this.taskInfo.getTaskId(), false);
            if (conn != null) {
                conn.close();
            }
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
        }
        return rtn;
    }

    private Boolean runMaven(String appRootPath, String mavenParam) {
        MavenRunner mavenRunner = new MavenRunner(mavenParam, appRootPath, this.logger);
        mavenRunner.setMavenHome(SdEnvUtil.MAVEN_PATH);
        mavenRunner.setJavaHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path"));
        mavenRunner.setSetting(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
        return mavenRunner.run();
    }

    private class SqlRunLogWriter
    extends PrintWriter {
        private boolean errorFlag;
        private boolean hasError;
        private StringBuffer errorMsg;

        public SqlRunLogWriter(Writer out, boolean errorFlag) {
            super(out);
            this.errorMsg = new StringBuffer();
            this.errorFlag = errorFlag;
        }

        @Override
        public void println(Object x) {
            String s = String.valueOf(x);
            if (this.errorFlag) {
                ComponentAppDeployTask.this.logger.error((Object)s);
                this.hasError = true;
                this.errorMsg.append(s + '\n');
            } else {
                ComponentAppDeployTask.this.logger.info((Object)s);
            }
        }

        public boolean isHasError() {
            return this.hasError;
        }

        public String getErrorMsg() {
            return this.errorMsg.toString();
        }
    }
}

