/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GenDomainTask
extends BaseGenTask {
    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        logger.info("\u751f\u6210domain\u5b50\u5de5\u7a0b\u4ee3\u7801");
        boolean result = true;
        String subsCode = appInfo.getAppCode();
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(appInfo.getAppId());
        tableParam.setObjectTypes(Arrays.asList(ObjectType.Table.getCode(), ObjectType.Main.getCode(), ObjectType.Second.getCode()));
        if (StringUtils.isNotBlank((CharSequence)appInfo.getSrvModelId())) {
            SrvModelInfoDTO srvModelInfo = new SrvModelInfoDTO();
            srvModelInfo.setSrvModelId(appInfo.getSrvModelId());
            srvModelInfo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)srvModelInfo);
            if (srvModelInfo != null && StringUtils.isNotBlank((CharSequence)srvModelInfo.getTableModelId())) {
                tableParam.setObjectId(srvModelInfo.getTableModelId());
            }
        }
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>(tableList.size());
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                TmProjectInfoBo tpib = new TmProjectInfoBo();
                tpib.setProjectId(appInfo.getAppCode());
                tpib.setProjectCode(appInfo.getAppCode());
                tpib.setProjectName(appInfo.getAppName());
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s Domain Entity %s-%s", appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                ModelTableInfoBo tableBo = this.generateTableBO(table);
                bo.setMainTableModel(tableBo);
                ObjectType objectTypeEnum = ObjectType.getType((String)table.getObjectType().toString());
                if (objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.Main || objectTypeEnum == ObjectType.Second) {
                    this.generateModelTableJoinDetail(tableBo);
                }
                bo.getMapData().put("tableModelCode", table.getObjectCode());
                bo.getMapData().put("objectType", String.valueOf(table.getObjectType()));
                int inoutNum = this.srvModelInoutService.countByTableModelId(appInfo.getAppId(), table.getObjectId());
                if (ObjectType.Table == objectTypeEnum) {
                    ctdbList.add(bo);
                    continue;
                }
                if (inoutNum <= 0) continue;
                ctdbList.add(bo);
            }
        }
        for (CodeTemplateDataBo ctdb : ctdbList) {
            this.wrapAppsParam(appInfo.getAppId(), ctdb);
            String package_prefix = this.getPackagePrefix(ctdb);
            this.produceCodeFile("XXXDO.java", "domain", "src/main/java/" + package_prefix + "/" + GenDomainTask.formatClassPath(subsCode) + "/domain/entity/", appInfo, ctdb);
        }
        SSubsInfoDTO sSubsInfo = new SSubsInfoDTO();
        sSubsInfo.setSubsId(appInfo.getSubsId());
        sSubsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sSubsInfo);
        List<OsrvArrangeDependency> dependencies = this.querySubsSDKDependencies(sSubsInfo);
        CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
        TmProjectInfoBo pomTp = new TmProjectInfoBo();
        pomTp.setProjectId(appInfo.getAppCode());
        pomTp.setProjectCode(appInfo.getAppCode());
        pomTp.setProjectName(appInfo.getAppName());
        pomBo.setTmProjectInfo(pomTp);
        pomBo.getMapData().put("sdkList", dependencies);
        this.wrapAppsParam(appInfo.getAppId(), pomBo);
        String package_prefix = this.getPackagePrefix(pomBo);
        this.produceCodeFile("project-pom.xml", "", "project-", null, "", appInfo, pomBo);
        this.produceCodeFile("domain-pom.xml", "", "domain-", "domain", "", appInfo, pomBo);
        return result;
    }
}

